/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.accessor;

import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.ao.SecSignIDSessionStorage;
import javax.servlet.http.Cookie;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;

public class SecSignIDSessionManager {
    private final long CLEANUP_INTERVAL_MILLIS = 86400000L;
    private static long lastCleanupTime = 0L;
    private final SecSignIDSessionStorage storage;

    public SecSignIDSessionManager(SecSignIDSessionStorage storage) {
        this.storage = storage;
    }

    public boolean updateSession(HttpServletRequest request, HttpServletResponse response) {
        HttpSession session = request.getSession(false);
        if (session == null) {
            return false;
        }
        String sessionId = session.getId();
        long timeoutDuration = this.getEffectiveSessionTimeoutDuration();
        if (timeoutDuration <= 0L) {
            return false;
        }
        long lastAccessTime = this.storage.getLastAccessTime(sessionId);
        long timeoutTime = lastAccessTime + timeoutDuration * 60L * 1000L;
        long nowTime = System.currentTimeMillis();
        if (timeoutDuration != 0L) {
            if (nowTime >= timeoutTime) {
                this.invalidateSession(request, response, session);
                this.storage.invalidate(sessionId);
                return true;
            }
            this.storage.setLastAccessTime(sessionId, nowTime);
            session.setMaxInactiveInterval((int)(60L * timeoutDuration));
        } else {
            this.storage.setLastAccessTime(sessionId, nowTime);
            session.setMaxInactiveInterval(-1);
        }
        this.cleanUpInactiveSessions();
        return false;
    }

    private void cleanUpInactiveSessions() {
        long nowTime = System.currentTimeMillis();
        if (nowTime >= lastCleanupTime + 86400000L) {
            lastCleanupTime = nowTime;
            long timeoutDuration = this.getEffectiveSessionTimeoutDuration() * 60L * 1000L;
            long inactiveDuration = timeoutDuration != 0L ? timeoutDuration * 2L : 86400000L;
            this.storage.invalidateInactive(inactiveDuration);
        }
    }

    private void invalidateSession(HttpServletRequest request, HttpServletResponse response, HttpSession session) {
        try {
            session.invalidate();
        }
        catch (IllegalStateException illegalStateException) {
            // empty catch block
        }
        this.removeSessionCookies(request, response);
    }

    private void removeSessionCookies(HttpServletRequest request, HttpServletResponse response) {
        Cookie[] cookies = request.getCookies();
        if (cookies == null) {
            return;
        }
        for (Cookie cookie : cookies) {
            if (cookie.getMaxAge() != -1) continue;
            cookie.setValue("");
            cookie.setPath("/");
            cookie.setMaxAge(0);
            response.addCookie(cookie);
        }
    }

    private long getEffectiveSessionTimeoutDuration() {
        long timeoutDuration = SecSignIDCommonStaticAccessor.getSessionTimeoutDuration();
        if (timeoutDuration < 0L) {
            timeoutDuration = 0L;
        }
        return timeoutDuration;
    }
}

