/**
 * (c) 2015 SecSign Technologies Inc.
 *
 * Adding some functionality to the login screen
 */
	
(function() {
  // Load the script
  const script = document.createElement("script");
  script.src = 'https://ajax.googleapis.com/ajax/libs/jquery/3.6.0/jquery.min.js';
  script.type = 'text/javascript';
  script.addEventListener('load', function() {
    console.log("jQuery ${$.fn.jquery} has been loaded successfully!");
    // use jQuery below
    
    jQuery(document).ready(function ($) {

            //set header from page title
            var pageTitle = $('title').text();
            var pageTitleIndex = pageTitle.indexOf(' - ');
            if(pageTitleIndex != -1){
                pageTitle = pageTitle.substr(pageTitleIndex + 3, pageTitle.length - pageTitleIndex - 1);
            }
            $("#secsign-page-title span").text(pageTitle);

            //set colors of login screen (default: header, fallback: secsign blue)
            var headercolor = $(".aui-header").css("background-color");
            if($("#secsignid-plugin").length>0)
			{
				if($("#secsignid-plugin").data("custom")){
					var color = $("#secsignid-plugin").data("color");
					if(!setLoginBg(color)){
						setLoginBg(headercolor);
					}
				} else {
					setLoginBg(headercolor);
				}
			}
            if($("#secsignid-plugin-big").length>0)
			{
				if($("#secsignid-plugin-big").data("custom")){
					var color = $("#secsignid-plugin-big").data("color");
					if(!setLoginBg(color)){
						setLoginBg(headercolor);
					}
				} else {
					setLoginBg(headercolor);
				}
			}
            if($("#secsignid-plugin-middle").length>0)
			{
				if($("#secsignid-plugin-middle").data("custom")){
					var color = $("#secsignid-plugin-middle").data("color");
					if(!setLoginBg(color)){
						setLoginBg(headercolor);
					}
				} else {
					setLoginBg(headercolor);
				}
			}

            //delete unsupported characters in ID field
			$('#secsignid.login-field').bind('keyup', function(){
				var sanitized = $(this).val().replace(/[^0-9a-zA-Z-@_.]/g,'');
				$(this).val(sanitized);
			});
            $('#id-form.login-field').bind('keyup', function(){
				var sanitized = $(this).val().replace(/[^0-9a-zA-Z-@_.]/g,'');
				$(this).val(sanitized);
			});

        


        function ColorLuminance(hex_or_rgb, lum) {

            var hex = rgb2hex(hex_or_rgb);
            var brightness = 0; // between 0 and 3x255

        	// validate hex string
        	hex = String(hex).replace(/[^0-9a-f]/gi, '');
        	if (hex.length < 6) {
        		hex = hex[0]+hex[0]+hex[1]+hex[1]+hex[2]+hex[2];
        	}
        	lum = lum || 0;

        	// convert to decimal and change luminosity
        	var rgb = "#", c, i;
        	for (i = 0; i < 3; i++) {
        		c = parseInt(hex.substr(i*2,2), 16);
                brightness+=c;
        		c = Math.round(Math.min(Math.max(0, c + (c * lum)), 255)).toString(16);
        		rgb += ("00"+c).substr(c.length);
        	}

            if(brightness>500){
                //background is too bright, darken font and borders
                $("#secsignid-plugin").addClass("customlight");
                $("#secsignid-plugin-big").addClass("customlight");
                $("#secsignid-plugin-middle").addClass("customlight");
            }

        	return rgb;
        }

        function rgb2hex(color){
            if (color.substr(0, 1) === '#') {
                return color;
            }
            var rgb = color.replace(/\s/g,'').match(/^rgba?\((\d+),(\d+),(\d+)/i);
            return (rgb && rgb.length === 4) ? "#" +
              ("0" + parseInt(rgb[1],10).toString(16)).slice(-2) +
              ("0" + parseInt(rgb[2],10).toString(16)).slice(-2) +
              ("0" + parseInt(rgb[3],10).toString(16)).slice(-2) : color;
        }

        function setLoginBg(color){
            if(color != null){
                var hex = /(^#[0-9A-F]{6}$)|(^#[0-9A-F]{3}$)/i.test(color);
                var rgb = color.substring(0, 3);
                if(hex || rgb == "rgb"){
                    var colordark  = ColorLuminance(color,0);
                    var colorlight = ColorLuminance(color,0.4);
                    $("#secsignid-plugin").css("background","linear-gradient(to bottom, "+colorlight+" 0%, "+colordark+" 100%)");
                    $("#secsignid-plugin-big").css("background","linear-gradient(to bottom, "+colorlight+" 0%, "+colordark+" 100%)");
                    $("#secsignid-plugin-middle").css("background","linear-gradient(to bottom, "+colorlight+" 0%, "+colordark+" 100%)");
                    return true;
                }
            }
            return false;
        }
});

  });
  document.head.appendChild(script);
})();	
	
