/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.crowd.servlet;

import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationNotFoundException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidCredentialException;
import com.atlassian.crowd.exception.InvalidEmailAddressException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.login.exception.InvalidResetPasswordTokenException;
import com.atlassian.crowd.manager.mail.MailSendException;
import com.atlassian.crowd.manager.property.PropertyManagerException;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import com.secsign.crowd.accessor.SecSignIDStaticAccessor;
import com.secsign.crowd.util.SecSignIDForgotPasswordHelper;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import javax.servlet.http.HttpSession;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDForgotFormServlet
extends HttpServlet {
    private static final long serialVersionUID = 6021643587383083271L;
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDForgotFormServlet.class);
    private String forgtFormTemplate = "/templates/secsignid-forgot-form.vm";
    private String forgtFormTemplateCrowd = "/templates/secsignid-crowd-forgot-form.vm";
    private final TemplateRenderer templateRenderer;
    private final I18nResolver i18nResolver;
    private final WebResourceManager webResourceManager;
    private SecSignIDDataAccessor dataAccessor;
    private HashMap<String, Object> context;

    public WebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }

    public SecSignIDForgotFormServlet(TemplateRenderer templateRenderer, I18nResolver i18nResolver, WebResourceManager webResourceManager, SecSignIDDataAccessor dataAccessor) {
        this.templateRenderer = templateRenderer;
        this.i18nResolver = i18nResolver;
        this.webResourceManager = webResourceManager;
        this.dataAccessor = dataAccessor;
    }

    protected void doGet(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        this.context = new HashMap();
        this.context.put("secsignServletPath", "/plugins/servlet/secsignid");
        this.context.put("req", httpServletReq);
        logger.debug("GET URL '" + httpServletReq.getRequestURI() + "'");
        logger.debug("    path info [get]: " + httpServletReq.getPathInfo());
        logger.debug("    parameter [get]: " + SecSignIDMappingUtils.toString(httpServletReq.getParameterMap()));
        logger.debug("    header [get]: " + SecSignIDMappingUtils.headerToString(httpServletReq));
        HttpSession session = httpServletReq.getSession();
        logger.debug("    session [get] SAMLRequest: " + session.getAttribute("SAMLRequest"));
        logger.debug("    session [get] RelayState: " + session.getAttribute("RelayState"));
        httpServletResp.setContentType("text/html;charset=utf-8");
        if (SecSignIDStaticAccessor.getMailManager().isConfigured()) {
            if (httpServletReq.getParameter("reset-password") != null) {
                this.handleResetPassword(httpServletReq, httpServletResp);
                return;
            }
            this.context.put("start", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
        } else {
            this.context.put("nomail", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
        }
    }

    private void handleResetPassword(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws RenderingException, IOException {
        boolean validToken;
        String token = httpServletReq.getParameter("token");
        String username = httpServletReq.getParameter("username");
        String diridString = httpServletReq.getParameter("directoryId");
        long dirid = -1L;
        if (diridString != null) {
            dirid = Long.parseLong(diridString);
        }
        if (!(validToken = SecSignIDStaticAccessor.getForgottenLoginManager().isValidResetToken(dirid, username, token))) {
            this.context.put("no-valid-token", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        this.context.put("reset-password", Boolean.TRUE);
        this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
    }

    protected void doPost(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        httpServletResp.setContentType("text/html;charset=utf-8");
        logger.debug("POST URL '" + httpServletReq.getRequestURI() + "'");
        logger.debug("    path info [post]: " + httpServletReq.getPathInfo());
        logger.debug("    parameter [post]: " + SecSignIDMappingUtils.toString(httpServletReq.getParameterMap()));
        logger.debug("    header [post]: " + SecSignIDMappingUtils.headerToString(httpServletReq));
        HttpSession session = httpServletReq.getSession();
        logger.debug("    session [get] SAMLRequest: " + session.getAttribute("SAMLRequest"));
        logger.debug("    session [get] RelayState: " + session.getAttribute("RelayState"));
        this.context = new HashMap();
        this.context.put("req", httpServletReq);
        if (httpServletReq.getParameter("forgot_username") != null) {
            this.handleForgotPassword(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("forgot_mail") != null) {
            this.handleForgotUsername(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("new_password_send") != null) {
            this.handleNewPassword(httpServletReq, httpServletResp);
            return;
        }
        this.context.put("start", Boolean.TRUE);
        this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
    }

    private void handleNewPassword(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws RenderingException, IOException {
        String passwordString = httpServletReq.getParameter("password");
        String rePasswordString = httpServletReq.getParameter("re_password");
        String token = httpServletReq.getParameter("token");
        String username = httpServletReq.getParameter("username");
        String diridString = httpServletReq.getParameter("directoryId");
        long dirid = Long.parseLong(diridString);
        if (!passwordString.equals(rePasswordString)) {
            this.context.put("errormsg", this.i18nResolver.getText("secsignid.messages.error.action.nonmatch.password"));
            this.context.put("reset-password", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        try {
            SecSignIDStaticAccessor.getForgottenLoginManager().resetUserCredential(dirid, username, new PasswordCredential(passwordString), token);
        }
        catch (UserNotFoundException e) {
            this.context.put("errormsg", this.i18nResolver.getText("secsignid.messages.error.crowd.failed"));
            this.context.put("reset-password", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        catch (DirectoryNotFoundException e) {
            this.context.put("errormsg", this.i18nResolver.getText("secsignid.messages.error.crowd.failed"));
            this.context.put("reset-password", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        catch (OperationFailedException e) {
            this.context.put("errormsg", this.i18nResolver.getText("secsignid.messages.error.crowd.failed"));
            this.context.put("reset-password", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        catch (InvalidCredentialException e) {
            this.context.put("errormsg", this.i18nResolver.getText("secsignid.messages.password.not.valid"));
            this.context.put("reset-password", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        catch (DirectoryPermissionException e) {
            this.context.put("errormsg", this.i18nResolver.getText("secsignid.messages.error.crowd.failed"));
            this.context.put("reset-password", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        catch (InvalidResetPasswordTokenException e) {
            this.context.put("no-valid-token", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        this.context.put("password-reset-done", Boolean.TRUE);
        this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
    }

    private void handleForgotPassword(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws RenderingException, IOException {
        User user;
        String enteredUsername = httpServletReq.getParameter("forgot_username");
        if (enteredUsername == null || enteredUsername.equals("")) {
            this.context.put("errormsg", this.i18nResolver.getText("secsignid.messages.error.nousername"));
            this.context.put("start", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        try {
            user = this.dataAccessor.getUserForKeyFirst(enteredUsername);
        }
        catch (OperationFailedException e1) {
            this.context.put("errormsg", this.i18nResolver.getText("secsignid.messages.error.crowd.failed"));
            this.context.put("start", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        if (user == null) {
            this.context.put("password-reset-ready", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        String userMail = user.getEmailAddress();
        try {
            SecSignIDStaticAccessor.getMailManager().sendPlainTextEmail(new InternetAddress(userMail), "Reset password", SecSignIDForgotPasswordHelper.getStringForMailWithPassword(user));
        }
        catch (AddressException e) {
            logger.error("AddressException on handle ForgotPassword");
            e.printStackTrace();
            this.context.put("errormsg", this.i18nResolver.getText("secsignid.messages.error.wrong.mail"));
            this.context.put("start", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        catch (MailSendException e) {
            logger.error("MailSendException on handle ForgotPassword");
            e.printStackTrace();
            this.context.put("errormsg", this.i18nResolver.getText("secsignid.messages.error.mail.problem"));
            this.context.put("start", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        catch (PropertyManagerException e) {
            logger.error("PropertyManagerException on handle ForgotPassword");
            e.printStackTrace();
            this.context.put("errormsg", this.i18nResolver.getText("secsignid.messages.error.ask.admin"));
            this.context.put("start", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        this.context.put("password-reset-ready", Boolean.TRUE);
        this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
    }

    private void handleForgotUsername(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws RenderingException, IOException {
        String enteredMail = httpServletReq.getParameter("forgot_mail");
        if (enteredMail == null || enteredMail.equals("")) {
            this.context.put("errormsg", this.i18nResolver.getText("secsignid.messages.error.action.empty.email"));
            this.context.put("start", Boolean.TRUE);
            this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
            return;
        }
        try {
            Application crowdApp = SecSignIDStaticAccessor.getApplicationManager().findByName("crowd");
            SecSignIDStaticAccessor.getForgottenLoginManager().sendUsernames(crowdApp, enteredMail);
        }
        catch (ApplicationNotFoundException crowdApp) {
        }
        catch (InvalidEmailAddressException e) {
            e.printStackTrace();
        }
        this.context.put("username-send-ready", Boolean.TRUE);
        this.templateRenderer.render(this.getForgotTemplate(), this.context, (Writer)httpServletResp.getWriter());
    }

    private String getForgotTemplate() {
        if (SecSignIDCommonStaticAccessor.getUseNewCrowdLogin()) {
            return this.forgtFormTemplateCrowd;
        }
        return this.forgtFormTemplate;
    }
}

