/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.crowd.listener;

import com.atlassian.event.api.EventListener;
import com.atlassian.event.api.EventPublisher;
import com.atlassian.plugin.event.events.PluginEnabledEvent;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.scheduler.SchedulerService;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.jobs.SecSignIDSchedulerUtil;
import com.secsign.atlassian.common.rest.SecSignIDRESTPluginRegistrationResponse;
import com.secsign.atlassian.common.rest.SecSignIDServerRESTConnector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;

public class SecSignIDPluginInstalledListener
implements InitializingBean,
DisposableBean {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDPluginInstalledListener.class);
    private final EventPublisher eventPublisher;
    private final SchedulerService schedulerService;
    private final SecSignIDDataAccessor dataAccessor;

    public SecSignIDPluginInstalledListener(EventPublisher eventPublisher, SchedulerService schedulerService, SecSignIDDataAccessor dataAccessor) {
        this.eventPublisher = eventPublisher;
        this.schedulerService = schedulerService;
        this.dataAccessor = dataAccessor;
    }

    @EventListener
    public void onPluginEnabled(PluginEnabledEvent event) {
        try {
            if ("com.secsign.secsign-crowd".equals(event.getPlugin().getKey())) {
                PluginSettings globalPluginSettings = SecSignIDCommonStaticAccessor.getPluginSettingsFactory().createGlobalSettings();
                Object value = globalPluginSettings.get("allToGlobal");
                if (value == null) {
                    logger.warn("change of Settings needed");
                    this.changeToGlobalSettings();
                    globalPluginSettings.put("allToGlobal", (Object)String.valueOf(true));
                    logger.warn("Wrote Settings to globalSettings");
                }
                if ((value = globalPluginSettings.get("toAllSettingsAsOne")) == null) {
                    logger.warn("Change To One Attribute needed");
                    this.dataAccessor.changeToOneAttribute();
                    globalPluginSettings.put("toAllSettingsAsOne", (Object)String.valueOf(true));
                    logger.warn("Change To One Attribute done");
                }
                if ((value = globalPluginSettings.get("updateUseFallback")) == null) {
                    boolean valueAsBoolean = SecSignIDCommonStaticAccessor.getNoFallback();
                    SecSignIDCommonStaticAccessor.saveUseFallback(!valueAsBoolean);
                    globalPluginSettings.put("updateUseFallback", (Object)String.valueOf(true));
                }
                this.dataAccessor.checkGroupsCreated();
                if (!SecSignIDCommonStaticAccessor.getFirstStart() && SecSignIDCommonStaticAccessor.isUsingCloudServer()) {
                    if (!SecSignIDCommonStaticAccessor.hasPluginPinAccount()) {
                        logger.info("Trying to create a plugin PIN account.");
                        try {
                            SecSignIDRESTPluginRegistrationResponse pluginRegisterResponse = SecSignIDServerRESTConnector.registerPlugin();
                            SecSignIDCommonStaticAccessor.savePinAccount(new String[]{pluginRegisterResponse.getAccountName(), pluginRegisterResponse.getPassword()});
                            logger.info("Successfully created a plugin PIN account.");
                        }
                        catch (Exception e) {
                            logger.error("Plugin PIN-Account couldn't be created.");
                            logger.error(e.getMessage(), (Throwable)e);
                        }
                    } else {
                        String baseUrl = this.dataAccessor.getBaseUrl();
                        SecSignIDCommonStaticAccessor.updateBaseUrl(baseUrl);
                    }
                    if (SecSignIDCommonStaticAccessor.isTelemetryEnabled() && SecSignIDCommonStaticAccessor.hasPluginPinAccount()) {
                        SecSignIDSchedulerUtil.registerJobRunner(this.schedulerService, this.dataAccessor);
                    }
                }
            }
        }
        catch (Exception e) {
            logger.error(e.getMessage(), (Throwable)e);
            logger.error("Error on installtion of SecSign Plugin:" + e.getMessage());
        }
    }

    private void changeToGlobalSettings() {
        Object value = null;
        PluginSettings globalPluginSettings = SecSignIDCommonStaticAccessor.getPluginSettingsFactory().createGlobalSettings();
        PluginSettings localpluginSettings = SecSignIDCommonStaticAccessor.getPluginSettingsFactory().createSettingsForKey("com.secsign.secsignid:crowd-settings");
        value = localpluginSettings.get("com.secsign.crowd.idserverurl");
        if (value != null) {
            logger.debug("Saved ID Server Url on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.idserverurl", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.idserverurl.fallback")) != null) {
            logger.debug("Saved Fallback ID Server Url on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.idserverurl.fallback", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.servicename")) != null) {
            logger.debug("Saved ServiceName on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.servicename", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.firststart")) != null) {
            logger.debug("Saved FirstStart on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.firststart", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.companyname")) != null) {
            logger.debug("Saved CompanyName on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.companyname", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.userchange")) != null) {
            logger.debug("Saved UserChange  on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.userchange", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.userestore")) != null) {
            logger.debug("Saved UseRestore on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.userestore", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.autofillusername")) != null) {
            logger.debug("Saved AutoFillUsername on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.autofillusername", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.autofillusernamecompany")) != null) {
            logger.debug("Saved AutoFillUsernameCompany on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.autofillusernamecompany", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.autofillmaill")) != null) {
            logger.debug("Saved AutoFillMail on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.autofillusername", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.basicauth")) != null) {
            logger.debug("Saved BasicAuth on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.basicauth", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.synchid")) != null) {
            logger.debug("Saved Synchronizable on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.synchid", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.synchwrite")) != null) {
            logger.debug("Saved SynchronizableWrite on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.synchwrite", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.safezone")) != null) {
            logger.debug("Saved SafeZone on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.safezone", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.safezoneraange")) != null) {
            logger.debug("Saved SafeZone Range on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.safezonerange", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.noaccesspass")) != null) {
            logger.debug("Saved NoAccesspass on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.noaccesspass", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.customlogin")) != null) {
            logger.debug("Saved CustomLogin on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.customlogin", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.logincolor")) != null) {
            logger.debug("Saved Login Color on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.logincolor", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.pinuser")) != null) {
            logger.debug("Saved PinUser on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.pinuser", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.pinpassword")) != null) {
            logger.debug("Saved PinUserPassword on new position: ***");
            globalPluginSettings.put("com.secsign.pinpassword", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.ldapattr")) != null) {
            logger.debug("Saved LDAPAttribute on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.ldapattr", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.ldapenable")) != null) {
            logger.debug("Saved LDAPEnable on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.ldapenable", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.localenable")) != null) {
            logger.debug("Saved LocalEnable on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.localenable", value);
        }
        if ((value = localpluginSettings.get("com.secsign.crowd.writeldap")) != null) {
            logger.debug("Saved WriteLDAP on new position: " + (String)value);
            globalPluginSettings.put("com.secsign.writeldap", value);
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.eventPublisher.register((Object)this);
        if (!SecSignIDCommonStaticAccessor.getFirstStart() && SecSignIDCommonStaticAccessor.isUsingCloudServer()) {
            if (!SecSignIDCommonStaticAccessor.hasPluginPinAccount()) {
                logger.info("Trying to create a plugin PIN account.");
                try {
                    SecSignIDRESTPluginRegistrationResponse pluginRegisterResponse = SecSignIDServerRESTConnector.registerPlugin();
                    SecSignIDCommonStaticAccessor.savePinAccount(new String[]{pluginRegisterResponse.getAccountName(), pluginRegisterResponse.getPassword()});
                    logger.info("Successfully created a plugin PIN account.");
                }
                catch (Exception e) {
                    logger.error("Plugin PIN-Account couldn't be created.");
                    logger.error(e.getMessage(), (Throwable)e);
                }
            } else {
                String baseUrl = this.dataAccessor.getBaseUrl();
                SecSignIDCommonStaticAccessor.updateBaseUrl(baseUrl);
            }
            if (SecSignIDCommonStaticAccessor.isTelemetryEnabled() && SecSignIDCommonStaticAccessor.hasPluginPinAccount()) {
                SecSignIDSchedulerUtil.registerJobRunner(this.schedulerService, this.dataAccessor);
            }
        }
    }

    public void destroy() throws Exception {
        this.eventPublisher.unregister((Object)this);
        SecSignIDSchedulerUtil.unregisterJobRunner(this.schedulerService);
    }
}

