/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.util;

import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import java.io.UnsupportedEncodingException;
import java.net.URLDecoder;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.regex.Pattern;
import javax.servlet.http.HttpServletRequest;

public class SecSignIDMappingUtils {
    private static Pattern commaPattern = Pattern.compile(",");
    private static char glueChar = (char)44;

    public static String getSecSignIdString(String[] secSignIdArray) {
        StringBuilder sb = new StringBuilder();
        if (secSignIdArray != null) {
            for (int i = 0; i < secSignIdArray.length; ++i) {
                sb.append(secSignIdArray[i]);
                if (i >= secSignIdArray.length - 1) continue;
                sb.append(",");
            }
        }
        return sb.toString();
    }

    public static String[] getArrayOfSecSignIds(String secSignIdsStr) {
        return SecSignIDMappingUtils.getArrayOfSecSignIds(secSignIdsStr, true);
    }

    public static String[] getArrayOfSecSignIds(String secSignIdsStr, boolean filterDuplicates) {
        if (secSignIdsStr == null || secSignIdsStr.length() < 1 || secSignIdsStr.equalsIgnoreCase("SECSIGN_NULL")) {
            return new String[0];
        }
        secSignIdsStr = SecSignIDMappingUtils.trim(secSignIdsStr.trim(), glueChar).trim();
        String[] secSignIds = commaPattern.split(secSignIdsStr);
        for (int i = 0; i < secSignIds.length; ++i) {
            secSignIds[i] = secSignIds[i].trim().toLowerCase();
        }
        if (filterDuplicates) {
            LinkedHashSet<String> filteredSecSignIds = new LinkedHashSet<String>();
            for (int i = 0; i < secSignIds.length; ++i) {
                if (secSignIds[i] == null || secSignIds[i].length() <= 0) continue;
                filteredSecSignIds.add(secSignIds[i]);
            }
            secSignIds = filteredSecSignIds.toArray(new String[filteredSecSignIds.size()]);
        }
        return secSignIds;
    }

    public static String getUserKeyFromMappingKey(String mappingKey) {
        int dividerIndex = mappingKey.indexOf(":");
        return mappingKey.substring(0, dividerIndex).replace("___", " ");
    }

    public static long getDirIDFromMappingKey(String mappingKey) {
        int dividerIndex = mappingKey.indexOf(":");
        return Long.parseLong(mappingKey.substring(dividerIndex + 1));
    }

    public static String getGroupNameFromGroupMappingKey(String mappingKey) {
        int dividerIndex = mappingKey.indexOf(";");
        return mappingKey.substring(0, dividerIndex).toLowerCase().replace("___", " ");
    }

    public static long getDirIDFromGroupMappingKey(String mappingKey) {
        int dividerIndex = mappingKey.indexOf(";");
        return Long.parseLong(mappingKey.substring(dividerIndex + 1));
    }

    public static String trim(String stringToBeTrimmed) {
        return SecSignIDMappingUtils.trim(stringToBeTrimmed, ' ', true);
    }

    public static String trim(String stringToBeTrimmed, char characterToBeTrimmed) {
        return SecSignIDMappingUtils.trim(stringToBeTrimmed, characterToBeTrimmed, true);
    }

    public static String trim(String stringToBeTrimmed, char characterToBeTrimmed, boolean allWhiteSpace) {
        int beginning;
        int length;
        if (stringToBeTrimmed == null || stringToBeTrimmed.length() < 1) {
            return stringToBeTrimmed;
        }
        if (characterToBeTrimmed == ' ' && allWhiteSpace) {
            return stringToBeTrimmed.trim();
        }
        int ending = length = stringToBeTrimmed.length();
        for (beginning = 0; beginning < ending && stringToBeTrimmed.charAt(beginning) == characterToBeTrimmed; ++beginning) {
        }
        while (beginning < ending && stringToBeTrimmed.charAt(ending - 1) == characterToBeTrimmed) {
            --ending;
        }
        return beginning > 0 || ending < length ? stringToBeTrimmed.substring(beginning, ending) : stringToBeTrimmed;
    }

    public static String arrayToString(Object[] objects) {
        if (objects == null) {
            return "null";
        }
        int length = objects.length;
        if (length == 0) {
            return "[]";
        }
        StringBuilder sb = new StringBuilder();
        sb.append('[');
        for (int i = 0; i < length; ++i) {
            sb.append(String.valueOf(objects[i]));
        }
        sb.append(']');
        return sb.toString();
    }

    public static String toString(Map map) {
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        Iterator it = map.entrySet().iterator();
        while (it.hasNext()) {
            Map.Entry entry = it.next();
            String key = String.valueOf(entry.getKey());
            if (key.contains("pass") || key.equals("pw")) {
                sb.append(key).append("=").append("***");
            } else if (entry.getValue() instanceof String[]) {
                sb.append(key).append("=").append(Arrays.toString((String[])entry.getValue()));
            } else {
                sb.append(key).append("=").append(String.valueOf(entry.getValue()));
            }
            if (!it.hasNext()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static String headerToString(HttpServletRequest httpServletReq) {
        if (httpServletReq == null) {
            return "header is null";
        }
        Enumeration enum0 = httpServletReq.getHeaderNames();
        StringBuilder sb = new StringBuilder();
        sb.append("{");
        while (enum0.hasMoreElements()) {
            String headerFieldName = (String)enum0.nextElement();
            sb.append(headerFieldName).append("=").append(httpServletReq.getHeader(headerFieldName));
            if (!enum0.hasMoreElements()) continue;
            sb.append(", ");
        }
        sb.append("}");
        return sb.toString();
    }

    public static HashMap<String, Object> createQueryMap(String query, boolean decodeValue) {
        String[] pairs;
        HashMap<String, Object> queryMap = new HashMap<String, Object>();
        for (String pair : pairs = query.split("&")) {
            int idx = pair.indexOf("=");
            try {
                String key = URLDecoder.decode(pair.substring(0, idx), "utf-8");
                String value = decodeValue ? URLDecoder.decode(pair.substring(idx + 1), "utf-8") : pair.substring(idx + 1);
                queryMap.put(key, value);
            }
            catch (UnsupportedEncodingException unsupportedEncodingException) {
                // empty catch block
            }
        }
        return queryMap;
    }

    public static List<String> fixGroupListForDirIDAndEscape(List<String> groups, long dirid) {
        ArrayList<String> groupNamesFixed = new ArrayList<String>();
        for (String string : groups) {
            groupNamesFixed.add(string.toLowerCase().replace(" ", "___") + ";" + dirid);
        }
        return groupNamesFixed;
    }

    public static String arrayToString(byte[] encryptedBytesArray) {
        String result = "";
        for (byte b : encryptedBytesArray) {
            result = result + b + ";";
        }
        return result;
    }

    public static byte[] stringToByteArray(String pinAccountPassword) {
        String[] given = pinAccountPassword.split(";");
        byte[] result = new byte[given.length];
        for (int i = 0; i < given.length; ++i) {
            byte current;
            String b = given[i];
            result[i] = current = Byte.valueOf(b).byteValue();
        }
        return result;
    }

    public static String getShortFormOf2FAMethods(SecSignID2FASettings setting) {
        int enabledMethods = 0;
        int allowedMethods = 0;
        if (SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled()) {
            ++enabledMethods;
            if (setting.getTwoStepAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                ++allowedMethods;
            }
        }
        if (SecSignIDCommonStaticAccessor.getFidoAuthEnabled()) {
            ++enabledMethods;
            if (setting.getFidoAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                ++allowedMethods;
            }
        }
        if (SecSignIDCommonStaticAccessor.getTotpAuthEnabled()) {
            ++enabledMethods;
            if (setting.getTotpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                ++allowedMethods;
            }
        }
        if (SecSignIDCommonStaticAccessor.getMailotpAuthEnabled()) {
            ++enabledMethods;
            if (setting.getMailOtpAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                ++allowedMethods;
            }
        }
        if (SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled()) {
            ++enabledMethods;
            if (setting.getPasswordlessAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) {
                ++allowedMethods;
            }
        }
        return "(" + allowedMethods + " " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.twofa.of") + " " + enabledMethods + " " + SecSignIDCommonStaticAccessor.getI18nResolver().getText("secsignid.twofa.methods") + ")";
    }
}

