/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.servlet;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDShareSettingsServlet
extends HttpServlet {
    public static final String USERNAME_SESSION_ATTRIBUTE_KEY = "qr.username";
    private static final long serialVersionUID = 6842235411471448500L;
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDShareSettingsServlet.class);
    private static final String EDIT_OPTIONS_TEMPLATE = "templates/secsignid-share-settings-otp.vm";
    private final I18nResolver i18nResolver;
    private SecSignIDDataAccessor dataAccessor;
    private final TemplateRenderer templateRenderer;

    public SecSignIDShareSettingsServlet(I18nResolver i18nResolver, SecSignIDDataAccessor staticAccessor, TemplateRenderer templateRenderer) {
        this.i18nResolver = i18nResolver;
        this.dataAccessor = staticAccessor;
        this.templateRenderer = templateRenderer;
    }

    protected void doGet(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        boolean basicAuthUsed;
        HashMap<String, String> context = new HashMap<String, String>();
        User appUser = this.dataAccessor.getUserCurrentlyLoggedIn();
        boolean bl = basicAuthUsed = httpServletReq.getSession().getAttribute("secsign.basicAuth") != null;
        if (appUser == null || basicAuthUsed || !this.dataAccessor.isUserAdmin(appUser)) {
            this.dataAccessor.sendRedirectForNotAuthed(httpServletReq, httpServletResp);
            return;
        }
        String otp = SecSignIDCommonStaticAccessor.createAndStoreOTPForSharingSettings();
        context.put("otp", otp);
        httpServletResp.setContentType("text/html;charset=utf-8");
        try {
            this.templateRenderer.render(EDIT_OPTIONS_TEMPLATE, context, (Writer)httpServletResp.getWriter());
        }
        catch (Exception er) {
            logger.error(er.getMessage(), (Throwable)er);
        }
    }

    protected void doPost(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        try {
            String content = httpServletReq.getReader().lines().collect(Collectors.joining(System.lineSeparator()));
            JSONObject objectFromContent = new JSONObject(content);
            JSONObject answerObject = new JSONObject();
            String otp = objectFromContent.getString("otp");
            if (!SecSignIDCommonStaticAccessor.checkOTPForSharingSettings(otp)) {
                answerObject.put("success", false);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
            } else {
                answerObject.put("success", true);
                answerObject.put("settings", (Object)SecSignIDCommonStaticAccessor.getSettingsToShare());
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
            }
        }
        catch (JSONException jSONException) {
            // empty catch block
        }
    }
}

