/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.servlet;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.ApplicationPermissionException;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.InvalidAuthenticationException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.exception.runtime.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.plugin.webresource.WebResourceManager;
import com.atlassian.sal.api.message.I18nResolver;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.secsign.atlassian.common.accessor.SecSignIDCommonStaticAccessor;
import com.secsign.atlassian.common.data.SecSignID2FAActivatedSettings;
import com.secsign.atlassian.common.data.SecSignID2FASettings;
import com.secsign.atlassian.common.data.SecSignIDWhiteListItem;
import com.secsign.atlassian.common.interfaces.SecSignIDDataAccessor;
import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import com.secsign.atlassian.common.rest.SecSignIDServerRESTConnector;
import com.secsign.atlassian.common.util.SecSignIDCommonConstants;
import com.secsign.atlassian.common.util.SecSignIDMappingUtils;
import com.secsign.atlassian.common.util.SecSignIDTemplateHelper;
import java.io.IOException;
import java.io.Serializable;
import java.io.Writer;
import java.net.Inet6Address;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDPluginManagementServlet
extends HttpServlet {
    private static final long serialVersionUID = -6458614560444771181L;
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDPluginManagementServlet.class);
    private static final String EDIT_OPTIONS_TEMPLATE = "templates/options/secsignid-options-page-container.vm";
    private static final String SHOW_IP_TEMPLATE = "templates/options/secsignid-ip-page.vm";
    private static final String SECSIGNID_TUTORIAL_TEMPLATE = "templates/tutorial/secsignid-tutorial-container.vm";
    private static final String CHANGE_TEMPLATE = "templates/secsignid-changegroups.vm";
    private static final String SHOW_IP_PARA = "show_ip";
    private static final String EDIT_USER_PARA = "edit_users";
    private static final String EDIT_OPTIONS_PARA = "edit_options";
    private static final String SAVE_OPTIONS_PARA = "save_options";
    private static final String SHOW_TUTORIAL_PARA = "show_tutorial";
    private final I18nResolver i18nResolver;
    private SecSignIDDataAccessor dataAccessor;
    private boolean hasError;
    private final TemplateRenderer templateRenderer;
    private WebResourceManager webResourceManager;
    private HashMap<String, Object> context = new HashMap();
    private boolean isJira;
    private boolean isBamboo;
    private boolean isConfluence;
    private boolean isCrowd;
    private boolean isBitbucket;
    private boolean fidoSupported;
    private String _choosenGroup;
    private String _choosenGroupName;
    private long _choosenGroupDirid;
    private SecSignID2FASettings _choosenGroupSettings;
    private boolean _isCreatedGroup;
    private boolean _gitAccessSecuredBy2FA;
    private Integer _gitAccessNew2FARequiredAfterHours;
    private boolean _gitAccessIPSafeZoneEnabled;
    private boolean _gitAccessProtectReadAccessBy2FA;
    private boolean _gitAccessBlockUserWithoutSecSignId;
    private String _gitAccessEnabledForGroups;
    private List<String> _groupNames;
    private Collection<Directory> _directories;
    private int _groupPage;
    private int _pagesGroup;
    private long _chosenDir;
    boolean _byUserGroup;
    boolean _oneOptionByUser;
    Integer _pwdAllowedValueForGroup;
    Integer _passwordlessValueForGroup;
    Integer _twostepValueForGroup;
    Integer _totpValueForGroup;
    Integer _mailotpValueForGroup;
    Integer _fidoValueForGroup;
    SecSignID2FASettings _admin2FASettings;
    SecSignID2FAActivatedSettings _admin2FAActivatedSettings;
    private String _serviceName;
    private String _idServerUrl;
    private boolean _showSuccess;
    private boolean _showError;
    private boolean _synchronizable;
    private boolean _synchronizableWrite;
    private boolean _resetOnCrowd;
    private String _crowdBaseUrl;
    private String _ldapAttr;
    private boolean _ldapEnable;
    private boolean _localEnable;
    private boolean _writeLDAPEnable;
    private List<String> _errorList = new ArrayList<String>();
    private String _fallbackServerUrl;
    private boolean _ownPinAccount;
    private boolean _pluginPinAccount;
    private String _pinAccount;
    private String _pinAccountPassword;
    private boolean _safeZone;
    private boolean _useForwardedHeader;
    private List<String> _ipRanges;
    private List<SecSignIDWhiteListItem> _whiteList;
    private boolean _userChange;
    private boolean _customLogin;
    private String _loginColor;
    private boolean _useNewCrowdLogin;
    private String _customLogoData;
    private boolean _sessionTimeout;
    private int _sessionTimeoutDuration;
    private String _customLoginLink;
    private String _customLoginLinkText;
    private boolean _trustDeviceEnabled;
    private int _trustDeviceDuration;
    private String _loginTitle;
    private String _loginSubtitle;
    private String _iOSUrl;
    private String _androidUrl;
    private String _windowsUrl;
    private String _macOSUrl;
    private String _pluginversion;
    private boolean _informUser;
    private boolean _informAdmin;
    private String _informGroup;
    private String _observeGroup;
    long _pages;
    int _page;
    long _pagesSearch;
    int _pageSearch;
    String _searchKey;
    String _baseUrl;
    private TreeMap<String, String> _ipMappings;
    User _loggedInUser;
    String[] _adminIDs;
    Integer _adminPwd;
    boolean _skipAdmin;
    boolean _tutorialRepeated;
    String _wishID;
    String _qrCode;
    boolean _add;
    boolean _fillUsername;
    boolean _fillUsernameCompany;
    boolean _fillMail;
    boolean _fillPattern;
    String _fillPatternPattern;
    boolean _allDeactivated;
    boolean _activationAdd;
    boolean _activationCrowd;
    boolean _activationDialog;
    boolean _activationUser;
    boolean _activationReserve;
    boolean _serverAdded;
    boolean _passwordlessAuthEnabled;
    boolean _twoStepAuthEnabled;
    boolean _mailotpAuthEnabled;
    boolean _totpAuthEnabled;
    boolean _fidoAuthEnabled;
    boolean _groupsCreated;
    boolean _disableBasicAuth;
    boolean _disableAccessToken;
    boolean _useFallback;
    boolean _useRestore;
    private String _companyName;
    private String _companyNameClearLower;
    boolean _defaultServer;
    private boolean _allowUserExisting;
    private boolean _allowUserCreate;
    private HashMap<String, SecSignID2FASettings> _groupMappings;
    private boolean _serviceDesk;
    private boolean _serviceDesk2FA;
    private String _serviceDeskGroups;

    public SecSignIDPluginManagementServlet(I18nResolver i18nResolver, SecSignIDDataAccessor staticAccessor, TemplateRenderer templateRenderer, WebResourceManager webResourceManager) {
        this.i18nResolver = i18nResolver;
        this.dataAccessor = staticAccessor;
        this.templateRenderer = templateRenderer;
        this.webResourceManager = webResourceManager;
        this.isJira = this.dataAccessor.getApplication().equals("Jira");
        this.isBamboo = this.dataAccessor.getApplication().equals("Bamboo");
        this.isConfluence = this.dataAccessor.getApplication().equals("Confluence");
        this.isCrowd = this.dataAccessor.getApplication().equals("Crowd");
        this.isBitbucket = this.dataAccessor.getApplication().equals("Bitbucket");
        this.fidoSupported = SecSignIDCommonStaticAccessor.isFIDOSupported();
        this._baseUrl = this.dataAccessor.getBaseUrl();
        this._pluginversion = this.dataAccessor.getVersion();
    }

    public WebResourceManager getWebResourceManager() {
        return this.webResourceManager;
    }

    private void showChange(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        this.context = new HashMap();
        this.getPluginOptions();
        this._errorList = new ArrayList<String>();
        this.fillContext(httpServletReq, httpServletResp);
        httpServletResp.setContentType("text/html;charset=utf-8");
        try {
            this.templateRenderer.render(CHANGE_TEMPLATE, this.context, (Writer)httpServletResp.getWriter());
        }
        catch (Exception er) {
            logger.error(er.getMessage(), (Throwable)er);
        }
    }

    protected void doGet(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        boolean basicAuthUsed;
        User appUser = this.dataAccessor.getUserCurrentlyLoggedIn();
        boolean bl = basicAuthUsed = httpServletReq.getSession().getAttribute("secsign.basicAuth") != null;
        if (appUser == null || basicAuthUsed || !this.dataAccessor.isUserAdmin(appUser)) {
            httpServletResp.sendRedirect(this.dataAccessor.getBaseUrl());
            return;
        }
        this.getAdminValues();
        this._chosenDir = -1L;
        this._choosenGroup = null;
        this._groupNames = null;
        this._pagesGroup = 0;
        this._groupMappings = null;
        this._errorList = new ArrayList<String>();
        this._showSuccess = false;
        this._showError = false;
        this._directories = this.dataAccessor.getAllDirectories();
        if (httpServletReq.getParameter("dirID") != null) {
            this._chosenDir = Long.parseLong(httpServletReq.getParameter("dirID"));
            if (httpServletReq.getParameter("groupPage") != null) {
                this._groupPage = Integer.parseInt(httpServletReq.getParameter("groupPage"));
            } else if (httpServletReq.getParameter("groupName") != null) {
                String groupName = httpServletReq.getParameter("groupName");
                try {
                    this._groupPage = this.dataAccessor.findPageForGroup(groupName, this._chosenDir);
                }
                catch (DirectoryNotFoundException e) {
                    logger.error("DirectoryNotFoundException on get GroupPage");
                }
                catch (com.atlassian.crowd.exception.OperationFailedException e) {
                    logger.error("OperationFailedException on get GroupPage");
                }
            } else {
                this._groupPage = 1;
            }
            if (this._groupPage == 0) {
                this._groupPage = 1;
            }
            try {
                this._groupNames = this.dataAccessor.getGroups(this._groupPage, this._chosenDir);
                this._pagesGroup = this.dataAccessor.getPagesGroup(this._chosenDir);
                this._groupMappings = this.dataAccessor.get2FASettingsForGroups(this._groupNames);
            }
            catch (DirectoryNotFoundException e) {
                logger.error("DirectoryNotFoundException on getGroupMappings: " + e.getMessage(), (Throwable)e);
                this.addError(this.i18nResolver.getText("secsignid.messages.error.operation.failed"));
            }
            catch (Exception e) {
                logger.error(e.getLocalizedMessage() + " on getGroupMappings");
                this.addError(this.i18nResolver.getText("secsignid.messages.error.operation.failed"));
            }
        }
        if (SecSignIDCommonStaticAccessor.getFirstStart() || httpServletReq.getParameter(SHOW_TUTORIAL_PARA) != null) {
            this.doShowTutorial(httpServletReq, httpServletResp);
            return;
        }
        boolean checkStarted = SecSignIDCommonStaticAccessor.newAuthenticationFixStarted();
        if (!checkStarted) {
            this.showChange(httpServletReq, httpServletResp);
            return;
        }
        if (!SecSignIDCommonStaticAccessor.newAuthenticationFixed()) {
            this.showChange(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter(SHOW_IP_PARA) != null) {
            this.doShowIPs(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter(EDIT_OPTIONS_PARA) != null) {
            this.doEditOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter(EDIT_OPTIONS_PARA) == null && httpServletReq.getParameter(EDIT_USER_PARA) == null) {
            this.doEditOptions(httpServletReq, httpServletResp);
            return;
        }
    }

    private void handleGroupChoosen(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        String mappingKey = httpServletReq.getParameter("groupToChange");
        String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
        long dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(mappingKey);
        this._choosenGroup = mappingKey;
        this._choosenGroupName = groupname;
        this._choosenGroupDirid = dirid;
        try {
            this._choosenGroupSettings = this.dataAccessor.get2FASettingsForGroup(groupname, dirid);
            this._isCreatedGroup = this.isCreatedGroup(groupname);
        }
        catch (Exception e) {
            logger.error(e.getClass() + "on handleGroupChoosen");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError(e));
        }
        this.renderOptions(httpServletReq, httpServletResp);
    }

    private void renderOptions(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        this.getAdminValues();
        this.fillContext(httpServletReq, httpServletResp);
        httpServletResp.setContentType("text/html;charset=utf-8");
        try {
            this.templateRenderer.render(EDIT_OPTIONS_TEMPLATE, this.context, (Writer)httpServletResp.getWriter());
        }
        catch (Exception er) {
            logger.error(er.getMessage(), (Throwable)er);
        }
    }

    private void renderTutorial(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        this.fillContext(httpServletReq, httpServletResp);
        httpServletResp.setContentType("text/html;charset=utf-8");
        try {
            this.templateRenderer.render(SECSIGNID_TUTORIAL_TEMPLATE, this.context, (Writer)httpServletResp.getWriter());
        }
        catch (Exception er) {
            logger.error(er.getMessage(), (Throwable)er);
        }
    }

    private void fillContext(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        this.context = new HashMap();
        this.context.put("pluginversion", this._pluginversion);
        this.context.put("thisApp", this.dataAccessor.getApplication());
        this.context.put("contextPath", httpServletReq.getContextPath());
        this.context.put("upmLink", this.dataAccessor.getUPMLink());
        this.context.put("synchronizable", this._synchronizable);
        this.context.put("synchronizableWrite", this._synchronizableWrite);
        this.context.put("defaultServer", this._defaultServer);
        this.context.put("useFallback", this._useFallback);
        this.context.put("passwordlessAuthEnabled", this._passwordlessAuthEnabled);
        this.context.put("twoStepAuthEnabled", this._twoStepAuthEnabled);
        this.context.put("mailotpAuthEnabled", this._mailotpAuthEnabled);
        this.context.put("totpAuthEnabled", this._totpAuthEnabled);
        this.context.put("fidoAuthEnabled", this._fidoAuthEnabled);
        this.context.put("groupsCreated", this._groupsCreated);
        this.context.put("req", httpServletReq);
        this.context.put("serviceName", this._serviceName);
        this.context.put("companyName", this._companyName);
        this.context.put("companyNameClearLower", this._companyNameClearLower);
        this.context.put("pinAccount", this._pinAccount);
        this.context.put("ownPinAccount", this._ownPinAccount);
        this.context.put("pluginPinAccount", this._pluginPinAccount);
        this.context.put("pinAccountPassword", this._pinAccountPassword);
        this.context.put("disableBasicAuth", this._disableBasicAuth);
        this.context.put("disableAccessToken", this._disableAccessToken);
        this.context.put("whiteList", this._whiteList);
        this.context.put("allowUserExisting", this._allowUserExisting);
        this.context.put("allowUserCreate", this._allowUserCreate);
        this.context.put("fillUsername", this._fillUsername);
        this.context.put("fillMail", this._fillMail);
        this.context.put("fillUsernameCompany", this._fillUsernameCompany);
        this.context.put("fillPattern", this._fillPattern);
        this.context.put("fillPatternPattern", this._fillPatternPattern);
        this.context.put("directories", this._directories);
        this.context.put("adminUser", this._loggedInUser);
        this.context.put("adminUserKey", this.dataAccessor.getUserKeyForUsername(this._loggedInUser.getName()));
        this.context.put("adminIDs", SecSignIDMappingUtils.getSecSignIdString(this._adminIDs));
        this.context.put("fidoSupported", this.fidoSupported);
        this.context.put("skipAdmin", this._skipAdmin);
        this.context.put("tutorialRepeated", this._tutorialRepeated);
        this.context.put("admin2FASettings", this._admin2FASettings);
        this.context.put("admin2FAActivatedSettings", this._admin2FAActivatedSettings);
        this.context.put("servletObject", (Object)this);
        if (this._chosenDir > 0L) {
            this.context.put("chosenDir", this._chosenDir);
        }
        this.context.put("pagesGroup", this._pagesGroup);
        this.context.put("groupPage", this._groupPage);
        this.context.put("groupNames", this._groupNames);
        this.context.put("groupMappings", this._groupMappings);
        this.context.put("authIsAllowedValue", SecSignIDCommonConstants.AuthIsAllowed);
        this.context.put("PASSWORDLESSGROUPNAME", "PasswordlessAllowed".toLowerCase());
        this.context.put("TWOSTEPGROUPNAME", "2SASecSignIDAllowed".toLowerCase());
        this.context.put("MAILOTPGROUPNAME", "2SAMailOTPAllowed".toLowerCase());
        this.context.put("TOTPGROUPNAME", "2SATOTPAllowed".toLowerCase());
        this.context.put("FIDOGROUPNAME", "2SAFIDOAllowed".toLowerCase());
        this.context.put("iosUrl", this._iOSUrl);
        this.context.put("androidUrl", this._androidUrl);
        this.context.put("windowsUrl", this._windowsUrl);
        this.context.put("macUrl", this._macOSUrl);
        this.context.put("sessionTimeout", this._sessionTimeout);
        this.context.put("sessionTimeoutDuration", this._sessionTimeoutDuration);
        this.context.put("trustDeviceEnabled", this._trustDeviceEnabled);
        this.context.put("trustDeviceDuration", this._trustDeviceDuration);
        this.context.put("safeZone", this._safeZone);
        this.context.put("ipRanges", this._ipRanges);
        this.context.put("useForwardedHeader", this._useForwardedHeader);
        this.context.put("userChange", this._userChange);
        this.context.put("useNewCrowdLogin", this._useNewCrowdLogin);
        this.context.put("loginTitle", this._loginTitle);
        this.context.put("loginSubtitle", this._loginSubtitle);
        this.context.put("customLogoData", this._customLogoData);
        this.context.put("customLoginLink", this._customLoginLink);
        this.context.put("customLoginLinkText", this._customLoginLinkText);
        this.context.put("customLogin", this._customLogin);
        this.context.put("loginColor", this._loginColor);
        this.context.put("ldapEnable", this._ldapEnable);
        this.context.put("ldapAttr", this._ldapAttr);
        this.context.put("localEnable", this._localEnable);
        this.context.put("writeLDAPEnable", this._writeLDAPEnable);
        this.context.put("resetOnCrowd", this._resetOnCrowd);
        this.context.put("crowdBaseUrl", this._crowdBaseUrl);
        this.context.put("idServerUrl", this._idServerUrl);
        this.context.put("fallbackServerUrl", this._fallbackServerUrl);
        this.context.put("showSuccess", this._showSuccess);
        this.context.put("showError", this._showError);
        this.context.put("errorList", new ArrayList<String>(this._errorList));
        this.context.put("informUser", this._informUser);
        this.context.put("informAdmin", this._informAdmin);
        this.context.put("informGroup", this._informGroup);
        this.context.put("observeGroup", this._observeGroup);
        if (this._choosenGroup != null) {
            this.context.put("choosenGroup", this._choosenGroup);
            this.context.put("choosenGroupName", this._choosenGroupName);
            this.context.put("choosenGroupDirid", this._choosenGroupDirid);
            this.context.put("choosenGroupSettings", this._choosenGroupSettings);
            this.context.put("isCreatedGroup", this._isCreatedGroup);
        }
        if (this.isJira) {
            this.context.put("imagepath", "download/resources/com.secsign.secsignid:secsignid-resources");
        }
        if (this.isConfluence) {
            this.context.put("imagepath", "download/resources/com.secsign.secsignid-confluence:secsignid-resources");
        }
        if (this.isCrowd) {
            this.context.put("imagepath", "download/resources/com.secsign.secsign-crowd:secsignid-resources");
        }
        if (this.isBitbucket) {
            this.context.put("imagepath", "download/resources/com.secsign.secsignid-bitbucket:secsignid-resources");
        }
        if (this.isBamboo) {
            this.context.put("imagepath", "download/resources/com.secsign.secsignid-bamboo:secsignid-resources");
        }
        this.context.put("templateHelper", new SecSignIDTemplateHelper());
        this.context.put("isJira", this.isJira);
        this.context.put("isConfluence", this.isConfluence);
        this.context.put("isCrowd", this.isCrowd);
        this.context.put("isBitbucket", this.isBitbucket);
        this.context.put("isBamboo", this.isBamboo);
        this.context.put("serviceDesk", this._serviceDesk);
        this.context.put("serviceDesk2FA", this._serviceDesk2FA);
        this.context.put("serviceDeskGroups", this._serviceDeskGroups);
        this.context.put("ipMappings", this._ipMappings);
        this.context.put("pages", this._pages);
        this.context.put("page", this._page);
        if (this.isBitbucket) {
            this.context.put("gitClientAccessSecSignId", this._gitAccessSecuredBy2FA);
            this.context.put("gitAccessNew2FARequiredAfterHours", this._gitAccessNew2FARequiredAfterHours);
            this.context.put("gitAccessIPSafeZoneEnabled", this._gitAccessIPSafeZoneEnabled);
            this.context.put("gitAccessProtectReadAccessBy2FA", this._gitAccessProtectReadAccessBy2FA);
            this.context.put("gitAccessBlockUserWithoutSecSignId", this._gitAccessBlockUserWithoutSecSignId);
            this.context.put("gitAccessEnabledForGroups", this._gitAccessEnabledForGroups == null ? "" : this._gitAccessEnabledForGroups);
        }
    }

    private void getPluginOptions() {
        this._directories = this.dataAccessor.getAllDirectories();
        this._serviceName = SecSignIDCommonStaticAccessor.getServiceName();
        this._idServerUrl = SecSignIDCommonStaticAccessor.getSecSignIdServerUrl();
        this._defaultServer = SecSignIDCommonStaticAccessor.isDefaultServer();
        this._fallbackServerUrl = SecSignIDCommonStaticAccessor.getFallbackSecSignIdServerUrl();
        this._ownPinAccount = SecSignIDCommonStaticAccessor.hasOwnPinAccount();
        this._pluginPinAccount = SecSignIDCommonStaticAccessor.hasPluginPinAccount();
        if (this._ownPinAccount) {
            String[] array = SecSignIDCommonStaticAccessor.getPinAccount();
            this._pinAccount = array[0];
            this._pinAccountPassword = array[1];
        } else {
            this._pinAccount = "";
            this._pinAccountPassword = "";
        }
        this._passwordlessAuthEnabled = SecSignIDCommonStaticAccessor.getPasswordlessAuthEnabled();
        this._twoStepAuthEnabled = SecSignIDCommonStaticAccessor.getTwoStepAuthEnabled();
        this._mailotpAuthEnabled = SecSignIDCommonStaticAccessor.getMailotpAuthEnabled();
        this._totpAuthEnabled = SecSignIDCommonStaticAccessor.getTotpAuthEnabled();
        this._fidoAuthEnabled = SecSignIDCommonStaticAccessor.getFidoAuthEnabled();
        this._groupsCreated = SecSignIDCommonStaticAccessor.getGroupsCreated();
        this._safeZone = SecSignIDCommonStaticAccessor.getSafeZone();
        this._useForwardedHeader = SecSignIDCommonStaticAccessor.getUseForwardedHeader();
        this._userChange = SecSignIDCommonStaticAccessor.getUserChange();
        this._customLogin = SecSignIDCommonStaticAccessor.getCustomLogin();
        this._loginColor = SecSignIDCommonStaticAccessor.getLoginColor();
        this._useNewCrowdLogin = SecSignIDCommonStaticAccessor.getUseNewCrowdLogin();
        this._loginTitle = SecSignIDCommonStaticAccessor.getLoginTitle();
        this._loginSubtitle = SecSignIDCommonStaticAccessor.getLoginSubtitle();
        this._customLogoData = SecSignIDCommonStaticAccessor.getCustomLogo();
        this._customLoginLink = SecSignIDCommonStaticAccessor.getCustomLink();
        this._customLoginLinkText = SecSignIDCommonStaticAccessor.getCustomLinkText();
        this._sessionTimeout = SecSignIDCommonStaticAccessor.getSessionTimeoutEnabled();
        this._sessionTimeoutDuration = SecSignIDCommonStaticAccessor.getSessionTimeoutDuration();
        this._trustDeviceEnabled = SecSignIDCommonStaticAccessor.getTrustDeviceEnabled();
        this._trustDeviceDuration = SecSignIDCommonStaticAccessor.getTrustDeviceDuration();
        this._iOSUrl = SecSignIDCommonStaticAccessor.getIOSUrl();
        this._androidUrl = SecSignIDCommonStaticAccessor.getAndroidUrl();
        this._windowsUrl = SecSignIDCommonStaticAccessor.getWindowsUrl();
        this._macOSUrl = SecSignIDCommonStaticAccessor.getMacOSUrl();
        this._ipRanges = SecSignIDCommonStaticAccessor.getIPRanges();
        this._useFallback = SecSignIDCommonStaticAccessor.getUseFallback();
        this._useRestore = SecSignIDCommonStaticAccessor.getUseRestore();
        this._disableBasicAuth = SecSignIDCommonStaticAccessor.isBasicAuthDisabled();
        this._disableAccessToken = SecSignIDCommonStaticAccessor.isAccessTokenDisabled();
        this._fillUsername = SecSignIDCommonStaticAccessor.getAutoFillUsername();
        this._fillUsernameCompany = SecSignIDCommonStaticAccessor.getAutoFillUsernameCompany();
        this._fillMail = SecSignIDCommonStaticAccessor.getAutoFillMail();
        this._fillPattern = SecSignIDCommonStaticAccessor.getAutoFillPattern();
        this._fillPatternPattern = SecSignIDCommonStaticAccessor.getAutoFillPatternPattern();
        this._companyName = SecSignIDCommonStaticAccessor.getCompanyName();
        this._companyNameClearLower = SecSignIDCommonStaticAccessor.getCleanLowerCaseCompanyName();
        this._synchronizable = SecSignIDCommonStaticAccessor.isSynchronizable();
        this._synchronizableWrite = SecSignIDCommonStaticAccessor.isSynchronizableWrite();
        this._allDeactivated = this.dataAccessor.getAllDeactivated();
        this._serviceDesk = SecSignIDCommonStaticAccessor.getServiceDesk();
        this._serviceDesk2FA = SecSignIDCommonStaticAccessor.getServiceDesk2FA();
        this._serviceDeskGroups = SecSignIDCommonStaticAccessor.getServiceDeskGroups();
        this._crowdBaseUrl = SecSignIDCommonStaticAccessor.getCrowdBaseUrl();
        this._resetOnCrowd = SecSignIDCommonStaticAccessor.getResetOnCrowd();
        this._ldapEnable = SecSignIDCommonStaticAccessor.getLDAPEnable();
        this._ldapAttr = SecSignIDCommonStaticAccessor.getLDAPSecSignIDAttr();
        this._localEnable = SecSignIDCommonStaticAccessor.getLocalEnable();
        this._writeLDAPEnable = SecSignIDCommonStaticAccessor.getWriteLDAPEnable();
        this._allowUserCreate = SecSignIDCommonStaticAccessor.getAllowUserCreate();
        this._allowUserExisting = SecSignIDCommonStaticAccessor.getAllowUserExisting();
        if (this.isBitbucket) {
            this._gitAccessSecuredBy2FA = SecSignIDCommonStaticAccessor.getGitAccessSecuredBy2FA();
            this._gitAccessNew2FARequiredAfterHours = SecSignIDCommonStaticAccessor.getGitAccessNew2FARequiredAfterHours();
            this._gitAccessIPSafeZoneEnabled = SecSignIDCommonStaticAccessor.getGitAccessIPSafeZoneEnabled();
            this._gitAccessBlockUserWithoutSecSignId = SecSignIDCommonStaticAccessor.getGitAccessBlockUserWithoutSecSignId();
            this._gitAccessEnabledForGroups = SecSignIDCommonStaticAccessor.getGitAccessEnabledForGroups();
            this._gitAccessProtectReadAccessBy2FA = SecSignIDCommonStaticAccessor.getGitAccessProtectReadAccessBy2FA();
        }
        this._informUser = SecSignIDCommonStaticAccessor.getInformUser();
        this._informAdmin = SecSignIDCommonStaticAccessor.getInformAdmin();
        this._informGroup = SecSignIDCommonStaticAccessor.getInformGroup();
        this._observeGroup = SecSignIDCommonStaticAccessor.getObserveGroup();
        this._whiteList = SecSignIDCommonStaticAccessor.getWhiteList();
        this._tutorialRepeated = !SecSignIDCommonStaticAccessor.getFirstStart();
    }

    private void saveServiceDesk(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean oldServiceDesk = this._serviceDesk;
        this._serviceDesk = Boolean.valueOf(httpServletReq.getParameter("serviceDeskInput"));
        boolean oldServiceDesk2FA = this._serviceDesk2FA;
        this._serviceDesk2FA = Boolean.valueOf(httpServletReq.getParameter("serviceDesk2FAInput"));
        String oldServiceDeskGroups = this._serviceDeskGroups;
        this._serviceDeskGroups = httpServletReq.getParameter("serviceDeskGroupsInput");
        if (this._serviceDeskGroups != null && !this._serviceDeskGroups.equals("")) {
            String result = "";
            String[] groupnames = this._serviceDeskGroups.split(",");
            List<Directory> dirs = this.dataAccessor.getAllDirectories();
            for (String string : groupnames) {
                try {
                    if (string.equals("")) continue;
                    if (string.contains(";")) {
                        long dirid;
                        String groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
                        if (this.dataAccessor.checkGroupExists(groupname, dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string))) {
                            if (result.equals("")) {
                                result = result + string;
                                continue;
                            }
                            result = result + "," + string;
                            continue;
                        }
                        this.addError(this.i18nResolver.getText("secsignid.options.group.not.exists"));
                        this._showError = true;
                        return;
                    }
                    for (Directory directory : dirs) {
                        if (this.dataAccessor.checkGroupExists(string, directory.getId())) {
                            if (result.equals("")) {
                                result = result + string + ";" + directory.getId();
                                continue;
                            }
                            result = result + "," + string + ";" + directory.getId();
                            continue;
                        }
                        this.addError(this.i18nResolver.getText("secsignid.options.group.not.exists"));
                        this._showError = true;
                        return;
                    }
                }
                catch (com.atlassian.crowd.exception.OperationFailedException e) {
                    logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError((Exception)((Object)e)));
                    logger.error("OperationFailedException on saving serviceDesk Groups on saveServiceDesk");
                }
            }
            this._serviceDeskGroups = result;
        } else {
            this._serviceDeskGroups = "";
        }
        if (this._serviceDesk != oldServiceDesk) {
            this.dataAccessor.logChangeSettingToAuditLog("serviceDesk", String.valueOf(this._serviceDesk), String.valueOf(oldServiceDesk), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("serviceDesk", String.valueOf(this._serviceDesk), String.valueOf(oldServiceDesk), this.dataAccessor.getUserKeyForUsername(this.dataAccessor.getUserCurrentlyLoggedIn().getName()), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId());
            }
        }
        if (this._serviceDesk2FA != oldServiceDesk2FA) {
            this.dataAccessor.logChangeSettingToAuditLog("serviceDesk2FA", String.valueOf(this._serviceDesk2FA), String.valueOf(oldServiceDesk2FA), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("serviceDesk2FA", String.valueOf(this._serviceDesk2FA), String.valueOf(oldServiceDesk2FA), this.dataAccessor.getUserKeyForUsername(this.dataAccessor.getUserCurrentlyLoggedIn().getName()), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId());
            }
        }
        if (this._serviceDeskGroups != oldServiceDeskGroups) {
            this.dataAccessor.logChangeSettingToAuditLog("serviceDeskGroups", String.valueOf(this._serviceDeskGroups), String.valueOf(oldServiceDeskGroups), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("serviceDeskGroups", String.valueOf(this._serviceDeskGroups), String.valueOf(oldServiceDeskGroups), this.dataAccessor.getUserKeyForUsername(this.dataAccessor.getUserCurrentlyLoggedIn().getName()), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId());
            }
        }
        SecSignIDCommonStaticAccessor.saveServiceDesk(this._serviceDesk);
        SecSignIDCommonStaticAccessor.saveServiceDesk2FA(this._serviceDesk2FA);
        SecSignIDCommonStaticAccessor.saveServiceDeskGroups(this._serviceDeskGroups);
    }

    private void saveGitClientAccess(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean oldgitAccessSecuredBy2FA = this._gitAccessSecuredBy2FA;
        this._gitAccessSecuredBy2FA = Boolean.valueOf(httpServletReq.getParameter("gitClientAccessSecSignIdInput"));
        Integer oldgitAccessNew2FARequiredAfterHours = this._gitAccessNew2FARequiredAfterHours;
        this._gitAccessNew2FARequiredAfterHours = Integer.valueOf(httpServletReq.getParameter("gitAccessNew2FARequiredAfterHoursInput"));
        boolean oldgitAccessIPSafeZoneEnabled = this._gitAccessIPSafeZoneEnabled;
        this._gitAccessIPSafeZoneEnabled = Boolean.valueOf(httpServletReq.getParameter("gitAccessIPSafeZoneEnabledInput"));
        boolean oldgitAccessProtectReadAccessBy2FA = this._gitAccessProtectReadAccessBy2FA;
        this._gitAccessProtectReadAccessBy2FA = Boolean.valueOf(httpServletReq.getParameter("gitAccessProtectReadAccessBy2FAInput"));
        boolean oldgitAccessBlockUserWithoutSecSignId = this._gitAccessBlockUserWithoutSecSignId;
        this._gitAccessBlockUserWithoutSecSignId = Boolean.valueOf(httpServletReq.getParameter("gitAccessBlockUserWithoutSecSignIdInput"));
        String oldgitAccessEnabledForGroups = this._gitAccessEnabledForGroups;
        this._gitAccessEnabledForGroups = String.valueOf(httpServletReq.getParameter("gitAccessEnabledForGroupsInput"));
        SecSignIDCommonStaticAccessor.saveGitAccessSecuredBy2FA(this._gitAccessSecuredBy2FA);
        if (!this._gitAccessSecuredBy2FA == oldgitAccessSecuredBy2FA) {
            this.dataAccessor.logChangeSettingToAuditLog("gitAccessSecuredBy2FA", String.valueOf(this._gitAccessSecuredBy2FA), String.valueOf(oldgitAccessSecuredBy2FA), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("gitAccessSecuredBy2FA", String.valueOf(this._gitAccessSecuredBy2FA), String.valueOf(oldgitAccessSecuredBy2FA), this.dataAccessor.getUserKeyForUsername(this.dataAccessor.getUserCurrentlyLoggedIn().getName()), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId());
            }
        }
        SecSignIDCommonStaticAccessor.saveGitAccessBlockUserWithoutSecSignId(this._gitAccessBlockUserWithoutSecSignId);
        if (!this._gitAccessBlockUserWithoutSecSignId == oldgitAccessBlockUserWithoutSecSignId) {
            this.dataAccessor.logChangeSettingToAuditLog("gitAccessBlockUserWithoutSecSignId", String.valueOf(this._gitAccessBlockUserWithoutSecSignId), String.valueOf(oldgitAccessBlockUserWithoutSecSignId), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("gitAccessBlockUserWithoutSecSignId", String.valueOf(this._gitAccessBlockUserWithoutSecSignId), String.valueOf(oldgitAccessBlockUserWithoutSecSignId), this.dataAccessor.getUserKeyForUsername(this.dataAccessor.getUserCurrentlyLoggedIn().getName()), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId());
            }
        }
        SecSignIDCommonStaticAccessor.saveGitAccessIPSafeZoneEnabled(this._gitAccessIPSafeZoneEnabled);
        if (!this._gitAccessIPSafeZoneEnabled == oldgitAccessIPSafeZoneEnabled) {
            this.dataAccessor.logChangeSettingToAuditLog("gitAccessIPSafeZoneEnabled", String.valueOf(this._gitAccessIPSafeZoneEnabled), String.valueOf(oldgitAccessIPSafeZoneEnabled), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("gitAccessIPSafeZoneEnabled", String.valueOf(this._gitAccessIPSafeZoneEnabled), String.valueOf(oldgitAccessIPSafeZoneEnabled), this.dataAccessor.getUserKeyForUsername(this.dataAccessor.getUserCurrentlyLoggedIn().getName()), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId());
            }
        }
        SecSignIDCommonStaticAccessor.saveGitAccessProtectReadAccessBy2FA(this._gitAccessProtectReadAccessBy2FA);
        if (!this._gitAccessProtectReadAccessBy2FA == oldgitAccessProtectReadAccessBy2FA) {
            this.dataAccessor.logChangeSettingToAuditLog("gitAccessProtectReadAccessBy2FA", String.valueOf(this._gitAccessProtectReadAccessBy2FA), String.valueOf(oldgitAccessProtectReadAccessBy2FA), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("gitAccessProtectReadAccessBy2FA", String.valueOf(this._gitAccessProtectReadAccessBy2FA), String.valueOf(oldgitAccessProtectReadAccessBy2FA), this.dataAccessor.getUserKeyForUsername(this.dataAccessor.getUserCurrentlyLoggedIn().getName()), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId());
            }
        }
        SecSignIDCommonStaticAccessor.saveGitAccessNew2FARequiredAfterHours(this._gitAccessNew2FARequiredAfterHours);
        if (!this._gitAccessNew2FARequiredAfterHours.equals(oldgitAccessNew2FARequiredAfterHours)) {
            this.dataAccessor.logChangeSettingToAuditLog("gitAccessNew2FARequiredAfterHours", String.valueOf(this._gitAccessNew2FARequiredAfterHours), String.valueOf(oldgitAccessNew2FARequiredAfterHours), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("gitAccessNew2FARequiredAfterHours", String.valueOf(this._gitAccessNew2FARequiredAfterHours), String.valueOf(oldgitAccessNew2FARequiredAfterHours), this.dataAccessor.getUserKeyForUsername(this.dataAccessor.getUserCurrentlyLoggedIn().getName()), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId());
            }
        }
        SecSignIDCommonStaticAccessor.saveGitAccessEnabledForGroups(this._gitAccessEnabledForGroups);
        if (!this._gitAccessEnabledForGroups.equals(oldgitAccessEnabledForGroups)) {
            this.dataAccessor.logChangeSettingToAuditLog("gitAccessEnabledForGroups", String.valueOf(this._gitAccessEnabledForGroups), String.valueOf(oldgitAccessEnabledForGroups), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("gitAccessEnabledForGroups", String.valueOf(this._gitAccessEnabledForGroups), String.valueOf(oldgitAccessEnabledForGroups), this.dataAccessor.getUserKeyForUsername(this.dataAccessor.getUserCurrentlyLoggedIn().getName()), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId());
            }
        }
        this._showSuccess = true;
    }

    protected void doPost(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        boolean basicAuthUsed;
        User appUser = this.dataAccessor.getUserCurrentlyLoggedIn();
        boolean bl = basicAuthUsed = httpServletReq.getSession().getAttribute("secsign.basicAuth") != null;
        if (appUser == null || basicAuthUsed || !this.dataAccessor.isUserAdmin(appUser)) {
            httpServletResp.sendRedirect(this.dataAccessor.getBaseUrl());
            return;
        }
        this._showSuccess = false;
        this._showError = false;
        this._chosenDir = -1L;
        this._choosenGroup = null;
        this._groupNames = null;
        this._pagesGroup = 0;
        this._groupMappings = null;
        this.hasError = false;
        this._errorList = new ArrayList<String>();
        this.getPluginOptions();
        if (httpServletReq.getParameter("secsignid-activate-crowd") != null) {
            this.activateCrowdAccess(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter(SHOW_IP_PARA) != null) {
            this.doShowIPs(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("groupToAdd") != null) {
            this.addGroupToOtherGroup(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("resetFIDOForUser") != null) {
            this.handleResetFIDO(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("resetTOTPForUser") != null) {
            this.handleResetTOTP(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("groupToChange") != null) {
            this.handleGroupChoosen(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("search-for-groups") != null) {
            this.handleSearchForGroup(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter(SAVE_OPTIONS_PARA) != null) {
            this.doSaveOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("secsignid-save-user") != null) {
            this.saveChangesForUser(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("add-user-to-twostep") != null || httpServletReq.getParameter("add-user-to-fido") != null || httpServletReq.getParameter("add-user-to-totp") != null || httpServletReq.getParameter("add-user-to-mailotp") != null || httpServletReq.getParameter("add-user-to-passwordless") != null) {
            this.addUserToGroup(httpServletReq, httpServletResp);
            return;
        }
    }

    private void activateCrowdAccess(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        try {
            this.dataAccessor.activateCrowdAccess();
            JSONObject answerObject = new JSONObject();
            answerObject.put("success", true);
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (Exception e) {
            logger.error("Exception on activating crowd access: " + e.getMessage());
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError(e));
            return;
        }
    }

    private void addGroupToOtherGroup(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        JSONObject answerObject = new JSONObject();
        try {
            String groupName = httpServletReq.getParameter("group");
            String groupToAdd = httpServletReq.getParameter("groupToAdd");
            try {
                this.dataAccessor.addGroupMembersToGroup(groupName, groupToAdd);
                answerObject.put("success", true);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
                return;
            }
            catch (Exception e) {
                logger.error(e.getClass() + " on addGroupToOtherGroup for " + groupToAdd + " to " + groupName);
                logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError(e));
                answerObject.put("success", false);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
                return;
            }
        }
        catch (JSONException e) {
            httpServletResp.setStatus(500);
            return;
        }
    }

    private void handleResetFIDO(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        JSONObject answerObject = new JSONObject();
        try {
            String userKey = httpServletReq.getParameter("userkey");
            String dirIDString = httpServletReq.getParameter("dirid");
            long dirid = 0L;
            if (dirIDString != null) {
                dirid = Long.parseLong(dirIDString);
            }
            try {
                SecSignID2FAActivatedSettings settings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, dirid);
                settings.setFidoActive(false);
                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, dirid, settings);
            }
            catch (Exception e) {
                answerObject.put("success", false);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
                return;
            }
            answerObject.put("success", true);
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (JSONException e) {
            httpServletResp.setStatus(500);
            return;
        }
    }

    private void handleResetTOTP(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        JSONObject answerObject = new JSONObject();
        try {
            String userKey = httpServletReq.getParameter("userkey");
            String dirIDString = httpServletReq.getParameter("dirid");
            long dirid = 0L;
            if (dirIDString != null) {
                dirid = Long.parseLong(dirIDString);
            }
            try {
                SecSignID2FAActivatedSettings settings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(userKey, dirid);
                settings.setTotpActive(false);
                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, dirid, settings);
            }
            catch (Exception e) {
                answerObject.put("success", false);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
                return;
            }
            answerObject.put("success", true);
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (JSONException e) {
            httpServletResp.setStatus(500);
            return;
        }
    }

    private void addUserToGroup(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) throws IOException {
        JSONObject answerObject = new JSONObject();
        try {
            String userKey = httpServletReq.getParameter("userkey");
            String dirIDString = httpServletReq.getParameter("dirid");
            long dirid = 0L;
            if (dirIDString != null) {
                dirid = Long.parseLong(dirIDString);
            }
            if (dirid == 0L || userKey == null || userKey.equals("")) {
                // empty if block
            }
            try {
                if (httpServletReq.getParameter("add-user-to-twostep") != null) {
                    this.dataAccessor.addUserToTwoStep(userKey, dirid);
                }
                if (httpServletReq.getParameter("add-user-to-fido") != null) {
                    this.dataAccessor.addUserToFIDO(userKey, dirid);
                }
                if (httpServletReq.getParameter("add-user-to-totp") != null) {
                    this.dataAccessor.addUserToTOTP(userKey, dirid);
                }
                if (httpServletReq.getParameter("add-user-to-mailotp") != null) {
                    this.dataAccessor.addUserToMailOTP(userKey, dirid);
                }
                if (httpServletReq.getParameter("add-user-to-passwordless") != null) {
                    this.dataAccessor.addUserToPasswordless(userKey, dirid);
                }
            }
            catch (Exception e) {
                answerObject.put("success", false);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
                return;
            }
            answerObject.put("success", true);
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (JSONException e) {
            httpServletResp.setStatus(500);
            return;
        }
    }

    private void handleSearchForGroup(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        String searchTerm = httpServletReq.getParameter("searchTerm");
        try {
            JSONObject answerObject = new JSONObject();
            List<String> groupNames = this.dataAccessor.findGroupsForTerm(searchTerm);
            if (groupNames.size() > 10) {
                groupNames.remove(10);
                answerObject.put("tooManyGroups", true);
            }
            if (httpServletReq.getParameter("forUsersPage") != null) {
                answerObject.put("success", true);
                answerObject.put("groupNames", groupNames);
                httpServletResp.setContentType("application/json");
                httpServletResp.getWriter().write(answerObject.toString());
                return;
            }
            HashMap<String, SecSignID2FASettings> foundSettings = this.dataAccessor.get2FASettingsForGroups(groupNames);
            answerObject.put("success", true);
            answerObject.put("groupNames", groupNames);
            answerObject.put("groupMappings", foundSettings);
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (Exception e) {
            logger.error(e.getClass() + " on handleSearchForGroup");
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError(e));
            return;
        }
    }

    public void doShowTutorial(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        this.getPluginOptions();
        this._skipAdmin = this._adminIDs != null && this._adminIDs.length != 0;
        this.renderTutorial(httpServletReq, httpServletResp);
    }

    public void doShowIPs(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        this._page = 1;
        if (httpServletReq.getParameter("page") != null) {
            this._page = Integer.parseInt(httpServletReq.getParameter("page"));
        }
        TreeMap<String, String> temp = this.dataAccessor.getIPMappings();
        int userPerPage = 10;
        this._pages = (temp.size() + userPerPage - 1) / userPerPage;
        this._ipMappings = new TreeMap(new Comparator<String>(){

            @Override
            public int compare(String s1, String s2) {
                return s1.substring(0, s1.indexOf(":")).compareToIgnoreCase(s2.substring(0, s2.indexOf(":")));
            }
        });
        int count = 0;
        for (Map.Entry<String, String> entry : temp.entrySet()) {
            if (count >= (this._page - 1) * userPerPage && count < this._page * userPerPage) {
                this._ipMappings.put(entry.getKey(), entry.getValue());
            }
            ++count;
        }
        this.fillContext(httpServletReq, httpServletResp);
        httpServletResp.setContentType("text/html;charset=utf-8");
        try {
            this.templateRenderer.render(SHOW_IP_TEMPLATE, this.context, (Writer)httpServletResp.getWriter());
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    public void doSaveOptions(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        if (httpServletReq.getParameter("2faMethods") != null) {
            this.save2FAMethods(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("autoID") != null) {
            this.saveAutoID(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("session") != null) {
            this.saveSession(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("trustdevice") != null) {
            this.saveTrustDevice(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("userChange") != null) {
            this.saveUserChange(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("safeZone") != null) {
            this.saveSafeZone(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("addIP") != null) {
            this.addIPToSafeZone(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("deleteIP") != null) {
            this.deleteIPFromSafeZone(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("crowdLayout") != null) {
            this.saveCrowdLayout(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("customLinks") != null) {
            this.saveCustomLinks(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("customLayout") != null) {
            this.saveCustomLayout(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("synchronizable") != null) {
            this.saveSynchronizableSettings(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("resetoncrowd") != null) {
            this.saveResetOnCrowd(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("crowdsettings") != null) {
            this.saveCrowdSettings(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("server") != null) {
            this.saveServer(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("pinaccount") != null) {
            this.savePinAccount(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("extern") != null) {
            this.saveExtern(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("addToWhitelist") != null) {
            this.addItemToWhitelist(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("removeFromWhitelist") != null) {
            this.deleteItemFromWhitelist(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("adminNotify") != null) {
            this.saveNotifyAdmin(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("userNotify") != null) {
            this.saveNotifyUser(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("resetAllSettings") != null) {
            this.resetAllSettings(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("checkAllData") != null) {
            this.checkAllData(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("serviceDesk") != null) {
            this.saveServiceDesk(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("git") != null) {
            this.saveGitClientAccess(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        if (httpServletReq.getParameter("furtherCustom") != null) {
            this.saveFurtherCustom(httpServletReq, httpServletResp);
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        this.renderOptions(httpServletReq, httpServletResp);
    }

    public void resetAllSettings(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        try {
            this.dataAccessor.deleteAllOptionsAndMappings();
            this.getPluginOptions();
            this.renderTutorial(httpServletReq, httpServletResp);
            return;
        }
        catch (OperationFailedException e) {
            this.addError(this.i18nResolver.getText("secsignid.messages.error.operation.failed"));
            this._showError = true;
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        catch (InvalidAuthenticationException e) {
            this.addError(this.i18nResolver.getText("secsignid.messages.error.operation.failed"));
            this._showError = true;
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
        catch (ApplicationPermissionException e) {
            this.addError(this.i18nResolver.getText("secsignid.messages.error.operation.failed"));
            this._showError = true;
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
    }

    public void checkAllData(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        try {
            this.dataAccessor.checkDataIntegrity();
            this._showSuccess = true;
            return;
        }
        catch (OperationFailedException e) {
            this.addError(this.i18nResolver.getText("secsignid.messages.error.operation.failed"));
            this._showError = true;
            this.renderOptions(httpServletReq, httpServletResp);
            return;
        }
    }

    public void saveNotifyUser(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean informUser = Boolean.valueOf(httpServletReq.getParameter("informUserInput"));
        this.writeLogAndInformForChangeSettings("informAdmin", this._informUser, informUser, httpServletReq);
        this._informUser = informUser;
        SecSignIDCommonStaticAccessor.saveInformUser(informUser);
        this._showSuccess = true;
    }

    public void saveNotifyAdmin(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        Object groupname;
        List<Directory> dirs;
        String[] groupnames;
        String result;
        boolean informAdmin = Boolean.valueOf(httpServletReq.getParameter("informAdminInput"));
        String observeGroup = httpServletReq.getParameter("observeGroupsInput");
        String informGroup = httpServletReq.getParameter("informGroupsInput");
        if (observeGroup != null && !observeGroup.equals("")) {
            result = "";
            groupnames = observeGroup.split(",");
            dirs = this.dataAccessor.getAllDirectories();
            for (String string : groupnames) {
                try {
                    if (string.equals("")) continue;
                    if (string.contains(";")) {
                        long dirid;
                        groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
                        if (this.dataAccessor.checkGroupExists((String)groupname, dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string))) {
                            if (result.equals("")) {
                                result = result + string;
                                continue;
                            }
                            result = result + "," + string;
                            continue;
                        }
                        this.addError(this.i18nResolver.getText("secsignid.options.group.not.exists"));
                        this._showError = true;
                        return;
                    }
                    for (Directory directory : dirs) {
                        if (this.dataAccessor.checkGroupExists(string, directory.getId())) {
                            if (result.equals("")) {
                                result = result + string + ";" + directory.getId();
                                continue;
                            }
                            result = result + "," + string + ";" + directory.getId();
                            continue;
                        }
                        this.addError(this.i18nResolver.getText("secsignid.options.group.not.exists"));
                        this._showError = true;
                        return;
                    }
                }
                catch (com.atlassian.crowd.exception.OperationFailedException e) {
                    this.addError(this.i18nResolver.getText("secsignid.messages.error.operation.failed"));
                    this._showError = true;
                    return;
                }
            }
            observeGroup = result;
        } else {
            observeGroup = "";
        }
        if (informGroup != null && !informGroup.equals("")) {
            result = "";
            groupnames = informGroup.split(",");
            dirs = this.dataAccessor.getAllDirectories();
            for (String string : groupnames) {
                try {
                    if (string.equals("")) continue;
                    if (string.contains(";")) {
                        long dirid;
                        groupname = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
                        if (this.dataAccessor.checkGroupExists((String)groupname, dirid = SecSignIDMappingUtils.getDirIDFromGroupMappingKey(string))) {
                            if (result.equals("")) {
                                result = result + string;
                                continue;
                            }
                            result = result + "," + string;
                            continue;
                        }
                        this.addError(this.i18nResolver.getText("secsignid.options.group.not.exists"));
                        this._showError = true;
                        return;
                    }
                    for (Directory directory : dirs) {
                        if (this.dataAccessor.checkGroupExists(string, directory.getId())) {
                            if (result.equals("")) {
                                result = result + string + ";" + directory.getId();
                                continue;
                            }
                            result = result + "," + string + ";" + directory.getId();
                            continue;
                        }
                        this.addError(this.i18nResolver.getText("secsignid.options.group.not.exists"));
                        this._showError = true;
                        return;
                    }
                }
                catch (com.atlassian.crowd.exception.OperationFailedException e) {
                    this.addError(this.i18nResolver.getText("secsignid.messages.error.operation.failed"));
                    this._showError = true;
                    return;
                }
            }
            informGroup = result;
        } else {
            informGroup = "";
        }
        this.writeLogAndInformForChangeSettings("informAdmin", this._informAdmin, informAdmin, httpServletReq);
        this.writeLogAndInformForChangeSettings("observeGroup", this._observeGroup, observeGroup, httpServletReq);
        this.writeLogAndInformForChangeSettings("informGroup", this._informGroup, informGroup, httpServletReq);
        this._informAdmin = informAdmin;
        this._informGroup = informGroup;
        this._observeGroup = observeGroup;
        SecSignIDCommonStaticAccessor.saveInformAdmin(this._informAdmin);
        SecSignIDCommonStaticAccessor.saveObserveGroup(this._observeGroup);
        SecSignIDCommonStaticAccessor.saveInformGroup(this._informGroup);
        this._showSuccess = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addItemToWhitelist(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        SecSignIDWhiteListItem itemToAdd = new SecSignIDWhiteListItem();
        String descriptonToAdd = httpServletReq.getParameter("descriptionToAdd");
        String urlToAdd = httpServletReq.getParameter("urlToAdd");
        String ipToAdd = httpServletReq.getParameter("ipToAdd");
        if (ipToAdd != null && ipToAdd.contains(".")) {
            if (!ipToAdd.matches("(([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\\.){3}([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])")) {
                this.addError(this.i18nResolver.getText("secsignid.options.whitelist.ip.error"));
                this._showError = true;
                return;
            }
            itemToAdd.setIpAddress(ipToAdd);
        } else if (ipToAdd != null && ipToAdd.contains(":")) {
            try {
                InetAddress ipAd = Inet6Address.getByName(ipToAdd);
                itemToAdd.setIpAddress(ipAd.getHostAddress());
            }
            catch (UnknownHostException e) {
                this.addError(this.i18nResolver.getText("secsignid.options.whitelist.ip.error"));
                this._showError = true;
                return;
            }
        } else {
            this.addError(this.i18nResolver.getText("secsignid.options.whitelist.ip.error"));
            this._showError = true;
            return;
        }
        if (urlToAdd == null || urlToAdd.equals("")) {
            this.addError(this.i18nResolver.getText("secsignid.options.whitelist.url.error"));
            this._showError = true;
            return;
        }
        if (!urlToAdd.startsWith("/")) {
            urlToAdd = "/" + urlToAdd;
        }
        itemToAdd.setUrl(urlToAdd);
        if (descriptonToAdd != null) {
            itemToAdd.setDescription(descriptonToAdd);
        }
        this._whiteList.add(itemToAdd);
        boolean basicAuth = Boolean.valueOf(httpServletReq.getParameter("basicAuthInput"));
        boolean accessToken = Boolean.valueOf(httpServletReq.getParameter("accessTokensInput"));
        this.writeLogAndInformForChangeSettings("disableBasicAuth", this._disableBasicAuth, basicAuth, httpServletReq);
        this.writeLogAndInformForChangeSettings("disableAccessToken", this._disableAccessToken, accessToken, httpServletReq);
        SecSignIDCommonStaticAccessor.saveDisableBasicAuth(basicAuth);
        SecSignIDCommonStaticAccessor.saveDisableAccessToken(accessToken);
        this._disableBasicAuth = basicAuth;
        this._disableAccessToken = accessToken;
        this.writeLogAndInformForChangeSettings("Whitelist", "", "added " + itemToAdd, httpServletReq);
        SecSignIDCommonStaticAccessor.saveWhiteList(this._whiteList);
        this._showSuccess = true;
    }

    public void deleteItemFromWhitelist(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        int index = Integer.parseInt(httpServletReq.getParameter("index"));
        SecSignIDWhiteListItem removed = this._whiteList.get(index);
        if (this._whiteList.get(index) == null) {
            this._whiteList.remove(index);
        }
        this._whiteList.remove(index);
        boolean basicAuth = Boolean.valueOf(httpServletReq.getParameter("basicAuthInput"));
        boolean accessToken = Boolean.valueOf(httpServletReq.getParameter("accessTokensInput"));
        this.writeLogAndInformForChangeSettings("disableBasicAuth", this._disableBasicAuth, basicAuth, httpServletReq);
        this.writeLogAndInformForChangeSettings("disableAccessToken", this._disableAccessToken, accessToken, httpServletReq);
        SecSignIDCommonStaticAccessor.saveDisableBasicAuth(basicAuth);
        SecSignIDCommonStaticAccessor.saveDisableAccessToken(accessToken);
        this._disableBasicAuth = basicAuth;
        this._disableAccessToken = accessToken;
        this.writeLogAndInformForChangeSettings("Whitelist", "", "removed " + removed, httpServletReq);
        SecSignIDCommonStaticAccessor.saveWhiteList(this._whiteList);
        this._showSuccess = true;
    }

    public void saveExtern(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean basicAuth = Boolean.valueOf(httpServletReq.getParameter("basicAuthInput"));
        boolean accessToken = Boolean.valueOf(httpServletReq.getParameter("accessTokensInput"));
        this.writeLogAndInformForChangeSettings("disableBasicAuth", this._disableBasicAuth, basicAuth, httpServletReq);
        this.writeLogAndInformForChangeSettings("disableAccessToken", this._disableAccessToken, accessToken, httpServletReq);
        SecSignIDCommonStaticAccessor.saveDisableBasicAuth(basicAuth);
        SecSignIDCommonStaticAccessor.saveDisableAccessToken(accessToken);
        this._disableBasicAuth = basicAuth;
        this._disableAccessToken = accessToken;
        this._showSuccess = true;
    }

    public void savePinAccount(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean ownPinAccount = Boolean.valueOf(httpServletReq.getParameter("ownPinAccountInput"));
        String pinAccount = httpServletReq.getParameter("pinAccountInput");
        String pinAccountPassword = httpServletReq.getParameter("pinAccountPasswordInput");
        try {
            SecSignIDCommonStaticAccessor.savePinAccount(new String[]{pinAccount, pinAccountPassword});
        }
        catch (Exception e) {
            this.addError(this.i18nResolver.getText("secsignid.error.server.pin.error"));
            this._pinAccount = pinAccount;
            this._pinAccountPassword = pinAccountPassword;
            this._ownPinAccount = ownPinAccount;
            this._showError = true;
        }
        this.writeLogAndInformForChangeSettings("ownPinAccount", this._ownPinAccount, ownPinAccount, httpServletReq);
        this.writeLogAndInformForChangeSettings("pinAccount", this._idServerUrl, pinAccount, httpServletReq);
        this.writeLogAndInformForChangeSettings("pinAccountPassword", "***", "***", httpServletReq);
        this._pinAccount = pinAccount;
        this._pinAccountPassword = pinAccountPassword;
        this._ownPinAccount = ownPinAccount;
        this._showSuccess = true;
    }

    public void saveServer(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        String serverUrl = httpServletReq.getParameter("idServerUrlInput");
        boolean useFallback = Boolean.valueOf(httpServletReq.getParameter("useFallbackInput"));
        String fallbackServerUrl = httpServletReq.getParameter("idServerUrlFallbackInput");
        try {
            boolean testMainUrl = SecSignIDServerRESTConnector.testSecSignIDServerUrl(serverUrl);
            if (!testMainUrl) {
                this.addError(this.i18nResolver.getText("secsignid.messages.error.server.notreached"));
                this._showError = true;
                this._idServerUrl = serverUrl;
                this._useFallback = useFallback;
                this._fallbackServerUrl = fallbackServerUrl;
                return;
            }
        }
        catch (SecSignIDRESTException e) {
            this.addError(this.i18nResolver.getText("secsignid.messages.error.rest"));
            logger.debug("SecSignIDRESTException on saveServer mainServer: " + e.getMessage());
            this._showError = true;
            this._idServerUrl = serverUrl;
            this._useFallback = useFallback;
            this._fallbackServerUrl = fallbackServerUrl;
            return;
        }
        if (useFallback) {
            try {
                boolean testFallbackUrl = SecSignIDServerRESTConnector.testSecSignIDServerUrl(fallbackServerUrl);
                if (!testFallbackUrl) {
                    this.addError(this.i18nResolver.getText("secsignid.messages.error.server.notreached") + fallbackServerUrl);
                    this._showError = true;
                    this._idServerUrl = serverUrl;
                    this._useFallback = useFallback;
                    this._fallbackServerUrl = fallbackServerUrl;
                    return;
                }
            }
            catch (SecSignIDRESTException e) {
                this.addError(this.i18nResolver.getText("secsignid.messages.error.rest"));
                logger.debug("SecSignIDRESTException on saveServer fallbackServer: " + e.getMessage());
                this._showError = true;
                this._idServerUrl = serverUrl;
                this._useFallback = useFallback;
                this._fallbackServerUrl = fallbackServerUrl;
                return;
            }
        }
        this.writeLogAndInformForChangeSettings("useFallback", this._useFallback, useFallback, httpServletReq);
        this.writeLogAndInformForChangeSettings("serverUrl", this._idServerUrl, serverUrl, httpServletReq);
        this.writeLogAndInformForChangeSettings("fallbackServerUrl", this._fallbackServerUrl, fallbackServerUrl, httpServletReq);
        SecSignIDCommonStaticAccessor.saveUseFallback(useFallback);
        SecSignIDCommonStaticAccessor.saveServerUrl(serverUrl);
        SecSignIDCommonStaticAccessor.saveFallbackServerUrl(fallbackServerUrl);
        this._idServerUrl = serverUrl;
        this._useFallback = useFallback;
        this._fallbackServerUrl = fallbackServerUrl;
        this._showSuccess = true;
    }

    public void saveCrowdSettings(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean localEnable = Boolean.valueOf(httpServletReq.getParameter("localEnableInput"));
        boolean ldapEnable = Boolean.valueOf(httpServletReq.getParameter("ldapEnableInput"));
        String ldapAttr = httpServletReq.getParameter("ldapAttrInput");
        boolean writeLDAPEnable = Boolean.valueOf(httpServletReq.getParameter("writeLDAPEnableInput"));
        if (ldapAttr.equals("")) {
            this.addError(this.i18nResolver.getText("secsignid.error.directory.crowd.ldap.attr.empty"));
            this._localEnable = localEnable;
            this._ldapEnable = ldapEnable;
            this._ldapAttr = ldapAttr;
            this._writeLDAPEnable = writeLDAPEnable;
            this._showError = true;
            return;
        }
        this.writeLogAndInformForChangeSettings("localEnable", this._localEnable, localEnable, httpServletReq);
        this.writeLogAndInformForChangeSettings("ldapEnable", this._ldapEnable, ldapEnable, httpServletReq);
        this.writeLogAndInformForChangeSettings("writeLDAPEnable", this._writeLDAPEnable, writeLDAPEnable, httpServletReq);
        this.writeLogAndInformForChangeSettings("ldapAttr", this._ldapAttr, ldapAttr, httpServletReq);
        SecSignIDCommonStaticAccessor.saveLocalEnable(localEnable);
        SecSignIDCommonStaticAccessor.saveLDAPEnable(ldapEnable);
        SecSignIDCommonStaticAccessor.saveLDAPSecSignIDAttr(ldapAttr);
        SecSignIDCommonStaticAccessor.saveWriteLDAPEnable(writeLDAPEnable);
        this._localEnable = localEnable;
        this._ldapEnable = ldapEnable;
        this._ldapAttr = ldapAttr;
        this._writeLDAPEnable = writeLDAPEnable;
        this._showSuccess = true;
    }

    public void saveResetOnCrowd(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean resetOnCrowd = Boolean.valueOf(httpServletReq.getParameter("resetOnCrowdInput"));
        String crowdBaseUrl = httpServletReq.getParameter("crowdBaseUrlInput");
        if (crowdBaseUrl.equals("")) {
            this.addError(this.i18nResolver.getText("secsignid.error.directory.reset.crowd.base.url.invalid"));
            this._showError = true;
            this._resetOnCrowd = resetOnCrowd;
            this._crowdBaseUrl = crowdBaseUrl;
            return;
        }
        try {
            URI.create(crowdBaseUrl);
        }
        catch (Exception e) {
            this.addError(this.i18nResolver.getText("secsignid.error.directory.reset.crowd.base.url.invalid"));
            this._showError = true;
            this._resetOnCrowd = resetOnCrowd;
            this._crowdBaseUrl = crowdBaseUrl;
            return;
        }
        this.writeLogAndInformForChangeSettings("resetOnCrowd", this._resetOnCrowd, resetOnCrowd, httpServletReq);
        this.writeLogAndInformForChangeSettings("crowdBaseUrl", this._crowdBaseUrl, crowdBaseUrl, httpServletReq);
        SecSignIDCommonStaticAccessor.saveResetOnCrowd(resetOnCrowd);
        SecSignIDCommonStaticAccessor.saveCrowdBaseUrl(crowdBaseUrl);
        this._resetOnCrowd = resetOnCrowd;
        this._crowdBaseUrl = crowdBaseUrl;
        this._showSuccess = true;
    }

    public void saveSynchronizableSettings(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean synchronizable = Boolean.valueOf(httpServletReq.getParameter("synchronizableInput"));
        boolean synchronizableWrite = Boolean.valueOf(httpServletReq.getParameter("synchronizableWriteInput"));
        try {
            this.dataAccessor.updateAllMappings(synchronizable, synchronizableWrite);
        }
        catch (Exception e) {
            logger.error("Error on updating Mappings to Synchronizable " + synchronizable + " and SynchronizableWrite " + synchronizableWrite);
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError(e));
            this.addError(this.i18nResolver.getText("secsignid.messages.error.crowd.failed"));
            this._synchronizable = synchronizable;
            this._synchronizableWrite = synchronizableWrite;
            this._showError = true;
            return;
        }
        this.writeLogAndInformForChangeSettings("synchronizable", this._synchronizable, synchronizable, httpServletReq);
        this.writeLogAndInformForChangeSettings("synchronizableWrite", this._synchronizableWrite, synchronizableWrite, httpServletReq);
        SecSignIDCommonStaticAccessor.saveSynchronizable(synchronizable);
        SecSignIDCommonStaticAccessor.saveSynchronizableWrite(synchronizableWrite);
        this._synchronizable = synchronizable;
        this._synchronizableWrite = synchronizableWrite;
        this._showSuccess = true;
    }

    public void saveCustomLayout(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean customLogin = Boolean.valueOf(httpServletReq.getParameter("customLayoutInput"));
        String loginColor = httpServletReq.getParameter("customColorInput");
        this.writeLogAndInformForChangeSettings("customLogin", this._customLogin, customLogin, httpServletReq);
        this.writeLogAndInformForChangeSettings("loginColor", this._loginColor, loginColor, httpServletReq);
        SecSignIDCommonStaticAccessor.saveCustomLogin(customLogin);
        SecSignIDCommonStaticAccessor.saveLoginColor(loginColor);
        this._customLogin = customLogin;
        this._loginColor = loginColor;
        this._showSuccess = true;
    }

    public void saveCustomLinks(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        String iosUrl = httpServletReq.getParameter("iosLinkInput");
        String androidUrl = httpServletReq.getParameter("androidLinkInput");
        String windowsUrl = httpServletReq.getParameter("windowsLinkInput");
        String macUrl = httpServletReq.getParameter("macLinkInput");
        this.writeLogAndInformForChangeSettings("iosUrl", this._iOSUrl, iosUrl, httpServletReq);
        this.writeLogAndInformForChangeSettings("androidUrl", this._androidUrl, androidUrl, httpServletReq);
        this.writeLogAndInformForChangeSettings("windowsUrl", this._windowsUrl, windowsUrl, httpServletReq);
        this.writeLogAndInformForChangeSettings("macUrl", "", this._macOSUrl, httpServletReq);
        SecSignIDCommonStaticAccessor.saveIOSUrl(iosUrl);
        SecSignIDCommonStaticAccessor.saveAndroidUrl(androidUrl);
        SecSignIDCommonStaticAccessor.saveWindowsUrl(windowsUrl);
        SecSignIDCommonStaticAccessor.saveMacOSUrl(macUrl);
        this._iOSUrl = iosUrl;
        this._androidUrl = androidUrl;
        this._windowsUrl = windowsUrl;
        this._macOSUrl = macUrl;
        this._showSuccess = true;
    }

    public void saveCrowdLayout(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean crowdLayout = Boolean.valueOf(httpServletReq.getParameter("crowdLayoutInput"));
        String loginTilte = httpServletReq.getParameter("crowdTitleInput");
        String loginSubtitle = httpServletReq.getParameter("crowdSubtitleInput");
        String logoData = httpServletReq.getParameter("crowdLogoDataInput");
        this.writeLogAndInformForChangeSettings("crowdLayout", this._useNewCrowdLogin, crowdLayout, httpServletReq);
        this.writeLogAndInformForChangeSettings("loginTilte", this._loginTitle, loginTilte, httpServletReq);
        this.writeLogAndInformForChangeSettings("loginSubtitle", this._loginSubtitle, loginSubtitle, httpServletReq);
        this.writeLogAndInformForChangeSettings("logoData", "", "new Logo", httpServletReq);
        SecSignIDCommonStaticAccessor.saveUseNewCrowdLogin(crowdLayout);
        SecSignIDCommonStaticAccessor.saveLoginTitle(loginTilte);
        SecSignIDCommonStaticAccessor.saveLoginSubtitle(loginSubtitle);
        SecSignIDCommonStaticAccessor.saveCustomLogo(logoData);
        this._useNewCrowdLogin = crowdLayout;
        this._loginTitle = loginTilte;
        this._loginSubtitle = loginSubtitle;
        this._customLogoData = logoData;
        this._showSuccess = true;
    }

    public void saveFurtherCustom(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        String customLoginLink = httpServletReq.getParameter("customLoginLinkInput");
        String customLoginLinkText = httpServletReq.getParameter("customLoginLinkTextInput");
        this.writeLogAndInformForChangeSettings("customLoginLink", this._customLoginLink, customLoginLink, httpServletReq);
        this.writeLogAndInformForChangeSettings("customLoginLinkText", this._customLoginLinkText, customLoginLinkText, httpServletReq);
        SecSignIDCommonStaticAccessor.saveCustomLink(customLoginLink);
        SecSignIDCommonStaticAccessor.saveCustomLinkText(customLoginLinkText);
        this._customLoginLink = customLoginLink;
        this._customLoginLinkText = customLoginLinkText;
        this._showSuccess = true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void addIPToSafeZone(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        String safeZoneIpString;
        block7: {
            String ip;
            safeZoneIpString = httpServletReq.getParameter("ipToAddInput");
            if (safeZoneIpString != null && safeZoneIpString.contains("/") && safeZoneIpString.contains(".")) {
                ip = safeZoneIpString.substring(0, safeZoneIpString.indexOf(47)).trim();
                String suffix = safeZoneIpString.substring(safeZoneIpString.indexOf(47) + 1, safeZoneIpString.length()).trim();
                int sufInt = Integer.parseInt(suffix);
                if (ip.matches("(([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])\\.){3}([01]?[0-9]{1,2}|2[0-4][0-9]|25[0-5])") && sufInt >= 0 && sufInt <= 32) {
                    this._ipRanges.add(ip + "/" + sufInt);
                    break block7;
                } else {
                    this.addError(this.i18nResolver.getText("secsignid.options.safezone.ip.error"));
                    this._showError = true;
                    return;
                }
            }
            if (safeZoneIpString != null && safeZoneIpString.contains(":") && safeZoneIpString.contains("/")) {
                ip = safeZoneIpString.substring(0, safeZoneIpString.indexOf("/"));
                String suffix = safeZoneIpString.substring(safeZoneIpString.indexOf("/") + 1, safeZoneIpString.length());
                try {
                    InetAddress ipAd = Inet6Address.getByName(ip);
                    this._ipRanges.add(ipAd.getHostAddress() + "/" + suffix);
                }
                catch (UnknownHostException e) {
                    this.addError(this.i18nResolver.getText("secsignid.options.safezone.ip.error"));
                    this._showError = true;
                    return;
                }
            } else {
                this.addError(this.i18nResolver.getText("secsignid.options.safezone.ip.error"));
                this._showError = true;
                return;
            }
        }
        boolean safeZone = true;
        this.writeLogAndInformForChangeSettings("safeZoneEnabled", this._safeZone, safeZone, httpServletReq);
        this.writeLogAndInformForChangeSettings("safeZoneRange", "", "added " + safeZoneIpString, httpServletReq);
        SecSignIDCommonStaticAccessor.saveSafeZone(safeZone);
        SecSignIDCommonStaticAccessor.saveIPRange(this._ipRanges);
        this._safeZone = safeZone;
        this._showSuccess = true;
    }

    public void deleteIPFromSafeZone(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        int index = Integer.parseInt(httpServletReq.getParameter("indexToDeleteInput"));
        String removed = this._ipRanges.get(index);
        if (this._ipRanges.get(index).equals("")) {
            this._ipRanges.remove(index);
        }
        this._ipRanges.remove(index);
        boolean safeZone = true;
        this.writeLogAndInformForChangeSettings("safeZoneEnabled", this._safeZone, safeZone, httpServletReq);
        this.writeLogAndInformForChangeSettings("safeZoneRange", "", "removed " + removed, httpServletReq);
        SecSignIDCommonStaticAccessor.saveSafeZone(safeZone);
        SecSignIDCommonStaticAccessor.saveIPRange(this._ipRanges);
        this._safeZone = safeZone;
        this._showSuccess = true;
    }

    private void writeLogAndInformForChangeSettings(String changedValue, Object before, Object after, HttpServletRequest httpServletReq) {
        if (!before.equals(after)) {
            this.dataAccessor.logChangeSettingToAuditLog(changedValue, String.valueOf(after), String.valueOf(before), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup(changedValue, String.valueOf(after), String.valueOf(before), this._loggedInUser.getName(), this._loggedInUser.getDirectoryId());
            }
        }
    }

    public void saveAutoID(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean fillUsername = Boolean.valueOf(httpServletReq.getParameter("fillUsernameInput"));
        boolean fillUsernameCompany = Boolean.valueOf(httpServletReq.getParameter("fillUsernameCompanyInput"));
        boolean fillMail = Boolean.valueOf(httpServletReq.getParameter("fillMailInput"));
        boolean fillPattern = Boolean.valueOf(httpServletReq.getParameter("fillPatternInput"));
        String fillPatternPattern = httpServletReq.getParameter("fillPatternPatternInput");
        boolean allowUserCreate = Boolean.valueOf(httpServletReq.getParameter("allowUserCreateInput"));
        boolean allowUserExisting = Boolean.valueOf(httpServletReq.getParameter("allowUserExistingInput"));
        if (fillPattern) {
            if (fillPatternPattern == null || fillPatternPattern.equals("") || !fillPatternPattern.contains("%username%") && !fillPatternPattern.contains("%displayname%") && !fillPatternPattern.contains("%mail%") && !fillPatternPattern.contains("%index%")) {
                this.addError(this.i18nResolver.getText("secsignid.users.pattern.illegal"));
                this._showError = true;
                this._fillUsername = fillUsername;
                this._fillUsernameCompany = fillUsernameCompany;
                this._fillMail = fillMail;
                this._fillPattern = fillPattern;
                this._fillPatternPattern = fillPatternPattern;
                this._allowUserCreate = allowUserCreate;
                this._allowUserExisting = allowUserExisting;
                return;
            }
        } else {
            fillPatternPattern = "";
        }
        SecSignIDCommonStaticAccessor.saveAutoFillUsername(fillUsername);
        SecSignIDCommonStaticAccessor.saveAutoFillUsernameCompany(fillUsernameCompany);
        SecSignIDCommonStaticAccessor.saveAutoFillMail(fillMail);
        SecSignIDCommonStaticAccessor.saveAutoFillPattern(fillPattern);
        SecSignIDCommonStaticAccessor.saveAutoFillPatternPattern(fillPatternPattern);
        SecSignIDCommonStaticAccessor.saveAllowUserCreate(allowUserCreate);
        SecSignIDCommonStaticAccessor.saveAllowUserExisting(allowUserExisting);
        this.writeLogAndInformForChangeSettings("fillUsername", this._fillUsername, fillUsername, httpServletReq);
        this.writeLogAndInformForChangeSettings("fillUsernameCompany", this._fillUsernameCompany, fillUsernameCompany, httpServletReq);
        this.writeLogAndInformForChangeSettings("fillMail", this._fillMail, fillMail, httpServletReq);
        this.writeLogAndInformForChangeSettings("fillPattern", this._fillPattern, fillPattern, httpServletReq);
        this.writeLogAndInformForChangeSettings("fillPatternPattern", this._fillPatternPattern, fillPatternPattern, httpServletReq);
        this.writeLogAndInformForChangeSettings("allowUserCreate", this._allowUserCreate, allowUserCreate, httpServletReq);
        this.writeLogAndInformForChangeSettings("allowUserExisting", this._allowUserExisting, allowUserExisting, httpServletReq);
        this._fillUsername = fillUsername;
        this._fillUsernameCompany = fillUsernameCompany;
        this._fillMail = fillMail;
        this._fillPattern = fillPattern;
        this._fillPatternPattern = fillPatternPattern;
        this._allowUserCreate = allowUserCreate;
        this._allowUserExisting = allowUserExisting;
        this._showSuccess = true;
    }

    public void saveSession(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean sessionTimeout = Boolean.valueOf(httpServletReq.getParameter("sessionTimeoutInput"));
        String sessionTimeoutDuration = httpServletReq.getParameter("sessionTimeoutDurationInput");
        int sessionTimeOutInteger = this._sessionTimeoutDuration;
        try {
            sessionTimeOutInteger = Integer.parseInt(sessionTimeoutDuration);
        }
        catch (NumberFormatException e) {
            this.addError(this.i18nResolver.getText("secsignid.error.session.timeout"));
            this._sessionTimeout = sessionTimeout;
            this._showError = true;
            return;
        }
        this.writeLogAndInformForChangeSettings("sessionTimeout", this._sessionTimeout, sessionTimeout, httpServletReq);
        this.writeLogAndInformForChangeSettings("sessionTimeout", this._sessionTimeoutDuration, Integer.valueOf(sessionTimeoutDuration), httpServletReq);
        SecSignIDCommonStaticAccessor.saveSessionTimeoutEnabled(sessionTimeout);
        SecSignIDCommonStaticAccessor.saveSessionTimeoutDuration(sessionTimeOutInteger);
        this._sessionTimeout = sessionTimeout;
        this._sessionTimeoutDuration = sessionTimeOutInteger;
        this._showSuccess = true;
    }

    public void saveTrustDevice(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean trustDevice = Boolean.valueOf(httpServletReq.getParameter("trustDeviceInput"));
        String trustDeviceDuration = httpServletReq.getParameter("trustDeviceDurationInput");
        int trustDeviceDurationInteger = this._trustDeviceDuration;
        try {
            trustDeviceDurationInteger = Integer.parseInt(trustDeviceDuration);
        }
        catch (NumberFormatException e) {
            this.addError(this.i18nResolver.getText("secsignid.error.trustdevice.timeout"));
            this._trustDeviceEnabled = trustDevice;
            this._showError = true;
            return;
        }
        this.writeLogAndInformForChangeSettings("trustDeviceEnabled", this._trustDeviceEnabled, trustDevice, httpServletReq);
        this.writeLogAndInformForChangeSettings("trustDeviceDuration", this._trustDeviceDuration, Integer.valueOf(trustDeviceDuration), httpServletReq);
        SecSignIDCommonStaticAccessor.saveTrustDeviceEnabled(trustDevice);
        SecSignIDCommonStaticAccessor.saveTrustDeviceDuration(trustDeviceDurationInteger);
        this._trustDeviceEnabled = trustDevice;
        this._trustDeviceDuration = trustDeviceDurationInteger;
        this._showSuccess = true;
    }

    public void saveUserChange(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean userChange = Boolean.valueOf(httpServletReq.getParameter("userChangeInput"));
        this.writeLogAndInformForChangeSettings("userChange", this._userChange, userChange, httpServletReq);
        SecSignIDCommonStaticAccessor.saveUserChange(userChange);
        this._userChange = userChange;
        this._showSuccess = true;
    }

    public void saveSafeZone(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean safeZone = Boolean.valueOf(httpServletReq.getParameter("safeZoneInput"));
        this.writeLogAndInformForChangeSettings("safeZoneEnabled", this._safeZone, safeZone, httpServletReq);
        SecSignIDCommonStaticAccessor.saveSafeZone(safeZone);
        this._useForwardedHeader = safeZone ? Boolean.valueOf(httpServletReq.getParameter("useForwardedHeaderInput")) : false;
        SecSignIDCommonStaticAccessor.saveUseForwardedHeader(this._useForwardedHeader);
        this._safeZone = safeZone;
        this._showSuccess = true;
    }

    public void save2FAMethods(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean twoStepEnabled = Boolean.valueOf(httpServletReq.getParameter("twoStepAuthInput"));
        boolean fidoEnabled = Boolean.valueOf(httpServletReq.getParameter("fidoAuthInput"));
        boolean totpEnabled = Boolean.valueOf(httpServletReq.getParameter("totpAuthInput"));
        boolean mailotpEnabled = Boolean.valueOf(httpServletReq.getParameter("mailotpAuthInput"));
        boolean passwordlessEnabled = Boolean.valueOf(httpServletReq.getParameter("passwordlessAuthInput"));
        SecSignIDCommonStaticAccessor.saveSecSignEnabled(twoStepEnabled);
        SecSignIDCommonStaticAccessor.saveFIDOEnabled(fidoEnabled);
        SecSignIDCommonStaticAccessor.saveTOTPEnabled(totpEnabled);
        SecSignIDCommonStaticAccessor.saveMailOTPEnabled(mailotpEnabled);
        SecSignIDCommonStaticAccessor.savePasswordlessEnabled(passwordlessEnabled);
        if (twoStepEnabled != this._twoStepAuthEnabled) {
            this.dataAccessor.logChangeSettingToAuditLog("SecSignIDEnabled", String.valueOf(twoStepEnabled), String.valueOf(this._twoStepAuthEnabled), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("SecSignIDEnabled", String.valueOf(twoStepEnabled), String.valueOf(this._twoStepAuthEnabled), this._loggedInUser.getName(), this._loggedInUser.getDirectoryId());
            }
        }
        if (fidoEnabled != this._fidoAuthEnabled) {
            this.dataAccessor.logChangeSettingToAuditLog("FIDOEnabled", String.valueOf(fidoEnabled), String.valueOf(this._fidoAuthEnabled), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("FIDOEnabled", String.valueOf(fidoEnabled), String.valueOf(this._fidoAuthEnabled), this._loggedInUser.getName(), this._loggedInUser.getDirectoryId());
            }
        }
        if (totpEnabled != this._totpAuthEnabled) {
            this.dataAccessor.logChangeSettingToAuditLog("TOTPEnabled", String.valueOf(totpEnabled), String.valueOf(this._totpAuthEnabled), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("TOTPEnabled", String.valueOf(totpEnabled), String.valueOf(this._totpAuthEnabled), this._loggedInUser.getName(), this._loggedInUser.getDirectoryId());
            }
        }
        if (mailotpEnabled != this._mailotpAuthEnabled) {
            this.dataAccessor.logChangeSettingToAuditLog("MailOTPEnabled", String.valueOf(mailotpEnabled), String.valueOf(this._mailotpAuthEnabled), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("MailOTPEnabled", String.valueOf(mailotpEnabled), String.valueOf(this._mailotpAuthEnabled), this._loggedInUser.getName(), this._loggedInUser.getDirectoryId());
            }
        }
        if (passwordlessEnabled != this._passwordlessAuthEnabled) {
            this.dataAccessor.logChangeSettingToAuditLog("PasswordlessEnabled", String.valueOf(passwordlessEnabled), String.valueOf(this._passwordlessAuthEnabled), httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformAdmin()) {
                this.dataAccessor.mailChangeSettingToInformGroup("PasswordlessEnabled", String.valueOf(passwordlessEnabled), String.valueOf(this._passwordlessAuthEnabled), this._loggedInUser.getName(), this._loggedInUser.getDirectoryId());
            }
        }
        this._twoStepAuthEnabled = twoStepEnabled;
        this._fidoAuthEnabled = fidoEnabled;
        this._totpAuthEnabled = totpEnabled;
        this._mailotpAuthEnabled = mailotpEnabled;
        this._passwordlessAuthEnabled = passwordlessEnabled;
        this._showSuccess = true;
    }

    public String getAllOptionsAsString() {
        return this.dataAccessor.getAllOptionsAsString();
    }

    public void doEditOptions(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        logger.debug("doEditOptions / request parameter map: " + SecSignIDMappingUtils.toString(httpServletReq.getParameterMap()));
        this.getPluginOptions();
        this.renderOptions(httpServletReq, httpServletResp);
    }

    private void getAdminValues() {
        this._loggedInUser = this.dataAccessor.getUserCurrentlyLoggedIn();
        logger.debug("Logged in user is " + this._loggedInUser.getName());
        if (this._loggedInUser != null) {
            try {
                this._adminIDs = SecSignIDMappingUtils.getArrayOfSecSignIds(this.dataAccessor.getSecSignIdStringForApplicationUserKey(this.dataAccessor.getUserKeyForUsername(this._loggedInUser.getName()), this._loggedInUser.getDirectoryId()));
                this._admin2FASettings = this.dataAccessor.get2FASettingsFromUserKey(this.dataAccessor.getUserKeyForUsername(this._loggedInUser.getName()), this._loggedInUser.getDirectoryId());
                this._admin2FAActivatedSettings = this.dataAccessor.get2FAActivatedSettingsFromUserKey(this.dataAccessor.getUserKeyForUsername(this._loggedInUser.getName()), this._loggedInUser.getDirectoryId());
            }
            catch (Exception e) {
                this.addError(this.i18nResolver.getText("secsignid.messages.error.operation.failed"));
            }
        }
    }

    private void addError(String errorString) {
        this._errorList.add(errorString);
    }

    public String getUserProfileLink(User appUser) {
        if (appUser != null) {
            return this.dataAccessor.getUserProfileLink(appUser, this._baseUrl);
        }
        return "#";
    }

    public String getGroupLink(String groupName, Long dirid) {
        return this.dataAccessor.getGroupLink(groupName, dirid);
    }

    public String getGroupLinkToAdd(String groupName, Long dirid) {
        return this.dataAccessor.getGroupLinkToAdd(groupName, dirid);
    }

    public boolean isChangeable(User user) {
        this.dataAccessor.isChangeable(user);
        return true;
    }

    public String checkForDuplicates(HashMap<String, String[]> mapping) {
        ArrayList<String> duplicateCheck = new ArrayList<String>();
        for (String[] secsignids : mapping.values()) {
            for (String secsign : secsignids) {
                if (duplicateCheck.contains(secsign)) {
                    return secsign;
                }
                duplicateCheck.add(secsign);
            }
        }
        return null;
    }

    public String getGroupsForUser(User user) throws DirectoryNotFoundException, com.atlassian.crowd.exception.OperationFailedException {
        String groupNameString = "[ ";
        String userKey = this.dataAccessor.getUserKeyForUsername(user.getName());
        List<String> groupNames = this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId());
        for (String string : groupNames) {
            string = SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(string);
            if (!groupNameString.equals("[ ")) {
                if ((groupNameString = groupNameString + " ; " + string).length() <= 100) continue;
                groupNameString = groupNameString + ",....";
                break;
            }
            groupNameString = groupNameString + string;
        }
        groupNameString = groupNameString + " ]";
        return groupNameString;
    }

    public HashMap<String, SecSignID2FASettings> getGroupMappingsForUser(User user) {
        try {
            String userKey = this.dataAccessor.getUserKeyForUsername(user.getName());
            List<String> groupNames = this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId());
            HashMap<String, SecSignID2FASettings> mappings = this.dataAccessor.get2FASettingsForGroups(groupNames);
            return mappings;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.error("DirectoryNotFoundException on get getGroupMappingsForUser");
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on get getGroupMappingsForUser");
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on get getGroupMappingsForUser");
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on get getGroupMappingsForUser");
        }
        return null;
    }

    public HashMap<String, SecSignID2FASettings> getGroupMappingsForUserNotDeactivated(User user) {
        try {
            String userKey = this.dataAccessor.getUserKeyForUsername(user.getName());
            List<String> groupNames = this.dataAccessor.getGroupMappingKeysForUserKey(userKey, user.getDirectoryId());
            HashMap<String, SecSignID2FASettings> mappings = this.dataAccessor.get2FASettingsForGroups(groupNames);
            HashMap mappingstoIterate = (HashMap)mappings.clone();
            for (Map.Entry entry : mappingstoIterate.entrySet()) {
                if (!((SecSignID2FASettings)entry.getValue()).getPwdAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed)) continue;
                mappings.remove(entry.getKey());
            }
            return mappings;
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.error("DirectoryNotFoundException on get getGroupMappingsForUser");
        }
        catch (InvalidAuthenticationException e) {
            logger.error("InvalidAuthenticationException on get getGroupMappingsForUser");
        }
        catch (ApplicationPermissionException e) {
            logger.error("ApplicationPermissionException on get getGroupMappingsForUser");
        }
        catch (DirectoryNotFoundException e) {
            logger.error("DirectoryNotFoundException on get getGroupMappingsForUser");
        }
        return null;
    }

    public boolean is2FAActivated(SecSignID2FASettings setting) {
        logger.debug(setting.toString());
        return !setting.getPwdAllowed().equals(SecSignIDCommonConstants.AuthIsAllowed);
    }

    public String getShortFormOf2FAMethods(SecSignID2FASettings setting) {
        return SecSignIDMappingUtils.getShortFormOf2FAMethods(setting);
    }

    public String getUnescapedGroupnameFromMappingKey(String mappingKey) {
        return SecSignIDMappingUtils.getGroupNameFromGroupMappingKey(mappingKey);
    }

    private void saveChangesForUser(HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        boolean save = false;
        String userKey = httpServletReq.getParameter("userToChange");
        String secSignID = httpServletReq.getParameter("secSignID");
        long dirID = -1L;
        if (httpServletReq.getParameter("dirID") != null) {
            dirID = Long.parseLong(httpServletReq.getParameter("dirID"));
        }
        if (!secSignID.equals("")) {
            if (!this.hasError) {
                this.checkMappingsForProblems(userKey, secSignID, dirID, httpServletReq, httpServletResp);
            }
            if (!this.hasError) {
                save = this.checkIDExists(secSignID, httpServletReq, httpServletResp);
            }
            if (!this.hasError) {
                if (save) {
                    this.saveSecSignIDForUserKey(userKey, dirID, secSignID, httpServletReq, httpServletResp);
                } else {
                    this.reserveAndSaveSecSignID(userKey, dirID, secSignID, httpServletReq, httpServletResp);
                }
            }
        } else {
            save = true;
            this.saveSecSignIDForUserKey(userKey, dirID, "", httpServletReq, httpServletResp);
        }
        if (!this.hasError) {
            this.sendSuccess(save, httpServletReq, httpServletResp);
        }
    }

    private void sendSuccess(boolean saved, HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        try {
            JSONObject answerObject = new JSONObject();
            answerObject.put("success", true);
            answerObject.put("saved", saved);
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (JSONException e) {
            logger.error("JSONException on sendSuccess: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException on sendSuccess: " + e.getMessage(), (Throwable)e);
        }
    }

    private void sendError(String errorMessage, HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        try {
            this.hasError = true;
            JSONObject answerObject = new JSONObject();
            answerObject.put("success", false);
            answerObject.put("errorMsg", (Object)errorMessage);
            httpServletResp.setContentType("application/json");
            httpServletResp.getWriter().write(answerObject.toString());
            return;
        }
        catch (JSONException e) {
            logger.error("JSONException on sendSuccess: " + e.getMessage(), (Throwable)e);
        }
        catch (IOException e) {
            logger.error("IOException on sendSuccess: " + e.getMessage(), (Throwable)e);
        }
    }

    private void saveSecSignIDForUserKey(String userKey, long dirID, String secSignID, HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        try {
            this.dataAccessor.saveSecSignIDForUserKey(userKey, dirID, secSignID);
            this.dataAccessor.logChangeSecSignIDToAuditLog(userKey, dirID, secSignID, httpServletReq.getRemoteAddr());
            if (SecSignIDCommonStaticAccessor.getInformUser()) {
                this.dataAccessor.mailChangeSecSignIDToUser(userKey, dirID, this.dataAccessor.getUserKeyForUsername(this.dataAccessor.getUserCurrentlyLoggedIn().getName()), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId(), secSignID);
            }
            if (SecSignIDCommonStaticAccessor.getInformAdmin() && SecSignIDCommonStaticAccessor.isUserObserved(this.dataAccessor.getGroupMappingKeysForUserKey(userKey, dirID))) {
                this.dataAccessor.mailChangeSecSignIDToInformGroup(userKey, dirID, this.dataAccessor.getUserKeyForUsername(this.dataAccessor.getUserCurrentlyLoggedIn().getName()), this.dataAccessor.getUserCurrentlyLoggedIn().getDirectoryId(), secSignID);
            }
            this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, dirID, new SecSignID2FAActivatedSettings());
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            this.sendError(this.i18nResolver.getText("secsignid.messages.error.ldap.failed"), httpServletReq, httpServletResp);
            return;
        }
        catch (Exception e) {
            logger.error(SecSignIDCommonStaticAccessor.getStackTraceOfError(e));
            this.sendError(this.i18nResolver.getText("secsignid.messages.error.ldap.failed"), httpServletReq, httpServletResp);
            return;
        }
    }

    private void reserveAndSaveSecSignID(String userKey, long dirID, String secSignID, HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        if (SecSignIDCommonStaticAccessor.getUseRestore()) {
            try {
                User user = this.dataAccessor.getUserForKey(userKey, this._chosenDir);
                SecSignIDServerRESTConnector.createSecSignID(secSignID, user.getEmailAddress());
                this.saveSecSignIDForUserKey(userKey, dirID, secSignID, httpServletReq, httpServletResp);
                this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, dirID, new SecSignID2FAActivatedSettings());
            }
            catch (com.atlassian.crowd.exception.OperationFailedException e) {
                logger.debug("OperationFailedException on reserving SecSignID");
                this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
                return;
            }
            catch (ApplicationPermissionException e) {
                logger.debug("ApplicationPermissionException on reserving SecSignID");
                this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
                return;
            }
            catch (InvalidAuthenticationException e) {
                logger.debug("InvalidAuthenticationException on reserving SecSignID");
                this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
                return;
            }
            catch (DirectoryPermissionException e) {
                logger.debug("DirectoryPermissionException on reserving SecSignID");
                this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
                return;
            }
            catch (SecSignIDRESTException e) {
                logger.error("SecSignIDRESTException on reserving SecSignID: " + e.getMessage());
                this.sendError(this.i18nResolver.getText("secsignid.messages.error.rest"), httpServletReq, httpServletResp);
                return;
            }
            catch (OperationFailedException e) {
                logger.debug("runtime.OperationFailedException on reserving SecSignID: " + e.getMessage());
                this.sendError(this.i18nResolver.getText("secsignid.messages.error.qrtest"), httpServletReq, httpServletResp);
                return;
            }
            catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
                logger.debug("UserNotFoundException on reserving SecSignID: " + e.getMessage());
                this.sendError(this.i18nResolver.getText("secsignid.messages.error.qrtest"), httpServletReq, httpServletResp);
                return;
            }
            catch (UserNotFoundException e) {
                logger.debug("crowd.UserNotFoundException on reserving SecSignID: " + e.getMessage());
                this.sendError(this.i18nResolver.getText("secsignid.messages.error.qrtest"), httpServletReq, httpServletResp);
                return;
            }
            catch (DirectoryNotFoundException e) {
                logger.debug("ApplicationNotFoundException on reserving SecSignID");
                this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
                return;
            }
            return;
        }
        try {
            SecSignIDServerRESTConnector.getCreateSecSignIDQrCode(secSignID);
            this.dataAccessor.save2FAActivatedSettingsForUserKey(userKey, dirID, new SecSignID2FAActivatedSettings());
            this.saveSecSignIDForUserKey(userKey, dirID, secSignID, httpServletReq, httpServletResp);
        }
        catch (com.atlassian.crowd.exception.OperationFailedException e) {
            logger.debug("OperationFailedException on reserving SecSignID");
            this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
            return;
        }
        catch (ApplicationPermissionException e) {
            logger.debug("ApplicationPermissionException on reserving SecSignID");
            this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
            return;
        }
        catch (InvalidAuthenticationException e) {
            logger.debug("InvalidAuthenticationException on reserving SecSignID");
            this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
            return;
        }
        catch (DirectoryPermissionException e) {
            logger.debug("DirectoryPermissionException on reserving SecSignID");
            this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
            return;
        }
        catch (SecSignIDRESTException e) {
            logger.error("SecSignIDRESTException on reserving SecSignID: " + e.getMessage());
            this.sendError(this.i18nResolver.getText("secsignid.messages.error.rest"), httpServletReq, httpServletResp);
            return;
        }
        catch (OperationFailedException e) {
            logger.debug("runtime.OperationFailedException on reserving SecSignID");
            this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
            return;
        }
        catch (com.atlassian.crowd.exception.runtime.UserNotFoundException e) {
            logger.debug("UserNotFoundException on reserving SecSignID");
            this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
            return;
        }
        catch (UserNotFoundException e) {
            logger.debug("crowd.exception.UserNotFoundException on reserving SecSignID");
            this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
            return;
        }
        catch (DirectoryNotFoundException e) {
            logger.debug("DirectoryNotFoundException on reserving SecSignID");
            this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
            return;
        }
    }

    private boolean checkIDExists(String secSignID, HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        try {
            return SecSignIDServerRESTConnector.checkSecSignID(secSignID);
        }
        catch (SecSignIDRESTException e) {
            logger.error("SecSignIDRESTException on checkIDExists: " + e.getMessage());
            this.sendError(this.i18nResolver.getText("secsignid.error.qrtest"), httpServletReq, httpServletResp);
            return false;
        }
    }

    private void checkMappingsForProblems(String userKey, String secSignID, long dirID, HttpServletRequest httpServletReq, HttpServletResponse httpServletResp) {
        Object[] result;
        if (SecSignIDCommonStaticAccessor.secSignIdContainsIllegalCharacters(secSignID)) {
            this.sendError(this.i18nResolver.getText("secsignid.messages.error.action.illegalcharacters2", new Serializable[]{secSignID}) + " " + secSignID, httpServletReq, httpServletResp);
            return;
        }
        try {
            result = this.dataAccessor.checkDuplicatesWithUserKey(secSignID, dirID, userKey);
        }
        catch (Exception e) {
            this.sendError(this.i18nResolver.getText("secsignid.messages.error.synch"), httpServletReq, httpServletResp);
            return;
        }
        if (((Boolean)result[0]).booleanValue()) {
            this.sendError(this.i18nResolver.getText("secsignid.messages.error.action.duplicate2", new Serializable[]{secSignID, (String)result[1]}) + secSignID, httpServletReq, httpServletResp);
            return;
        }
    }

    public String getKeyForUsername(String username) {
        return this.dataAccessor.getUserKeyForUsername(username);
    }

    public String getUsernameForKey(String userKey) {
        return this.dataAccessor.getUsernameForUserKey(userKey);
    }

    private boolean isCreatedGroup(String groupName) {
        if (groupName.toLowerCase().equals("PasswordlessAllowed".toLowerCase())) {
            return true;
        }
        if (groupName.toLowerCase().equals("2SASecSignIDAllowed".toLowerCase())) {
            return true;
        }
        if (groupName.toLowerCase().equals("2SAFIDOAllowed".toLowerCase())) {
            return true;
        }
        if (groupName.toLowerCase().equals("2SATOTPAllowed".toLowerCase())) {
            return true;
        }
        return groupName.toLowerCase().equals("2SAMailOTPAllowed".toLowerCase());
    }
}

