/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.rest;

import com.secsign.atlassian.common.rest.SecSignIDRESTException;
import org.json.JSONException;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SecSignIDRESTAccessTokenResponse {
    private static final Logger logger = LoggerFactory.getLogger(SecSignIDRESTAccessTokenResponse.class);
    private final String token;
    private final long validUntil;

    public static SecSignIDRESTAccessTokenResponse fromJson(String json) throws JSONException, SecSignIDRESTException {
        JSONObject rootObject = new JSONObject(json);
        String token = rootObject.optString("token", null);
        if (token == null) {
            logger.debug("Key 'token' not found");
            throw new SecSignIDRESTException("Key 'token' not found");
        }
        long validUntil = rootObject.optLong("validuntil", -1L);
        if (validUntil == -1L) {
            logger.debug("Key 'validuntil' not found");
            throw new SecSignIDRESTException("Key 'validuntil' not found");
        }
        return new SecSignIDRESTAccessTokenResponse(token, validUntil);
    }

    private SecSignIDRESTAccessTokenResponse(String token, long validUntil) {
        this.token = token;
        this.validUntil = validUntil;
    }

    public String getToken() {
        return this.token;
    }

    public long getValidUntil() {
        return this.validUntil;
    }
}

