/*
 * Decompiled with CFR 0.152.
 */
package com.secsign.atlassian.common.crypto;

public final class SHA256 {
    private final int[] K = new int[]{1116352408, 1899447441, -1245643825, -373957723, 961987163, 1508970993, -1841331548, -1424204075, -670586216, 310598401, 607225278, 1426881987, 1925078388, -2132889090, -1680079193, -1046744716, -459576895, -272742522, 264347078, 604807628, 770255983, 1249150122, 1555081692, 1996064986, -1740746414, -1473132947, -1341970488, -1084653625, -958395405, -710438585, 113926993, 338241895, 666307205, 773529912, 1294757372, 1396182291, 1695183700, 1986661051, -2117940946, -1838011259, -1564481375, -1474664885, -1035236496, -949202525, -778901479, -694614492, -200395387, 275423344, 430227734, 506948616, 659060556, 883997877, 958139571, 1322822218, 1537002063, 1747873779, 1955562222, 2024104815, -2067236844, -1933114872, -1866530822, -1538233109, -1090935817, -965641998};
    private byte[] buffer = new byte[64];
    private int buffered;
    private long count;
    private final int hashLength = 32;
    private static final int DATA_LENGTH = 64;
    private int[] _data;
    protected int[] digest;
    private byte[] tmp;
    private int[] w;

    protected SHA256() {
        this.init();
    }

    public int getDigestLen() {
        return 32;
    }

    public int getBlockLen() {
        return 64;
    }

    public void init() {
        this.digest = new int[8];
        this._data = new int[16];
        this.tmp = new byte[64];
        this.w = new int[64];
        this.reset();
    }

    protected void reset() {
        this.buffered = 0;
        this.count = 0L;
        this.digest[0] = 1779033703;
        this.digest[1] = -1150833019;
        this.digest[2] = 1013904242;
        this.digest[3] = -1521486534;
        this.digest[4] = 1359893119;
        this.digest[5] = -1694144372;
        this.digest[6] = 528734635;
        this.digest[7] = 1541459225;
    }

    private void transform(byte[] in) {
        this.byte2int(in, 0, this._data, 0, 16);
        this.transform(this._data);
    }

    protected byte[] digest(byte[] in, int pos) {
        if (pos != 0) {
            System.arraycopy(in, 0, this.tmp, 0, pos);
        }
        this.tmp[pos++] = -128;
        if (pos > 56) {
            while (pos < 64) {
                this.tmp[pos++] = 0;
            }
            this.byte2int(this.tmp, 0, this._data, 0, 16);
            this.transform(this._data);
            pos = 0;
        }
        while (pos < 56) {
            this.tmp[pos++] = 0;
        }
        this.byte2int(this.tmp, 0, this._data, 0, 14);
        long bc = this.bitcount();
        this._data[14] = (int)(bc >>> 32);
        this._data[15] = (int)bc;
        this.transform(this._data);
        byte[] buf = new byte[32];
        int off = 0;
        for (int i = 0; i < 8; ++i) {
            int d = this.digest[i];
            buf[off++] = (byte)(d >>> 24);
            buf[off++] = (byte)(d >>> 16);
            buf[off++] = (byte)(d >>> 8);
            buf[off++] = (byte)d;
        }
        return buf;
    }

    private static int rotateRight(int x, int shift) {
        return x << 32 - shift | x >>> shift;
    }

    private static int upperSigma0(int x) {
        return SHA256.rotateRight(x, 2) ^ SHA256.rotateRight(x, 13) ^ SHA256.rotateRight(x, 22);
    }

    private static int upperSigma1(int x) {
        return SHA256.rotateRight(x, 6) ^ SHA256.rotateRight(x, 11) ^ SHA256.rotateRight(x, 25);
    }

    private static int lowerSigma0(int x) {
        return SHA256.rotateRight(x, 7) ^ SHA256.rotateRight(x, 18) ^ x >>> 3;
    }

    private static int lowerSigma1(int x) {
        return SHA256.rotateRight(x, 17) ^ SHA256.rotateRight(x, 19) ^ x >>> 10;
    }

    private static int ch(int x, int y, int z) {
        return x & y ^ ~x & z;
    }

    private static int maj(int x, int y, int z) {
        return x & y ^ x & z ^ y & z;
    }

    private void transform(int[] X) {
        int t;
        int[] W = this.w;
        for (t = 0; t < 16; ++t) {
            W[t] = X[t];
        }
        for (t = 16; t < 64; ++t) {
            W[t] = SHA256.lowerSigma1(W[t - 2]) + W[t - 7] + SHA256.lowerSigma0(W[t - 15]) + W[t - 16];
        }
        int a = this.digest[0];
        int b = this.digest[1];
        int c = this.digest[2];
        int d = this.digest[3];
        int e = this.digest[4];
        int f = this.digest[5];
        int g = this.digest[6];
        int h = this.digest[7];
        for (int t2 = 0; t2 < 64; ++t2) {
            int t1 = h + SHA256.upperSigma1(e) + SHA256.ch(e, f, g) + this.K[t2] + W[t2];
            int t22 = SHA256.upperSigma0(a) + SHA256.maj(a, b, c);
            h = g;
            g = f;
            f = e;
            e = d + t1;
            d = c;
            c = b;
            b = a;
            a = t1 + t22;
        }
        this.digest[0] = a + this.digest[0];
        this.digest[1] = b + this.digest[1];
        this.digest[2] = c + this.digest[2];
        this.digest[3] = d + this.digest[3];
        this.digest[4] = e + this.digest[4];
        this.digest[5] = f + this.digest[5];
        this.digest[6] = g + this.digest[6];
        this.digest[7] = h + this.digest[7];
    }

    private void byte2int(byte[] src, int srcOffset, int[] dst, int dstOffset, int length) {
        while (length-- > 0) {
            dst[dstOffset++] = src[srcOffset++] << 24 | (src[srcOffset++] & 0xFF) << 16 | (src[srcOffset++] & 0xFF) << 8 | src[srcOffset++] & 0xFF;
        }
    }

    protected long bitcount() {
        return this.count * 8L;
    }

    public void update(byte[] data) {
        this.update(data, 0, data.length);
    }

    public void update(byte[] dataIn, int offset, int length) {
        int remainder;
        this.count += (long)length;
        int datalen = 64;
        while (length >= (remainder = datalen - this.buffered)) {
            System.arraycopy(dataIn, offset, this.buffer, this.buffered, remainder);
            this.transform(this.buffer);
            length -= remainder;
            offset += remainder;
            this.buffered = 0;
        }
        if (length > 0) {
            System.arraycopy(dataIn, offset, this.buffer, this.buffered, length);
            this.buffered += length;
        }
    }

    public byte[] digest() {
        return this.digest(this.buffer, this.buffered);
    }
}

