/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.utils;

import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.plugin.PluginParseException;
import com.atlassian.plugin.web.Condition;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class IsAdminConditionUtil
implements Condition {
    private static final Logger LOGGER = LoggerFactory.getLogger(IsAdminConditionUtil.class);
    private UserManager userManager;
    private DirectoryManager directoryManager;

    public IsAdminConditionUtil(UserManager userManager, DirectoryManager directoryManager) {
        this.userManager = userManager;
        this.directoryManager = directoryManager;
    }

    public void init(Map<String, String> params) throws PluginParseException {
    }

    public boolean shouldDisplay(Map<String, Object> context) {
        UserProfile user = this.userManager.getRemoteUser();
        try {
            LOGGER.debug("user is: " + String.valueOf(user));
            LOGGER.debug("isAdmin: " + this.userManager.isAdmin(user.getUserKey()));
            if (user != null && this.userManager.isAdmin(user.getUserKey())) {
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return false;
    }
}

