/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.utils;

import com.atlassian.json.jsonorg.JSONObject;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import lombok.Generated;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class AuditLogDetailsUtils {
    private static Log LOGGER = LogFactory.getLog(AuditLogDetailsUtils.class);
    private String username = "";
    private String dateAndTime = "";
    private String action = "";
    private String description = "";
    private String ipAddress = "";
    private String Status = "";

    public static AuditLogDetailsUtils fromJsonString(String auditLogJson) {
        try {
            JSONObject obj = new JSONObject(auditLogJson);
            AuditLogDetailsUtils log = new AuditLogDetailsUtils();
            log.setUsername(obj.optString("username", ""));
            log.setDateAndTime(obj.optString("dateAndTime", ""));
            log.setAction(obj.optString("action", ""));
            log.setDescription(obj.optString("description", ""));
            log.setIpAddress(obj.optString("ipAddress", ""));
            log.setStatus(obj.optString("Status", ""));
            return log;
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error parsing audit log JSON: " + auditLogJson), (Throwable)e);
            throw new RuntimeException("Failed to parse audit log JSON", e);
        }
    }

    public String toJsonString() {
        try {
            JSONObject obj = new JSONObject();
            obj.put("username", this.username);
            obj.put("dateAndTime", this.dateAndTime);
            obj.put("action", this.action);
            obj.put("description", this.description);
            obj.put("ipAddress", this.ipAddress);
            obj.put("Status", this.Status);
            return obj.toString();
        }
        catch (Exception e) {
            LOGGER.error((Object)("Error converting log to JSON: " + String.valueOf(this)), (Throwable)e);
            return null;
        }
    }

    public static List<AuditLogDetailsUtils> fromJsonStringList(List<String> jsonStringList) {
        ArrayList<AuditLogDetailsUtils> resultList = new ArrayList<AuditLogDetailsUtils>();
        for (int i = 0; i < jsonStringList.size(); ++i) {
            try {
                AuditLogDetailsUtils log = AuditLogDetailsUtils.fromJsonString(jsonStringList.get(i));
                resultList.add(log);
                continue;
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error parsing JSON log entry at index " + i), (Throwable)e);
            }
        }
        return resultList;
    }

    public static List<String> toJsonStringList(List<AuditLogDetailsUtils> logsList) {
        return logsList.stream().map(AuditLogDetailsUtils::toJsonString).filter(Objects::nonNull).collect(Collectors.toList());
    }

    @Generated
    public String getUsername() {
        return this.username;
    }

    @Generated
    public String getDateAndTime() {
        return this.dateAndTime;
    }

    @Generated
    public String getAction() {
        return this.action;
    }

    @Generated
    public String getDescription() {
        return this.description;
    }

    @Generated
    public String getIpAddress() {
        return this.ipAddress;
    }

    @Generated
    public String getStatus() {
        return this.Status;
    }

    @Generated
    public void setUsername(String username) {
        this.username = username;
    }

    @Generated
    public void setDateAndTime(String dateAndTime) {
        this.dateAndTime = dateAndTime;
    }

    @Generated
    public void setAction(String action) {
        this.action = action;
    }

    @Generated
    public void setDescription(String description) {
        this.description = description;
    }

    @Generated
    public void setIpAddress(String ipAddress) {
        this.ipAddress = ipAddress;
    }

    @Generated
    public void setStatus(String Status) {
        this.Status = Status;
    }
}

