/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.usermanagement.dto.ImportJob;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.opencsv.CSVReader;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.UUID;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadCSVServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadCSVServlet.class);
    private Integer totalUpdations = 0;
    private Integer totalCreations = 0;
    private Boolean groupsCsvUpload;
    private DirectoryManager directoryManager;
    private UserManagementPluginHandler userManagementPluginHandler;
    private UserManager userManager;
    private CrowdService crowdService;
    private UserManagementPluginSettings settings;
    private static final int BATCH_SIZE = 1000;
    private static final int NUM_THREADS = 10;
    volatile boolean stopProcessing = false;
    private static final Map<String, ImportJob> jobs = new ConcurrentHashMap<String, ImportJob>();
    private static final ExecutorService importExecutor = Executors.newFixedThreadPool(4);

    public UploadCSVServlet(DirectoryManager directoryManager, UserManagementPluginHandler userManagementPluginHandler, UserManager userManager, CrowdService crowdService, UserManagementPluginSettings settings) {
        this.directoryManager = directoryManager;
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.userManager = userManager;
        this.crowdService = crowdService;
        this.settings = settings;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        MultiPartRequestWrapper wrapper;
        UploadedFile uploadedFile;
        File file;
        HttpServletRequest req = ServletActionContext.getRequest();
        this.groupsCsvUpload = Boolean.parseBoolean(req.getParameter("groupsCsvUpload"));
        if (this.groupsCsvUpload == null) {
            this.groupsCsvUpload = false;
        }
        if ((file = (File)(uploadedFile = (wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest()).getFiles("csvFile")[0]).getContent()) == null) {
            response.setStatus(400);
            response.getWriter().write("No file uploaded");
            return;
        }
        File safeTempFile = File.createTempFile("safe-uploaded-", ".csv");
        try (FileInputStream in = new FileInputStream(file);
             FileOutputStream out = new FileOutputStream(safeTempFile);){
            int length;
            byte[] buffer = new byte[8192];
            while ((length = in.read(buffer)) > 0) {
                out.write(buffer, 0, length);
            }
        }
        String jobId = UUID.randomUUID().toString();
        ImportJob job = new ImportJob(jobId);
        jobs.put(jobId, job);
        importExecutor.submit(() -> {
            try {
                this.processCsvImport(safeTempFile, job, this.groupsCsvUpload);
            }
            catch (Exception e) {
                LOGGER.error("Error processing CSV import", (Throwable)e);
                job.status = "FAILED";
            }
            finally {
                if (safeTempFile.exists()) {
                    safeTempFile.delete();
                }
            }
        });
        if (this.groupsCsvUpload.booleanValue()) {
            response.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/usermanagement/groupmanagement?importStarted=true");
        } else {
            response.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/usermanagement/importexport?importStarted=true");
        }
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String jobId = request.getParameter("jobId");
        if (jobId == null || !jobs.containsKey(jobId)) {
            response.setStatus(404);
            response.getWriter().write("Job not found");
            return;
        }
        ImportJob job = jobs.get(jobId);
        response.setContentType("application/json");
        response.getWriter().write(String.format("{\"status\":\"%s\",\"totalRows\":%d,\"processedRows\":%d,\"successCount\":%d,\"errorCount\":%d,\"errors\":%s}", job.status, job.totalRows, job.processedRows, job.successCount, job.errorCount, job.errorMessages.toString()));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Could not resolve type clashes
     */
    private void processCsvImport(File file, ImportJob job, boolean groupsCsvUpload) throws UnknownHostException {
        InetAddress ip = InetAddress.getLocalHost();
        String importType = groupsCsvUpload ? "Groups" : "Users";
        LOGGER.info("Starting {} CSV import, groupsCsvUpload={}", (Object)importType, (Object)groupsCsvUpload);
        String username = this.userManager.getRemoteUser() != null ? this.userManager.getRemoteUser().getUsername() : "system";
        try (CSVReader csvReader = new CSVReader(new FileReader(file));){
            if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getLicenseType(), (CharSequence)"TRIAL") && !groupsCsvUpload) {
                int currentImportedCount = this.settings.getUserImportedCount();
                if (currentImportedCount >= 10) {
                    LOGGER.warn("Trial import limit already reached: " + currentImportedCount + "/10 imported users");
                    job.status = "FAILED";
                    job.errorMessages.add("Trial limit reached (" + currentImportedCount + "/10 imported users). No further user imports allowed.");
                    this.userManagementPluginHandler.storeAuditLogs(username, ip.getHostAddress(), importType + " CSV Import", importType + " CSV import failed - trial import limit reached (" + currentImportedCount + "/10)", "Error");
                    return;
                }
                LOGGER.info("Trial license user import check passed: {} imported users, {} import slots remaining", (Object)currentImportedCount, (Object)(10 - currentImportedCount));
            }
            int UserNameIndex = 10;
            int UserEmailIndex = 10;
            int FullNameIndex = 10;
            int GroupsIndex = 10;
            int StatusIndex = 10;
            int DirectoryIndex = 10;
            Object[] nextLine = csvReader.readNext();
            if (nextLine != null) {
                LOGGER.info("CSV Headers: {}", (Object)Arrays.toString(nextLine));
                int colCount = nextLine.length;
                block64: for (int i = 0; i < colCount; ++i) {
                    switch (nextLine[i]) {
                        case "Username": 
                        case "username": {
                            UserNameIndex = i;
                            continue block64;
                        }
                        case "Email": 
                        case "email": {
                            UserEmailIndex = i;
                            continue block64;
                        }
                        case "FullName": 
                        case "fullname": {
                            FullNameIndex = i;
                            continue block64;
                        }
                        case "Groups": 
                        case "groups": {
                            GroupsIndex = i;
                            LOGGER.info("Found Groups column at index {}", (Object)i);
                            continue block64;
                        }
                        case "Status": 
                        case "status": {
                            StatusIndex = i;
                            continue block64;
                        }
                        case "Directory": 
                        case "directory": {
                            DirectoryIndex = i;
                        }
                    }
                }
            }
            List<String[]> rowsData = csvReader.readAll();
            job.totalRows = rowsData.size();
            boolean trialLimitReached = false;
            block65: for (int batchStart = 0; batchStart < rowsData.size() && !trialLimitReached; batchStart += 1000) {
                int batchEnd = Math.min(batchStart + 1000, rowsData.size());
                List<String[]> batch = rowsData.subList(batchStart, batchEnd);
                for (String[] row : batch) {
                    StringBuilder logBuffer = new StringBuilder();
                    String UserName = UserNameIndex != 10 ? row[UserNameIndex].trim() : "";
                    try {
                        int currentImportedCount;
                        List<Object> groupList;
                        Long actualUserDirectoryId;
                        block95: {
                            boolean isUserPresent;
                            com.atlassian.crowd.model.user.User user;
                            Directory UserDirectory;
                            Long Directory_ID;
                            String Status;
                            String FullName;
                            String UserEmail;
                            String Groups;
                            block93: {
                                String Directory2;
                                String string = Groups = GroupsIndex != 10 ? row[GroupsIndex].trim() : "";
                                if (groupsCsvUpload) {
                                    LOGGER.info("Processing group row {}: {}", (Object)(job.processedRows + 1), (Object)Groups);
                                    if (Groups.isEmpty()) {
                                        LOGGER.warn("Empty group name at row {}", (Object)(job.processedRows + 1));
                                        ++job.errorCount;
                                        job.errorMessages.add("Missing group name at row " + (job.processedRows + 1));
                                        ++job.processedRows;
                                        continue;
                                    }
                                    List allDirectories = this.directoryManager.findAllDirectories();
                                    Directory targetDirectory = (Directory)allDirectories.get(0);
                                    Long actualUserDirectoryId2 = targetDirectory.getId();
                                    String groupName = Groups.trim();
                                    if (groupName.startsWith("[") && groupName.endsWith("]")) {
                                        groupName = groupName.substring(1, groupName.length() - 1);
                                    }
                                    if (!groupName.isEmpty()) {
                                        try {
                                            this.directoryManager.findGroupByName(actualUserDirectoryId2.longValue(), groupName);
                                            LOGGER.info("Group '{}' already exists", (Object)groupName);
                                        }
                                        catch (GroupNotFoundException e) {
                                            try {
                                                LOGGER.info("Creating group: {}", (Object)groupName);
                                                GroupTemplate groupTemplate = new GroupTemplate(groupName, actualUserDirectoryId2.longValue());
                                                this.directoryManager.addGroup(actualUserDirectoryId2.longValue(), groupTemplate);
                                                ++job.successCount;
                                                LOGGER.info("Successfully created group: {}", (Object)groupName);
                                            }
                                            catch (Exception createEx) {
                                                LOGGER.error("Failed to create group '{}': {}", (Object)groupName, (Object)createEx.getMessage());
                                                ++job.errorCount;
                                                job.errorMessages.add("Error creating group at row " + (job.processedRows + 1) + ": " + createEx.getMessage());
                                            }
                                        }
                                        catch (Exception findEx) {
                                            ++job.errorCount;
                                            job.errorMessages.add("Error checking group at row " + (job.processedRows + 1) + ": " + findEx.getMessage());
                                        }
                                    }
                                    ++job.processedRows;
                                    continue;
                                }
                                logBuffer.append("\n[Row ").append(job.processedRows + 1).append(": ").append(UserName).append("]");
                                UserEmail = UserEmailIndex != 10 ? row[UserEmailIndex].trim() : "";
                                FullName = FullNameIndex != 10 ? row[FullNameIndex].trim() : UserName;
                                Status = StatusIndex != 10 ? row[StatusIndex].trim() : "";
                                String string2 = Directory2 = DirectoryIndex != 10 ? row[DirectoryIndex].trim() : "";
                                if (!groupsCsvUpload && (UserName.isEmpty() || UserEmail.isEmpty())) {
                                    ++job.errorCount;
                                    job.errorMessages.add("Missing username/email at row " + (job.processedRows + 1));
                                    continue;
                                }
                                Directory_ID = null;
                                UserDirectory = null;
                                if (!Directory2.isEmpty()) {
                                    try {
                                        UserDirectory = this.directoryManager.findDirectoryByName(Directory2);
                                        Directory_ID = UserDirectory.getId();
                                    }
                                    catch (DirectoryNotFoundException e) {
                                        List allDirectories = this.directoryManager.findAllDirectories();
                                        Directory writableDir = null;
                                        for (Directory dir : allDirectories) {
                                            if (!dir.getAllowedOperations().contains(OperationType.CREATE_USER)) continue;
                                            writableDir = dir;
                                            break;
                                        }
                                        UserDirectory = writableDir != null ? writableDir : (Directory)allDirectories.get(0);
                                        Directory_ID = UserDirectory.getId();
                                        logBuffer.append("\nDirectory '").append(Directory2).append("' not found, using: ").append(UserDirectory.getName());
                                        job.errorMessages.add("Directory '" + Directory2 + "' not found for row " + (job.processedRows + 1) + ", using: " + UserDirectory.getName());
                                    }
                                } else {
                                    UserDirectory = (Directory)this.directoryManager.findAllDirectories().get(0);
                                    Directory_ID = UserDirectory.getId();
                                }
                                user = null;
                                isUserPresent = false;
                                actualUserDirectoryId = Directory_ID;
                                try {
                                    user = this.directoryManager.findUserByName(Directory_ID.longValue(), UserName);
                                    isUserPresent = true;
                                    logBuffer.append("\nUser exists: ").append(UserName);
                                }
                                catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException e) {
                                    if (DirectoryIndex == 10 || Directory2.isEmpty()) {
                                        try {
                                            List allDirectories = this.directoryManager.findAllDirectories();
                                            for (Directory dir : allDirectories) {
                                                try {
                                                    user = this.directoryManager.findUserByName(dir.getId().longValue(), UserName);
                                                    isUserPresent = true;
                                                    actualUserDirectoryId = dir.getId();
                                                    UserDirectory = dir;
                                                    logBuffer.append("\nUser found in: ").append(dir.getName());
                                                    break;
                                                }
                                                catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException throwable) {
                                                }
                                            }
                                        }
                                        catch (Exception searchEx) {
                                            logBuffer.append("\nError searching directories: ").append(searchEx.getMessage());
                                        }
                                    }
                                    if (isUserPresent) break block93;
                                    logBuffer.append("\nWill create new user: ").append(UserName);
                                }
                            }
                            groupList = new ArrayList();
                            if (!Groups.isEmpty() && !(groupList = Arrays.asList(Groups.replaceAll(",+\\s+", ",").split(","))).isEmpty()) {
                                String last;
                                String first = (String)groupList.get(0);
                                if (first.startsWith("[")) {
                                    groupList.set(0, first.substring(1));
                                }
                                if ((last = (String)groupList.get(groupList.size() - 1)).endsWith("]")) {
                                    groupList.set(groupList.size() - 1, last.substring(0, last.length() - 1));
                                }
                            }
                            if (isUserPresent) {
                                boolean isChanged;
                                UserTemplate userTemplate;
                                block94: {
                                    boolean shouldBeActive;
                                    userTemplate = new UserTemplate((User)user);
                                    isChanged = false;
                                    if (!StringUtils.equalsIgnoreCase((CharSequence)user.getDisplayName(), (CharSequence)FullName)) {
                                        userTemplate.setDisplayName(FullName);
                                        isChanged = true;
                                    }
                                    if (!StringUtils.equalsIgnoreCase((CharSequence)user.getEmailAddress(), (CharSequence)UserEmail)) {
                                        userTemplate.setEmailAddress(UserEmail);
                                        isChanged = true;
                                    }
                                    boolean bl = shouldBeActive = Status.equalsIgnoreCase("Active") || Status.equalsIgnoreCase("true");
                                    if (user.isActive() != shouldBeActive) {
                                        userTemplate.setActive(shouldBeActive);
                                        isChanged = true;
                                    }
                                    if (UserDirectory.getAllowedOperations().contains(OperationType.UPDATE_USER)) break block94;
                                    logBuffer.append("\nDirectory not writable, skipping user.");
                                    ++job.errorCount;
                                    job.errorMessages.add("Directory not writable at row " + (job.processedRows + 1));
                                }
                                try {
                                    if (isChanged) {
                                        this.directoryManager.updateUser(actualUserDirectoryId.longValue(), userTemplate);
                                        ++job.successCount;
                                        logBuffer.append("\nUpdated user: ").append(UserName);
                                        if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getLicenseType(), (CharSequence)"TRIAL")) {
                                            this.settings.setUserImportedCount(this.settings.getUserImportedCount() + 1);
                                        }
                                    } else {
                                        logBuffer.append("\nNo changes needed for user: ").append(UserName);
                                    }
                                    break block95;
                                }
                                catch (Exception e) {
                                    logBuffer.append("\nFailed to update user: ").append(e.getMessage());
                                    ++job.errorCount;
                                    job.errorMessages.add("Error updating user at row " + (job.processedRows + 1) + ": " + e.getMessage());
                                    ++job.processedRows;
                                }
                                continue;
                            }
                            try {
                                UserTemplate newUser = new UserTemplate(UserName, Directory_ID.longValue());
                                newUser.setDisplayName(FullName);
                                newUser.setEmailAddress(UserEmail);
                                boolean shouldBeActive = Status.equalsIgnoreCase("Active") || Status.equalsIgnoreCase("true");
                                newUser.setActive(shouldBeActive);
                                this.directoryManager.addUser(Directory_ID.longValue(), newUser, PasswordCredential.NONE);
                                ++job.successCount;
                                user = this.directoryManager.findUserByName(Directory_ID.longValue(), UserName);
                                actualUserDirectoryId = Directory_ID;
                                logBuffer.append("\nCreated user: ").append(UserName);
                                if (!StringUtils.equalsIgnoreCase((CharSequence)this.settings.getLicenseType(), (CharSequence)"TRIAL")) break block95;
                                this.settings.setUserImportedCount(this.settings.getUserImportedCount() + 1);
                            }
                            catch (Exception e) {
                                logBuffer.append("\nFailed to create user: ").append(e.getMessage());
                                ++job.errorCount;
                                job.errorMessages.add("Error creating user at row " + (job.processedRows + 1) + ": " + e.getMessage());
                                ++job.processedRows;
                                continue;
                            }
                        }
                        for (String groupName : groupList) {
                            if (groupName.isEmpty()) continue;
                            try {
                                try {
                                    this.directoryManager.findGroupByName(actualUserDirectoryId.longValue(), groupName);
                                }
                                catch (GroupNotFoundException e) {
                                    GroupTemplate groupTemplate = new GroupTemplate(groupName, actualUserDirectoryId.longValue());
                                    this.directoryManager.addGroup(actualUserDirectoryId.longValue(), groupTemplate);
                                    this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), InetAddress.getLocalHost().getHostAddress(), "Groups Created", "Created group by uploading csv file :" + groupName, "Successful");
                                }
                                catch (Exception e) {
                                    LOGGER.warn("Failed to check/create group '{}': {}", (Object)groupName, (Object)e.getMessage());
                                }
                                this.directoryManager.addUserToGroup(actualUserDirectoryId.longValue(), UserName, groupName);
                                logBuffer.append("\nAdded to group: ").append(groupName);
                            }
                            catch (Exception e) {
                                logBuffer.append("\nFailed to assign group '").append(groupName).append("': ").append(e.getMessage());
                                ++job.errorCount;
                                job.errorMessages.add("Error assigning group at row " + (job.processedRows + 1) + ": " + e.getMessage());
                            }
                        }
                        if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getLicenseType(), (CharSequence)"TRIAL") && !groupsCsvUpload && (currentImportedCount = this.settings.getUserImportedCount()) >= 10) {
                            logBuffer.append("\nTrial import limit reached (").append(currentImportedCount).append("/10 imported users), stopping import.");
                            job.status = "COMPLETED";
                            trialLimitReached = true;
                            this.userManagementPluginHandler.storeAuditLogs(username, ip.getHostAddress(), importType + " CSV Import", importType + " CSV import stopped - trial import limit reached (" + currentImportedCount + "/10)", "Error");
                            continue block65;
                        }
                    }
                    catch (Exception e) {
                        logBuffer.append("\nError processing user: ").append(e.getMessage());
                        ++job.errorCount;
                        job.errorMessages.add("Error at row " + (job.processedRows + 1) + ": " + e.getMessage());
                    }
                    finally {
                        ++job.processedRows;
                        continue;
                    }
                    if (!trialLimitReached) continue;
                    continue block65;
                }
            }
            job.status = "COMPLETED";
            String successMessage = importType + " CSV import completed successfully";
            LOGGER.info("CSV import completed: {}", (Object)successMessage);
            this.userManagementPluginHandler.storeAuditLogs(username, ip.getHostAddress(), importType + " CSV Import", successMessage, "Success");
        }
        catch (Exception e) {
            LOGGER.error("Fatal error in processCsvImport: " + e.getMessage(), (Throwable)e);
            job.status = "FAILED";
            job.errorMessages.add("Fatal error: " + e.getMessage());
            String failureMessage = importType + " CSV import failed";
            this.userManagementPluginHandler.storeAuditLogs(username, ip.getHostAddress(), importType + " CSV Import", failureMessage, "Error");
        }
    }

    private boolean canGroupsBeUpdated(User user) {
        Directory directory = null;
        try {
            directory = this.directoryManager.findDirectoryById(user.getDirectoryId());
        }
        catch (Exception e) {
            LOGGER.error("Issue in updating groups for user " + user.getName());
            return false;
        }
        return directory != null && directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP);
    }

    private void removeUserFromGroups(User user, List<String> groupsToRemove, String ip) throws OperationNotPermittedException {
        try {
            for (String group : groupsToRemove) {
                this.directoryManager.removeUserFromGroup(user.getDirectoryId(), user.getName(), group);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occured while removing groups for user " + String.valueOf(user) + " error= " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> createAndAssignNewGroupsUser(List<String> roleValuesList, Long directoryID) throws UnknownHostException {
        ArrayList<String> groupsToAssign = new ArrayList<String>();
        InetAddress ip = InetAddress.getLocalHost();
        String username = this.userManager.getRemoteUser() != null ? this.userManager.getRemoteUser().getUsername() : "system";
        try {
            for (String groupName : roleValuesList) {
                if (groupName.length() <= 0) continue;
                Boolean groupExist = Boolean.FALSE;
                try {
                    this.directoryManager.findGroupByName(directoryID.longValue(), groupName.trim());
                    groupExist = Boolean.TRUE;
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
                finally {
                    if (!groupExist.booleanValue()) {
                        try {
                            GroupTemplate groupTemplate = new GroupTemplate(groupName.trim(), directoryID.longValue());
                            this.directoryManager.addGroup(directoryID.longValue(), groupTemplate);
                            this.userManagementPluginHandler.storeAuditLogs(username, ip.getHostAddress(), "Group Created", "Created group: " + groupName, "Success");
                        }
                        catch (Exception e) {
                            LOGGER.error(e.getMessage());
                        }
                    }
                }
                groupsToAssign.add(groupName.trim());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return groupsToAssign;
    }

    public void addUserToGroups(User user, List<String> groupsToAssign, String ip) throws OperationNotPermittedException {
        try {
            for (String group : groupsToAssign) {
                if (group.length() <= 0) continue;
                this.directoryManager.addUserToGroup(user.getDirectoryId(), user.getName(), group);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error adding user to groups : " + e.getMessage());
        }
    }

    public Integer getTotalUpdations() {
        return this.totalUpdations;
    }

    public void setTotalUpdations(Integer totalUpdations) {
        this.totalUpdations = totalUpdations;
    }

    public Integer getTotalCreations() {
        return this.totalCreations;
    }

    public void setTotalCreations(Integer totalCreations) {
        this.totalCreations = totalCreations;
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().close();
        }
    }

    public static void shutdownExecutor() {
        LOGGER.info("Shutting down importExecutor for UploadCSVServlet.");
        importExecutor.shutdownNow();
    }
}

