/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.servlet;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.AuditLogDetailsUtils;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.StringJoiner;
import java.util.stream.Collectors;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class MoAuditLogsExport
extends HttpServlet {
    private static Log LOGGER = LogFactory.getLog(MoAuditLogsExport.class);
    private UserManager userManager;
    private UserManagementPluginSettings settings;

    public MoAuditLogsExport(UserManager userManager, UserManagementPluginSettings settings) {
        this.userManager = userManager;
        this.settings = settings;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.info((Object)"MoAuditLogsExport called");
        if (this.doValidate().booleanValue()) {
            String username = request.getParameter("username");
            String ip = request.getParameter("ip");
            String action = request.getParameter("action");
            String period = request.getParameter("period");
            String status = request.getParameter("status");
            List<Object> filteredAuditLogsList = new ArrayList();
            try {
                filteredAuditLogsList = this.settings.getLogsToDisplay(this.settings.getAuditLogs(), username, ip, action, status, period);
            }
            catch (Exception e) {
                LOGGER.debug((Object)("excption in error " + String.valueOf(e)));
            }
            List<Object> auditLogsObjects = new ArrayList();
            Collections.reverse(filteredAuditLogsList);
            LOGGER.debug((Object)("auditlog size :" + filteredAuditLogsList.size()));
            auditLogsObjects = filteredAuditLogsList.stream().map(AuditLogDetailsUtils::fromJsonString).collect(Collectors.toList());
            StringJoiner stringJoiner = new StringJoiner(",");
            stringJoiner.add("Sr.no");
            stringJoiner.add("Username");
            stringJoiner.add("Date");
            stringJoiner.add("IP Address");
            stringJoiner.add("Action");
            stringJoiner.add("Description");
            stringJoiner.add("Status");
            String str = stringJoiner.toString() + "\n";
            int listCounter = 0;
            for (int counter = 0; counter < auditLogsObjects.size(); ++counter) {
                stringJoiner = new StringJoiner(",");
                stringJoiner.add("" + ++listCounter);
                stringJoiner.add(((AuditLogDetailsUtils)auditLogsObjects.get(counter)).getUsername());
                stringJoiner.add(((AuditLogDetailsUtils)auditLogsObjects.get(counter)).getDateAndTime());
                stringJoiner.add(((AuditLogDetailsUtils)auditLogsObjects.get(counter)).getIpAddress());
                stringJoiner.add(((AuditLogDetailsUtils)auditLogsObjects.get(counter)).getAction());
                stringJoiner.add(((AuditLogDetailsUtils)auditLogsObjects.get(counter)).getStatus());
                String desc = ((AuditLogDetailsUtils)auditLogsObjects.get(counter)).getDescription();
                String finalDescription = desc.replace(',', ';');
                stringJoiner.add(finalDescription);
                str = str + stringJoiner.toString() + "\n";
            }
            response.setHeader("Content-Disposition", "attachment; filename=\"Crowd_BulkUserManagement_Audit_Logs.csv\"");
            response.setHeader("Cache-Control", "max-age=0");
            response.setHeader("Pragma", "");
            response.setContentType("text/csv");
            response.getOutputStream().write(str.getBytes());
            return;
        }
        LOGGER.debug((Object)"You do not have administrator privilege to Perform the Operation. ");
        this.sendErrorResponse("Error_Admin_Privilege", response);
    }

    public Boolean doValidate() {
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            return true;
        }
        return false;
    }

    private void sendErrorResponse(String errorMessages, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(500);
        resp.getOutputStream().write(errorMessages.getBytes());
        resp.getOutputStream().close();
    }
}

