/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.servlet;

import jakarta.servlet.ServletOutputStream;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.File;
import java.io.IOException;
import java.io.OutputStream;
import java.nio.file.Files;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadExportServlet
extends HttpServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(DownloadExportServlet.class);

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.info("Initiating user list download process.");
        String username = StringUtils.defaultString((String)request.getRemoteUser());
        File exportFile = new File(System.getProperty("java.io.tmpdir"), "export_" + username + ".csv");
        File doneMarker = new File(exportFile.getAbsolutePath() + ".done");
        String isCheck = request.getParameter("check");
        if (StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{isCheck}) && StringUtils.containsIgnoreCase((CharSequence)isCheck, (CharSequence)"true")) {
            if (doneMarker.exists()) {
                response.setStatus(200);
            } else {
                response.setStatus(204);
            }
            return;
        }
        if (!exportFile.exists()) {
            response.setStatus(404);
            response.getWriter().write("Export not ready yet. Please try again later.");
            return;
        }
        response.setContentType("text/csv");
        response.setHeader("Content-Disposition", "attachment; filename=CrowdUserList.csv");
        response.setHeader("X-Accel-Buffering", "no");
        response.setHeader("Cache-Control", "no-cache, no-store, must-revalidate");
        response.setHeader("Pragma", "no-cache");
        response.setDateHeader("Expires", 0L);
        try (ServletOutputStream out = response.getOutputStream();){
            Files.copy(exportFile.toPath(), (OutputStream)out);
            out.flush();
            LOGGER.info("Export file successfully sent to user: {}", (Object)username);
        }
        catch (IOException e) {
            LOGGER.error("Error sending export file for user: {}", (Object)username, (Object)e);
            response.sendError(500, "Failed to download file.");
            return;
        }
        finally {
            boolean deletedFile = exportFile.delete();
            boolean deletedMarker = doneMarker.delete();
            LOGGER.debug("Cleanup - export file deleted: {}, marker deleted: {}", (Object)deletedFile, (Object)deletedMarker);
        }
        exportFile.delete();
        doneMarker.delete();
    }
}

