/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.scheduler;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.scheduler.AuditLogTask;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.Executors;
import java.util.concurrent.ScheduledExecutorService;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class AuditLogScheduler
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogScheduler.class);
    private SchedulerService schedulerService;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler pluginHandler;
    private ScheduledExecutorService executor;
    private static final JobId JOB_ID = JobId.of((String)AuditLogTask.class.getName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)AuditLogTask.class.getName());
    private static final long DAILY_INTERVAL_MILLIS = 86400000L;

    @Autowired
    public AuditLogScheduler(SchedulerService schedulerService, UserManagementPluginSettings settings, UserManagementPluginHandler pluginHandler) {
        this.schedulerService = schedulerService;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
    }

    public void schedule() throws SchedulerServiceException, UnknownHostException {
        Object actionDescription;
        long refreshIntervalInMillis;
        LOGGER.debug("Scheduling scheduler for Audit Log schedular task");
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new AuditLogTask(this.settings, this.pluginHandler));
        String schedulerType = this.settings.getSchedulerType();
        InetAddress ip = InetAddress.getLocalHost();
        if ("daily".equalsIgnoreCase(schedulerType)) {
            refreshIntervalInMillis = 86400000L;
            actionDescription = "Auto-delete logs scheduler enabled (Daily) with interval of 24 hours";
            LOGGER.debug("Scheduled for daily runs with interval: " + refreshIntervalInMillis + " milliseconds");
        } else if ("custom".equalsIgnoreCase(schedulerType)) {
            refreshIntervalInMillis = this.getRefreshIntervalInMilis();
            actionDescription = "Auto-delete logs scheduler enabled (Custom) with interval of " + refreshIntervalInMillis / 86400000L + " days";
            LOGGER.debug("Scheduled for custom runs with interval: " + refreshIntervalInMillis + " milliseconds");
        } else {
            LOGGER.error("Invalid scheduler type: " + schedulerType);
            throw new SchedulerServiceException("Invalid scheduler type: " + schedulerType);
        }
        Date firstRun = Date.from(Instant.now().plusMillis(refreshIntervalInMillis));
        LOGGER.debug("First run scheduled for: " + String.valueOf(firstRun));
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)refreshIntervalInMillis, null));
        try {
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
            this.settings.setNextSchedulerRunTime(firstRun);
            this.pluginHandler.storeAuditLogs("system", ip.getHostAddress(), "Scheduler Enabled", "Scheduler has been enabled. " + (String)actionDescription + ". First run scheduled for: " + String.valueOf(firstRun), "Success");
        }
        catch (SchedulerServiceException e) {
            LOGGER.error("An error occurred while scheduling audit log task", (Throwable)e);
            this.pluginHandler.storeAuditLogs("system", ip.getHostAddress(), "Scheduler Enable Failed", "Failed to enable scheduler. Error: " + e.getMessage(), "Error");
            throw e;
        }
    }

    public void unschedule() throws UnknownHostException {
        LOGGER.debug("Initiating the unschedule operation " + String.valueOf(JOB_ID));
        try {
            this.schedulerService.unscheduleJob(JOB_ID);
            this.settings.setNextSchedulerRunTime(null);
            InetAddress ip = InetAddress.getLocalHost();
            this.pluginHandler.storeAuditLogs("system", ip.getHostAddress(), "Scheduler Disabled", "Scheduler Disabled for Auto-delete logs.", "Success");
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while unscheduling audit log task", (Throwable)e);
            throw e;
        }
    }

    public void afterPropertiesSet() throws Exception {
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.submit(() -> {
            try {
                LOGGER.debug("Initializing AuditLogScheduler: checking if auto-delete audit logs is enabled.");
                if (this.settings.getAutoDeleteAuditLogs().booleanValue()) {
                    LOGGER.debug("Auto-delete audit logs is enabled. Attempting to schedule audit log task.");
                    this.schedule();
                } else {
                    LOGGER.debug("Auto-delete audit logs is disabled. Skipping scheduler initialization.");
                }
            }
            catch (Exception e) {
                LOGGER.error("Failed to schedule Audit Log", (Throwable)e);
            }
        });
    }

    public void destroy() throws Exception {
        try {
            this.unschedule();
        }
        catch (UnknownHostException e) {
            LOGGER.error("AuditLogScheduler: Failed to unschedule Audit Log", (Throwable)e);
        }
        if (this.executor != null && !this.executor.isShutdown()) {
            LOGGER.info("AuditLogScheduler: Shutting down executor.");
            this.executor.shutdownNow();
        }
    }

    public long getRefreshIntervalInMilis() {
        Integer noOfDays = this.settings.getAutoDeleteLogsAfterDays();
        LOGGER.debug("getRefreshIntervalInMills called.");
        long interval = noOfDays * 24 * 60;
        return interval * 60L * 1000L;
    }
}

