/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.miniorange.usermanagement.constants.UserManagementPluginCommonConstants;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.net.URI;
import java.text.SimpleDateFormat;
import java.util.Date;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class extendFreeTrial
extends HttpServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(extendFreeTrial.class);
    private static final String ACCOUNT_DETAILS_ACTION_PATH = "/plugins/servlet/crowd-user-account/account";
    private Boolean submitted;
    private String errorMessage;
    private UserManagementPluginSettings settings;
    private LoginUriProvider loginUriProvider;
    private UserManager userManager;

    public extendFreeTrial(UserManagementPluginSettings settings, LoginUriProvider loginUriProvider, UserManager userManager) {
        this.settings = settings;
        this.loginUriProvider = loginUriProvider;
        this.userManager = userManager;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            this.submitted = Boolean.valueOf(req.getParameter("submitted"));
            if (this.submitted.booleanValue()) {
                LOGGER.debug("Generating freemium trial");
                int trial_count = this.settings.getTrialCount();
                LOGGER.debug("trail count :- " + trial_count);
                if (trial_count < UserManagementPluginCommonConstants.MO_NUMBER_OF_FREEMIUM_TRIALS) {
                    this.settings.setTrialCount(++trial_count);
                } else if (trial_count >= UserManagementPluginCommonConstants.MO_NUMBER_OF_FREEMIUM_TRIALS) {
                    LOGGER.error("Trial limit exceeded, reach out to miniorange ");
                    resp.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/crowd-user-mologin/dologin");
                    return;
                }
                Date expiry = DateUtils.addMonths((Date)new Date(), (int)1);
                SimpleDateFormat dateFormatter = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS");
                this.settings.setCustomerAPIKey("NA");
                this.settings.setCustomerEmail("-");
                this.settings.setCustomerId("NA");
                this.settings.setLicenseVerified(Boolean.TRUE);
                this.settings.setCustomerTokenKey("18SaSh02nk19et95");
                this.settings.setLicenseType("TRIAL");
                this.settings.setLicencedUsers(this.settings.getCrowdUserTier());
                this.settings.setLicenseExpireDate(dateFormatter.format(expiry));
                LOGGER.debug("Freemium trial Generated - license type is :- " + this.settings.getLicenseType());
                this.settings.setCreatedGroupsCount(0);
                this.settings.setDeletedGroupsCount(0);
                this.settings.setUserDeletedCount(0);
                this.settings.setUsersAddedToGroupCount(0);
                this.settings.setUsersRemovedFromGroupCount(0);
                this.settings.setUserDeactivatedCount(0);
                this.settings.setUserActivatedCount(0);
                resp.sendRedirect(this.settings.getBaseUrl() + ACCOUNT_DETAILS_ACTION_PATH);
                return;
            }
        } else {
            resp.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(req), UserRole.ADMIN).toASCIIString());
        }
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public Boolean getSubmitted() {
        return this.submitted;
    }

    public void setSubmitted(Boolean submitted) {
        this.submitted = submitted;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public void setErrorMessage(String errorMessage) {
        this.errorMessage = errorMessage;
    }
}

