/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.actions;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoVerifyLicenseAction
extends HttpServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(MoVerifyLicenseAction.class);
    private static final String VERIFY_LICENSE_ACTION_PATH = "/templates/verifylicense.vm";
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler pluginHandler;
    private TemplateRenderer renderer;
    private String email;
    private String key;
    private Boolean submitted;
    private Boolean backToRegister;

    public MoVerifyLicenseAction(UserManager userManager, LoginUriProvider loginUriProvider, UserManagementPluginSettings settings, UserManagementPluginHandler pluginHandler, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.renderer = renderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse respone) throws IOException {
        LOGGER.info("verify license action execute called.");
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            if (!this.settings.getLicenseType().equalsIgnoreCase("TRIAL")) {
                if (this.settings.isCustomerRegistered().booleanValue() && this.settings.getLicenseVerified().booleanValue() && !this.settings.isLicenseExpired().booleanValue()) {
                    LOGGER.debug("customer is registered with valid license, redirecting to the configuration page");
                }
                if (!this.settings.isCustomerRegistered().booleanValue()) {
                    LOGGER.debug("customer is not registered redirect to login page.");
                    respone.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/crowd-user-mologin/dologin");
                    return;
                }
            }
            this.initializeSAMLConfig();
            respone.setContentType("text/html;charset=utf-8");
            this.renderer.render(VERIFY_LICENSE_ACTION_PATH, this.initaliseVerifyAction(), (Writer)respone.getWriter());
        } else {
            respone.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse respone) throws IOException {
        LOGGER.info("verify license action doPost called.");
        this.backToRegister = Boolean.valueOf(request.getParameter("backToRegister"));
        if (BooleanUtils.toBoolean((Boolean)this.backToRegister)) {
            LOGGER.debug("back to login page");
            this.settings.removeCustomerAccount();
            LOGGER.debug("Customer is not registered. Redirect to customer login page. ");
            respone.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/crowd-user-mologin/dologin");
            return;
        }
        this.submitted = Boolean.valueOf(request.getParameter("submitted"));
        if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
            LOGGER.debug("verify license action submitted");
            this.key = String.valueOf(request.getParameter("key"));
            if (StringUtils.isBlank((CharSequence)this.key)) {
                this.initializeSAMLConfig();
            }
            Boolean valid = this.pluginHandler.verifyLicense(this.settings, this.key);
            LOGGER.debug("valid = " + valid);
            if (!valid.booleanValue()) {
                this.initializeSAMLConfig();
                respone.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/crowd-user-mologin/dologin");
                return;
            }
            respone.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/usermanagement/configure");
            return;
        }
        respone.setContentType("text/html;charset=utf-8");
        this.renderer.render(VERIFY_LICENSE_ACTION_PATH, this.initaliseVerifyAction(), (Writer)respone.getWriter());
    }

    private void initializeSAMLConfig() {
        this.email = this.settings.getCustomerEmail();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    HashMap<String, Object> initaliseVerifyAction() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", "");
        context.put("settings", this.settings);
        context.put("email", this.email);
        context.put("contextPath", this.settings.getBaseUrl());
        context.put("submitted", this.submitted);
        context.put("key", this.key);
        context.put("backToRegister", this.backToRegister);
        return context;
    }
}

