/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.actions;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.Customer;
import com.miniorange.usermanagement.constants.UserManagementPluginCommonConstants;
import com.miniorange.usermanagement.exceptions.MoPluginException;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoCustomerLoginAction
extends HttpServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(MoCustomerLoginAction.class);
    private static final String CUSTOMER_LOGIN_ACTION_PATH = "/templates/login.vm";
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler moPluginHandler;
    private TemplateRenderer renderer;
    private Boolean submitted;
    private String email;
    private String password;
    private String message;

    public MoCustomerLoginAction(UserManager userManager, LoginUriProvider loginUriProvider, UserManagementPluginSettings settings, UserManagementPluginHandler moPluginHandler, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
        this.renderer = renderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse respone) throws IOException {
        LOGGER.debug("Customer login action doGet() called...");
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            if (this.settings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("License key validation failed. Redirecting to license validation page.");
                respone.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/crowd-user-molicense/doverify");
                return;
            }
            this.message = "";
            respone.setContentType("text/html;charset=utf-8");
            this.renderer.render(CUSTOMER_LOGIN_ACTION_PATH, this.initaliseCustomerLoginAction(), (Writer)respone.getWriter());
        } else {
            respone.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse respone) throws IOException {
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            if (this.settings.isCustomerRegistered().booleanValue()) {
                LOGGER.debug("customer is registered, redirecting to the configure action");
                respone.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/usermanagement/configure");
            }
            this.submitted = Boolean.valueOf(request.getParameter("submitted"));
            this.email = String.valueOf(request.getParameter("email"));
            this.password = String.valueOf(request.getParameter("password"));
            if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
                try {
                    try {
                        Customer customer = this.moPluginHandler.fetchCustomer(this.email, this.password);
                        this.settings.setCustomerId(customer.getCustomerId().toString());
                        this.settings.setCustomerEmail(customer.getEmail());
                        this.settings.setCustomerAPIKey(customer.getApiKey());
                        this.settings.setCustomerTokenKey(customer.getTokenKey());
                        respone.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/crowd-user-molicense/doverify");
                        return;
                    }
                    catch (MoPluginException e) {
                        LOGGER.error("Invalid username and password.");
                    }
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while verifying account details", (Throwable)e);
                    LOGGER.error("An unknown error occurred. Please check logs and contact us at info@miniorange.com.");
                }
            }
            respone.setContentType("text/html;charset=utf-8");
            this.renderer.render(CUSTOMER_LOGIN_ACTION_PATH, this.initaliseCustomerLoginAction(), (Writer)respone.getWriter());
        } else {
            respone.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    HashMap<String, Object> initaliseCustomerLoginAction() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", "");
        context.put("settings", this.settings);
        context.put("contextPath", this.settings.getBaseUrl());
        context.put("email", this.settings.getCustomerEmail());
        context.put("trial_count", this.settings.getTrialCount());
        context.put("number_of_freemium_trials", UserManagementPluginCommonConstants.MO_NUMBER_OF_FREEMIUM_TRIALS);
        return context;
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

