/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.actions;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.exceptions.MoPluginException;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.net.URI;
import java.util.HashMap;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoAccountDetailsAction
extends HttpServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(MoAccountDetailsAction.class);
    private static final String ACCOUNT_DETAILS_ACTION_PATH = "/templates/account.vm";
    private UserManager userManager;
    private LoginUriProvider loginUriProvider;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler moPluginHandler;
    private TemplateRenderer renderer;
    private String email;
    private Boolean reregister;
    private Boolean checklicense;
    private String crowdBaseUrl;
    private String licenseType;
    private String licenseExpireDate;
    private Boolean isNoOfUserExceed;
    private boolean licenseValid;
    private String message;

    public MoAccountDetailsAction(UserManager userManager, LoginUriProvider loginUriProvider, UserManagementPluginSettings settings, UserManagementPluginHandler moPluginHandler, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.loginUriProvider = loginUriProvider;
        this.settings = settings;
        this.moPluginHandler = moPluginHandler;
        this.renderer = renderer;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse respone) throws IOException {
        LOGGER.info("Account Details Action: doGet() called");
        this.licenseValid = this.settings.checkLicenseValidation(respone);
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            if (!this.settings.checkLicenseValidation(respone)) {
                return;
            }
            this.initializeAccountConfig();
            this.message = "";
            respone.setContentType("text/html;charset=utf-8");
            this.renderer.render(ACCOUNT_DETAILS_ACTION_PATH, this.initialAccountManagement(), (Writer)respone.getWriter());
        } else {
            respone.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            UserProfile user = this.userManager.getRemoteUser();
            if (user != null && this.userManager.isAdmin(user.getUserKey())) {
                if (!this.settings.checkLicenseValidation(response)) {
                    return;
                }
                this.reregister = Boolean.valueOf(request.getParameter("reregister"));
                this.checklicense = Boolean.valueOf(request.getParameter("checklicense"));
                if (BooleanUtils.toBoolean((Boolean)this.reregister)) {
                    LOGGER.debug("deactivating customer account");
                    this.moPluginHandler.deactivateAndRemoveCustomerAccount();
                    response.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/crowd-user-mologin/dologin");
                    return;
                }
                this.initializeAccountConfig();
                this.message = "";
                response.setContentType("text/html;charset=utf-8");
                this.renderer.render(ACCOUNT_DETAILS_ACTION_PATH, this.initialAccountManagement(), (Writer)response.getWriter());
            } else {
                response.sendRedirect(this.loginUriProvider.getLoginUri(this.getUri(request)).toASCIIString());
            }
        }
        catch (MoPluginException ex) {
            this.moPluginHandler.deactivateAndRemoveCustomerAccount();
            LOGGER.error("License Not Found. Please contact info@miniorange.com for more details.");
            response.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/crowd-user-mologin/dologin");
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while while verifying license against registered account ", (Throwable)e);
        }
    }

    HashMap<String, Object> initialAccountManagement() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", "");
        context.put("settings", this.settings);
        context.put("contextPath", this.settings.getBaseUrl());
        context.put("licenseType", this.licenseType);
        context.put("licenseValid", this.licenseValid);
        return context;
    }

    private void initializeAccountConfig() {
        this.email = this.settings.getCustomerEmail();
        this.crowdBaseUrl = this.settings.getSpBaseUrl();
        this.licenseType = this.settings.getLicenseType();
        this.licenseExpireDate = this.settings.getLicenseExpireDate();
        this.isNoOfUserExceed = this.settings.isNoOfUserExceed();
    }

    private URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }
}

