/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.actions;

import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.constants.UserManagementPluginCommonConstants;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import jakarta.servlet.http.HttpServlet;
import jakarta.servlet.http.HttpServletRequest;
import jakarta.servlet.http.HttpServletResponse;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkGroupManagementAction
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkGroupManagementAction.class);
    private static final String GROUP_MANAGEMENT_ACTION_PATH = "/templates/bulkGroupManagement.vm";
    private UserManager userManager;
    private UserManagementPluginSettings settings;
    private LoginUriProvider loginUriProvider;
    private CommonUserUtils commonUserUtils;
    private TemplateRenderer renderer;
    private String licenseType;
    private String groupsToCreate;
    private Boolean userManagementGroupsSubmitted;
    private Boolean userManagementGroupsDeletionSubmitted;
    private Boolean usermanagementGroupsUploadSubmitted;
    private String groupManagementSelectedAction;
    private String creationSelection;
    private String groupsToDelete;
    private ArrayList<String> groupsToDeleteList;
    private ArrayList<ArrayList<String>> groupToAddCsv;
    private Boolean uploadgroupSuccessfull = Boolean.FALSE;
    private Set<String> groupSet = new LinkedHashSet<String>();
    private ArrayList<String> groupList = new ArrayList();
    private ArrayList<String> currentPageGroupsList;
    private String groupSearchKeyword = "";
    private Integer selectedPage;
    private Integer startIndex;
    private Integer endIndex;
    private Integer numberOfPages;
    private Integer numberOfRecordsPerPage;
    private Integer groupPerPage;
    private List<String> numberOfPagesList;
    private Set<String> directorySet = new LinkedHashSet<String>();
    private List<String> directories;
    private DirectoryManager directoryManager;
    private String uploadURL;
    private Boolean maxUsersLicense;
    private Boolean evaluationLicense;
    private String deleteFromDirectory;
    private Boolean enableDebugLogs;
    private boolean licenseValid;
    private String message;

    public BulkGroupManagementAction(UserManager userManager, DirectoryManager directoryManager, UserManagementPluginSettings settings, LoginUriProvider loginUriProvider, CommonUserUtils commonUserUtils, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.settings = settings;
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.directoryManager = directoryManager;
        this.commonUserUtils = commonUserUtils;
    }

    public Boolean doValidate() {
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null) {
            LOGGER.debug("Logged-In user: " + user.getUsername());
            if (user.getUserKey() != null) {
                return this.userManager.isAdmin(user.getUserKey());
            }
        } else {
            LOGGER.debug("No user is logged in.");
        }
        return false;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse respone) throws IOException {
        LOGGER.debug("Bulk group management action doGet() called...");
        if (this.settings.getLicenseType().contains("TRIAL") && !this.settings.checkLicenseValidation(respone)) {
            return;
        }
        if (this.doValidate().booleanValue()) {
            String endIndexOfPage;
            String startIndexOfPage;
            LOGGER.debug("After user validation bulk group management....");
            if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getCsvUploadStatus(), (CharSequence)"success")) {
                this.settings.setCsvUploadStatus("notUploaded");
            } else if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getCsvUploadStatus(), (CharSequence)"error")) {
                this.settings.setCsvUploadStatus("notUploaded");
            }
            this.licenseValid = this.settings.checkLicenseValidation(respone);
            String currentURL = request.getRequestURL().toString();
            LOGGER.debug("is license valid: " + this.licenseValid);
            this.uploadURL = !this.licenseValid ? currentURL : this.settings.getBaseUrl() + "/plugins/servlet/usermanagment/uploadcsv";
            Directory defaultDirectory = null;
            try {
                List list = this.directoryManager.findAllDirectories();
                LOGGER.debug("total directories: " + list.size());
                if (!list.isEmpty()) {
                    defaultDirectory = (Directory)list.get(0);
                    for (Directory x : list) {
                        this.directorySet.add(x.getName());
                    }
                }
                this.directories = new ArrayList<String>(this.directorySet);
            }
            catch (Exception e) {
                LOGGER.error("Directories were not found:" + e.getMessage());
            }
            this.enableDebugLogs = this.settings.getEnableDebugLogs();
            if (BooleanUtils.toBoolean((Boolean)this.userManagementGroupsDeletionSubmitted)) {
                startIndexOfPage = "";
                endIndexOfPage = "";
            } else {
                LOGGER.debug("groupPerPageUrl: " + request.getParameter("groupPerPageUrl"));
                LOGGER.debug("groupPerPage: " + request.getParameter("groupPerPage"));
                this.groupPerPage = request.getParameter("groupPerPageurl") == null ? UserManagementPluginCommonConstants.MO_NUMBER_OF_GROUP_PER_PAGE : Integer.valueOf(Integer.parseInt(request.getParameter("groupPerPageurl")));
                startIndexOfPage = request.getParameter("startIndex");
                endIndexOfPage = request.getParameter("endIndex");
                this.groupSearchKeyword = request.getParameter("groupSearchKeywordUrl");
                this.deleteFromDirectory = request.getParameter("selectedDirectoryInUrl");
            }
            if (this.groupPerPage == null) {
                this.groupPerPage = UserManagementPluginCommonConstants.MO_NUMBER_OF_GROUP_PER_PAGE;
            }
            if (this.deleteFromDirectory == null || this.deleteFromDirectory.isEmpty()) {
                this.deleteFromDirectory = defaultDirectory.getName();
            }
            Directory deleteFromDirectoryObj = defaultDirectory;
            try {
                if (this.deleteFromDirectory != "") {
                    deleteFromDirectoryObj = this.directoryManager.findDirectoryByName(this.deleteFromDirectory);
                } else {
                    this.deleteFromDirectory = defaultDirectory.getName();
                }
            }
            catch (Exception exp) {
                LOGGER.error("Directory was not found:" + exp.getMessage());
            }
            this.numberOfRecordsPerPage = this.groupPerPage;
            this.groupSearchKeyword = StringUtils.isBlank((CharSequence)this.groupSearchKeyword) ? "" : UserManagementPluginSettings.sanitizeText(this.groupSearchKeyword).trim();
            if (StringUtils.isBlank((CharSequence)startIndexOfPage) && StringUtils.isBlank((CharSequence)endIndexOfPage)) {
                this.selectedPage = 1;
                this.startIndex = 0;
                this.endIndex = this.numberOfRecordsPerPage;
            } else {
                this.startIndex = Integer.parseInt(startIndexOfPage);
                this.endIndex = Integer.parseInt(endIndexOfPage);
                this.selectedPage = this.endIndex / this.groupPerPage;
            }
            LOGGER.debug("numberOfRecordsPerPage is :" + this.numberOfRecordsPerPage);
            LOGGER.debug("groupSearchKeyword is :" + this.groupSearchKeyword);
            LOGGER.debug("startIndex is :" + this.startIndex);
            LOGGER.debug("endIndex is :" + this.endIndex);
            LOGGER.debug("group perPage is :" + this.groupPerPage);
            EntityQuery groupQuery = QueryBuilder.queryFor(InternalGroup.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)GroupTermKeys.NAME).containing((Object)this.groupSearchKeyword)})).returningAtMost(-1);
            LOGGER.debug("delete from directory " + deleteFromDirectoryObj.getName());
            try {
                this.groupSet = new HashSet<String>();
                for (InternalGroup group : this.directoryManager.searchGroups(this.directoryManager.findDirectoryByName(this.deleteFromDirectory).getId().longValue(), groupQuery)) {
                    this.groupSet.add(group.getName());
                }
                this.groupList = new ArrayList<String>(this.groupSet);
            }
            catch (Exception e) {
                LOGGER.debug("Execpetion while fetching group list: " + String.valueOf(e));
            }
            this.currentPageGroupsList = (ArrayList)this.commonUserUtils.getSelectedDetailsForPagination(this.groupList, this.groupPerPage, this.startIndex, this.endIndex);
            this.numberOfPages = this.groupList.size() / this.groupPerPage;
            if (this.groupList.size() > this.numberOfPages * this.groupPerPage) {
                Integer n = this.numberOfPages;
                this.numberOfPages = this.numberOfPages + 1;
            }
            this.initialization();
            this.message = "";
            respone.setContentType("text/html;charset=utf-8");
            this.renderer.render(GROUP_MANAGEMENT_ACTION_PATH, this.initialiseGroupManagement(), (Writer)respone.getWriter());
        } else {
            respone.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.commonUserUtils.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("doPost method called...");
        if (this.doValidate().booleanValue()) {
            LOGGER.debug("After user validation bulk group management action...");
            this.groupSearchKeyword = request.getParameter("groupSearchKeyword");
            this.deleteFromDirectory = request.getParameter("deleteFromDirectory");
            if (BooleanUtils.toBoolean((Boolean)this.userManagementGroupsDeletionSubmitted)) {
                String startIndexOfPage = "";
                String endIndexOfPage = "";
            } else {
                LOGGER.debug("groupPerPage: " + request.getParameter("groupPerPage"));
                this.groupPerPage = request.getParameter("groupPerPage") != null ? Integer.parseInt(request.getParameter("groupPerPage")) : UserManagementPluginCommonConstants.MO_NUMBER_OF_GROUP_PER_PAGE;
                this.groupSearchKeyword = request.getParameter("groupSearchKeywordUrl") != null ? request.getParameter("groupSearchKeywordUrl") : this.groupSearchKeyword;
                this.deleteFromDirectory = request.getParameter("selectedDirectoryInUrl") != null ? request.getParameter("selectedDirectoryInUrl") : this.deleteFromDirectory;
            }
            this.numberOfRecordsPerPage = this.groupPerPage = this.groupPerPage != null ? this.groupPerPage : UserManagementPluginCommonConstants.MO_NUMBER_OF_GROUP_PER_PAGE;
            this.groupSearchKeyword = StringUtils.isNotBlank((CharSequence)this.groupSearchKeyword) ? UserManagementPluginSettings.sanitizeText(this.groupSearchKeyword).trim() : "";
            this.selectedPage = 1;
            this.startIndex = 0;
            this.endIndex = this.numberOfRecordsPerPage;
            LOGGER.debug("numberOfRecordsPerPage is: " + this.numberOfRecordsPerPage);
            LOGGER.debug("groupSearchKeyword is: " + this.groupSearchKeyword);
            LOGGER.debug("startIndex is: " + this.startIndex);
            LOGGER.debug("endIndex is: " + this.endIndex);
            LOGGER.debug("groupPerPage is: " + this.groupPerPage);
            EntityQuery groupQuery = QueryBuilder.queryFor(InternalGroup.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)GroupTermKeys.NAME).containing((Object)this.groupSearchKeyword)})).returningAtMost(-1);
            try {
                this.groupSet = new HashSet<String>();
                for (InternalGroup group : this.directoryManager.searchGroups(this.directoryManager.findDirectoryByName(this.deleteFromDirectory).getId().longValue(), groupQuery)) {
                    this.groupSet.add(group.getName());
                }
                this.groupList = new ArrayList<String>(this.groupSet);
            }
            catch (Exception e) {
                LOGGER.error("Exception while fetching group list: " + e.getMessage(), (Throwable)e);
            }
            this.currentPageGroupsList = (ArrayList)this.commonUserUtils.getSelectedDetailsForPagination(this.groupList, this.groupPerPage, this.startIndex, this.endIndex);
            this.numberOfPages = (int)Math.ceil((double)this.groupList.size() / (double)this.groupPerPage.intValue());
            this.maxUsersLicense = this.settings.getLicencedUsers() == 0;
            if (!this.maxUsersLicense.booleanValue()) {
                this.evaluationLicense = this.settings.getLicenseVerified() == false || this.settings.isLicenseExpired() != false;
            }
            this.message = "";
            response.setContentType("text/html;charset=utf-8");
            this.renderer.render(GROUP_MANAGEMENT_ACTION_PATH, this.initialiseGroupManagement(), (Writer)response.getWriter());
        }
    }

    public void initialization() {
        this.groupManagementSelectedAction = this.settings.getUserManagementSelectedAction();
        this.creationSelection = this.settings.getCreationSelection();
        this.groupsToCreate = this.settings.getGroupsToCreate();
        this.groupsToDeleteList = (ArrayList)this.settings.getGroupsToDelete();
    }

    HashMap<String, Object> initialiseGroupManagement() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", "");
        context.put("settings", this.settings);
        context.put("contextPath", this.settings.getBaseUrl());
        context.put("licenseType", this.licenseType);
        context.put("uploadURL", this.uploadURL);
        context.put("licenseValid", this.licenseValid);
        context.put("groupManagementSelectedAction", this.groupManagementSelectedAction);
        context.put("maxUsersLicense", this.maxUsersLicense);
        context.put("groupsToCreate", this.groupsToCreate);
        context.put("directories", this.directories);
        context.put("groupsToDelete", this.groupsToDelete);
        context.put("evaluationLicense", this.evaluationLicense);
        context.put("groupSearchKeyword", this.groupSearchKeyword);
        context.put("currentPageGroupsList", this.currentPageGroupsList);
        context.put("startIndex", this.startIndex);
        context.put("endIndex", this.endIndex);
        context.put("groupList", this.groupList);
        context.put("deleteFromDirectory", this.deleteFromDirectory);
        context.put("numberOfRecordsPerPage", this.numberOfRecordsPerPage);
        context.put("selectedPage", this.selectedPage);
        context.put("numberOfPagesList", this.getNumberOfPagesList());
        context.put("groupPerPage", this.groupPerPage);
        context.put("remainingLicenseDays", this.commonUserUtils.getRemainingLicenseDays());
        return context;
    }

    public List<String> getNumberOfPagesList() {
        this.numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfPages; ++i) {
            this.numberOfPagesList.add("" + i);
        }
        return this.numberOfPagesList;
    }
}

