/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement;

import com.miniorange.usermanagement.scheduler.AuditLogScheduler;
import com.miniorange.usermanagement.scheduler.UserDeactivateService;
import com.miniorange.usermanagement.servlet.UploadCSVServlet;
import jakarta.annotation.PreDestroy;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class PluginShutdownListener {
    private static final Logger LOGGER = LoggerFactory.getLogger(PluginShutdownListener.class);
    @Autowired
    private AuditLogScheduler auditLogScheduler;
    @Autowired
    private UserDeactivateService userDeactivateService;

    @PreDestroy
    public void onPluginShutdown() {
        LOGGER.debug("PluginShutdownListener: Plugin shutdown initiated.");
        try {
            LOGGER.debug("PluginShutdownListener: Shutting down UploadCSVServlet executor.");
            UploadCSVServlet.shutdownExecutor();
            if (this.auditLogScheduler != null) {
                LOGGER.debug("PluginShutdownListener: Destroying AuditLogScheduler.");
                this.auditLogScheduler.destroy();
            }
            if (this.userDeactivateService != null) {
                LOGGER.debug("PluginShutdownListener: Destroying UserDeactivateService.");
                this.userDeactivateService.destroy();
            }
            LOGGER.debug("PluginShutdownListener: Plugin shutdown completed successfully.");
        }
        catch (Exception e) {
            LOGGER.error("PluginShutdownListener: Exception during plugin shutdown.", (Throwable)e);
        }
    }
}

