
AJS.$(document).ready(function() {
    google.charts.setOnLoadCallback(function() {
        drawGraph();
        drawChart();
    });

    showProgressBar();
});

function drawChart() {
    var activeUsers = $activeUsers;
    var deactivateUsers = $deactivatedUsers;
    var inactiveUsers = $inactiveUsers;
    var data = new google.visualization.DataTable();
    data.addColumn('string', 'User Type');
    data.addColumn('number', 'Count');
    data.addRows([
        ['Deactivated Users', deactivateUsers],
        ['Inactive Users', inactiveUsers],
        ['Active Users', activeUsers]
    ]);
    var options = {
        titleTextStyle :
            { color: 'black',
                fontName: 'monospace',
                fontSize: 20,
                textAlign:'center'
            },
        'width':250,
        'height':300,
        is3D:true,
        slices: {
            0: { color: '#e4080a' },
            1: { color: '#ffb40a' },
            2: { color: '#0856d1' }
        },
        legend: 'none',
        chartArea:{left:10,top:20,right:10,width:'95%',height:'95%'}
    };

    var chart = new google.visualization.PieChart(document.getElementById('pieContainer'));
    chart.draw(data, options);
}

function drawGraph() {
    var barChart;
    var data = document.getElementById("userStatusCounts").value;
    var respData = JSON.parse(data);

    var activeCountsData = Object.values(respData.activeCounts);
    var inactiveCountsData = Object.values(respData.inactiveCounts);

    var categories = Object.keys(respData.activeCounts);

    var options = {
        chart: {
            type: 'bar',
            animations: {
                enabled: true,
                easing: 'easeinout',
                speed: 800
            }
        },
        series: [
            { name: 'Active Users', data: activeCountsData },
            { name: 'Inactive Users', data: inactiveCountsData }
        ],
        xaxis: {
            categories: categories,
            title: {
                text: 'Number of Days (Before)',
                style: {
                    fontSize: '12px',
                    fontWeight: 'bold'
                }
            }
        },
        yaxis: {
            title: {
                text: 'Users Count',
                style: {
                    fontSize: '12px',
                    fontWeight: 'bold'
                }
            },
            min: 0
        },
        dataLabels: {
            enabled: false
        },
        legend: {
            show: true,
            position: 'top'
        },
        colors: ['#06419d', '#FFB40A']
    };

    if (barChart) {
        barChart.destroy();
    }


    barChart = new ApexCharts(document.querySelector("#chartContainer"), options);
    barChart.render();
}


function showProgressBar() {
    var usedLicense = parseInt($usedLicense);
    var licensedTier = $licenseTier;
    var availableLicense = $availableLicense;

    if (licensedTier === "-1") {
        licensedTier = usedLicense;
    } else {
        licensedTier = Math.max(usedLicense, parseInt(licensedTier));
    }

    var availableLicenseProgress = document.getElementById("availableLicenseProgress");
    if (availableLicense === "-1") {
        availableLicenseProgress.style.width = '100%';
    } else {
        var availableLicensePercent = (parseInt(availableLicense) / licensedTier) * 100;
        availableLicenseProgress.setAttribute('width', availableLicensePercent + '%');
    }
}


function showUsers(userType) {

    var userList = [];
    userList = document.getElementById(userType).value;
    userList = JSON.parse(userList);
    var userHeaderName = document.getElementById("userListType");

    switch (userType) {
        case "activeUserList" : userHeaderName.innerHTML = "Active Users List";
            break;

        case "loggedInActiveUsersList":
            userHeaderName.innerHTML = "Logged-in Active Users List";
            break;

        case "neverLoggedInActiveUsersList":
            userHeaderName.innerHTML = "Never Logged-in Active Users List";
            break;

        case "inactiveUsersList" : userHeaderName.innerHTML = "Inactive Users List";
            break;

        case "deactivatedUsersList" : userHeaderName.innerHTML = "Deactivated Users List";
            break;

        case "activatedUsersList" : userHeaderName.innerHTML = "Activated Users List";
            break;

    }

    var tableBody = document.querySelector("#userDataTable tbody");
    tableBody.innerHTML = '';

    var tableHead = document.querySelector("#userDataTable thead ");
    tableHead.innerHTML= '';

    var newRow = document.createElement("tr");
    tableHead.appendChild(newRow);

    if(userType=== "deactivatedUsersList"){

        var headers = ['S.No.','Username','Creation Date'];
        var table = document.getElementById('userDataTable');
        var thead = table.querySelector('thead');
        var row = thead.querySelector('tr');

        headers.forEach(function(header) {
            var th = document.createElement('th');
            th.textContent = header;
            row.appendChild(th);
        });

        var count = 0;

        tableBody.innerHTML = userList.map(function (item) {
            var rowData = item.split(';');
            count++;
            return '<tr><td>' + count + '</td><td>' + rowData[0] + '</td><td>' + rowData[1]+'</td></tr>';
        }).join('');

    }else {

        var headers = ['S.No.','Username', 'Creation Date', 'Last Login (Days Ago)'];
        var table = document.getElementById('userDataTable');
        var thead = table.querySelector('thead');
        var row = thead.querySelector('tr');

        headers.forEach(function(header) {
            var th = document.createElement('th');
            th.textContent = header;
            row.appendChild(th);
        });
        if(userList.length != 0){
            var count = 0;
            tableBody.innerHTML = userList.map(function (item) {
                count++;
                var rowData = item.split(';');
                return '<tr><td>' + count + '</td><td>' + rowData[0] + '</td><td>' + rowData[1] + '</td><td>' + rowData[2] + '</td></tr>';
            }).join('');
        }else{
            var noUserRow = document.createElement('tr');
            var noUserCell = document.createElement('td');
            noUserCell.colSpan = headers.length;
            noUserCell.textContent = 'No users exist';
            noUserCell.style.textAlign = 'center';
            noUserCell.style.padding = '10px';
            noUserRow.appendChild(noUserCell);
            tableBody.appendChild(noUserRow);
        }

    }

    var overlay = document.getElementById('dialogOverlay');
    var dialogBox = document.getElementById('dialogBox');
    overlay.style.display = 'flex';
    setTimeout(function() {
        dialogBox.classList.add('show');
    }, 10);

}

function closeDialog(){
    var overlay = document.getElementById('dialogOverlay');
    var dialogBox = document.getElementById('dialogBox');
    dialogBox.classList.remove('show');
    overlay.style.display = 'none';
}