/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.scheduler;

import com.atlassian.sal.api.user.UserManager;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.scheduler.UserDeactivateTask;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.time.Instant;
import java.util.Date;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.DisposableBean;
import org.springframework.beans.factory.InitializingBean;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserDeactivateService
implements InitializingBean,
DisposableBean {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDeactivateService.class);
    private SchedulerService schedulerService;
    private CommonUserUtils commonUserUtils;
    private UserManagementPluginSettings settings;
    private UserManagementPluginHandler userManagementPluginHandler;
    private UserManager userManager;
    private ExecutorService executor;
    private static final JobId JOB_ID = JobId.of((String)UserDeactivateTask.class.getName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)UserDeactivateTask.class.getName());
    long refreshIntervalInMiliseconds = 86400000L;
    private String actionOnUser;

    @Autowired
    public UserDeactivateService(CommonUserUtils commonUserUtils, UserManagementPluginSettings settings, SchedulerService schedulerService, UserManagementPluginHandler userManagementPluginHandler, UserManager userManager) {
        this.schedulerService = schedulerService;
        this.commonUserUtils = commonUserUtils;
        this.settings = settings;
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.userManager = userManager;
    }

    public void schedule() throws UnknownHostException, SchedulerServiceException {
        LOGGER.debug("Scheduling scheduler for deactivation task");
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new UserDeactivateTask(this.commonUserUtils, this.settings, this, this.userManagementPluginHandler));
        this.refreshIntervalInMiliseconds = this.getRefreshIntervalInMilis();
        LOGGER.debug("Refresh Interval in millis=" + this.refreshIntervalInMiliseconds);
        Date firstRun = Date.from(Instant.now().plusMillis(this.refreshIntervalInMiliseconds));
        InetAddress ip = InetAddress.getLocalHost();
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)this.refreshIntervalInMiliseconds, null));
        try {
            String action;
            switch (this.actionOnUser = this.settings.getActionOnUser()) {
                case "autoDeactivateUser": {
                    action = "Auto Deactivate User";
                    break;
                }
                case "removeGroupsFromUsers": {
                    action = "Remove Groups From Users";
                    break;
                }
                default: {
                    action = "Remove Groups From Users and Auto Deactivate User";
                }
            }
            this.userManagementPluginHandler.storeAuditLogs("system", ip.getHostAddress(), "Scheduler Enabled", "Scheduler has been enabled. Applied operation: " + action + ".", "Success");
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
            this.settings.setNextScheduledRunTime(firstRun);
        }
        catch (SchedulerServiceException e) {
            LOGGER.error("An error occurred while scheduling user deactivation task ", (Throwable)e);
            this.userManagementPluginHandler.storeAuditLogs("system", ip.getHostAddress(), "Scheduler Failed", "Failed to configure scheduler.", "Error");
            throw e;
        }
    }

    public void afterPropertiesSet() {
        LOGGER.debug("Initializing UserDeactivateService: Evaluating actionOnUser for scheduler setup.");
        this.executor = Executors.newSingleThreadScheduledExecutor();
        this.executor.submit(() -> {
            try {
                this.actionOnUser = this.settings.getActionOnUser();
                if ("autoDeactivateUser".equalsIgnoreCase(this.actionOnUser) || "removeGroupsFromUsers".equalsIgnoreCase(this.actionOnUser) || "removeGroupsAndAutoDeactivate".equalsIgnoreCase(this.actionOnUser)) {
                    LOGGER.info("Scheduler will be initialized for actionOnUser='{}'", (Object)this.actionOnUser);
                    this.schedule();
                } else {
                    LOGGER.info("No scheduling required for actionOnUser='{}'. Scheduler will be disabled.", (Object)this.actionOnUser);
                    this.unschedule();
                }
            }
            catch (Exception e) {
                LOGGER.error("An error occurred during scheduler initialization", (Throwable)e);
            }
        });
    }

    public void destroy() {
        LOGGER.debug("UserDeactivateService: destroy() called, unscheduling jobs and shutting down executor.");
        try {
            this.unschedule();
            this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
        }
        catch (Exception e) {
            LOGGER.error("UserDeactivateService: Exception while unscheduling user task", (Throwable)e);
        }
        if (this.executor != null && !this.executor.isShutdown()) {
            LOGGER.info("UserDeactivateService: Shutting down executor.");
            this.executor.shutdownNow();
        }
        LOGGER.debug("UserDeactivateService: destroy() completed.");
    }

    public void unschedule() throws UnknownHostException {
        LOGGER.debug("Initiating the unschedule operation " + JOB_ID);
        this.schedulerService.unscheduleJob(JOB_ID);
        this.settings.setNextScheduledRunTime(null);
        InetAddress ip = InetAddress.getLocalHost();
        this.userManagementPluginHandler.storeAuditLogs("system", ip.getHostAddress(), "Scheduler Disabled", "Scheduler Disabled for the Action on User.", "Success");
    }

    public long getRefreshIntervalInMilis() {
        String refreshInterval = this.settings.getRefreshInterval();
        int customRefreshInterval = this.settings.getCustomRefreshInterval();
        String customRefreshIntervalUnit = this.settings.getCustomRefreshIntervalUnit();
        LOGGER.debug("getRefreshIntervalInMills called.");
        long interval = StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"hourly") ? 60L : (StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"twicedaily") ? 720L : (StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"daily") ? 1440L : (StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"weekly") ? 10080L : (StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"monthly") ? 43200L : (StringUtils.equalsIgnoreCase((CharSequence)customRefreshIntervalUnit, (CharSequence)"hours") ? (long)(customRefreshInterval * 60) : (StringUtils.equalsIgnoreCase((CharSequence)customRefreshIntervalUnit, (CharSequence)"days") ? (long)(customRefreshInterval * 24 * 60) : (long)customRefreshInterval))))));
        return interval * 60L * 1000L;
    }
}

