/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.scheduler;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import java.text.ParseException;
import java.util.Date;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogTask
implements JobRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogTask.class);
    public UserManagementPluginSettings settings;
    public UserManagementPluginHandler pluginHandler;

    public AuditLogTask(UserManagementPluginSettings settings, UserManagementPluginHandler pluginHandler) {
        this.settings = settings;
        this.pluginHandler = pluginHandler;
    }

    public JobRunnerResponse runJob(JobRunnerRequest request) {
        try {
            LOGGER.debug("Running the job.....");
            if (this.settings.getLastRunTime() == null) {
                this.settings.setLastRunTime(new Date());
                LOGGER.debug("Audit log scheduler last run time not found. Initializing with current timestamp as first run.");
            }
            if (this.settings.checkLicenseValidation(null)) {
                this.deleteAuditLogs();
                this.settings.setLastRunTime(new Date());
            } else {
                LOGGER.error("License validation failed: An error occurred during the validation process.");
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while executing the process", (Throwable)e);
        }
        return JobRunnerResponse.success();
    }

    public void deleteAuditLogs() throws ParseException {
        if (this.settings.getAutoDeleteAuditLogs().booleanValue()) {
            List<String> auditLogs = this.settings.getAuditLogs();
            Integer pastDays = this.settings.getAutoDeleteLogsAfterDays();
            Integer numberOfEntriesToRetain = this.settings.getNumberOfEntriesToRetain();
            LOGGER.debug("Total logs before deletion: {}", (Object)auditLogs.size());
            List<String> logsAfterDeletion = this.pluginHandler.autoDeleteAuditLogs(auditLogs, pastDays, numberOfEntriesToRetain);
            LOGGER.debug("Total logs after deletion: {}", (Object)logsAfterDeletion.size());
            LOGGER.debug("Total logs deleted: {}", (Object)(auditLogs.size() - logsAfterDeletion.size()));
            this.settings.setAuditLogs(logsAfterDeletion);
            LOGGER.debug("Successfully deleted logs!");
        }
    }
}

