/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.actions;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ImportExportAction
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(ImportExportAction.class);
    private static final String IMPORT_EXPORT_ACTION_PATH = "/templates/importexport.vm";
    private UserManager userManager;
    private UserManagementPluginSettings settings;
    private LoginUriProvider loginUriProvider;
    private CommonUserUtils commonUserUtils;
    private TemplateRenderer renderer;
    private boolean licenseValid;
    private String uploadURL;
    private String exportURL;
    private String licenseType;
    private Boolean enableDebugLogs;
    private String message;

    public ImportExportAction(UserManager userManager, UserManagementPluginSettings settings, LoginUriProvider loginUriProvider, CommonUserUtils commonUserUtils, TemplateRenderer renderer) {
        this.userManager = userManager;
        this.settings = settings;
        this.loginUriProvider = loginUriProvider;
        this.commonUserUtils = commonUserUtils;
        this.renderer = renderer;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, NumberFormatException, IOException {
        LOGGER.debug("Import Export doGet() method called");
        if (!this.settings.checkLicenseValidation(resp)) {
            return;
        }
        LOGGER.debug("After user validation on import export action....");
        String currentURL = req.getRequestURL().toString();
        LOGGER.debug("currentURL: {}", (Object)currentURL);
        this.licenseValid = this.settings.checkLicenseValidation(resp);
        LOGGER.debug("is license valid: " + this.licenseValid);
        if (!this.licenseValid) {
            this.uploadURL = currentURL;
            this.exportURL = currentURL;
        } else {
            this.uploadURL = this.settings.getBaseUrl() + "/plugins/servlet/usermanagment/uploadcsv";
            this.exportURL = this.settings.getBaseUrl() + "/plugins/servlet/usermanagment/exportcsv";
        }
        this.licenseType = this.settings.getLicenseType();
        if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getCsvUploadStatus(), (CharSequence)"success")) {
            this.settings.setCsvUploadStatus("notUploaded");
        } else if (StringUtils.equalsIgnoreCase((CharSequence)this.settings.getCsvUploadStatus(), (CharSequence)"error")) {
            this.settings.setCsvUploadStatus("notUploaded");
        }
        this.message = "";
        resp.setContentType("text/html;charset=utf-8");
        this.renderer.render(IMPORT_EXPORT_ACTION_PATH, this.initialiseImportExport(), (Writer)resp.getWriter());
    }

    HashMap<String, Object> initialiseImportExport() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", "");
        context.put("settings", this.settings);
        context.put("contextPath", this.settings.getBaseUrl());
        context.put("licenseType", this.licenseType);
        context.put("uploadURL", this.uploadURL);
        context.put("exportURL", this.exportURL);
        context.put("licenseValid", this.licenseValid);
        context.put("remainingLicenseDays", this.commonUserUtils.getRemainingLicenseDays());
        if (StringUtils.equalsIgnoreCase((CharSequence)this.licenseType, (CharSequence)"TRIAL")) {
            int importedCount = this.settings.getUserImportedCount();
            context.put("importedUsersCount", importedCount);
            context.put("remainingImports", Math.max(0, 10 - importedCount));
        }
        return context;
    }
}

