/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.actions;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.constants.UserManagementPluginCommonConstants;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.IOException;
import java.io.Writer;
import java.text.Format;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import java.util.stream.StreamSupport;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkUserManagementAction
extends HttpServlet {
    private static final String USER_MANAGEMENT_ACTION_PATH = "/templates/bulkUserManagement.vm";
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkUserManagementAction.class);
    private List<UserTemplate> userTemplates;
    private int page;
    private int numberOfPages;
    private int numberOfUsers;
    private Boolean enableDebugLogs;
    private int startIndex;
    public String message = "";
    private HashMap<String, List<String>> usersAndGroup = new HashMap();
    private List<String> numberOfPagesList;
    private boolean licenseValid;
    private List<String> directories;
    private Integer userPerPage;
    private List<UserTemplate> currentPageUsersList;
    private String start_date_lastLoginTime;
    private String end_date_lastLoginTime;
    private String searchUser;
    private String userFilter;
    private boolean submitted;
    private Boolean sortByLastLogin;
    private String currentDate;
    private String[] groupSearchKey;
    private List<String> groupSearchList = new ArrayList<String>();
    private String groupSearchKeyValue;
    private String selectedDirectory;
    private String loginBasedFilter;
    private Integer numberOfRecordsPerPage;
    private Integer selectedPage;
    private Integer endIndex;
    private int totalUsers;
    private Format format;
    String startIndexOfPage = "";
    String endIndexOfPage = "";
    private Set<String> directorySet = new LinkedHashSet<String>();
    private Map<String, String> userDirectoryNameMap = new HashMap<String, String>();
    private boolean lastLoginDate;
    public ArrayList<String> errorMessage = new ArrayList();
    public Map<String, String> lastLoginTime;
    private UserManager userManager;
    private DirectoryManager directoryManager;
    private CommonUserUtils commonUserUtils;
    private final UserManagementPluginSettings settings;
    private TemplateRenderer renderer;
    private LoginUriProvider loginUriProvider;
    private CrowdService crowdService;
    private Directory directory;

    public BulkUserManagementAction(UserManagementPluginSettings settings, UserManager userManager, DirectoryManager directoryManager, CommonUserUtils commonUserUtils, TemplateRenderer renderer, LoginUriProvider loginUriProvider, CrowdService crowdService) {
        this.userManager = userManager;
        this.directoryManager = directoryManager;
        this.commonUserUtils = commonUserUtils;
        this.settings = settings;
        this.renderer = renderer;
        this.loginUriProvider = loginUriProvider;
        this.crowdService = crowdService;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws NumberFormatException, IOException {
        if (!this.settings.checkLicenseValidation(resp)) {
            return;
        }
        if (this.doValidate().booleanValue()) {
            LOGGER.debug("After user validation automated user management...");
            this.page = req.getParameter("page") != null ? Integer.parseInt(req.getParameter("page")) : 1;
            LOGGER.debug("user filter is: " + this.userFilter);
            this.startIndex = (this.page - 1) * 20;
            this.numberOfUsers = this.commonUserUtils.getTotalSearchResults("");
            this.numberOfPages = (int)Math.ceil((double)this.numberOfUsers / 20.0);
            this.start_date_lastLoginTime = "1970-01-01";
            Calendar cal = Calendar.getInstance();
            SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
            String expiryDateString = dateFormat.format(new Date(cal.getTimeInMillis()));
            this.currentDate = expiryDateString.split(" ")[0];
            this.userPerPage = req.getParameter("userPerPage") == null ? UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE : Integer.parseInt(req.getParameter("userPerPage"));
            LOGGER.debug("User per page is: " + this.userPerPage);
            this.submitted = Boolean.parseBoolean(req.getParameter("submitted"));
            LOGGER.debug("submitted is: " + this.submitted);
            if (BooleanUtils.toBoolean((Boolean)this.submitted)) {
                this.startIndexOfPage = "";
                this.endIndexOfPage = "";
                String hasFilteredGroups = req.getParameter("hasFilteredGroups");
                if (hasFilteredGroups != null && hasFilteredGroups.equals("false")) {
                    this.groupSearchList = new ArrayList<String>();
                    this.groupSearchKeyValue = "Group";
                } else {
                    this.groupSearchKey = req.getParameterValues("groupSearchKey");
                    if (this.groupSearchKey == null) {
                        this.groupSearchKeyValue = "Group";
                    } else {
                        this.groupSearchList = Arrays.asList(this.groupSearchKey);
                        this.groupSearchList.removeAll(Arrays.asList(null, ""));
                        this.groupSearchKeyValue = this.groupSearchList.size() == 1 ? this.groupSearchList.size() + " Group Selected " : this.groupSearchList.size() + " Groups Selected ";
                        this.groupSearchKeyValue = this.groupSearchKeyValue.substring(0, 8) + "...";
                    }
                }
                this.start_date_lastLoginTime = req.getParameter("start_date_lastLoginTime");
                this.end_date_lastLoginTime = req.getParameter("end_date_lastLoginTime");
            } else {
                this.start_date_lastLoginTime = "1970-01-01";
                this.end_date_lastLoginTime = this.currentDate;
                if (this.userPerPage == null) {
                    this.userPerPage = req.getParameter("userPerPage") == null ? UserManagementPluginCommonConstants.MO_NUMBER_OF_USER_PER_PAGE : Integer.valueOf(Integer.parseInt(req.getParameter("userPerPage")));
                }
                LOGGER.debug("user per page is:" + this.userPerPage);
                String groupSearchKeyURL = req.getParameter("selectedGroups");
                this.groupSearchKey = req.getParameterValues("groupSearchKey");
                if (this.groupSearchKey == null || this.groupSearchKey.length == 0) {
                    this.groupSearchList = new ArrayList<String>();
                    this.groupSearchKeyValue = "Group";
                } else if (groupSearchKeyURL != null && !groupSearchKeyURL.isEmpty()) {
                    String[] groupSearchKey = groupSearchKeyURL.replaceAll("[\\[\\]]", "").split(",");
                    ArrayList<String> groupSearchList = new ArrayList<String>(Arrays.asList(groupSearchKey));
                    groupSearchList.removeAll(Arrays.asList(null, ""));
                }
                this.startIndexOfPage = req.getParameter("startIndex");
                this.endIndexOfPage = req.getParameter("endIndex");
                this.lastLoginDate = Boolean.parseBoolean(req.getParameter("lastLoginDate"));
            }
            try {
                List list = this.directoryManager.findAllDirectories();
                LOGGER.debug("total directories: " + list.size());
                if (!list.isEmpty()) {
                    for (Directory x : list) {
                        this.directorySet.add(x.getName());
                    }
                }
                this.directories = new ArrayList<String>(this.directorySet);
                this.directories.add("All Directories");
            }
            catch (Exception e) {
                LOGGER.error("Directories were not found:" + e.getMessage());
            }
            this.numberOfRecordsPerPage = this.userPerPage;
            LOGGER.debug("No. of records per page: " + this.numberOfRecordsPerPage);
            if (StringUtils.isBlank((CharSequence)this.startIndexOfPage) && StringUtils.isBlank((CharSequence)this.endIndexOfPage)) {
                this.selectedPage = 1;
                this.startIndex = 0;
                this.endIndex = this.numberOfRecordsPerPage;
            } else {
                this.startIndex = Integer.parseInt(this.startIndexOfPage.replaceAll(",", ""));
                this.endIndex = Integer.parseInt(this.endIndexOfPage.replaceAll(",", ""));
                this.selectedPage = this.endIndex / this.userPerPage;
            }
            LOGGER.debug("selectedPage: " + this.selectedPage);
            if (StringUtils.isNotBlank((CharSequence)this.start_date_lastLoginTime)) {
                this.settings.setStart_date_lastLoginTime(this.start_date_lastLoginTime);
            } else {
                this.settings.setStart_date_lastLoginTime("1970-01-01");
            }
            if (StringUtils.isNotBlank((CharSequence)this.end_date_lastLoginTime)) {
                this.settings.setEnd_date_lastLoginTime(this.end_date_lastLoginTime);
            } else {
                this.settings.setEnd_date_lastLoginTime(this.currentDate);
            }
            LOGGER.debug("start date: " + this.start_date_lastLoginTime + " last date: " + this.end_date_lastLoginTime);
            String selectDirectory = req.getParameter("selectedDirectory");
            LOGGER.debug("select directory: " + selectDirectory);
            if (selectDirectory == null) {
                selectDirectory = "All Directories";
            }
            if (StringUtils.isNotBlank((CharSequence)selectDirectory)) {
                this.selectedDirectory = selectDirectory.trim();
            }
            boolean foundDirectory = false;
            Directory directory = null;
            try {
                if (!this.selectedDirectory.contains("All Directories") && this.selectedDirectory != "") {
                    directory = this.directoryManager.findDirectoryByName(this.selectedDirectory);
                }
                if (directory != null) {
                    foundDirectory = true;
                }
            }
            catch (Exception exp) {
                LOGGER.error("Directory was not found:" + exp.getMessage());
            }
            LOGGER.debug("selected directory is : " + this.selectedDirectory);
            LOGGER.debug("directory is: " + directory);
            this.userFilter = req.getParameter("userFilter");
            this.searchUser = req.getParameter("searchUser");
            this.loginBasedFilter = req.getParameter("loginBasedFilter");
            this.sortByLastLogin = this.settings.getSortByLastLogin();
            this.initialiseUserManagement();
            LOGGER.debug("userFilter: " + this.userFilter);
            switch (this.userFilter) {
                case "all": {
                    this.numberOfUsers = this.commonUserUtils.getTotalSearchResults(this.searchUser);
                    this.userTemplates = foundDirectory ? (this.groupSearchList.isEmpty() ? this.commonUserUtils.getAllUsersWithAllUserCase(this.searchUser, this.sortByLastLogin, foundDirectory, directory.getId(), this.start_date_lastLoginTime, this.end_date_lastLoginTime, this.startIndex, this.loginBasedFilter) : this.commonUserUtils.getAllUsersWithGroupsForAll(this.searchUser, this.sortByLastLogin, this.groupSearchList, foundDirectory, directory.getId(), this.start_date_lastLoginTime, this.end_date_lastLoginTime, this.startIndex, this.loginBasedFilter)) : (this.groupSearchList.isEmpty() ? this.commonUserUtils.getAllUsersWithAllUserCase(this.searchUser, this.sortByLastLogin, foundDirectory, 0L, this.start_date_lastLoginTime, this.end_date_lastLoginTime, this.startIndex, this.loginBasedFilter) : this.commonUserUtils.getAllUsersWithGroupsForAll(this.searchUser, this.sortByLastLogin, this.groupSearchList, foundDirectory, 0L, this.start_date_lastLoginTime, this.end_date_lastLoginTime, this.startIndex, this.loginBasedFilter));
                    if (this.userTemplates == null) {
                        this.totalUsers = 0;
                        break;
                    }
                    this.totalUsers = this.userTemplates.size();
                    break;
                }
                case "active": {
                    LOGGER.debug("Find Active Users");
                    this.numberOfUsers = this.commonUserUtils.getTotalSearchResults(this.searchUser, true);
                    if (foundDirectory) {
                        this.userTemplates = this.groupSearchList.isEmpty() ? this.commonUserUtils.getAllUsers(this.searchUser, this.sortByLastLogin, foundDirectory, directory.getId(), this.startIndex, true, true, this.start_date_lastLoginTime, this.end_date_lastLoginTime, this.loginBasedFilter) : this.commonUserUtils.getAllUsersWithGroups(this.searchUser, this.sortByLastLogin, this.groupSearchList, foundDirectory, directory.getId(), this.startIndex, true, true, this.start_date_lastLoginTime, this.end_date_lastLoginTime, this.loginBasedFilter);
                        this.totalUsers = this.userTemplates.size();
                        break;
                    }
                    this.userTemplates = this.groupSearchList.isEmpty() ? this.commonUserUtils.getAllUsers(this.searchUser, this.sortByLastLogin, foundDirectory, 0L, this.startIndex, true, true, this.start_date_lastLoginTime, this.end_date_lastLoginTime, this.loginBasedFilter) : this.commonUserUtils.getAllUsersWithGroups(this.searchUser, this.sortByLastLogin, this.groupSearchList, foundDirectory, 0L, this.startIndex, true, true, this.start_date_lastLoginTime, this.end_date_lastLoginTime, this.loginBasedFilter);
                    this.totalUsers = this.userTemplates.size();
                    break;
                }
                case "inactive": {
                    LOGGER.debug("Find Inactive users");
                    this.numberOfUsers = this.commonUserUtils.getTotalSearchResults(this.searchUser, false);
                    if (foundDirectory) {
                        this.userTemplates = this.groupSearchList.isEmpty() ? this.commonUserUtils.getAllUsers(this.searchUser, this.sortByLastLogin, foundDirectory, directory.getId(), this.startIndex, false, true, this.start_date_lastLoginTime, this.end_date_lastLoginTime, this.loginBasedFilter) : this.commonUserUtils.getAllUsersWithGroups(this.searchUser, this.sortByLastLogin, this.groupSearchList, foundDirectory, directory.getId(), this.startIndex, false, true, this.start_date_lastLoginTime, this.end_date_lastLoginTime, this.loginBasedFilter);
                        this.totalUsers = this.userTemplates.size();
                        break;
                    }
                    this.userTemplates = this.groupSearchList.isEmpty() ? this.commonUserUtils.getAllUsers(this.searchUser, this.sortByLastLogin, foundDirectory, 0L, this.startIndex, false, true, this.start_date_lastLoginTime, this.end_date_lastLoginTime, this.loginBasedFilter) : this.commonUserUtils.getAllUsersWithGroups(this.searchUser, this.sortByLastLogin, this.groupSearchList, foundDirectory, 0L, this.startIndex, false, true, this.start_date_lastLoginTime, this.end_date_lastLoginTime, this.loginBasedFilter);
                    this.totalUsers = this.userTemplates.size();
                    LOGGER.debug("total users are: " + this.totalUsers);
                }
            }
            LOGGER.debug("number of user is: " + this.userTemplates.size() + " startIndex is:" + this.startIndex + " end Index is:" + this.endIndex);
            this.currentPageUsersList = this.getSelectedUsersForPagination(this.userTemplates, this.startIndex, this.endIndex);
            LOGGER.debug("total number of users : " + this.totalUsers);
            LOGGER.debug("current page user list is: " + this.currentPageUsersList.size());
            this.format = new SimpleDateFormat(" dd/MMM/yyyy hh:mm aaa");
            this.numberOfPages = this.totalUsers / this.userPerPage;
            if (this.currentPageUsersList.isEmpty() && this.numberOfPages > 0) {
                LOGGER.debug("if list size is 0");
                this.startIndex -= this.userPerPage.intValue();
                this.endIndex = this.endIndex - this.userPerPage;
                this.currentPageUsersList = this.getSelectedUsersForPagination(this.userTemplates, this.startIndex, this.endIndex);
                LOGGER.debug("number of user is: " + this.userTemplates.size() + " startIndex is:" + this.startIndex + " end Index is:" + this.endIndex);
            }
            if (this.totalUsers > this.numberOfPages * this.userPerPage) {
                ++this.numberOfPages;
            }
            this.numberOfPagesList = this.getNumberOfPagesList();
            LOGGER.debug("Number Of pages/results:" + this.numberOfPages);
            this.lastLoginTime = this.getUsersLoginDetails(this.userTemplates, this.startIndex, this.endIndex);
            this.message = "";
            resp.setContentType("text/html;charset=utf-8");
            this.renderer.render(USER_MANAGEMENT_ACTION_PATH, this.initializeBUMConfig(), (Writer)resp.getWriter());
        } else {
            resp.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.commonUserUtils.getUri(req), UserRole.ADMIN).toASCIIString());
        }
    }

    public Boolean doValidate() {
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            return true;
        }
        return false;
    }

    public void initialiseUserManagement() {
        if (this.searchUser == null) {
            this.searchUser = "";
        }
        if (this.userFilter == null) {
            this.userFilter = "all";
        }
        if (this.selectedDirectory == null) {
            this.selectedDirectory = "All Directories";
        }
        if (this.groupSearchKeyValue == null) {
            this.groupSearchKeyValue = "Group";
        }
        if (this.loginBasedFilter == null) {
            this.loginBasedFilter = "bothUser";
        }
    }

    HashMap<String, Object> initializeBUMConfig() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", "");
        context.put("page", this.page);
        context.put("numberOfPages", this.numberOfPages);
        context.put("settings", this.settings);
        context.put("contextPath", this.settings.getBaseUrl());
        context.put("startIndex", this.startIndex);
        context.put("endIndex", this.endIndex);
        context.put("directoryManager", this.directoryManager);
        context.put("directories", this.directories);
        context.put("userPerPage", this.userPerPage);
        context.put("currentDate", this.currentDate);
        context.put("selectedPage", this.selectedPage);
        context.put("commonUserUtils", this.commonUserUtils);
        context.put("currentPageUsersList", this.currentPageUsersList);
        context.put("groupSearchKeyValue", this.groupSearchKeyValue);
        context.put("end_date_lastLoginTime", this.end_date_lastLoginTime);
        context.put("start_date_lastLoginTime", this.start_date_lastLoginTime);
        context.put("searchUser", this.searchUser);
        context.put("userFilter", this.userFilter);
        context.put("usersAndGroup", this.usersAndGroup);
        context.put("selectedDirectory", this.selectedDirectory);
        context.put("numberOfPagesList", this.numberOfPagesList);
        context.put("numberOfRecordsPerPage", this.numberOfRecordsPerPage);
        context.put("totalUsers", this.totalUsers);
        context.put("sortByLastLogin", this.sortByLastLogin);
        context.put("submitted", this.submitted);
        context.put("userTemplates", this.userTemplates);
        context.put("lastLoginDate", this.lastLoginDate);
        context.put("numberOfUsers", this.numberOfUsers);
        context.put("loginBasedFilter", this.loginBasedFilter);
        context.put("crowdGroups", this.commonUserUtils.getAllGroups());
        context.put("groupSearchList", this.groupSearchList);
        context.put("getUserDetails", this.lastLoginTime);
        context.put("userDirectoryNameMap", this.userDirectoryNameMap);
        context.put("remainingLicenseDays", this.commonUserUtils.getRemainingLicenseDays());
        return context;
    }

    public List<UserTemplate> getSelectedUsersForPagination(List<UserTemplate> selectedUsers, Integer startIndex, Integer endIndex) {
        LOGGER.debug("Retrieving users between start index {} and end index {}", (Object)startIndex, (Object)endIndex);
        ArrayList<UserTemplate> selectedUserPagination = new ArrayList<UserTemplate>();
        ArrayList<String> usernames = new ArrayList<String>();
        int lastIndex = selectedUsers.size() - 1;
        endIndex = Math.min(endIndex, selectedUsers.size());
        for (int i = startIndex.intValue(); i < endIndex; ++i) {
            UserTemplate user = selectedUsers.get(i);
            if (usernames.contains(user.getName())) continue;
            selectedUserPagination.add(user);
            usernames.add(user.getName());
            List<Object> groups = new ArrayList();
            MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(Integer.MAX_VALUE);
            Iterable groupIterable = this.crowdService.search((Query)query);
            groups = StreamSupport.stream(groupIterable.spliterator(), false).map(Group::getName).collect(Collectors.toList());
            this.usersAndGroup.put(selectedUsers.get(i).getName(), groups);
        }
        return selectedUserPagination;
    }

    public List<String> getNumberOfPagesList() {
        LOGGER.debug("getNumberOfPagesList ....");
        this.numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfPages; ++i) {
            this.numberOfPagesList.add("" + i);
        }
        return this.numberOfPagesList;
    }

    public Map<String, String> getUsersLoginDetails(List<UserTemplate> usersList, int startIndex, int endIndex) {
        endIndex = Math.min(endIndex, usersList.size());
        List<UserTemplate> subList = usersList.subList(startIndex, endIndex);
        this.userDirectoryNameMap = new ConcurrentHashMap<String, String>();
        ConcurrentHashMap<String, String> result = new ConcurrentHashMap<String, String>();
        subList.parallelStream().forEach(user -> {
            String username = user.getName();
            result.computeIfAbsent(username, key -> {
                long dirId = user.getDirectoryId();
                String directoryName = "Unknown";
                try {
                    Directory dir = this.directoryManager.findDirectoryById(dirId);
                    directoryName = dir.getName();
                }
                catch (DirectoryNotFoundException e) {
                    LOGGER.error("Directory not found for ID: " + dirId, (Throwable)e);
                }
                this.userDirectoryNameMap.put(username, directoryName);
                Date lastLoginDate = CommonUserUtils.getLastActivationDate(username, dirId);
                return lastLoginDate != null ? lastLoginDate.toString() : "Never Logged In";
            });
        });
        return result;
    }
}

