AJS.$(function(){

    var helpButton = document.getElementById("Help_Button");
    var sticky = helpButton.offsetTop;
    helpButton.classList.add("sticky");

    deactivateDays("${limitDays}");
    deactivateDaysForNeverLoggedUsers("${limitDaysForNeverLoggedUsers}");
    // deactivateActivateDays("${dndPeriod}");
    beforeDeactivation("${mailPeriod}");
    // reActivateUserChecked();
    // addGroupsChecked();
    // addGroupsToActiveUsers();
    toggleDaysInputVisibility();
    mailNotificaionChnage();
    var selectedAction = document.getElementById("actionOnUser");
    disableLimitDays(selectedAction.value);
    disableElements(selectedAction.value);
    selectedAction.addEventListener("change", function() {
        console.log("selected action is: "+selectedAction.value)
        var selectedOption = selectedAction.value;
        disableElements(selectedOption);
    });

    AJS.$("#refreshInterval").change(function () {
        var value = AJS.$("#refreshInterval").val();
        if (value == "custom") {
            AJS.$("#customRefreshValue").show();
            AJS.$("#customRefreshInterval").prop("required", true);
        } else {
            AJS.$("#customRefreshValue").hide();
            AJS.$("#customRefreshInterval").prop("required", false);
        }
    });

    AJS.$("#test-regex").click(function () {
        testregexConfigurations();
    });
});

function testregexConfigurations() {
    console.log("regex function is called after click");
    var osDestination = "regexTestingExcludeGroups";
    var regexUrl = AJS.contextPath() + '/plugins/servlet/usermanagement/moapi';
    regexUrl += "?action=" + encodeURIComponent(osDestination) +
        "&regexp=" + encodeURIComponent(AJS.$("#regexPatternForExcludeGroups").val()) +
        "&groupName="+ encodeURIComponent(AJS.$("#groupToTestRegex").val());
    var myWindow = window.open(regexUrl, "TEST Regex Configuration", "scrollbars=1 width=600, height=400");
}
function toggleDaysInputVisibility() {
    var toggle = document.getElementById('neverLoggedinUsers');
    var daysInputDiv = document.getElementById('limitDaysForNeverLoggedUsersDiv');
    var daysInput = document.getElementById('limitDaysForNeverLoggedUsers');

    if (toggle.checked) {
        daysInputDiv.style.display = 'block';
    } else {
        daysInputDiv.style.display = 'none';
        daysInput.value = '30';
    }
}

function mailNotificaionChnage() {
    var isChecked = document.getElementById("mailNotification").checked;
    console.log("isChecked: "+isChecked);

    if (isChecked){
        document.getElementById("mailtextdesc").style.display = "block";
        document.getElementById("mailsubject").style.display = "block";
        document.getElementById("mailsubjectlabel").style.display = "block";
        document.getElementById("mailtext").style.display = "block";
        document.getElementById("mailtextlabel").style.display = "block";
        document.getElementById("mailPeriodLabel").style.display = "block";
        document.getElementById("mailPeriod").style.display = "inline-block";
        document.getElementById("des_mail").style.display = "block";
        document.getElementById("mailPeriodDays").style.display = "inline-block";
        var elements = document.getElementsByClassName("spacing");
        for(var i=0; i<elements.length ; i++)
        {
            elements[i].style.display = "block";
        }

    }
    else {
        document.getElementById("mailtextdesc").style.display = "none";
        document.getElementById("mailtext").style.display = "none";
        document.getElementById("mailtextlabel").style.display = "none";
        document.getElementById("mailsubject").style.display = "none";
        document.getElementById("mailsubjectlabel").style.display = "none";
        document.getElementById("mailPeriodLabel").style.display = "none";
        document.getElementById("mailPeriod").style.display = "none";
        document.getElementById("des_mail").style.display = "none";
        document.getElementById("mailPeriodDays").style.display = "none";
        var elements = document.getElementsByClassName("spacing");
        for(var i=0; i<elements.length ; i++)
        {
            elements[i].style.display = "none";
        }
    }
}

function disableElements(element){
    disableLimitDays(element);
    if(element==="none"){
        document.getElementById("neverLoggedinUsers-label").style.display = "block";
        document.getElementById("neverLoggedinUsers").style.display = "block";
        document.getElementById("mailNotification").style.display = "block";
        document.getElementById("mailNotification-desc").style.display = "block";
        document.getElementById("mailNotification-label").style.display = "block";
        document.getElementById("deactivationLineBreak").style.display = "block";
        document.getElementById("mailNotificationLineBreak").style.display = "block";
        $('#neverLoggedinUsers').prop('checked', false);
        document.getElementById("neverLoggedinUsers").disabled = true;
        $('#mailNotification').prop('checked', false);
        document.getElementById("mailNotification").disabled = true;
        mailNotificaionChnage();
        document.getElementById("limitDays").disabled = true;
        document.getElementById("excludeUsers").disabled = true;
        //  document.getElementById("dndPeriod").disabled = true;
        AJS.$("#groupSearch").hide();
        AJS.$("#groupSearchDiv").hide();
    }else if(element ==="autoDeactivateUser"){
        $('#neverLoggedinUsers-label').html("Auto-Deactivate Never Logged-In Users ");
        document.getElementById("neverLoggedinUsers-label").style.display = "block";
        document.getElementById("neverLoggedinUsers").style.display = "block";
        document.getElementById("mailNotification").style.display = "block";
        document.getElementById("mailNotification-desc").style.display = "block";
        document.getElementById("mailNotification-label").style.display = "block";
        document.getElementById("deactivationLineBreak").style.display = "block";
        document.getElementById("mailNotificationLineBreak").style.display = "block";
        document.getElementById("neverLoggedinUsers").disabled = false;
        document.getElementById("mailNotification").disabled = false;
        document.getElementById("limitDays").disabled = false;
        document.getElementById("excludeUsers").disabled = false;
        document.getElementById("excludeGroups").disabled = false;
        //  document.getElementById("dndPeriod").disabled = false;
        AJS.$("#groupSearch").hide();
        AJS.$("#groupSearchDiv").hide();
    }else if(element ==="removeGroupsFromUsers"){
        $('#neverLoggedinUsers-label').html("Remove Groups From Never-Logged-In Users");
        //$('#neverLoggedinUsers').prop('checked', false);
        document.getElementById("neverLoggedinUsers").disabled = false;
        $('#mailNotification').prop('checked', false);
        document.getElementById("mailNotification").disabled = true;
        mailNotificaionChnage();
        document.getElementById("neverLoggedinUsers-label").style.display = "block";
        document.getElementById("neverLoggedinUsers").style.display = "block";
        document.getElementById("mailNotification").style.display = "none";
        document.getElementById("mailNotification-desc").style.display = "none";
        document.getElementById("mailNotification-label").style.display = "none";
        document.getElementById("deactivationLineBreak").style.display = "none";
        document.getElementById("mailNotificationLineBreak").style.display = "none";
        document.getElementById("excludeUsers").disabled = false;
        document.getElementById("limitDays").disabled = false;
        document.getElementById("limitDaysForNeverLoggedUsers").disabled = false;
        //   document.getElementById("dndPeriod").disabled = false;
        AJS.$("#groupSearch").show();
        AJS.$("#groupSearchDiv").show();
    }else{
        $('#neverLoggedinUsers-label').html(" Auto-Deactivate & Remove Groups From Never-Logged-In Users ");
        document.getElementById("neverLoggedinUsers-label").style.display = "block";
        document.getElementById("neverLoggedinUsers").style.display = "block";
        document.getElementById("mailNotification").style.display = "block";
        document.getElementById("mailNotification-desc").style.display = "block";
        document.getElementById("mailNotification-label").style.display = "block";
        document.getElementById("deactivationLineBreak").style.display = "block";
        document.getElementById("mailNotificationLineBreak").style.display = "block";
        document.getElementById("neverLoggedinUsers").disabled = false;
        document.getElementById("mailNotification").disabled = false;
        document.getElementById("limitDays").disabled = false;
        document.getElementById("excludeUsers").disabled = false;
        document.getElementById("limitDaysForNeverLoggedUsers").disabled = false;
        //   document.getElementById("dndPeriod").disabled = false;
        AJS.$("#groupSearch").show();
        AJS.$("#groupSearchDiv").show();
    }
}
function disableLimitDays(element){
    if(element==="none"){
        document.getElementById("neverLoggedinUsers").disabled = true;
        document.getElementById("mailNotification").disabled = true;
        document.getElementById("limitDays").disabled = true;
        document.getElementById("excludeUsers").disabled = true;
        document.getElementById("excludeGroups").disabled = true;
        document.getElementById("refreshInterval").disabled = true;
        AJS.$("#groupSearch").hide();
        AJS.$("#groupSearchDiv").hide();
        AJS.$("#customRefreshValue").hide();
        AJS.$("#customRefreshInterval").prop("required", false);
    }else{
        document.getElementById("neverLoggedinUsers").disabled = false;
        document.getElementById("mailNotification").disabled = false;
        document.getElementById("limitDays").disabled = false;
        document.getElementById("excludeUsers").disabled = false;
        document.getElementById("excludeGroups").disabled = false;
        document.getElementById("refreshInterval").disabled = false;
        if (AJS.$("#refreshInterval").val() === "custom") {
            AJS.$("#customRefreshValue").show();
            AJS.$("#customRefreshInterval").prop("required", true);
        } else {
            AJS.$("#customRefreshValue").hide();
            AJS.$("#customRefreshInterval").prop("required", false);
        }
    }
}


function deactivateDays(val) {
    document.getElementById("limit_numberofdays").innerHTML = val;
}
function deactivateDaysForNeverLoggedUsers(val) {
    document.getElementById("limit_numberofdays_forNeverLoggedUsers").innerHTML = val;
}

function deactivateActivateDays(val) {
    document.getElementById("dndDays").innerHTML = val;
}
function beforeDeactivation(val) {
    document.getElementById("day_before").innerHTML = val;
}

function isRegexEnabled() {
    console.log("inside isRegexEnbaled Function");
    if (AJS.$("#enableRegexForGroupsToRemove").is(":checked")) {
        AJS.$("#regexfield").show();
    }else {
        AJS.$("#regexfield").hide();
    }
}

function actionOnUser(){
    var selectedAction = document.getElementById("actionOnUser");
    var selectedOption = selectedAction.value;
    disableElements(selectedOption);
}

// function reActivateUserChecked(){
//     if (document.getElementById("reActivateUser").checked){
//         document.getElementById("addGroupsToReactiveUser").disabled = false;
//     }
//     else{
//         AJS.$("#addGroupDiv").hide();
//         document.getElementById("addGroupsToReactiveUser").disabled = true;
//         document.getElementById("addGroupsToReactiveUser").checked = false;
//     }
//
//     AJS.$("#reActivateUser").change(function () {
//         if (this.checked) {
//             document.getElementById("addGroupsToReactiveUser").disabled = false;
//         } else {
//             AJS.$("#addGroupDiv").hide();
//             document.getElementById("addGroupsToReactiveUser").disabled = true;
//             document.getElementById("addGroupsToReactiveUser").checked = false;
//         }
//     });
// }
//
// function addGroupsChecked(){
//     if (document.getElementById("addGroupsToReactiveUser").checked) {
//         AJS.$("#addGroupDiv").show();
//     } else {
//         AJS.$("#addGroupDiv").hide();
//     }
//
//     AJS.$("#addGroupsToReactiveUser").change(function () {
//         if (this.checked) {
//             AJS.$("#addGroupDiv").show();
//         } else {
//             AJS.$("#addGroupDiv").hide();
//         }
//     });
// }
// function addGroupsToActiveUsers(){
//     if (document.getElementById("addGroupsToActiveUser").checked) {
//         AJS.$("#addGroupsToActiveUser-div").show();
//     } else {
//         AJS.$("#addGroupsToActiveUser-div").hide();
//     }
//     AJS.$("#addGroupsToActiveUser").change(function () {
//         if (this.checked) {
//             AJS.$("#addGroupsToActiveUser-div").show();
//         } else {
//             AJS.$("#addGroupsToActiveUser-div").hide();
//         }
//     });
// }



AJS.$(document).on('change',"#enableRegexForGroupsToRemove",function(){
    console.log("inside isRegexEnable AJS Call");
    if (this.checked) {
        AJS.$("#enableRegexPatternToExcludeGroups").show();
    } else {
        AJS.$("#enableRegexPatternToExcludeGroups").hide();
    }
});

AJS.$(document).on('click', '#submit', function(event) {
    var excludeGroups = AJS.$("#excludeGroups").val();

    if (!excludeGroups || excludeGroups.length === 0) {
        event.preventDefault();
        AJS.$("#showExcludeGroupWarning").show();
    } else {
        AJS.$("#showExcludeGroupWarning").hide();
    }
});


function validateForm() {
    let isValid = true;
    const errors = [];

    // Validate action selection
    const actionOnUser = AJS.$("#actionOnUser").val();
    if (!actionOnUser) {
        errors.push("Please select an action");
        isValid = false;
    }


    const limitDays = AJS.$("#limitDays").val();
    if (!limitDays || limitDays < 1) {
        errors.push("Days must be at least 1");
        isValid = false;
    }

    const neverLoggedinUsersChecked = document.getElementById("neverLoggedinUsers").checked;
    if (neverLoggedinUsersChecked) {
        const limitDaysForNeverLoggedUsers = AJS.$("#limitDaysForNeverLoggedUsers").val();
        if (!limitDaysForNeverLoggedUsers || limitDaysForNeverLoggedUsers < 1) {
            errors.push("Days for never logged in users must be at least 1");
            isValid = false;
        }
    }

    if (actionOnUser === "removeGroupsFromUsers" || actionOnUser === "removeGroupsAndAutoDeactivate") {
        const enableRegex = AJS.$("#enableRegexForGroupsToRemove").is(":checked");
        if (enableRegex) {
            if (!validateRegex()) {
                isValid = false; // validateRegex already shows error messages
            }
        } else {
            const removeGroups = AJS.$("#groupSearchKey").val();
            if (!removeGroups || removeGroups.length === 0) {
                errors.push("Please select at least 1 group to be removed");
                isValid = false;
            }
        }
    }

    const excludeGroups = AJS.$("#excludeGroups").val();
    if (!excludeGroups || !excludeGroups.includes("crowd-administrators")) {
        errors.push("Crowd-Administrators group must be in exclude groups");
        isValid = false;
    }

    // Validate mail notification settings
    if (AJS.$("#mailNotification").is(":checked")) {
        const mailPeriod = parseInt(AJS.$("#mailPeriod").val(), 10) || 0;
        const mailSubject = AJS.$("#mailsubject").val()?.trim();
        const mailText = AJS.$("#mailtext").val()?.trim();

        if (isNaN(mailPeriod) || mailPeriod < 1) {
            errors.push("Mail period must be at least 1 day");
            isValid = false;
        }

        if (!mailSubject || mailSubject.length === 0) {
            errors.push("Email subject cannot be empty");
            isValid = false;
        }

        if (!mailText || mailText.length === 0) {
            errors.push("Email template cannot be empty");
            isValid = false;
        }
    }

    if (!isValid) {
        const errorHtml = errors.map(error => `<p>${error}</p>`).join('');
        AJS.flag({
            type: 'error',
            title: 'Validation Error',
            body: errorHtml,
            close: 'auto'
        });
    }

    return isValid;
}

AJS.$(document).on('submit', '#list-app-form', function(event) {
    if (!validateForm()) {
        event.preventDefault();
        return false;
    }

    AJS.flag({
        type: 'success',
        title: 'Success',
        body: 'Settings saved successfully',
        close: 'auto'
    });
    return true;
});

// Add custom regex validation
function validateRegex() {
    const regexPattern = AJS.$("#regexPatternForExcludeGroups").val();
    if (!regexPattern) {
        AJS.flag({
            type: 'error',
            title: 'Error',
            body: 'Regular expression pattern is required',
            close: 'auto'
        });
        return false;
    }

    try {
        new RegExp(regexPattern);
        return true;
    } catch (e) {
        AJS.flag({
            type: 'error',
            title: 'Invalid Regular Expression',
            body: 'Please enter a valid regular expression pattern',
            close: 'auto'
        });
        return false;
    }
}


AJS.$("#test-regex").click(function(e) {
    if (!validateRegex()) {
        e.preventDefault();
        return false;
    }
    testregexConfigurations();
});

AJS.$(document).ready(function() {

    const excludeGroups = AJS.$("#excludeGroups");
    if (!excludeGroups.val()?.includes("crowd-administrators")) {
        const currentSelection = excludeGroups.val() || [];
        excludeGroups.val([...currentSelection, "crowd-administrators"]).trigger('change');
    }

    if ( window.history.replaceState ) {
        window.history.replaceState( null, null, window.location.href );
    }
});

