AJS.$(function () {

    var helpButton = document.getElementById("Help_Button");
    var sticky = helpButton.offsetTop;
    helpButton.classList.add("sticky");

    AJS.$("#downloadSampleGroupsCSV").on("click", function (e) {
        e.preventDefault();
        var location = window.location.href;
        var fst = location.split("/crowd-bulkgroupmanagement")[0];
        var next ="/downloadsample?csvtype=sample&groupcsv=true";
        window.location.href = fst + next;

    })
    AJS.$(document).on('click', '#reset-filters-button', function() {
        resetFilters();
    });
});

function validateFileUpload() {
    if (AJS.$("#csvFile").val() == '') {
        // your validation error action
        return false;
    }
    return true;
}

function IsLicenseValid() {
    console.log("inside is license valid check");
    var licenseValid = true;
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
        data: {
            "action": "CheckEvalLicense"
        },
        type: "GET",
        async: false,
        error: function (response) {
            if (response.responseText == "Error_User_eval_License") {
                licenseValid = false;
                require('aui/flag')({
                    title: 'Exceeded Crowd User Limit',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Please upgrade the license</p>'
                });
            }
        }
    });
    return licenseValid;
}

function importLoadingFlag() {
    var licenseValid = IsLicenseValid();
    console.log("is license valid: " + licenseValid);
    if (licenseValid) {
        if (validateFileUpload()) {
            console.log("started importing");
            require('aui/flag')({
                title: 'Importing Groups',
                type: 'info',
                close: 'never',
                body: '<p><aui-spinner size="large"></aui-spinner></p>'
            });
            setTimeout(() => {
                require('aui/flag')({
                    title: 'Import Successful',
                    type: 'success',
                    close: 'auto',
                    body: '<p>Groups have been imported successfully.</p>'
                });
            }, 5000);
        }
        else {
            event.preventDefault();
            console.log("No file uploaded");
            require('aui/flag')({
                title: 'Error: No File Uploaded',
                type: 'error',
                close: 'auto',
                body: '<p>Please upload a CSV file to import groups.</p>'
            });
        }
    } else {
        console.log("License is not valid");
    }
}

function performActionChange(selectedAction) {
    console.log("Calling performActionChange For : " + selectedAction);
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
        timeout: 0,
        data: {
            "action": "ChangeGroupManagementSelectedAction",
            "selectedAction": selectedAction
        },
        type: "GET",
        success: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        error: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        async: true
    });
}

function performCreationActionChange(selectedAction) {
    console.log("Calling performCreationActionChange For : " + selectedAction);
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
        timeout: 0,
        data: {
            "action": "changeGroupManagementCreationSelectedAction",
            "CreationSelectedAction": selectedAction
        },
        type: "GET",
        success: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        error: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        async: true
    });
}

function performBulkGroupAction() {
    var licenseValid = IsLicenseValid();
    if (!licenseValid) return;

    var groupsToAdd = AJS.$('#groupsToCreate').val().trim();
    var selectedDirectory = AJS.$('#selectedDirectory').val();

    if (!groupsToAdd) {
        require('aui/flag')({
            title: 'Provide Groups Name',
            type: 'error',
            close: 'auto',
            body: '<p>Please enter group names</p>'
        });
        return;
    }

    if (selectedDirectory == "directoryNotSelected") {
        require('aui/flag')({
            title: 'Directory Not selected',
            type: 'error',
            close: 'auto',
            body: '<p>Please Select the Directory to perform the Action </p>'
        });
        return;
    }

    if (groupsToAdd.includes(",")) {
        require('aui/flag')({
            title: 'Invalid Separator',
            type: 'error',
            close: 'auto',
            body: '<p>Group names must be separated by a semicolon (;). Commas (,) are not allowed.</p>'
        });
        return;
    }

    const loadingFlag = require('aui/flag')({
        title: 'Creating Groups',
        type: 'info',
        close: 'never',
        body: '<p><aui-spinner size="large"></aui-spinner> Creating groups, please wait...</p>'
    });

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
        data: {
            "action": "bulkCreationGroup",
            "groupsToAdd": groupsToAdd,
            "selectedDirectory": selectedDirectory
        },
        type: "GET",
        success: function(response) {
            loadingFlag.close();
            var userClicked = false;

            var successFlag = AJS.flag({
                title: 'Groups Created',
                type: 'info',
                close: 'auto',
                body: '<p>Groups have been processed. <a href="#" id="view-creation-details">Click here</a> to view the details.</p>'
            });

            AJS.$("#view-creation-details").data('flagInstance', successFlag);
            AJS.$("#view-creation-details").data('groupResults', prepareGroupResults(groupsToAdd, response));

            AJS.$("#view-creation-details").on('click', function(event) {
                event.preventDefault();
                userClicked = true;
                var flag = AJS.$(this).data('flagInstance');
                openGroupActionDialog(flag, AJS.$(this).data('groupResults'));
            });

            setTimeout(function() {
                if (!userClicked) {
                    location.reload();
                }
            }, 5000);
        },
        error: function(response) {
            loadingFlag.close();
            if (response.responseText === "Trial_limit_exceeded") {
                require('aui/flag')({
                    title: 'Trial Limit Exceeded',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Please upgrade the license</p>'
                });
            }
            setTimeout(() => location.reload(), 5000);
        }
    });
}


function PerformBulkGroupDeletionAction(groups) {
    console.log("PerformBulkGroupDeletionAction called with groups:", groups);
    var licenseValid = IsLicenseValid();
    if (!licenseValid) return;

    const loadingFlag = require('aui/flag')({
        title: 'Deleting Groups',
        type: 'info',
        close: 'never',
        body: '<p><aui-spinner size="large"></aui-spinner> Deleting groups, please wait...</p>'
    });

    var selectedDirectory = document.getElementById("deleteFromDirectory").value;
    var groupsArray = typeof groups === 'string' ? groups.split(',') : groups;

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
        data: {
            "action": "BulkDeletionGroup",
            "groupsToDelete": groupsArray.join(','),
            "selectedDirectory": selectedDirectory
        },
        type: "GET",
        success: function(response) {
            loadingFlag.close();
            document.getElementById("spin").style.display = "none";
            var userClicked = false;
            console.log("Response Text:", response.responseText || "Empty response");

            var results = prepareGroupDeletionResults(groupsArray, response);
            var successCount = results.filter(r => r.status === 'Success').length;
            var failureCount = results.filter(r => r.status === 'Failure').length;
            var summaryMessage = successCount > 0 ? `${successCount} groups processed successfully` : 'No groups were deleted';
            if (failureCount > 0) {
                summaryMessage += `, ${failureCount} groups could not be confirmed`;
            }

            var successFlag = require('aui/flag')({
                title: 'Groups Deletion Attempted',
                type: 'info',
                close: 'auto',
                body: '<p>' + summaryMessage + '. <a href="#" id="view-deletion-details">Click here</a> to view the details.</p>'
            });

            AJS.$("#view-deletion-details").data('flagInstance', successFlag);
            AJS.$("#view-deletion-details").data('groupResults', results);

            AJS.$("#view-deletion-details").on('click', function(event) {
                event.preventDefault();
                userClicked = true;
                var flag = AJS.$(this).data('flagInstance');
                openGroupActionDialog(flag, AJS.$(this).data('groupResults'), 'deletion');
            });

            setTimeout(function() {
                if (!userClicked) {
                    location.reload();
                }
            }, 5000);
        },
        error: function(response) {
            loadingFlag.close();
            document.getElementById("spin").style.display = "none";
            var errorMessage = 'Error deleting groups';
            var results = [];

            switch(response.responseText) {
                case "Error_User_Is_Admin":
                    errorMessage = 'Cannot delete Administrator groups';
                    results = groupsArray.map((group, index) => ({
                        srNo: index + 1,
                        groupName: group,
                        status: 'Failure',
                        message: errorMessage
                    }));
                    break;
                case "Error_Admin_Privilege":
                    errorMessage = 'You do not have administrator privileges';
                    results = groupsArray.map((group, index) => ({
                        srNo: index + 1,
                        groupName: group,
                        status: 'Failure',
                        message: errorMessage
                    }));
                    break;
                case "Trial_limit_exceeded":
                    errorMessage = 'Please upgrade the license';
                    results = groupsArray.map((group, index) => ({
                        srNo: index + 1,
                        groupName: group,
                        status: 'Failure',
                        message: errorMessage
                    }));
                    break;
                default:
                    errorMessage = 'An unknown error occurred';
                    results = groupsArray.map((group, index) => ({
                        srNo: index + 1,
                        groupName: group,
                        status: 'Failure',
                        message: errorMessage
                    }));
            }

            var errorFlag = require('aui/flag')({
                title: 'Error',
                type: 'error',
                close: 'auto',
                body: '<p>' + errorMessage + '. <a href="#" id="view-deletion-details">Click here</a> to view the details.</p>'
            });

            AJS.$("#view-deletion-details").data('flagInstance', errorFlag);
            AJS.$("#view-deletion-details").data('groupResults', results);

            AJS.$("#view-deletion-details").on('click', function(event) {
                event.preventDefault();
                var flag = AJS.$(this).data('flagInstance');
                openGroupActionDialog(flag, AJS.$(this).data('groupResults'), 'deletion');
            });

            setTimeout(() => location.reload(), 5000);
        }
    });
}


function prepareGroupResults(groupsToAdd, response) {
    console.log("Response:" + response);
    var groups = [...new Set(groupsToAdd.split(';').map(g => g.trim()))];

    var results = [];
    console.log("Responses:" + response.groupsCreated);
    var createdGroups = response.groupsCreated || [];
    var existingGroups = response.groupsAlreadyExist || [];

    groups.forEach((group, index) => {
        var result = {
            srNo: index + 1,
            groupName: group,
            status: createdGroups.includes(group) ? 'Success' : 'Failure',
            message: createdGroups.includes(group)
                ? 'Group created successfully'
                : existingGroups.includes(group)
                    ? 'Group already exists'
                    : 'Failed to create group'
        };
        results.push(result);
    });

    return results;
}


function prepareGroupDeletionResults(groups, response) {
    console.log('Preparing deletion results for groups:', groups);
    console.log('Response received:', response);

    var uniqueGroups = [...new Set(groups.map(g => g.trim()))];
    console.log('Unique groups after deduplication:', uniqueGroups);

    var results = [];
    var isResponseEmpty = !response.responseText || response.responseText === '';

    uniqueGroups.forEach((group, index) => {
        var result = {
            srNo: index + 1,
            groupName: group,
            status: isResponseEmpty && !group.includes("crowd-administrators") ? 'Success' : 'Failure',
            message: isResponseEmpty && !group.includes("crowd-administrators")
                ? 'Group deleted successfully'
                : group.includes("crowd-administrators")
                    ? 'Cannot delete administrator group'
                    : 'Deletion status unknown (server provided no details)'
        };
        results.push(result);
    });

    return results;
}

AJS.$(document).ready(function () {
    window.onbeforeunload = null;
});

function pageRedirection(groupSearchKeyword, StartIndex, EndIndex, deleteFromDirectory) {
    console.log("pageRedirection of groups")
    var endIndex = parseInt(document.getElementById("endIndex").value, 10);
    var startIndex = parseInt(document.getElementById("startIndex").value, 10);
    var groupPerPage = parseInt(document.getElementById("groupPerPage").value, 10);
    var currentGroupPerPage = parseInt(document.getElementById("currentGroupPerPage").value, 10);
    var groupPerPageurl = parseInt(document.getElementById("groupPerPage").value, 10);

    if (groupSearchKeyword == 0) {
        groupSearchKeyword = "";
    }
    location.replace("groupmanagement?startIndex=" + StartIndex + "&endIndex=" + EndIndex + "&groupPerPageurl=" + groupPerPage + "&groupSearchKeywordUrl=" + groupSearchKeyword + "&selectedDirectoryInUrl=" + deleteFromDirectory + "&groupPerPageurl=" + groupPerPageurl)
}

function toggleAllGroups() {
    var isChecked = document.getElementById("selectAllGroups").checked;
    var startIndex = document.getElementById("startIndex").value;
    var endIndex = document.getElementById("endIndex").value;

    for (var i = startIndex; i < endIndex; i++) {
        document.getElementById("selectedGroup" + i).checked = isChecked;
    }
}

function performBulkGroupDeletion() {
    var action = document.getElementById("bulkdeleteAction");
    if (action.value == "Action") {
        document.getElementById("bulkdeleteAction").style.borderColor = "red";
        var dialog = new AJS.Dialog({
            width: 400,
            height: 150,
            id: "delete-dialog",
            closeOnOutsideClick: true
        });
        dialog.addPanel("Panel 1", "<p> Please select valid Bulk Action. <b> </b></p>", "panel-body");
        dialog.addLink("Retry", function (dialog) {
            dialog.hide();
        }, "#");

        dialog.show();
    } else {
        document.getElementById("bulkdeleteAction").style.borderColor = "";
        var startIndex = parseInt(document.getElementById("startIndex").value);
        var endIndex = parseInt(document.getElementById("endIndex").value);
        var licenseValid = IsLicenseValid();

        if (licenseValid) {
            switch (action.value) {
                case "DeleteSelectedGroup":
                    var dialog = new AJS.Dialog({
                        width: 400,
                        height: 150,
                        id: "delete-dialog",
                        closeOnOutsideClick: true
                    });
                    dialog.addPanel("Panel 1", "<p>Are you sure you want to delete the selected groups?</p>", "panel-body");
                    dialog.addButton("Yes", function (dialog) {
                        var selectedGroups = [];
                        for (var i = startIndex; i < endIndex; i++) {
                            var checkbox = document.getElementById("selectedGroup" + i);
                            if (checkbox && checkbox.checked) {
                                selectedGroups.push(checkbox.value);
                            }
                        }

                        if (selectedGroups.length > 0) {
                            document.getElementById("spin").style.display = "block";
                            PerformBulkGroupDeletionAction(selectedGroups);
                        } else {
                            noGroupSelectedErrorMsg(false);
                        }
                        dialog.hide();
                    });
                    dialog.addLink("No", function (dialog) {
                        dialog.hide();
                    }, "#");

                    dialog.show();
                    break;
            }
        }
    }
}

function noGroupSelectedErrorMsg(isCustomerSelected) {
    if (!isCustomerSelected) {
        require('aui/flag')({
            title: 'Group Not selected',
            type: 'error',
            close: 'auto',
            body: '<p>Please Select the Group to perform the Action </p>'
        });
    }
}

// AJS.$(document).on('click', '#exportGroup', function (e) {
//     e.preventDefault();
//     var licenseValid = IsLicenseValid();
//     if (licenseValid) {
//         window.location.href = AJS.contextPath() + "/plugins/servlet/usermanagement/moapi?action=exportGroupsCsv";
//     }
// });

function downloaddirectgroupfile(){
    var licenseValid = IsLicenseValid();
    if (licenseValid) {
        window.location.href = AJS.contextPath() + "/plugins/servlet/usermanagement/moapi?action=exportGroupsCsv";
        require('aui/flag')({
            title: 'Export Successful',
            type: 'success',
            close: 'auto',
            body: '<p>Groups have been exported successfully.</p>'
        });
    }
}

function resetFilters() {
    if (document.getElementById("spin") !== null) {
        document.getElementById("spin").style.display = "block";
    }
    if (document.getElementById("groupSearchKeyword") !== null) {
        document.getElementById("groupSearchKeyword").value = "";
    }
    if (document.getElementById("selectedDirectory") !== null) {
        document.getElementById("selectedDirectory").value = "All Directories";
    }
    window.location.href = AJS.contextPath() + "/plugins/servlet/usermanagement/groupmanagement";
}

function LoadingFlag(){
    document.getElementById("spin").style.display="block";
}


function openGroupActionDialog(flag, results) {
    flag.close();
    if (!AJS.$("#group-action-dialog").length) {
        AJS.$('body').append(`
            <section id="group-action-dialog" class="aui-dialog2 aui-dialog2-medium aui-layer" role="dialog" aria-hidden="true">
                <header class="aui-dialog2-header">
                    <h2 class="aui-dialog2-header-main">Groups Status</h2>
                </header>
                <div class="aui-dialog2-content">
                    <table class="aui">
                        <thead>
                            <tr>
                                <th style="text-align: center;">Sr. No.</th>
                                <th style="text-align: center;">Group Name</th>
                                <th style="text-align: center;">Status</th>
                                <th style="text-align: center;">Message</th>
                            </tr>
                        </thead>
                        <tbody id="group-action-details">
                        </tbody>
                    </table>
                </div>
                <footer class="aui-dialog2-footer">
                    <div class="aui-dialog2-footer-actions">
                        <button id="dialog-close-button" class="aui-button aui-button-primary" onclick="closeGroupDialog()">Close</button>
                    </div>
                </footer>
            </section>
        `);
    }

    var tableBody = AJS.$("#group-action-details");
    tableBody.empty();

    results.forEach(function(result) {
        var row = AJS.$('<tr>');
        row.append(AJS.$('<td>').css('text-align', 'center').text(result.srNo));
        row.append(AJS.$('<td>').css('text-align', 'center').text(result.groupName));
        row.append(AJS.$('<td>').css({
            'text-align': 'center',
            'color': result.status === 'Success' ? 'green' : 'red'
        }).text(result.status));
        row.append(AJS.$('<td>').css('text-align', 'center').text(result.message));
        tableBody.append(row);
    });

    AJS.dialog2("#group-action-dialog").show();

}

function closeGroupDialog() {
    console.log("closeGroupDialog called....");
    AJS.dialog2("#group-action-dialog").hide();
    setTimeout(function() {
        location.reload();
    }, 500);
}
