AJS.$(function() {

     var helpButton = document.getElementById("Help_Button");
     var sticky = helpButton.offsetTop;
     helpButton.classList.add("sticky");
    document.getElementById("auditlog-user-form-1").addEventListener("submit", function (event) {

        if (!validateForm()) {
            event.preventDefault();
        }

        var isEnabled = document.getElementById("autoDeleteAuditLogs").checked;
        localStorage.setItem("autoDeleteAuditLogs", isEnabled.toString());

    });

    document.getElementById('numberOfEntriesToRetain').addEventListener('input', function() {
        document.getElementById('retainCountDisplay').innerText = this.value || "1000";
    });
})
function LoadingFlag(){
    document.getElementById("spin").style.display="block";
}
function displayFilterSpecificLogs() {
    var action = document.getElementById("filterUsersByAction");
    var status = document.getElementById("filterByStatus");
    var period = document.getElementById("filterUsersByPeriod");
    var username = document.getElementById("auditLogUsernameSearchKeyword");
    var ip = document.getElementById("auditLogIpSearchKeyword");
    if (action.value === "" && status.value === "" && period.value === "" && username.value === "" && ip.value === "") {
        document.getElementById("filterUsersByAction").style.borderColor = "red";
        document.getElementById("filterByStatus").style.borderColor = "red";
        document.getElementById("filterUsersByPeriod").style.borderColor = "red";
        document.getElementById("auditLogUsernameSearchKeyword").style.borderColor = "red";
        document.getElementById("auditLogIpSearchKeyword").style.borderColor = "red";
        alert("Please select a valid Filter");
    }
}

function resetAuditLogsFilters() {
    AJS.$("#auditLogUsernameSearchKeyword").val("");
    AJS.$("#auditLogIpSearchKeyword").val("");
    AJS.$("#filterUsersByAction").val("All Actions");
    AJS.$("#filterUsersByPeriod").val("All Days");
    AJS.$("#filterByStatus").val("All Status");

    console.log("Resetting fields");
    usernameField.val("");
    ipField.val("");
    actionField.val("All Actions");
    periodField.val("All Days");
    statusField.val("All Status");

    AJS.flag({
        title: 'Filters Reset',
        type: 'success',
        close:'auto',
        body: '<p>All filters have been reset successfully</p>'
    });
}

function clearAuditLogs() {

    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
        data: {
            "action": "clearAuditLogs"
        },
        type: "GET",
        success: function (response) {
            console.log("Calling success");
            require('aui/flag')({
                title: 'Logs Cleared',
                type: 'success',
                close: 'auto',
                body: '<p>Successfully cleared all the logs</p>'
            });
            setTimeout(function () {
                location.reload();
            }, 5000);
        },
        error: function (response) {
            console.log("Calling error");

            if (response.responseText === "Error_Admin_Privilege") {
                require('aui/flag')({
                    title: 'You do not have administrator Privilege.',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Cant clear Audit logs</p>'
                });
                setTimeout(function () {
                    location.reload();
                }, 5000);
            } else {
                require('aui/flag')({
                    title: 'Deleting Group',
                    type: 'error',
                    close: 'auto',
                    body: '<p>An error occurred while clearing audit logs</p>'
                });
                setTimeout(function () {
                    location.reload();
                }, 5000);
            }
        },
    });
}

function exportLogs() {
    var username = document.getElementById("auditLogUsernameSearchKeyword").value;
    var ip = document.getElementById("auditLogIpSearchKeyword").value;
    var action = document.getElementById("filterUsersByAction").value;
    var period = document.getElementById("filterUsersByPeriod").value;
    var status = document.getElementById("filterByStatus").value;

    window.location.href = AJS.contextPath() + "/plugins/servlet/usermanagement/moapiauditlogexport" + "?username=" + username + "&ip=" + ip + "&action=" + action + "&period=" + period + "&status=" + status;
}

function disablelimitdays() {
    var isEnabled = document.getElementById("autoDeleteAuditLogs").checked;
    var daysInput = document.getElementById("autoDeleteLogsAfterDays");
    var schedulerType = document.getElementById("schedulerType");
    var submitButton = document.getElementById("perform-action-button");
    var customField = document.getElementById("daysSchedulerField");

    localStorage.setItem("autoDeleteAuditLogs", isEnabled.toString());

    daysInput.disabled = !isEnabled;
    schedulerType.disabled = !isEnabled;
    submitButton.disabled = false;

    if (!isEnabled) {
        schedulerType.value = "";
        customField.style.display = "none";
    } else {
        customField.style.display = schedulerType.value === "custom" ? "block" : "none";
    }

    schedulerType.addEventListener("change", function() {
        customField.style.display = this.value === "custom" ? "block" : "none";
    });
}


window.onload = function () {
    disablelimitdays();
};



function validateForm() {
    var toggle = document.getElementById("autoDeleteAuditLogs").checked;
    var schedulerType = document.getElementById("schedulerType");
    var daysInput = document.getElementById("autoDeleteLogsAfterDays");
    var daysField = document.getElementById("daysSchedulerField");
    var retainField=document.getElementById("numberOfEntriesToRetain");

    if (toggle) {
            if (!schedulerType) {
                showErrorMessage("Scheduler type field not found.");
                return false;
            }
            if (schedulerType.value === "") {
                showErrorMessage("Please select a scheduler type before submitting.");
                return false;
            }
            if (schedulerType.value === "custom") {
                daysField.style.display = "block";
                if (!daysInput.value || daysInput.value.trim() === "" || parseInt(daysInput.value) <= 0 || daysInput.value.includes('.') || daysInput.value.includes(',')) {
                    showErrorMessage("Please enter a valid number of days before submitting.");
                    daysInput.focus();
                    return false;
                }
            } else if (schedulerType.value === "daily") {
                daysField.style.display = "none";
            }
            if (!retainField.value || retainField.value.trim() === "" || parseInt(retainField.value) <= 0 || retainField.value.includes('.') || retainField.value.includes(',')) {
                showErrorMessage("Please enter a valid number of entries to be retained before submitting.");
                retainField.focus();
                return false;
            }
    }

    showSuccessMessage(toggle ? "Scheduler settings saved successfully." : "Scheduler disabled successfully.");
    return true;
}


function showErrorMessage(message) {
    AJS.flag({
        title: 'Error!',
        type: 'error',
        close: 'auto',
        body: '<p>'+message+'</p><br/>'
    });
}

function showSuccessMessage(message) {
    AJS.flag({
        title: 'Success!',
        type: 'success',
        close: 'auto',
        body: '<p>' + message + '</p>'
    });
}



