/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.utils;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.GroupNotFoundException;
import com.atlassian.crowd.exception.MembershipNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.ReadOnlyGroupException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.directory.DirectoryPermissionException;
import com.atlassian.crowd.manager.mail.MailManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.TimestampedUser;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.model.user.UserWithAttributes;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.PropertyRestriction;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.atlassian.sal.api.user.UserKey;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import java.net.InetAddress;
import java.net.URI;
import java.net.UnknownHostException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.time.temporal.ChronoUnit;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.TreeMap;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.mail.internet.InternetAddress;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CommonUserUtils {
    private static final Logger LOGGER = LoggerFactory.getLogger(CommonUserUtils.class);
    private TransactionTemplate transactionTemplate;
    private static DirectoryManager directoryManager;
    private static UserManagementPluginSettings settings;
    private CrowdService crowdService;
    private UserManager userManager;
    private MailManager mailManager;
    private UserManagementPluginHandler userManagementPluginHandler;

    @Autowired
    public CommonUserUtils(TransactionTemplate transactionTemplate, DirectoryManager directoryManager, UserManagementPluginSettings settings, CrowdService crowdService, MailManager mailManager, UserManagementPluginHandler userManagementPluginHandler, UserManager userManager) {
        this.transactionTemplate = transactionTemplate;
        CommonUserUtils.directoryManager = directoryManager;
        CommonUserUtils.settings = settings;
        this.crowdService = crowdService;
        this.mailManager = mailManager;
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.userManager = userManager;
    }

    public List<UserTemplate> getAllUsers(String searchQuery, Boolean sortByLastLogin, Boolean foundDirectory, long directoryId, int startIndex) {
        List<Object> userListToReturn = new ArrayList<UserTemplate>();
        ArrayList users = new ArrayList();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = directoryManager.findAllDirectories();
                for (Directory directory : directories) {
                    users.addAll(directoryManager.searchUsers(directory.getId().longValue(), query));
                }
            }
            userListToReturn = users.stream().map(UserTemplate::new).collect(Collectors.toList());
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }

    public List<String> getSelectedDetailsForPagination(List<String> detailsList, Integer groupsPerPage, Integer startIndex, Integer endIndex) {
        ArrayList<String> selectedDetailsPagination = new ArrayList<String>();
        for (int i = startIndex.intValue(); i < startIndex + groupsPerPage && i <= endIndex && i < detailsList.size(); ++i) {
            selectedDetailsPagination.add(detailsList.get(i));
        }
        Collections.sort(selectedDetailsPagination);
        return selectedDetailsPagination;
    }

    public int getTotalSearchResults(String searchQuery) {
        int totalUserCount = 0;
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            List directories = directoryManager.findAllDirectories();
            for (Directory directory : directories) {
                totalUserCount += directoryManager.searchUsers(directory.getId().longValue(), query).size();
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting total user count=", (Throwable)e);
        }
        return totalUserCount;
    }

    public int getTotalSearchResults(String searchQuery, Boolean isActive) {
        int totalUserCount = 0;
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActive)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            List directories = directoryManager.findAllDirectories();
            for (Directory directory : directories) {
                totalUserCount += directoryManager.searchUsers(directory.getId().longValue(), query).size();
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting total user count=", (Throwable)e);
        }
        return totalUserCount;
    }

    public List<UserTemplate> getAllUsersWithAllUserCase(String searchQuery, Boolean sortByLastLogin, Boolean foundDirectory, long directoryId, String startDate, String endDate, int startIndex, String loginBasedFilter) {
        LOGGER.debug("Retrieve all users with their corresponding user case, applying 'all' user filter.");
        String cacheKey = "foundDirectory" + foundDirectory + "directoryId" + directoryId + "allUserssearchQueryloginBasedFilter" + loginBasedFilter;
        ArrayList<PropertyRestriction> restrictionList = new ArrayList<PropertyRestriction>();
        List<Object> resultList = new ArrayList();
        ArrayList<UserTemplate> tempUsersList = new ArrayList<UserTemplate>();
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        ArrayList<User> users = new ArrayList<User>();
        restrictionList.add(Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery));
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf(restrictionList)).returningAtMost(Integer.MAX_VALUE);
        LocalDate currentDate = LocalDate.now();
        LOGGER.info("current date :" + currentDate);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = directoryManager.findAllDirectories();
                Iterator iterator = directories.iterator();
                while (iterator.hasNext()) {
                    Directory directory = (Directory)iterator.next();
                    long dictId = directory.getId();
                    users.addAll(directoryManager.searchUsers(dictId, query));
                }
            }
            if ((!BooleanUtils.toBoolean((Boolean)sortByLastLogin) || !searchQuery.isEmpty()) && startDate.equals("1970-01-01") && endDate.equals(currentDate.toString()) && loginBasedFilter.equals("bothUser")) {
                for (User user : users) {
                    userListToReturn.add(new UserTemplate(user));
                }
                return userListToReturn;
            }
            resultList = this.fetchAllUsers(users);
            userListToReturn.addAll((Collection)resultList.get(0));
            userListToReturn.addAll((Collection)resultList.get(1));
            tempUsersList.addAll((Collection)resultList.get(0));
            if (!startDate.equals("1970-01-01") || !endDate.equals(currentDate.toString())) {
                LOGGER.debug("Retrieving users within the specified date range.");
                if (loginBasedFilter.equals("neverLoggedInUser")) {
                    return new ArrayList<UserTemplate>();
                }
                return tempUsersList.size() != 0 ? this.fetchUsersWithinStartAndLastDate(tempUsersList, startDate, endDate) : null;
            }
            if (loginBasedFilter.equals("neverLoggedInUser")) {
                return (List)resultList.get(1);
            }
            if (loginBasedFilter.equals("loggedInUser")) {
                return (List)resultList.get(0);
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }

    public String getUserCreationTime(String username, long directoryId) {
        try {
            Date createdDate;
            User user = directoryManager.findUserByName(directoryId, username);
            if (user instanceof TimestampedUser && (createdDate = ((TimestampedUser)user).getCreatedDate()) != null) {
                SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss z");
                return sdf.format(createdDate);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error getting creation time for user: " + username, (Throwable)e);
        }
        return null;
    }

    public List<User> getActiveUsers() {
        ArrayList<User> users = new ArrayList<User>();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)""), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)"")}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)true)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        try {
            List directories = directoryManager.findAllDirectories();
            for (Directory directory : directories) {
                users.addAll(directoryManager.searchUsers(directory.getId().longValue(), query));
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return users;
    }

    public List<UserTemplate> getAllUsers(String searchQuery, Boolean sortByLastLogin, Boolean foundDirectory, long directoryId, int startIndex, Boolean isActive, Boolean limit, String startDate, String endDate, String loginBasedFilter) {
        LOGGER.debug("getAllUser with case: active/inactive");
        String cacheKey = "foundDirectory" + foundDirectory + "directoryId" + directoryId + "status_is:" + isActive + searchQuery + "loginBasedFilter" + loginBasedFilter;
        LOGGER.debug("cache Key is: " + cacheKey);
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        List<Object> resultList = new ArrayList();
        ArrayList<UserTemplate> tempUsersList = new ArrayList<UserTemplate>();
        ArrayList<User> users = new ArrayList<User>();
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.LAST_NAME).containing((Object)searchQuery)}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActive)})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
        LocalDate currentDate = LocalDate.now();
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(directoryManager.searchUsers(directoryId, query));
            } else {
                Iterator directories = directoryManager.findAllDirectories();
                Iterator iterator = directories.iterator();
                while (iterator.hasNext()) {
                    Directory directory = (Directory)iterator.next();
                    users.addAll(directoryManager.searchUsers(directory.getId().longValue(), query));
                }
            }
            if (limit.booleanValue()) {
                if (!BooleanUtils.toBoolean((Boolean)sortByLastLogin) && startDate.equals("1970-01-01") && endDate.equals(currentDate.toString()) && loginBasedFilter.equals("bothUser")) {
                    for (User user : users) {
                        userListToReturn.add(new UserTemplate(user));
                    }
                    return userListToReturn;
                }
                LOGGER.debug("loginBasedFilter is Not both users");
                resultList = this.fetchAllUsers(users);
                tempUsersList.addAll((Collection)resultList.get(0));
                userListToReturn.addAll((Collection)resultList.get(0));
                userListToReturn.addAll((Collection)resultList.get(1));
                if (!startDate.equals("1970-01-01") || !endDate.equals(currentDate.toString())) {
                    LOGGER.debug("Retrieving users within the specified date range.");
                    if (loginBasedFilter.equals("neverLoggedInUser")) {
                        return new ArrayList<UserTemplate>();
                    }
                    return tempUsersList.size() != 0 ? this.fetchUsersWithinStartAndLastDate(tempUsersList, startDate, endDate) : null;
                }
                if (loginBasedFilter.equals("neverLoggedInUser")) {
                    return (List)resultList.get(1);
                }
                if (loginBasedFilter.equals("loggedInUser")) {
                    return (List)resultList.get(0);
                }
            } else {
                for (User user : users.subList(startIndex, users.size())) {
                    userListToReturn.add(new UserTemplate(user));
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        LOGGER.debug("user list to return is: " + userListToReturn);
        return userListToReturn;
    }

    public static Date getLastLoginDate(String userName, long directoryId) {
        try {
            UserWithAttributes userWithAttributes = directoryManager.findUserWithAttributesByName(directoryId, userName);
            String lastLoginTime = userWithAttributes.getValue("lastAuthenticated");
            if (lastLoginTime != null) {
                long loginTime = Long.parseLong(lastLoginTime);
                return new Date(loginTime);
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching last login time", (Throwable)e);
        }
        return null;
    }

    private void updateAndLogUserUpdate(UserTemplate user) {
        try {
            directoryManager.updateUser(user.getDirectoryId(), user);
            LOGGER.info("Status updated of user: " + user.getName());
        }
        catch (Exception e) {
            LOGGER.error("Exception while updating user " + user.getName());
        }
    }

    public URI getUri(HttpServletRequest request) {
        StringBuffer builder = request.getRequestURL();
        if (request.getQueryString() != null) {
            builder.append("?");
            builder.append(request.getQueryString());
        }
        return URI.create(builder.toString());
    }

    public List<List<UserTemplate>> fetchAllUsers(List<User> users) {
        LOGGER.debug("Fetching all users ...");
        ArrayList<List<UserTemplate>> resultList = new ArrayList<List<UserTemplate>>();
        List userListToReturnNull = Collections.synchronizedList(new ArrayList());
        ConcurrentHashMap<Long, User> userMapWithLastLogin = new ConcurrentHashMap<Long, User>();
        int batchSize = 2000;
        int numBatches = (int)Math.ceil((double)users.size() / (double)batchSize);
        LOGGER.debug("numbatches: " + numBatches);
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        ArrayList<CompletableFuture<Void>> allDirectoryUsers = new ArrayList<CompletableFuture<Void>>();
        for (int j = 0; j < numBatches; ++j) {
            int start = j * batchSize;
            int end = Math.min((j + 1) * batchSize, users.size());
            List<User> batch = users.subList(start, end);
            CompletableFuture<Void> directoryUsers = CompletableFuture.runAsync(() -> {
                HashMap<Long, User> tempUserMap = new HashMap<Long, User>();
                for (User user : batch) {
                    Date lastLoginDate = CommonUserUtils.getLastLoginDate(user.getName(), user.getDirectoryId());
                    if (lastLoginDate == null) {
                        userListToReturnNull.add(new UserTemplate(user));
                        continue;
                    }
                    long loginTime = lastLoginDate.getTime();
                    tempUserMap.put(loginTime, user);
                }
                userMapWithLastLogin.putAll(tempUserMap);
            }, executorService);
            allDirectoryUsers.add(directoryUsers);
        }
        CompletableFuture.allOf(allDirectoryUsers.toArray(new CompletableFuture[0])).join();
        executorService.shutdown();
        LOGGER.debug("number of users having last login is:" + userMapWithLastLogin.size());
        resultList.add(userMapWithLastLogin != null ? this.sortUsersByLastLogin(userMapWithLastLogin) : null);
        resultList.add(userListToReturnNull);
        return resultList;
    }

    public List<UserTemplate> sortUsersByLastLogin(Map<Long, User> userListWithLastLogin) {
        TreeMap sortedMap = new TreeMap(Collections.reverseOrder());
        sortedMap.putAll(userListWithLastLogin);
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>(sortedMap.size());
        for (User user : sortedMap.values()) {
            userListToReturn.add(new UserTemplate(user));
        }
        return userListToReturn;
    }

    public void deactivationProcessForUsers(List<UserTemplate> users, List<String> excludeUsers) {
        LOGGER.debug("Executing the user's deactivation process");
        Date currentDate = new Date();
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (UserTemplate user : users) {
            executor.submit(() -> {
                try {
                    this.processUserDeactivation(user, currentDate, excludeUsers);
                }
                catch (Exception e) {
                    LOGGER.error("Exception while processing user deactivation for user " + user.getName(), (Throwable)e);
                }
            });
        }
        executor.shutdown();
        try {
            if (!executor.awaitTermination(10L, TimeUnit.MINUTES)) {
                LOGGER.error("Executor did not terminate in time.");
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Executor was interrupted while awaiting termination.", (Throwable)e);
        }
    }

    private void processUserDeactivation(UserTemplate user, Date currentDate, List<String> excludeUsers) {
        block10: {
            try {
                User remoteUser = directoryManager.findRemoteUserByName(Long.valueOf(user.getDirectoryId()), user.getName());
                UserTemplate userTemplate = new UserTemplate(remoteUser);
                String userCreatedTime = null;
                InetAddress ip = InetAddress.getLocalHost();
                Date lastActive = CommonUserUtils.getLastActivationDate(user.getName(), user.getDirectoryId());
                if (!(directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), "crowd-administrators") || excludeUsers.contains(user.getName()) || CommonUserUtils.isUserInExcludeGroups(user))) {
                    if (lastActive == null) {
                        try {
                            UserWithAttributes userWithAttributes = directoryManager.findUserWithAttributesByName(user.getDirectoryId(), user.getName());
                            userCreatedTime = userWithAttributes.getValue("passwordLastChanged");
                        }
                        catch (Exception e) {
                            LOGGER.error("An error occurred while fetching last login time", (Throwable)e);
                        }
                        if (userCreatedTime != null) {
                            Date createdTime = new Date(Long.parseLong(userCreatedTime));
                            if (currentDate.getTime() - createdTime.getTime() > settings.getNumberOfDaysForNeverLoggedUsers() * 86400000L) {
                                userTemplate.setActive(false);
                                this.userManagementPluginHandler.storeAuditLogs(userTemplate.getName(), ip.getHostAddress(), "User Deactivated", "User Deactivated Successfully.", "Success");
                                this.updateAndLogUserUpdate(userTemplate);
                            }
                        } else {
                            userTemplate.setActive(false);
                            this.userManagementPluginHandler.storeAuditLogs(userTemplate.getName(), ip.getHostAddress(), "User Deactivated", "User Deactivated Successfully.", "Success");
                            this.updateAndLogUserUpdate(userTemplate);
                        }
                        break block10;
                    }
                    if (currentDate.getTime() - lastActive.getTime() > settings.getNumberOfDays() * 86400000L) {
                        userTemplate.setActive(false);
                        this.userManagementPluginHandler.storeAuditLogs(userTemplate.getName(), ip.getHostAddress(), "User Deactivated", "User Deactivated Successfully.", "Success");
                        this.updateAndLogUserUpdate(userTemplate);
                    }
                    break block10;
                }
                LOGGER.debug("Skipping deactivation for user " + user.getName() + ". Reason: Admin user or in exclude user list");
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }

    private static boolean isUserInExcludeGroups(UserTemplate user) {
        List<String> excludeGroupList = settings.getExcludeGroupsList();
        try {
            for (String group : excludeGroupList) {
                if (!directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), group)) continue;
                LOGGER.debug("User " + user.getName() + " is a member of the Excluded Group " + group);
                return true;
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred in fetching user groups");
        }
        return false;
    }

    public static Date getLastActivationDate(String userName, long directoryId) {
        String lastActivatedTime = null;
        try {
            UserWithAttributes userWithAttributes = directoryManager.findUserWithAttributesByName(directoryId, userName);
            lastActivatedTime = userWithAttributes.getValue("lastAuthenticated");
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching last login time", (Throwable)e);
        }
        if (lastActivatedTime == null) {
            return null;
        }
        Date loginDate = new Date(Long.parseLong(lastActivatedTime));
        return loginDate;
    }

    public void deactivateUsers() {
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                Calendar targeted = Calendar.getInstance();
                int days = (int)settings.getNumberOfDays();
                targeted.add(5, -days);
                Date targetDate = targeted.getTime();
                LOGGER.debug("targeted date is: " + targetDate);
                List<List<UserTemplate>> users = CommonUserUtils.this.fetchAllUsers(CommonUserUtils.this.getActiveUsers());
                List<UserTemplate> userWithoutLastLogin = users.get(1);
                List<UserTemplate> userWithLastLogin = users.get(0);
                List<String> excludeUsers = settings.getExcludeUsersList();
                LOGGER.debug("List of users to be excluded: " + excludeUsers);
                if (settings.getAutoDeactivateNeverLoggedInUser().booleanValue()) {
                    CommonUserUtils.this.deactivationProcessForUsers(userWithoutLastLogin, excludeUsers);
                    CommonUserUtils.this.sendMailBeforeDeactivation(userWithoutLastLogin, excludeUsers);
                }
                List<UserTemplate> usersBeforeTarget = CommonUserUtils.usersLoggedInBeforeTargetedDate(userWithLastLogin);
                List<UserTemplate> mailusersBeforeTarget = CommonUserUtils.mailBeforeTargetedDate(userWithLastLogin);
                CommonUserUtils.this.deactivationProcessForUsers(usersBeforeTarget, excludeUsers);
                CommonUserUtils.this.sendMailBeforeDeactivation(mailusersBeforeTarget, excludeUsers);
                return null;
            }
        });
    }

    public static List<UserTemplate> mailBeforeTargetedDate(List<UserTemplate> users) {
        LOGGER.debug("Retrieving users who have logged in prior to the targeted date.");
        Calendar targeted = Calendar.getInstance();
        int days = (int)(settings.getNumberOfDays() - settings.getMailPeriod());
        int mailDays = (int)settings.getMailPeriod();
        targeted.add(5, -days);
        Date targetDate = targeted.getTime();
        LOGGER.debug("targeted date is: " + targetDate);
        int index = CommonUserUtils.getIndex(users, targetDate);
        int size = users.size();
        List<UserTemplate> usersBeforeTarget = users.subList(index, size);
        return usersBeforeTarget;
    }

    public void sendMailBeforeDeactivation(List<UserTemplate> users, List<String> excludeUsers) {
        LOGGER.debug("Executing the user's mail notification process");
        Date currentDate = new Date();
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        for (UserTemplate user : users) {
            executor.submit(() -> {
                block10: {
                    try {
                        Date lastActive = CommonUserUtils.getLastActivationDate(user.getName(), user.getDirectoryId());
                        String userCreatedTime = null;
                        if (!(directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), "crowd-administrators") || excludeUsers.contains(user.getName()) || CommonUserUtils.isUserInExcludeGroups(user))) {
                            if (!settings.getMailNotification().booleanValue()) break block10;
                            long sendMailBeforeOneDay = (settings.getMailPeriod() - settings.getNumberOfDays()) * 86400000L;
                            long sendMailBeforeOneDayForNeverLoggedUser = (settings.getNumberOfDaysForNeverLoggedUsers() - settings.getMailPeriod()) * 86400000L;
                            if (lastActive == null) {
                                try {
                                    UserWithAttributes userWithAttributes = directoryManager.findUserWithAttributesByName(user.getDirectoryId(), user.getName());
                                    userCreatedTime = userWithAttributes.getValue("passwordLastChanged");
                                }
                                catch (Exception e) {
                                    LOGGER.error("An error occurred while fetching last login time", (Throwable)e);
                                }
                                if (userCreatedTime != null) {
                                    Date createdTime = new Date(Long.parseLong(userCreatedTime));
                                    if (currentDate.getTime() - createdTime.getTime() > sendMailBeforeOneDayForNeverLoggedUser) {
                                        this.sendEmailToNeverLoggedUser((User)user);
                                    }
                                } else {
                                    this.sendEmailToNeverLoggedUser((User)user);
                                }
                                break block10;
                            }
                            if (currentDate.getTime() - lastActive.getTime() > sendMailBeforeOneDay) {
                                this.sendEmailToUser((User)user, lastActive.getTime());
                            }
                            break block10;
                        }
                        LOGGER.debug("Skipping deactivation for user " + user.getName() + ". Reason: Admin user or in exclude user list");
                    }
                    catch (Exception e) {
                        LOGGER.debug("getting exception while sending mail to users : " + e);
                    }
                }
            });
        }
        executor.shutdown();
    }

    public void sendEmailToUser(User user, long lastActive) throws Exception {
        LOGGER.debug("Calling sendOtpOnEmail.");
        String subject = settings.getSubText();
        SimpleDateFormat sdf1 = new SimpleDateFormat("MMM dd, yyyy");
        String body = settings.getMailText();
        String days = String.valueOf(settings.getNumberOfDays());
        body = StringUtils.replace((String)body, (String)"$$username$$", (String)user.getDisplayName());
        body = StringUtils.replace((String)body, (String)"$$last-login-date$$", (String)sdf1.format(lastActive));
        body = StringUtils.replace((String)body, (String)"$$days$$", (String)days);
        InternetAddress address = new InternetAddress(user.getEmailAddress());
        try {
            this.mailManager.sendPlainTextEmail(address, subject, body);
        }
        catch (Exception e) {
            LOGGER.debug("Exception :- " + e);
            LOGGER.debug("Exception :- " + e.getMessage());
        }
        LOGGER.debug("Send email successfully");
    }

    public void sendEmailToNeverLoggedUser(User user) throws Exception {
        LOGGER.debug("Calling sendOtpOnEmail.");
        String subject = settings.getSubText();
        SimpleDateFormat sdf1 = new SimpleDateFormat("MMM dd, yyyy");
        String body = "Hello $$username$$,\n\nWe would like to inform you that your account is scheduled for deactivation due to inactivity in the last $$days$$ days. If you have any questions or require further information, please don't hesitate to contact your Administrator.\n\nThank you.";
        String days = String.valueOf(settings.getNumberOfDaysForNeverLoggedUsers());
        body = StringUtils.replace((String)body, (String)"$$username$$", (String)user.getDisplayName());
        body = StringUtils.replace((String)body, (String)"$$days$$", (String)days);
        InternetAddress address = new InternetAddress(user.getEmailAddress());
        try {
            this.mailManager.sendPlainTextEmail(address, subject, body);
        }
        catch (Exception e) {
            LOGGER.debug("Exception :- " + e);
            LOGGER.debug("Exception :- " + e.getMessage());
        }
        LOGGER.debug("Send email successfully");
    }

    public static List<UserTemplate> usersLoggedInBeforeTargetedDate(List<UserTemplate> users) {
        LOGGER.debug("Retrieving users who have logged in prior to the targeted date.");
        Calendar targeted = Calendar.getInstance();
        int days = (int)settings.getNumberOfDays();
        targeted.add(5, -days);
        Date targetDate = targeted.getTime();
        LOGGER.debug("targeted date is: " + targetDate);
        int index = CommonUserUtils.getIndex(users, targetDate);
        int size = users.size();
        List<UserTemplate> usersBeforeTarget = users.subList(index, size);
        return usersBeforeTarget;
    }

    private static int getIndex(List<UserTemplate> users, Date targetDate) {
        int left = 0;
        int right = users.size() - 1;
        try {
            while (left <= right) {
                int mid = left + (right - left) / 2;
                User user = (User)users.get(mid);
                Date loginDate = CommonUserUtils.getLastLoginDate(user.getName(), user.getDirectoryId());
                if (loginDate.after(targetDate)) {
                    left = mid + 1;
                    continue;
                }
                right = mid - 1;
            }
        }
        catch (NullPointerException e) {
            LOGGER.debug("login date of user is null");
        }
        return left;
    }

    public void removeGroupsFromUser() throws MembershipNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException {
        this.transactionTemplate.execute(new TransactionCallback(){

            public Object doInTransaction() {
                ArrayList<User> tempUser = new ArrayList<User>();
                ArrayList groupsThatFollowRegex = new ArrayList();
                List<String> groupsToRemove = settings.getGroupsToRemoveList();
                boolean enableRegexForGroupsToRemove = settings.getEnableRegexForGroups();
                String regexPatternForExcludeGroups = settings.getRegexPattenForGroups();
                ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
                if (BooleanUtils.toBoolean((Boolean)enableRegexForGroupsToRemove) && StringUtils.isNotBlank((CharSequence)regexPatternForExcludeGroups)) {
                    try {
                        List existingGroups = CommonUserUtils.this.fetchGroups();
                        existingGroups.stream().filter(group -> CommonUserUtils.this.checkExcludeGroupRegex(group, regexPatternForExcludeGroups)).forEach(group -> {
                            groupsThatFollowRegex.add(group);
                            groupsToRemove.add((String)group);
                        });
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while fetching all the groups");
                    }
                }
                LOGGER.debug("groups to remove are: " + groupsToRemove);
                List<String> excludeUsers = settings.getExcludeUsersList();
                LOGGER.debug("exclude users are: " + excludeUsers);
                tempUser.addAll(CommonUserUtils.this.getAllUsersWithGroupsForAll("", false, groupsToRemove, false, 0L, "", "", 0, "bothUser"));
                List<UserTemplate> userWithLastLogin = CommonUserUtils.this.fetchAllUsers(tempUser).get(0);
                List<UserTemplate> usersBeforeTarget = CommonUserUtils.usersLoggedInBeforeTargetedDate(userWithLastLogin);
                for (UserTemplate user : usersBeforeTarget) {
                    executor.execute(() -> {
                        String userName = user.getName();
                        LOGGER.debug("Removing group for user = " + userName);
                        long directoryId = user.getDirectoryId();
                        try {
                            boolean isAdmin = directoryManager.isUserDirectGroupMember(directoryId, userName, "crowd-administrators");
                            if (!(isAdmin || excludeUsers.contains(userName) || CommonUserUtils.isUserInExcludeGroups(user))) {
                                CommonUserUtils.this.removeUserFromGroup(directoryId, user, groupsToRemove);
                            } else {
                                LOGGER.debug("Skipping groups to remove for user " + user.getName() + ". Reason: Admin user/ Excluded User /Excluded Group ");
                            }
                        }
                        catch (Exception e) {
                            LOGGER.debug("group does not exist in the directory");
                        }
                    });
                }
                executor.shutdown();
                try {
                    executor.awaitTermination(Long.MAX_VALUE, TimeUnit.NANOSECONDS);
                }
                catch (InterruptedException e) {
                    e.printStackTrace();
                }
                return null;
            }
        });
    }

    public void removeGroupsFromNeverLoggedInUser() throws MembershipNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException {
        List userWithoutLastLogin = (List)this.transactionTemplate.execute((TransactionCallback)new TransactionCallback<List<UserTemplate>>(){

            public List<UserTemplate> doInTransaction() {
                ArrayList<User> tempUser = new ArrayList<User>();
                ArrayList<String> groupsToRemove = new ArrayList<String>(settings.getGroupsToRemoveList());
                boolean enableRegexForGroupsToRemove = settings.getEnableRegexForGroups();
                String regexPatternForExcludeGroups = settings.getRegexPattenForGroups();
                if (BooleanUtils.toBoolean((Boolean)enableRegexForGroupsToRemove) && StringUtils.isNotBlank((CharSequence)regexPatternForExcludeGroups)) {
                    try {
                        List existingGroups = CommonUserUtils.this.fetchGroups();
                        List newGroupsToRemove = existingGroups.stream().filter(group -> CommonUserUtils.this.checkExcludeGroupRegex(group, regexPatternForExcludeGroups)).collect(Collectors.toList());
                        groupsToRemove.addAll(newGroupsToRemove);
                    }
                    catch (Exception e) {
                        LOGGER.error("Error while fetching all the groups", (Throwable)e);
                    }
                }
                LOGGER.debug("Groups to remove: " + groupsToRemove);
                List<String> excludeUsers = settings.getExcludeUsersList();
                LOGGER.debug("Exclude users: " + excludeUsers);
                tempUser.addAll(CommonUserUtils.this.getAllUsersWithGroupsForAll("", false, groupsToRemove, false, 0L, "", "", 0, "bothUser"));
                return CommonUserUtils.this.fetchAllUsers(tempUser).get(1);
            }
        });
        if (userWithoutLastLogin == null || userWithoutLastLogin.isEmpty()) {
            LOGGER.debug("No users found for group removal.");
            return;
        }
        ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        Date currentDate = new Date();
        for (UserTemplate user : userWithoutLastLogin) {
            executor.execute(() -> {
                block19: {
                    String userName = user.getName();
                    long directoryId = user.getDirectoryId();
                    ArrayList<String> groupsToRemove = new ArrayList<String>(settings.getGroupsToRemoveList());
                    boolean enableRegexForGroupsToRemove = settings.getEnableRegexForGroups();
                    String regexPatternForExcludeGroups = settings.getRegexPattenForGroups();
                    if (BooleanUtils.toBoolean((Boolean)enableRegexForGroupsToRemove) && StringUtils.isNotBlank((CharSequence)regexPatternForExcludeGroups)) {
                        try {
                            List<String> existingGroups = this.fetchGroups();
                            List newGroupsToRemove = existingGroups.stream().filter(group -> this.checkExcludeGroupRegex((String)group, regexPatternForExcludeGroups)).collect(Collectors.toList());
                            groupsToRemove.addAll(newGroupsToRemove);
                        }
                        catch (Exception e) {
                            LOGGER.error("Error while fetching all the groups for user: " + userName, (Throwable)e);
                        }
                    }
                    try {
                        boolean isAdmin = directoryManager.isUserDirectGroupMember(directoryId, userName, "crowd-administrators");
                        List<String> excludeUsers = settings.getExcludeUsersList();
                        if (!(isAdmin || excludeUsers.contains(userName) || CommonUserUtils.isUserInExcludeGroups(user))) {
                            String userCreatedTime = null;
                            Date lastActive = CommonUserUtils.getLastActivationDate(userName, directoryId);
                            try {
                                UserWithAttributes userWithAttributes = directoryManager.findUserWithAttributesByName(directoryId, userName);
                                userCreatedTime = userWithAttributes.getValue("passwordLastChanged");
                            }
                            catch (Exception e) {
                                LOGGER.error("An error occurred while fetching last password change time for user " + userName, (Throwable)e);
                            }
                            boolean shouldRemoveGroups = false;
                            if (lastActive == null) {
                                if (userCreatedTime != null) {
                                    try {
                                        Date createdTime = new Date(Long.parseLong(userCreatedTime));
                                        if (currentDate.getTime() - createdTime.getTime() > settings.getNumberOfDaysForNeverLoggedUsers() * 86400000L) {
                                            shouldRemoveGroups = true;
                                        }
                                    }
                                    catch (NumberFormatException e) {
                                        LOGGER.error("Invalid userCreatedTime format for user: " + userName, (Throwable)e);
                                        shouldRemoveGroups = true;
                                    }
                                } else {
                                    shouldRemoveGroups = true;
                                }
                            } else if (currentDate.getTime() - lastActive.getTime() > settings.getNumberOfDays() * 86400000L) {
                                shouldRemoveGroups = true;
                            }
                            if (shouldRemoveGroups) {
                                this.removeUserFromGroup(directoryId, user, groupsToRemove);
                                LOGGER.debug("Groups removed for user: " + userName);
                            } else {
                                LOGGER.debug("Skipped groups removal for user: " + userName + ". Reason: Recent activity or password change");
                            }
                            break block19;
                        }
                        LOGGER.debug("Skipped groups removal for user: " + userName + ". Reason: Admin user / Excluded User / Excluded Group");
                    }
                    catch (Exception e) {
                        LOGGER.error("Error processing group removal for user: " + userName, (Throwable)e);
                    }
                }
            });
        }
        executor.shutdown();
        try {
            if (!executor.awaitTermination(60L, TimeUnit.SECONDS)) {
                executor.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            LOGGER.error("Executor shutdown interrupted", (Throwable)e);
            executor.shutdownNow();
            Thread.currentThread().interrupt();
        }
    }

    private boolean checkExcludeGroupRegex(String groupName, String regexPattern) {
        try {
            Pattern pattern = Pattern.compile(regexPattern, 2);
            Matcher matcher = pattern.matcher(groupName);
            return matcher.find();
        }
        catch (Exception e) {
            LOGGER.error("Exception while applying regex on exclude group name...", (Throwable)e);
            return false;
        }
    }

    private void removeUserFromGroup(long directoryId, UserTemplate user, List<String> groupsToRemove) throws UserNotFoundException, DirectoryNotFoundException, OperationFailedException, MembershipNotFoundException, DirectoryPermissionException, ReadOnlyGroupException, GroupNotFoundException, UnknownHostException {
        String userName = user.getName();
        InetAddress ip = InetAddress.getLocalHost();
        UserKey userKey = new UserKey(userName);
        LOGGER.debug("Username =" + userName);
        if (!groupsToRemove.isEmpty()) {
            for (String group : groupsToRemove) {
                LOGGER.debug("Group to remove =" + group);
                boolean isGroupPresent = directoryManager.isUserDirectGroupMember(directoryId, userName, group);
                if (!isGroupPresent) continue;
                directoryManager.removeUserFromGroup(directoryId, userName, group);
                this.userManagementPluginHandler.storeAuditLogs(userName, ip.getHostAddress(), "Removed from Group", "Removed User from Group: " + group, "Success");
                LOGGER.debug("removed user" + userName + "from group: " + group);
            }
            UserWithAttributes userWithAttributes = directoryManager.findUserWithAttributesByName(directoryId, userName);
            for (String attribute : userWithAttributes.getKeys()) {
                if (!attribute.startsWith("autoGroupsAdded")) continue;
                LOGGER.debug("attribute is: " + attribute + " userName is: " + userName + " directory id: " + directoryId);
                directoryManager.removeUserAttributes(directoryId, userName, attribute);
            }
        }
    }

    public List<UserTemplate> getAllUsersWithGroupsForAll(String searchQuery, Boolean sortByLastLogin, List<String> groupSearchList, Boolean foundDirectory, long directoryId, String startDate, String endDate, int startIndex, String loginBasedFilter) {
        LOGGER.debug("Fetching all users having groups: getAllUsersWithGroupsForAll");
        String cacheKey = "foundDirectory" + foundDirectory + "directoryId" + directoryId + "group" + groupSearchList.hashCode() + searchQuery + "loginBasedFilter" + loginBasedFilter;
        ArrayList userListHavingGroups = new ArrayList();
        ArrayList<UserTemplate> userListHavingGroupsToReturn = new ArrayList<UserTemplate>();
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        List<Object> resultList = new ArrayList();
        int totalUser = this.getTotalSearchResults(searchQuery);
        ArrayList users = new ArrayList();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)searchQuery)})).startingAt(0).returningAtMost(totalUser);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = directoryManager.findAllDirectories();
                for (Directory directory : directories) {
                    users.addAll(directoryManager.searchUsers(directory.getId().longValue(), query));
                }
            }
            if (StringUtils.isEmpty((CharSequence)startDate) && StringUtils.isEmpty((CharSequence)endDate)) {
                startDate = settings.getStart_date_lastLoginTime();
                endDate = settings.getEnd_date_lastLoginTime();
            }
            LOGGER.debug("start date: " + startDate + " end date: " + endDate);
            LocalDate currentDate = LocalDate.now();
            users.parallelStream().forEach(user -> {
                for (String group : groupSearchList) {
                    try {
                        if (!directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), group)) continue;
                        userListHavingGroups.add(new UserTemplate(user));
                        break;
                    }
                    catch (Exception e) {
                        LOGGER.error("Getting error while fetching groups:" + e);
                    }
                }
            });
            userListHavingGroupsToReturn.addAll(userListHavingGroups);
            if (!BooleanUtils.toBoolean((Boolean)sortByLastLogin) && startDate.equals("1970-01-01") && endDate.equals(currentDate.toString()) && loginBasedFilter.equals("bothUser")) {
                return userListHavingGroupsToReturn;
            }
            ArrayList<User> usersWithGroup = new ArrayList<User>();
            usersWithGroup.addAll(userListHavingGroupsToReturn);
            resultList = this.fetchAllUsers(usersWithGroup);
            userListToReturn.addAll((Collection)resultList.get(0));
            userListToReturn.addAll((Collection)resultList.get(1));
            if (!startDate.equals("1970-01-01") || !endDate.equals(currentDate.toString())) {
                LOGGER.debug("Retrieving users within the specified date range.");
                if (loginBasedFilter.equals("neverLoggedInUser")) {
                    return new ArrayList<UserTemplate>();
                }
                return resultList.get(0) != null ? this.fetchUsersWithinStartAndLastDate((List)resultList.get(0), startDate, endDate) : null;
            }
            if (loginBasedFilter.equals("neverLoggedInUser")) {
                return (List)resultList.get(1);
            }
            if (loginBasedFilter.equals("loggedInUser")) {
                return (List)resultList.get(0);
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }

    public List<UserTemplate> getAllUsersWithGroups(String searchQuery, Boolean sortByLastLogin, List<String> groupSearchList, Boolean foundDirectory, long directoryId, int startIndex, Boolean isActive, Boolean limit, String startDate, String endDate, String loginBasedFilter) {
        LOGGER.debug("Fetching active/inactive users having groups: getAllUsersWithGroups");
        String cacheKey = "foundDirectory" + foundDirectory + "directoryId" + directoryId + "status_is:" + isActive + "group:" + groupSearchList.hashCode() + searchQuery + "loginBasedFilter:" + loginBasedFilter;
        int totalUser = this.getTotalSearchResults(searchQuery);
        ArrayList<UserTemplate> userListToReturn = new ArrayList<UserTemplate>();
        ArrayList<UserTemplate> userListHavingGroupsToReturn = new ArrayList<UserTemplate>();
        ArrayList userListHavingGroups = new ArrayList();
        List<Object> resultList = new ArrayList();
        ArrayList users = new ArrayList();
        EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.FIRST_NAME).containing((Object)searchQuery), Restriction.on((Property)UserTermKeys.DISPLAY_NAME).containing((Object)searchQuery)}), Restriction.on((Property)UserTermKeys.ACTIVE).exactlyMatching((Object)isActive)})).startingAt(0).returningAtMost(totalUser);
        LocalDate currentDate = LocalDate.now();
        LOGGER.info("current date :" + currentDate);
        try {
            if (foundDirectory.booleanValue()) {
                users.addAll(directoryManager.searchUsers(directoryId, query));
            } else {
                List directories = directoryManager.findAllDirectories();
                for (Directory directory : directories) {
                    users.addAll(directoryManager.searchUsers(directory.getId().longValue(), query));
                }
            }
            if (limit.booleanValue()) {
                users.parallelStream().forEach(user -> {
                    for (String group : groupSearchList) {
                        try {
                            if (!directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), group)) continue;
                            userListHavingGroups.add(new UserTemplate(user));
                            break;
                        }
                        catch (Exception e) {
                            LOGGER.debug("Getting error while fetching groups:" + e);
                        }
                    }
                });
                userListHavingGroupsToReturn.addAll(userListHavingGroups);
                if (!BooleanUtils.toBoolean((Boolean)sortByLastLogin) && startDate.equals("1970-01-01") && endDate.equals(currentDate.toString()) && loginBasedFilter.equals("bothUser")) {
                    return userListHavingGroupsToReturn;
                }
                ArrayList usersWithGroup = new ArrayList();
                usersWithGroup.addAll(userListHavingGroupsToReturn);
                resultList = this.fetchAllUsers(usersWithGroup);
                userListToReturn.addAll((Collection)resultList.get(0));
                userListToReturn.addAll((Collection)resultList.get(1));
                if (!startDate.equals("1970-01-01") || !endDate.equals(currentDate.toString())) {
                    LOGGER.debug("Retrieving users within the specified date range.");
                    if (loginBasedFilter.equals("neverLoggedInUser")) {
                        return new ArrayList<UserTemplate>();
                    }
                    return resultList.get(0) != null ? this.fetchUsersWithinStartAndLastDate((List)resultList.get(0), startDate, endDate) : null;
                }
                if (loginBasedFilter.equals("neverLoggedInUser")) {
                    return (List)resultList.get(1);
                }
                if (loginBasedFilter.equals("loggedInUser")) {
                    return (List)resultList.get(0);
                }
                return userListToReturn;
            }
            block3: for (User user2 : users.subList(startIndex, users.size())) {
                for (String group : groupSearchList) {
                    if (!directoryManager.isUserDirectGroupMember(user2.getDirectoryId(), user2.getName(), group)) continue;
                    userListToReturn.add(new UserTemplate(user2));
                    continue block3;
                }
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
        }
        return userListToReturn;
    }

    public List<UserTemplate> fetchUsersWithinStartAndLastDate(List<UserTemplate> userListToReturn, String startDate, String endDate) throws ParseException {
        LOGGER.debug("Fetching users within the specified date range..");
        SimpleDateFormat formatter = new SimpleDateFormat("yyyy-MM-dd");
        Date start_Date = formatter.parse(startDate);
        Date end_Date = formatter.parse(endDate);
        List<UserTemplate> filteredUserList = userListToReturn.parallelStream().filter(user -> {
            Date lastLoginDate = CommonUserUtils.getLastLoginDate(user.getName(), user.getDirectoryId());
            if (lastLoginDate != null) {
                long loginTime = lastLoginDate.getTime();
                return loginTime >= start_Date.getTime() && loginTime <= end_Date.getTime() + TimeUnit.DAYS.toMillis(1L);
            }
            return false;
        }).collect(Collectors.toList());
        return filteredUserList;
    }

    private List<String> fetchGroups() throws DirectoryNotFoundException, OperationFailedException {
        this.crowdService = (CrowdService)ComponentLocator.getComponent(CrowdService.class);
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"")).returningAtMost(Integer.MAX_VALUE);
        HashSet<String> uniqueGroupNames = new HashSet<String>();
        List allDirectories = directoryManager.findAllDirectories();
        for (Directory directory : allDirectories) {
            List groups = directoryManager.searchGroups(directory.getId().longValue(), query);
            for (Group group : groups) {
                uniqueGroupNames.add(group.getName());
            }
        }
        return new ArrayList<String>(uniqueGroupNames);
    }

    public void doActionOnUser() throws MembershipNotFoundException, DirectoryPermissionException, DirectoryNotFoundException, OperationFailedException, ReadOnlyGroupException {
        String actionOnUser = settings.getActionOnUser();
        if (actionOnUser.equals("autoDeactivateUser")) {
            LOGGER.debug("Within the auto-deactivation process for users.");
            this.deactivateUsers();
            LOGGER.info("User Auto-deactivation completed...");
        } else if (actionOnUser.equals("removeGroupsFromUsers")) {
            LOGGER.debug("Within the process of removing groups from users.");
            this.removeGroupsFromUser();
            if (settings.getAutoDeactivateNeverLoggedInUser().booleanValue()) {
                LOGGER.debug("Remove Groups From Never-Logged-In Users toggle is enabled. Processing group removal for never-logged-in users. Action selected: " + actionOnUser);
                this.removeGroupsFromNeverLoggedInUser();
            } else {
                LOGGER.debug("Remove Groups From Never-Logged-In Users toggle is disabled. Skipping group removal for never-logged-in users. Action selected: " + actionOnUser);
            }
            LOGGER.info("Group Removal Process Completed...");
        } else if (actionOnUser.equals("removeGroupsAndAutoDeactivate")) {
            LOGGER.debug("Within the automated process of deactivating users and removing groups.");
            this.removeGroupsFromUser();
            if (settings.getAutoDeactivateNeverLoggedInUser().booleanValue()) {
                LOGGER.debug("Remove Groups From Never-Logged-In Users toggle is enabled. Processing deactivation and group removal for never-logged-in users. Action selected: " + actionOnUser);
                this.removeGroupsFromNeverLoggedInUser();
            } else {
                LOGGER.debug("Remove Groups From Never-Logged-In Users toggle is disabled. Processing deactivation and skipping group removal for never-logged-in users. Action selected: " + actionOnUser);
            }
            this.deactivateUsers();
            LOGGER.info("Auto-deactivation and Group Removal Process Completed...");
        }
    }

    public List<Group> getAllGroups() {
        this.crowdService = (CrowdService)ComponentLocator.getComponent(CrowdService.class);
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"")).returningAtMost(Integer.MAX_VALUE);
        ArrayList<Group> finalGroups = new ArrayList<Group>();
        List allDirectories = directoryManager.findAllDirectories();
        for (Directory directory : allDirectories) {
            List groups = null;
            try {
                groups = directoryManager.searchGroups(directory.getId().longValue(), query);
            }
            catch (DirectoryNotFoundException e) {
                throw new RuntimeException(e);
            }
            catch (OperationFailedException e) {
                throw new RuntimeException(e);
            }
            finalGroups.addAll(groups);
        }
        return finalGroups;
    }

    public Boolean isSystemAdmin() {
        UserProfile userProfile;
        String CurrentLoggedInUser;
        Boolean isAdmin = Boolean.FALSE;
        UserProfile user = this.userManager.getRemoteUser();
        String string = CurrentLoggedInUser = user == null ? "" : user.getUsername();
        if (StringUtils.isNotBlank((CharSequence)CurrentLoggedInUser) && (userProfile = this.userManager.getUserProfile(CurrentLoggedInUser)) != null && this.userManager.isAdmin(userProfile.getUserKey())) {
            return Boolean.TRUE;
        }
        return isAdmin;
    }

    public long getRemainingLicenseDays() {
        try {
            LocalDate expiryDate;
            String expiryDateString = settings.getLicenseExpireDate();
            if (StringUtils.isBlank((CharSequence)expiryDateString)) {
                return -1L;
            }
            DateTimeFormatter formatter = DateTimeFormatter.ofPattern("yyyy-MM-dd HH:mm:ss.SSS");
            try {
                expiryDate = LocalDateTime.parse(expiryDateString, formatter).toLocalDate();
            }
            catch (Exception parseException) {
                LOGGER.error("Invalid license expiry date format: {}. Expected format: yyyy-MM-dd HH:mm:ss.SSS", (Object)expiryDateString);
                return -1L;
            }
            LocalDate currentDate = LocalDate.now();
            long daysRemaining = ChronoUnit.DAYS.between(currentDate, expiryDate);
            if (daysRemaining > 30L) {
                return 30L;
            }
            return daysRemaining > 0L ? daysRemaining : 0L;
        }
        catch (Exception e) {
            LOGGER.error("Error calculating remaining license days: ", (Throwable)e);
            return -1L;
        }
    }
}

