/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.servlet.MoAjaxExportUser;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TriggerExportServlet
extends HttpServlet {
    private static Logger LOGGER = LoggerFactory.getLogger(TriggerExportServlet.class);
    private final UserManager userManager;
    private final DirectoryManager directoryManager;
    private final UserManagementPluginSettings settings;
    private final CommonUserUtils commonUserUtils;
    private final CrowdService crowdService;
    private final UserManagementPluginHandler userManagementPluginHandler;
    private final Map<String, List<String>> usersAndGroup = new ConcurrentHashMap<String, List<String>>();
    public List<UserTemplate> userTemplates = new ArrayList<UserTemplate>();
    public Map<String, Boolean> exportOptions = new HashMap<String, Boolean>();
    public List<String> groupSearchKeyList = null;
    public String usernameSearchKeyword = null;
    public String userSearchFilter = null;
    public String selectedDirectory = "";
    public long selectedDirectoryId = 0L;
    public String loginBasedFilter = null;
    public String startDate;
    public String endDate;

    public TriggerExportServlet(UserManager userManager, DirectoryManager directoryManager, UserManagementPluginSettings settings, CommonUserUtils commonUserUtils, CrowdService crowdService, UserManagementPluginHandler userManagementPluginHandler) {
        this.userManager = userManager;
        this.directoryManager = directoryManager;
        this.settings = settings;
        this.commonUserUtils = commonUserUtils;
        this.crowdService = crowdService;
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        String header;
        block23: {
            this.exportOptions.put("Username", Boolean.parseBoolean(request.getParameter("Name")));
            this.exportOptions.put("Email", Boolean.parseBoolean(request.getParameter("Email")));
            this.exportOptions.put("FullName", Boolean.parseBoolean(request.getParameter("FullName")));
            this.exportOptions.put("Groups", Boolean.parseBoolean(request.getParameter("Groups")));
            this.exportOptions.put("Status", Boolean.parseBoolean(request.getParameter("Status")));
            this.exportOptions.put("Directory", Boolean.parseBoolean(request.getParameter("Directory")));
            this.exportOptions.put("LastLoginDate", Boolean.parseBoolean(request.getParameter("LastLoginDate")));
            header = request.getHeader("referer");
            if (header != null && header.contains("/servlet/usermanagement/configure")) {
                int startIndex;
                String[] groupSearchKey = request.getParameterValues("groupSearchKey") != null ? request.getParameterValues("groupSearchKey") : new String[]{};
                this.groupSearchKeyList = Arrays.stream(groupSearchKey).filter(StringUtils::isNotBlank).collect(Collectors.toList());
                if (this.groupSearchKeyList.isEmpty()) {
                    this.groupSearchKeyList = null;
                }
                this.usernameSearchKeyword = request.getParameter("usernameSearchKeyword") == null ? "" : request.getParameter("usernameSearchKeyword");
                this.loginBasedFilter = request.getParameter("loginBasedFilter");
                if (this.loginBasedFilter == null) {
                    this.loginBasedFilter = "bothUser";
                }
                if (request.getParameter("directory") == null) {
                    this.selectedDirectory = "";
                    this.selectedDirectoryId = -1L;
                } else {
                    this.selectedDirectory = request.getParameter("directory");
                    try {
                        this.selectedDirectoryId = this.directoryManager.findDirectoryByName(this.selectedDirectory).getId();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error in finding Selected Directory:" + e.getMessage());
                        this.selectedDirectoryId = -1L;
                    }
                }
                this.startDate = this.settings.getStart_date_lastLoginTime();
                this.endDate = this.settings.getEnd_date_lastLoginTime();
                this.userSearchFilter = request.getParameter("userSearchFilter");
                boolean sortByLastLogin = BooleanUtils.toBoolean((String)request.getParameter("sortByLastLogin"));
                int n = startIndex = StringUtils.isBlank((CharSequence)request.getParameter("startIndex")) ? 0 : Integer.parseInt(request.getParameter("startIndex"));
                if (this.userSearchFilter == null) {
                    this.userSearchFilter = "all";
                }
                try {
                    if (this.groupSearchKeyList == null || this.groupSearchKeyList.size() == 0) {
                        this.userTemplates = this.selectedDirectoryId == -1L ? (this.userSearchFilter.equals("all") ? this.commonUserUtils.getAllUsersWithAllUserCase(this.usernameSearchKeyword, sortByLastLogin, Boolean.FALSE, 0L, this.startDate, this.endDate, startIndex, this.loginBasedFilter) : (this.userSearchFilter.equals("active") ? this.commonUserUtils.getAllUsers(this.usernameSearchKeyword, sortByLastLogin, Boolean.FALSE, 0L, startIndex, true, true, this.startDate, this.endDate, this.loginBasedFilter) : this.commonUserUtils.getAllUsers(this.usernameSearchKeyword, sortByLastLogin, Boolean.FALSE, 0L, startIndex, false, true, this.startDate, this.endDate, this.loginBasedFilter))) : (this.userSearchFilter.equals("all") ? this.commonUserUtils.getAllUsersWithAllUserCase(this.usernameSearchKeyword, sortByLastLogin, Boolean.TRUE, this.selectedDirectoryId, this.startDate, this.endDate, startIndex, this.loginBasedFilter) : (this.userSearchFilter.equals("active") ? this.commonUserUtils.getAllUsers(this.usernameSearchKeyword, sortByLastLogin, Boolean.TRUE, this.selectedDirectoryId, startIndex, true, true, this.startDate, this.endDate, this.loginBasedFilter) : this.commonUserUtils.getAllUsers(this.usernameSearchKeyword, sortByLastLogin, Boolean.TRUE, this.selectedDirectoryId, startIndex, false, true, this.startDate, this.endDate, this.loginBasedFilter)));
                        break block23;
                    }
                    if (this.selectedDirectoryId == -1L) {
                        this.userTemplates = this.userSearchFilter.equals("all") ? this.commonUserUtils.getAllUsersWithGroupsForAll(this.usernameSearchKeyword, sortByLastLogin, this.groupSearchKeyList, Boolean.FALSE, 0L, this.startDate, this.endDate, startIndex, this.loginBasedFilter) : (this.userSearchFilter.equals("active") ? this.commonUserUtils.getAllUsersWithGroups(this.usernameSearchKeyword, sortByLastLogin, this.groupSearchKeyList, Boolean.FALSE, 0L, startIndex, true, true, this.startDate, this.endDate, this.loginBasedFilter) : this.commonUserUtils.getAllUsersWithGroups(this.usernameSearchKeyword, sortByLastLogin, this.groupSearchKeyList, Boolean.FALSE, 0L, startIndex, false, true, this.startDate, this.endDate, this.loginBasedFilter));
                        break block23;
                    }
                    if (this.userSearchFilter.equals("all")) {
                        this.userTemplates = this.commonUserUtils.getAllUsersWithGroupsForAll(this.usernameSearchKeyword, sortByLastLogin, this.groupSearchKeyList, Boolean.TRUE, this.selectedDirectoryId, this.startDate, this.endDate, startIndex, this.loginBasedFilter);
                        break block23;
                    }
                    if (this.userSearchFilter.equals("active")) {
                        this.userTemplates = this.commonUserUtils.getAllUsersWithGroups(this.usernameSearchKeyword, sortByLastLogin, this.groupSearchKeyList, Boolean.TRUE, this.selectedDirectoryId, startIndex, true, true, this.startDate, this.endDate, this.loginBasedFilter);
                        break block23;
                    }
                    this.userTemplates = this.commonUserUtils.getAllUsersWithGroups(this.usernameSearchKeyword, sortByLastLogin, this.groupSearchKeyList, Boolean.TRUE, this.selectedDirectoryId, startIndex, false, true, this.startDate, this.endDate, this.loginBasedFilter);
                }
                catch (Exception e) {
                    LOGGER.error("Error while fetching users:" + e);
                }
            } else {
                EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)""), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)"")})})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
                ArrayList userList = new ArrayList();
                try {
                    List directories = this.directoryManager.findAllDirectories();
                    for (Directory directory : directories) {
                        userList.addAll(this.directoryManager.searchUsers(directory.getId().longValue(), query));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
                }
                try {
                    this.userTemplates = userList.parallelStream().map(UserTemplate::new).collect(Collectors.toList());
                }
                catch (Exception e) {
                    LOGGER.error("Exception:  " + e);
                }
                LOGGER.debug("total users are: " + this.userTemplates.size());
            }
        }
        if (header != null && header.contains("/servlet/usermanagement/configure") || this.exportOptions.get("Groups").equals(true)) {
            this.userTemplates.forEach(user -> {
                try {
                    MembershipQuery query1 = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(user.getName()).returningAtMost(Integer.MAX_VALUE);
                    Iterable groupIterable = this.crowdService.search((Query)query1);
                    ArrayList<String> groupNames = new ArrayList<String>();
                    for (Group group : groupIterable) {
                        groupNames.add(group.getName());
                    }
                    this.usersAndGroup.put(user.getName(), groupNames);
                }
                catch (Exception e) {
                    LOGGER.debug("Error processing user: " + user.getName() + ", " + e.getMessage());
                }
            });
        }
        String username = StringUtils.defaultString((String)request.getRemoteUser());
        File exportFile = new File(System.getProperty("java.io.tmpdir"), "export_" + username + ".csv");
        File doneMarker = new File(exportFile.getAbsolutePath() + ".done");
        if (exportFile.exists()) {
            exportFile.delete();
        }
        if (doneMarker.exists()) {
            doneMarker.delete();
        }
        MoAjaxExportUser exportService = new MoAjaxExportUser(username, exportFile, this.userManager, this.directoryManager, this.settings, this.commonUserUtils, this.crowdService, this.userManagementPluginHandler, this.exportOptions, this.userTemplates, this.usersAndGroup);
        new Thread(exportService).start();
        response.setContentType("application/json");
        response.getWriter().write("{\"status\":\"started\"}");
    }
}

