/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.servlet;

import com.atlassian.annotations.security.UnrestrictedAccess;
import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.application.Application;
import com.atlassian.crowd.model.application.ApplicationDirectoryMapping;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.transaction.TransactionCallback;
import com.atlassian.sal.api.transaction.TransactionTemplate;
import com.miniorange.usermanagement.MultiReadHttpServletRequest;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.util.List;
import java.util.Map;
import javax.persistence.CascadeType;
import javax.persistence.FetchType;
import javax.persistence.OneToMany;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.maven.artifact.versioning.DefaultArtifactVersion;
import org.json.JSONObject;
import org.json.JSONTokener;
import org.w3c.dom.Document;
import org.w3c.dom.Node;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;

@UnrestrictedAccess
public class MoLoginFilter
implements Filter {
    private static Log LOGGER = LogFactory.getLog(MoLoginFilter.class);
    private UserManagementPluginSettings settings;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private CrowdService crowdService;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private DirectoryManager directoryManager;
    private ApplicationManager applicationManager;
    private TransactionTemplate transactionTemplate;
    private CommonUserUtils commonUserUtils;
    private UserManagementPluginHandler userManagementPluginHandler;
    private ApplicationProperties applicationProperties;
    @OneToMany(fetch=FetchType.EAGER, cascade={CascadeType.ALL})
    private User user;
    private UserTemplate userTemplate;
    String userName = "";

    public MoLoginFilter(UserManagementPluginSettings settings, CrowdService crowdService, DirectoryManager directoryManager, CommonUserUtils commonUserUtils, ApplicationManager applicationManager, TransactionTemplate transactionTemplate, UserManagementPluginHandler userManagementPluginHandler) {
        this.settings = settings;
        this.crowdService = crowdService;
        this.directoryManager = directoryManager;
        this.transactionTemplate = transactionTemplate;
        this.commonUserUtils = commonUserUtils;
        this.applicationManager = applicationManager;
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    public MoLoginFilter() {
    }

    public void init(FilterConfig filterConfig) throws ServletException {
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain chain) throws IOException, ServletException {
        MultiReadHttpServletRequest multiReadRequest;
        block28: {
            LOGGER.debug((Object)"MoLoginFilter");
            this.applicationProperties = (ApplicationProperties)ComponentLocator.getComponent(ApplicationProperties.class);
            if (this.applicationProperties != null) {
                DefaultArtifactVersion versionToCheck = new DefaultArtifactVersion("6.3.1");
                DefaultArtifactVersion currentVersion = new DefaultArtifactVersion(this.applicationProperties.getVersion());
                if (currentVersion.compareTo(versionToCheck) >= 0) {
                    chain.doFilter(request, response);
                }
            }
            HttpServletRequest httpRequest = (HttpServletRequest)request;
            StringBuffer url = httpRequest.getRequestURL();
            multiReadRequest = new MultiReadHttpServletRequest((HttpServletRequest)request);
            try {
                Boolean isAuthenticate;
                PasswordCredential passwordCredential;
                String pwd = "";
                if (url.toString().contains("/rest/tsv/1.0/authenticate")) {
                    String body = new String(multiReadRequest.getInputStream().readAllBytes());
                    if (StringUtils.isNotBlank((CharSequence)body)) {
                        JSONObject jsonBody = new JSONObject(body);
                        this.userName = jsonBody.getString("username");
                        pwd = jsonBody.getString("password");
                    }
                } else if (url.toString().contains("/rest/usermanagement/1/authentication")) {
                    String line;
                    StringBuilder requestBody = new StringBuilder();
                    BufferedReader reader = multiReadRequest.getReader();
                    while ((line = reader.readLine()) != null) {
                        requestBody.append(line);
                    }
                    String body = requestBody.toString();
                    pwd = this.extractPasswordValueFromXML(body);
                    Map parameterMap = multiReadRequest.getParameterMap();
                    String[] parameterValues = (String[])parameterMap.get("username");
                    this.userName = parameterValues[0];
                } else {
                    BufferedReader data = multiReadRequest.getReader();
                    JSONTokener tokener = new JSONTokener((Reader)data);
                    JSONObject json = new JSONObject(tokener);
                    this.userName = json.get("username").toString();
                    pwd = json.get("password").toString();
                }
                if (this.userName == null || pwd == null) {
                    chain.doFilter((ServletRequest)multiReadRequest, response);
                    return;
                }
                this.user = null;
                this.userTemplate = null;
                this.transactionTemplate.execute(new TransactionCallback(){

                    public Object doInTransaction() {
                        try {
                            Application application = MoLoginFilter.this.applicationManager.findByName("crowd");
                            List applicationDirectoryMappings = application.getApplicationDirectoryMappings();
                            LOGGER.debug((Object)"Searching user in directories");
                            for (ApplicationDirectoryMapping applicationDirectoryMapping : applicationDirectoryMappings) {
                                try {
                                    Directory directory = applicationDirectoryMapping.getDirectory();
                                    MoLoginFilter.this.user = (User)MoLoginFilter.this.directoryManager.findUserByName(directory.getId().longValue(), MoLoginFilter.this.userName);
                                    MoLoginFilter.this.userTemplate = new UserTemplate(MoLoginFilter.this.user);
                                    break;
                                }
                                catch (UserNotFoundException e) {
                                    LOGGER.debug((Object)("User does not exist in a directory, searching in next directory : " + e.getMessage()));
                                }
                                catch (Exception e) {
                                    LOGGER.error((Object)e.getMessage());
                                }
                            }
                        }
                        catch (Exception e) {
                            LOGGER.debug((Object)e.getMessage());
                        }
                        return null;
                    }
                });
                if (this.settings.getReActivateUser().booleanValue() && this.user != null && this.userTemplate != null && !this.user.isActive() && StringUtils.isNotBlank((CharSequence)this.userName)) {
                    LOGGER.debug((Object)"Activating user");
                    this.userTemplate.setActive(true);
                    this.directoryManager.updateUser(this.user.getDirectoryId(), this.userTemplate);
                    try {
                        passwordCredential = new PasswordCredential(pwd);
                        this.directoryManager.authenticateUser(this.user.getDirectoryId(), this.userName, passwordCredential);
                        isAuthenticate = true;
                        LOGGER.debug((Object)"user is authenticate...");
                        this.directoryManager.updateUser(this.user.getDirectoryId(), this.userTemplate);
                        try {
                            this.userManagementPluginHandler.storeAuditLogs(this.userName, httpRequest.getRemoteAddr(), "User Reactivated", "User '" + this.userName + "' was automatically reactivated and authenticated on login.", "Success");
                        }
                        catch (Exception ex) {
                            LOGGER.error((Object)("Failed to store audit log for successful reactivation: " + ex.getMessage()), (Throwable)ex);
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error((Object)("Authentication error : " + e.getMessage()));
                        this.userTemplate.setActive(false);
                        this.directoryManager.updateUser(this.user.getDirectoryId(), this.userTemplate);
                        isAuthenticate = false;
                        try {
                            this.userManagementPluginHandler.storeAuditLogs(this.userName, httpRequest.getRemoteAddr(), "User Reactivated", "Reactivation failed for user '" + this.userName + "' during login: " + e.getMessage(), "Error");
                        }
                        catch (Exception ex) {
                            LOGGER.error((Object)("Failed to store audit log for reactivation failure: " + ex.getMessage()), (Throwable)ex);
                        }
                    }
                    if (this.settings.getAddGroupsToReactiveUser().booleanValue() && isAuthenticate.booleanValue()) {
                        for (String group : this.settings.getAddGroups()) {
                            try {
                                this.directoryManager.addUserToGroup(this.user.getDirectoryId(), this.user.getName(), group);
                                LOGGER.debug((Object)("User is add to group : " + group));
                            }
                            catch (Exception e) {
                                LOGGER.debug((Object)("Error  :" + e));
                                throw new RuntimeException(e);
                            }
                        }
                    }
                    break block28;
                }
                if (!this.settings.getAddGroupsToActiveUser().booleanValue() || this.user == null || this.userTemplate == null || !this.user.isActive() || !StringUtils.isNotBlank((CharSequence)this.userName)) break block28;
                try {
                    passwordCredential = new PasswordCredential(pwd);
                    this.directoryManager.authenticateUser(this.user.getDirectoryId(), this.userName, passwordCredential);
                    isAuthenticate = true;
                }
                catch (Exception e) {
                    LOGGER.error((Object)("Authentication error : " + e.getMessage()));
                    this.userTemplate.setActive(false);
                    isAuthenticate = false;
                }
                if (isAuthenticate.booleanValue()) {
                    for (String group : this.settings.getGroupsAssignToActiveUsers()) {
                        try {
                            this.directoryManager.addUserToGroup(this.user.getDirectoryId(), this.user.getName(), group);
                            LOGGER.debug((Object)("User is add to group : " + group));
                        }
                        catch (Exception e) {
                            LOGGER.debug((Object)("Error  :" + e));
                            throw new RuntimeException(e);
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)"Error occurred while reactivating user : ", (Throwable)e);
            }
        }
        chain.doFilter((ServletRequest)multiReadRequest, response);
    }

    private String extractPasswordValueFromXML(String xmlBody) throws IOException, SAXException, ParserConfigurationException {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        DocumentBuilder builder = factory.newDocumentBuilder();
        InputSource inputSource = new InputSource(new StringReader(xmlBody));
        Document document = builder.parse(inputSource);
        Node passwordValueNode = document.getElementsByTagName("value").item(0);
        return passwordValueNode.getTextContent();
    }

    public void destroy() {
    }

    public CrowdService getCrowdService() {
        return this.crowdService;
    }

    public void setCrowdService(CrowdService crowdService) {
        this.crowdService = crowdService;
    }
}

