/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.scheduler;

import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.JobRunnerRequest;
import com.atlassian.scheduler.JobRunnerResponse;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.scheduler.UserDeactivateService;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.net.InetAddress;
import java.time.Instant;
import java.util.Date;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDeactivateTask
implements JobRunner {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDeactivateTask.class);
    public CommonUserUtils commonUserUtils;
    public UserManagementPluginSettings settings;
    public UserDeactivateService userDeactivateService;
    public UserManagementPluginHandler userManagementPluginHandler;

    public UserDeactivateTask(CommonUserUtils commonUserUtils, UserManagementPluginSettings settings, UserDeactivateService userDeactivateService, UserManagementPluginHandler userManagementPluginHandler) {
        this.commonUserUtils = commonUserUtils;
        this.settings = settings;
        this.userDeactivateService = userDeactivateService;
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    public JobRunnerResponse runJob(JobRunnerRequest jobRunnerRequest) {
        block5: {
            try {
                LOGGER.debug("Running the job.....");
                if (this.settings.checkLicenseValidation(null)) {
                    try {
                        InetAddress ip = InetAddress.getLocalHost();
                        this.userManagementPluginHandler.storeAuditLogs("system", ip.getHostAddress(), "Scheduler Triggered", "Scheduler Triggered for the selected action: " + this.settings.getActionOnUser() + ".", "Success");
                    }
                    catch (Exception e) {
                        LOGGER.error("Error storing scheduler triggered audit log", (Throwable)e);
                    }
                    this.commonUserUtils.doActionOnUser();
                    this.settings.setLastSchedulerRunTime(new Date());
                    long refreshIntervalInMiliseconds = this.userDeactivateService.getRefreshIntervalInMilis();
                    Date nextRun = Date.from(Instant.now().plusMillis(refreshIntervalInMiliseconds));
                    this.settings.setNextScheduledRunTime(nextRun);
                    break block5;
                }
                LOGGER.error("License validation failed: An error occurred during the validation process.");
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while executing the process", (Throwable)e);
            }
        }
        return JobRunnerResponse.success();
    }
}

