/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.handlers;

import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.json.jsonorg.JSONObject;
import com.miniorange.usermanagement.Customer;
import com.miniorange.usermanagement.exceptions.MoPluginException;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.AuditLogDetailsUtils;
import com.miniorange.usermanagement.utils.MoHttpUtils;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserManagementPluginHandler {
    private static Logger LOGGER = LoggerFactory.getLogger(UserManagementPluginHandler.class);
    private UserManagementPluginSettings settings;

    @Autowired
    public UserManagementPluginHandler(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    public void saveUserManagementSettings(long days, long limitDaysForNeverLoggedUsers, long dndPeriod, long mailPeriod, boolean neverloggedinusers, boolean mailNotification, String mailtext, String mailsubject, List<String> excludeUsersList, List<String> excludeGroupsList, List<String> groupSearchList, String actionOnUser, String refreshInterval, String customRefreshInterval, String customRefreshIntervalUnit, Boolean enableRegexForGroupsToRemove, String regexPatternForExcludeGroups) {
        LOGGER.debug("Saving User Management Settings");
        try {
            this.settings.setNumberOfDaysForNeverLoggedUsers(limitDaysForNeverLoggedUsers);
            this.settings.setNumberOfDays(days);
            this.settings.setDoNotDeactivatePeriod(dndPeriod);
            this.settings.setMailPeriod(mailPeriod);
            this.settings.setMailText(mailtext);
            this.settings.setSubText(mailsubject);
            this.settings.setAutoDeactivateNeverLoggedInUser(neverloggedinusers);
            this.settings.setMailNotification(mailNotification);
            this.settings.setExcludeUsersList(excludeUsersList);
            this.settings.setExcludeGroupsList(excludeGroupsList);
            this.settings.setGroupsToRemoveList(groupSearchList);
            this.settings.setActionOnUser(actionOnUser);
            this.settings.setRefreshInterval(refreshInterval);
            this.settings.setCustomRefreshInterval(customRefreshInterval);
            this.settings.setCustomRefreshIntervalUnit(customRefreshIntervalUnit);
            this.settings.setEnableRegexForGroups(enableRegexForGroupsToRemove);
            this.settings.setRegexPatternForGroups(regexPatternForExcludeGroups);
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while scheduling job.", (Throwable)e);
        }
    }

    public UserManagementPluginSettings getSettings() {
        return this.settings;
    }

    public void setSettings(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    public Customer fetchCustomer(String email, String password) {
        try {
            Customer customer = new Customer(email, password, "", "", "");
            String json = customer.getJSON();
            String response = MoHttpUtils.sendPostRequest("https://login.xecurify.com/moas/rest/customer/key", json, "application/json", UserManagementPluginHandler.getAuthorizationHeaders(Long.valueOf("16555"), "fFd2XcvTGDemZvbw1bcUesNJWEqKbbUq"));
            if (UserManagementPluginHandler.isJSONString(response).booleanValue()) {
                JSONObject jsonObj = new JSONObject(response);
                String statusNode = jsonObj.getString("status");
                if (StringUtils.equalsIgnoreCase((CharSequence)statusNode.toString(), (CharSequence)"success")) {
                    Long customerId = Long.valueOf(jsonObj.getString("id"));
                    customer = new Customer(customerId, email, "", "", "", "");
                    customer.setApiKey(jsonObj.getString("apiKey"));
                    customer.setTokenKey(jsonObj.getString("token"));
                    return customer;
                }
                throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, "Couldn't verify your accoumt. Please contact support at info@miniorange.com", null);
            }
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, response, null);
        }
        catch (Exception e) {
            LOGGER.error("An account verification error occurred ", (Throwable)e);
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public static HashMap<String, String> getAuthorizationHeaders(Long customerId, String apiKey) {
        HashMap<String, String> headers = new HashMap<String, String>();
        Long timestamp = System.currentTimeMillis();
        String stringToHash = customerId + timestamp + apiKey;
        String hashValue = DigestUtils.sha512Hex((String)stringToHash);
        headers.put("Customer-Key", String.valueOf(customerId));
        headers.put("Timestamp", String.valueOf(timestamp));
        headers.put("Authorization", hashValue);
        return headers;
    }

    public Boolean verifyLicense(UserManagementPluginSettings settings, String key) {
        try {
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerKey", settings.getCustomerID());
            jsonObject.put("code", key);
            jsonObject.put("isActive", false);
            JSONObject baseUrl = new JSONObject();
            baseUrl.put("field1", settings.getSpBaseUrl());
            jsonObject.put("additionalFields", baseUrl);
            String json = jsonObject.toString();
            String response = MoHttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/backupcode/verify", json, "application/json", UserManagementPluginHandler.getAuthorizationHeaders(Long.valueOf(settings.getCustomerID()), settings.getCustomerAPIKey()));
            LOGGER.debug("Verify license response: " + response);
            if (UserManagementPluginHandler.isJSONString(response).booleanValue()) {
                JSONObject responseJson = new JSONObject(response);
                String statusNode = responseJson.getString("status");
                String isExpired = responseJson.getString("isExpired");
                LOGGER.debug(" statusNode : " + statusNode);
                if (StringUtils.equalsIgnoreCase((CharSequence)statusNode.toString(), (CharSequence)"success") && StringUtils.equalsIgnoreCase((CharSequence)isExpired.toString(), (CharSequence)"false")) {
                    this.getLicencedUsers(settings);
                    settings.setCustomerLicenseKey(key);
                    settings.setLicenseVerified(Boolean.TRUE);
                    return true;
                }
                return false;
            }
            LOGGER.debug("Please contact support. Response String: " + response);
            return false;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while verifying license key", (Throwable)e);
            return false;
        }
    }

    public void getLicencedUsers(UserManagementPluginSettings settings) {
        try {
            JSONObject responseJson;
            String statusNode;
            JSONObject jsonObject = new JSONObject();
            jsonObject.put("customerId", settings.getCustomerID());
            jsonObject.put("applicationName", "crowd_user_management_premium_plan_dc");
            String json = jsonObject.toString();
            String response = MoHttpUtils.sendPostRequest("https://login.xecurify.com/moas/rest/customer/license", json, "application/json", UserManagementPluginHandler.getAuthorizationHeaders(Long.valueOf(settings.getCustomerID()), settings.getCustomerAPIKey()));
            LOGGER.debug("check customer license response: " + response);
            if (UserManagementPluginHandler.isJSONString(response).booleanValue() && StringUtils.equalsIgnoreCase((CharSequence)(statusNode = (responseJson = new JSONObject(response)).getString("status")).toString(), (CharSequence)"success")) {
                if (responseJson.has("licenseType")) {
                    settings.setLicenseType(responseJson.getString("licenseType"));
                }
                if (responseJson.has("licenseExpiry")) {
                    settings.setLicenseExpireDate(responseJson.getString("licenseExpiry"));
                }
                if (responseJson.has("noOfUsers")) {
                    String noOfUsers = responseJson.getString("noOfUsers");
                    Integer licensedUsers = Integer.valueOf(noOfUsers);
                    LOGGER.debug("no of license in user = " + licensedUsers);
                    if (licensedUsers > 0) {
                        settings.setLicencedUsers(licensedUsers);
                        return;
                    }
                }
            }
            LOGGER.error("Please contact support. Response String: " + response);
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, response, null);
        }
        catch (Exception e) {
            LOGGER.error("an error occurred while getting licensed users", (Throwable)e);
            throw new MoPluginException(MoPluginException.PluginErrorCode.UNKNOWN, "", e);
        }
    }

    public void deactivateAndRemoveCustomerAccount() {
        try {
            if (this.settings.getLicenseVerified().booleanValue()) {
                JSONObject jsonObject = new JSONObject();
                jsonObject.put("code", this.settings.getCustomerLicenseKey());
                jsonObject.put("customerKey", this.settings.getCustomerID());
                JSONObject additionalFields = new JSONObject();
                additionalFields.put("field1", this.settings.getSpBaseUrl());
                jsonObject.put("additionalFields", additionalFields);
                String json = jsonObject.toString();
                String response = MoHttpUtils.sendPostRequest("https://login.xecurify.com/moas/api/backupcode/updatestatus", json, "application/json", UserManagementPluginHandler.getAuthorizationHeaders(Long.valueOf(this.settings.getCustomerID()), this.settings.getCustomerAPIKey()));
                LOGGER.debug("Deactivate license response: " + response);
            }
            this.settings.removeCustomerAccount();
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while deactivating the license.", (Throwable)e);
            this.settings.removeCustomerAccount();
        }
    }

    private static Boolean isJSONString(String string) {
        try {
            new JSONObject(string);
        }
        catch (JSONException ex) {
            try {
                new JSONArray(string);
            }
            catch (JSONException ex1) {
                return false;
            }
        }
        return true;
    }

    public synchronized void storeAuditLogs(String username, String ip, String action, String description, String Status) {
        try {
            AuditLogDetailsUtils commonAuditLogDetails = new AuditLogDetailsUtils();
            commonAuditLogDetails.setUsername(username.trim());
            commonAuditLogDetails.setAction(action.trim());
            commonAuditLogDetails.setDescription(description.trim());
            commonAuditLogDetails.setIpAddress(ip.trim());
            commonAuditLogDetails.setStatus(Status.trim());
            Calendar calendar = Calendar.getInstance();
            long timeMilliSecs = calendar.getTimeInMillis();
            Date newdate = new Date(timeMilliSecs);
            SimpleDateFormat formatter = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z");
            commonAuditLogDetails.setDateAndTime(formatter.format(newdate));
            String jsonString = commonAuditLogDetails.toJsonString();
            if (jsonString == null) {
                throw new RuntimeException("Failed to convert audit log to JSON");
            }
            List<String> updateAuditList = this.settings.getAuditLogs();
            updateAuditList.add(jsonString);
            this.settings.setAuditLogs(updateAuditList);
        }
        catch (Exception e) {
            LOGGER.error("Error : " + e);
            throw new RuntimeException(e);
        }
    }

    public List<String> autoDeleteAuditLogs(List<String> auditLogsList, Integer pastDays, Integer numberOfEntriesToRetain) {
        LOGGER.debug("Started Auto Delete: Retain Top {} Logs", (Object)numberOfEntriesToRetain);
        if (auditLogsList == null || auditLogsList.isEmpty()) {
            return Collections.emptyList();
        }
        List<AuditLogDetailsUtils> parsedLogs = AuditLogDetailsUtils.fromJsonStringList(auditLogsList);
        if (parsedLogs.isEmpty()) {
            LOGGER.warn("No valid audit logs found after parsing");
            return Collections.emptyList();
        }
        SimpleDateFormat dateFormatter = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z");
        parsedLogs.sort((a, b) -> {
            try {
                Date dateA = dateFormatter.parse(a.getDateAndTime());
                Date dateB = dateFormatter.parse(b.getDateAndTime());
                return dateB.compareTo(dateA);
            }
            catch (ParseException e) {
                LOGGER.error("Error in sorted logs.", (Throwable)e);
                return 0;
            }
        });
        if (parsedLogs.size() > numberOfEntriesToRetain) {
            parsedLogs = parsedLogs.subList(0, numberOfEntriesToRetain);
        }
        parsedLogs.sort((a, b) -> {
            try {
                Date dateA = dateFormatter.parse(a.getDateAndTime());
                Date dateB = dateFormatter.parse(b.getDateAndTime());
                return dateA.compareTo(dateB);
            }
            catch (ParseException e) {
                LOGGER.error("Error while re-sorting logs .", (Throwable)e);
                return 0;
            }
        });
        List<String> updatedLogs = AuditLogDetailsUtils.toJsonStringList(parsedLogs);
        LOGGER.debug("Final logs retained: {}", (Object)updatedLogs.size());
        return updatedLogs;
    }
}

