/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.actions;

import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.IOException;
import java.io.Writer;
import java.security.Principal;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import java.util.stream.Collectors;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;

public class UserDashboardAction
extends HttpServlet {
    private static final Log LOGGER = LogFactory.getLog(UserDashboardAction.class);
    private static final String DASHBOARD_TEMPLATE = "/templates/dashboard.vm";
    private final TemplateRenderer renderer;
    private CommonUserUtils commonUserUtils;
    private UserManagementPluginSettings settings;
    private UserManager userManager;
    private String totalUsers = "";
    private String activatedUsers = "";
    private String deactivatedUsers = "";
    private String activeUsers = "";
    private String loggedInActiveUsers = "";
    private String neverLoggedInActiveUsers = "";
    private String inactiveUsers = "";
    private String licensedInactiveUsers = "";
    private String licensedActiveUsers = "";
    private String usedLicense = "";
    private String licenseTier = "";
    private String availableLicense = "";
    private String neverLoggedInUsers = "";
    Map<String, Map<Integer, Integer>> userStatusCounts = new HashMap<String, Map<Integer, Integer>>();
    private Queue<String> licensedActiveUsersList = new ConcurrentLinkedQueue<String>();
    private Queue<String> licensedInactiveUsersList = new ConcurrentLinkedQueue<String>();
    private Queue<String> activatedUserswithTimestamps = new ConcurrentLinkedQueue<String>();
    private Queue<String> deactivatedUsersWithTimestamps = new ConcurrentLinkedQueue<String>();
    private Queue<String> activeUsersList = new ConcurrentLinkedQueue<String>();
    private Queue<String> loggedInActiveUsersList = new ConcurrentLinkedQueue<String>();
    private Queue<String> neverLoggedInActiveUsersList = new ConcurrentLinkedQueue<String>();
    private Queue<String> inActiveUsersList = new ConcurrentLinkedQueue<String>();
    private Queue<String> neverLoggedInUsersList = new ConcurrentLinkedQueue<String>();
    private List<String> licensedUsersList = new ArrayList<String>();
    private List<com.atlassian.crowd.model.user.User> activatedUsersList = new ArrayList<com.atlassian.crowd.model.user.User>();
    private List<User> deactivatedUsersList = new ArrayList<User>();
    private final long dayInMillis = 86400000L;
    private String noOfDays = "";

    public UserDashboardAction(TemplateRenderer renderer, CommonUserUtils commonUserUtils, UserManagementPluginSettings settings, UserManager userManager) {
        this.renderer = renderer;
        this.commonUserUtils = commonUserUtils;
        this.settings = settings;
        this.userManager = userManager;
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws ServletException, IOException {
        LOGGER.debug((Object)" Dashboard doGet Method() called....");
        this.authenticateAdmin(request, response);
        this.UserDetails(request, response);
        Map<String, Object> context = this.initializeConfig();
        response.setContentType("text/html");
        LOGGER.debug((Object)"Rendered the dashboard template to doGet method");
        this.renderer.render(DASHBOARD_TEMPLATE, context, (Writer)response.getWriter());
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        LOGGER.debug((Object)"Dashboard doPost() method called ");
        this.authenticateAdmin(req, resp);
        String noOfDaysParam = req.getParameter("noOfDaysSubmitted");
        if (Boolean.parseBoolean(noOfDaysParam)) {
            String days = req.getParameter("noOfDays");
            this.settings.setNoOfDaysForUsersDashboard(days);
        }
        this.UserDetails(req, resp);
        Map<String, Object> context = this.initializeConfig();
        resp.setContentType("text/html");
        LOGGER.debug((Object)"Rendered the dashboard template to doPost method");
        this.renderer.render(DASHBOARD_TEMPLATE, context, (Writer)resp.getWriter());
    }

    private void UserDetails(HttpServletRequest request, HttpServletResponse response) {
        int[] intervals;
        LOGGER.debug((Object)"Initiating UserDetails processing");
        long currentTime = System.currentTimeMillis();
        this.noOfDays = this.settings.getNoOfDaysForUsersDashboard();
        long lastDay = currentTime - (long)Integer.parseInt(this.noOfDays) * this.dayInMillis;
        List<UserTemplate> allUsers = this.commonUserUtils.getAllUsers("", false, false, 0L, 0);
        this.activatedUsersList.clear();
        this.activatedUsersList.addAll(this.commonUserUtils.getActiveUsers());
        Set activatedUserNames = this.activatedUsersList.stream().map(Principal::getName).collect(Collectors.toSet());
        this.deactivatedUsersList.clear();
        if (allUsers != null) {
            this.deactivatedUsersList.addAll(allUsers.stream().filter(user -> !activatedUserNames.contains(user.getName())).collect(Collectors.toList()));
        }
        LOGGER.debug((Object)("Deactivated users count: " + this.deactivatedUsersList.size()));
        this.deactivatedUsersWithTimestamps.clear();
        this.deactivatedUsersWithTimestamps.addAll(this.deactivatedUsersList.stream().filter(user -> user != null && user.getName() != null).map(user -> {
            String creationTime = this.commonUserUtils.getUserCreationTime(user.getName(), user.getDirectoryId());
            return user.getName() + ";" + (creationTime != null ? creationTime : "N/A");
        }).collect(Collectors.toList()));
        LOGGER.debug((Object)("Processed deactivated users with timestamps: " + this.deactivatedUsersWithTimestamps.size()));
        this.activatedUserswithTimestamps.clear();
        this.activeUsersList.clear();
        this.loggedInActiveUsersList.clear();
        this.neverLoggedInActiveUsersList.clear();
        this.inActiveUsersList.clear();
        this.licensedActiveUsersList.clear();
        this.licensedInactiveUsersList.clear();
        this.neverLoggedInUsersList.clear();
        ConcurrentHashMap<Integer, Integer> activeCounts = new ConcurrentHashMap<Integer, Integer>();
        ConcurrentHashMap<Integer, Integer> inactiveCounts = new ConcurrentHashMap<Integer, Integer>();
        for (int interval : intervals = new int[]{5, 15, 30, 60, 120}) {
            activeCounts.put(interval, 0);
            inactiveCounts.put(interval, 0);
        }
        LOGGER.debug((Object)"Initialized interval buckets for user activity");
        ExecutorService executorService = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
        this.activatedUsersList.forEach(user -> executorService.submit(() -> {
            try {
                String username = user.getName();
                Date lastLoginDate = CommonUserUtils.getLastLoginDate(username, user.getDirectoryId());
                boolean isNeverLoggedIn = lastLoginDate == null;
                long userTime = isNeverLoggedIn ? System.currentTimeMillis() : lastLoginDate.getTime();
                boolean isActive = userTime >= lastDay;
                boolean isLicensed = this.licensedUsersList.contains(username);
                Arrays.stream(intervals).forEach(interval -> {
                    if (userTime < currentTime - (long)interval * 86400000L) {
                        inactiveCounts.merge(interval, 1, Integer::sum);
                    } else {
                        activeCounts.merge(interval, 1, Integer::sum);
                    }
                });
                String lastLoginBefore = isNeverLoggedIn ? "Never Logged In" : String.valueOf(TimeUnit.MILLISECONDS.toDays(currentTime - userTime));
                String creationTime = this.commonUserUtils.getUserCreationTime(username, user.getDirectoryId());
                String userInfo = username + ";" + (creationTime != null ? creationTime : "N/A") + ";" + lastLoginBefore;
                this.activatedUserswithTimestamps.offer(userInfo);
                (isActive ? this.activeUsersList : this.inActiveUsersList).offer(userInfo);
                if (isLicensed) {
                    (isActive ? this.licensedActiveUsersList : this.licensedInactiveUsersList).offer(userInfo);
                    if (isNeverLoggedIn) {
                        this.neverLoggedInUsersList.offer(userInfo);
                    }
                }
                if (isActive) {
                    if (isNeverLoggedIn) {
                        this.neverLoggedInActiveUsersList.offer(userInfo);
                    } else {
                        this.loggedInActiveUsersList.offer(userInfo);
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error((Object)("Error processing user: " + user.getName()), (Throwable)e);
            }
        }));
        executorService.shutdown();
        try {
            if (!executorService.awaitTermination(60L, TimeUnit.SECONDS)) {
                executorService.shutdownNow();
            }
        }
        catch (InterruptedException e) {
            executorService.shutdownNow();
            Thread.currentThread().interrupt();
        }
        LOGGER.debug((Object)"Calculating user status counts and metrics");
        this.userStatusCounts.put("activeCounts", activeCounts);
        this.userStatusCounts.put("inactiveCounts", inactiveCounts);
        this.activatedUsers = String.valueOf(this.activatedUsersList.size());
        this.deactivatedUsers = String.valueOf(this.deactivatedUsersList.size());
        this.totalUsers = String.valueOf(this.activatedUsersList.size() + this.deactivatedUsersList.size());
        this.activeUsers = String.valueOf(this.activeUsersList.size());
        this.loggedInActiveUsers = String.valueOf(this.loggedInActiveUsersList.size());
        this.neverLoggedInActiveUsers = String.valueOf(this.neverLoggedInActiveUsersList.size());
        this.inactiveUsers = String.valueOf(this.inActiveUsersList.size());
        this.licensedInactiveUsers = String.valueOf(this.licensedInactiveUsersList.size());
        this.licensedActiveUsers = String.valueOf(this.licensedActiveUsersList.size());
        this.neverLoggedInUsers = String.valueOf(this.neverLoggedInUsersList.size());
        this.licenseTier = String.valueOf(this.settings.getLicencedUsers());
        this.usedLicense = String.valueOf(this.settings.getCrowdUserTier());
        this.availableLicense = this.licenseTier.equals("UNLIMITED") ? "-1" : String.valueOf(Math.max(Integer.parseInt(this.licenseTier) - Integer.parseInt(this.usedLicense), 0));
        LOGGER.debug((Object)("Final Metrics: activatedUsers=" + this.activatedUsers + ", deactivatedUsers=" + this.deactivatedUsers + ", totalUsers=" + this.totalUsers + ", activeUsers=" + this.activeUsers + ", loggedInActiveUsers=" + this.loggedInActiveUsers + ", neverLoggedInActiveUsers=" + this.neverLoggedInActiveUsers + ", inactiveUsers=" + this.inactiveUsers + ", licensedActive=" + this.licensedActiveUsers + ", licensedInactive=" + this.licensedInactiveUsers + ", neverLoggedIn=" + this.neverLoggedInUsers + ", usedLicense=" + this.usedLicense + ", licenseTier=" + this.licenseTier + ", availableLicense=" + this.availableLicense));
    }

    private Map<String, Object> initializeConfig() {
        LOGGER.debug((Object)"Initializing template context");
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("licensedInactiveUsers", this.licensedInactiveUsers);
        context.put("activatedUsers", this.activatedUsers);
        context.put("totalUsers", this.totalUsers);
        context.put("licensedActiveUsers", this.licensedActiveUsers);
        context.put("inactiveUsers", this.inactiveUsers);
        context.put("usedLicense", this.usedLicense);
        context.put("licenseTier", this.licenseTier);
        context.put("availableLicense", this.availableLicense);
        context.put("neverLoggedInUsers", this.neverLoggedInUsers);
        context.put("activeUsers", this.activeUsers);
        context.put("loggedInActiveUsers", this.loggedInActiveUsers);
        context.put("neverLoggedInActiveUsers", this.neverLoggedInActiveUsers);
        context.put("deactivatedUsers", this.deactivatedUsers);
        context.put("noOfDays", this.noOfDays);
        context.put("activatedUsersList", this.serializeToJson(this.activatedUserswithTimestamps));
        context.put("activeUsersList", this.serializeToJson(this.activeUsersList));
        context.put("loggedInActiveUsersList", this.serializeToJson(this.loggedInActiveUsersList));
        context.put("neverLoggedInActiveUsersList", this.serializeToJson(this.neverLoggedInActiveUsersList));
        context.put("inactiveUsersList", this.serializeToJson(this.inActiveUsersList));
        context.put("deactivatedUsersList", this.serializeToJson(this.deactivatedUsersWithTimestamps));
        context.put("licensedActiveUsersList", this.serializeToJson(this.licensedActiveUsersList));
        context.put("licensedInactiveUsersList", this.serializeToJson(this.licensedInactiveUsersList));
        context.put("neverLoggedInUsersList", this.serializeToJson(this.neverLoggedInUsersList));
        context.put("userStatusCounts", this.serializeToJson(this.userStatusCounts));
        context.put("settings", this.settings);
        context.put("baseUrl", this.settings.getBaseUrl());
        return context;
    }

    private String serializeToJson(Object data) {
        if (data == null) {
            return "null";
        }
        try {
            if (data instanceof Map) {
                return this.mapToJson((Map)data);
            }
            if (data instanceof Collection) {
                return this.collectionToJson((Collection)data);
            }
            return "\"" + this.escapeJson(data.toString()) + "\"";
        }
        catch (Exception e) {
            LOGGER.error((Object)"Failed to serialize data to JSON", (Throwable)e);
            return "{}";
        }
    }

    private String collectionToJson(Collection<?> collection) {
        if (collection == null || collection.isEmpty()) {
            return "[]";
        }
        return "[" + collection.stream().map(item -> "\"" + this.escapeJson(item.toString()) + "\"").collect(Collectors.joining(",")) + "]";
    }

    private String mapToJson(Map<?, ?> map) {
        if (map == null || map.isEmpty()) {
            return "{}";
        }
        return "{" + map.entrySet().stream().map(entry -> {
            String key = "\"" + this.escapeJson(entry.getKey().toString()) + "\"";
            String value = entry.getValue() instanceof Map ? this.mapToJson((Map)entry.getValue()) : "\"" + this.escapeJson(entry.getValue().toString()) + "\"";
            return key + ":" + value;
        }).collect(Collectors.joining(",")) + "}";
    }

    private String escapeJson(String input) {
        if (input == null) {
            return "";
        }
        return input.replace("\\", "\\\\").replace("\"", "\\\"").replace("\b", "\\b").replace("\f", "\\f").replace("\n", "\\n").replace("\r", "\\r").replace("\t", "\\t");
    }

    private void authenticateAdmin(HttpServletRequest request, HttpServletResponse response) throws IOException {
        UserProfile user = this.userManager.getRemoteUser();
        String baseURL = this.settings.getBaseUrl();
        if (user != null) {
            String username = user.getUsername();
            LOGGER.debug((Object)("Authenticating user: " + username));
            boolean isAdmin = this.userManager.isAdmin(user.getUserKey());
            if (!isAdmin) {
                LOGGER.error((Object)"You do not have admin access. Contact your administrator.");
                try {
                    response.sendRedirect(baseURL);
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Redirect failed: ", (Throwable)e);
                    throw new RuntimeException(e);
                }
                return;
            }
            if (!this.settings.checkLicenseValidation(response)) {
                LOGGER.debug((Object)"License invalid. Redirecting to license verification.");
                try {
                    response.sendRedirect(baseURL + "/plugins/servlet/crowd-user-molicense/doverify");
                }
                catch (IOException e) {
                    LOGGER.error((Object)"Redirect failed: ", (Throwable)e);
                    throw new RuntimeException(e);
                }
            }
        } else {
            LOGGER.debug((Object)"No authenticated user. Redirecting to base URL.");
            try {
                response.sendRedirect(baseURL);
            }
            catch (IOException e) {
                LOGGER.error((Object)"Redirect failed: ", (Throwable)e);
                throw new RuntimeException(e);
            }
        }
    }
}

