/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.actions;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.Map;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TroubleshootingAction
extends HttpServlet {
    private static final String TROUBLE_SHOOTING_ACTION_PATH = "/templates/troubleshooting.vm";
    private static final Logger LOGGER = LoggerFactory.getLogger(TroubleshootingAction.class);
    private TemplateRenderer renderer;
    private LoginUriProvider loginUriProvider;
    private UserManager userManager;
    private CommonUserUtils commonUserUtils;
    private final UserManagementPluginSettings settings;
    private String message;

    public TroubleshootingAction(TemplateRenderer renderer, LoginUriProvider loginUriProvider, UserManager userManager, CommonUserUtils commonUserUtils, UserManagementPluginSettings settings) {
        this.renderer = renderer;
        this.loginUriProvider = loginUriProvider;
        this.userManager = userManager;
        this.commonUserUtils = commonUserUtils;
        this.settings = settings;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.settings.checkLicenseValidation(resp)) {
            return;
        }
        if (this.doValidate().booleanValue()) {
            LOGGER.debug("After user validation troubleshooting....");
            this.message = "";
            resp.setContentType("text/html;charset=utf-8");
            this.renderer.render(TROUBLE_SHOOTING_ACTION_PATH, this.initializeTroubleshootingConfig(), (Writer)resp.getWriter());
        } else {
            resp.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.commonUserUtils.getUri(req), UserRole.ADMIN).toASCIIString());
        }
    }

    public Boolean doValidate() {
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            return true;
        }
        return false;
    }

    public Map<String, Object> initializeTroubleshootingConfig() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", "");
        context.put("settings", this.settings);
        context.put("contextPath", this.settings.getBaseUrl());
        return context;
    }
}

