/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.settings;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.manager.application.ApplicationManager;
import com.atlassian.crowd.manager.property.PropertyManager;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.util.I18nHelper;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import com.miniorange.usermanagement.constants.UserManagementPluginCommonConstants;
import com.miniorange.usermanagement.utils.AuditLogDetailsUtils;
import com.miniorange.usermanagement.utils.MoEncryptionUtils;
import java.io.IOException;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.math.NumberUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.util.HtmlUtils;

@Component
public class UserManagementPluginSettings {
    private static Logger LOGGER = LoggerFactory.getLogger(UserManagementPluginSettings.class);
    private PluginSettingsFactory pluginSettingsFactory;
    private PropertyManager propertyManager;
    private CrowdService crowdService;
    private PluginSettings pluginSettings;
    private I18nHelper i18nHelper;
    private ApplicationManager applicationManager;

    public UserManagementPluginSettings(PluginSettingsFactory pluginSettingsFactory, PropertyManager propertyManager, CrowdService crowdService, I18nHelper i18nHelper, ApplicationManager applicationManager) {
        this.pluginSettingsFactory = pluginSettingsFactory;
        this.pluginSettings = pluginSettingsFactory.createGlobalSettings();
        this.propertyManager = propertyManager;
        this.crowdService = crowdService;
        this.i18nHelper = i18nHelper;
        this.applicationManager = applicationManager;
    }

    public long getNumberOfDays() {
        String numberOfDays = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.NUMBER_OF_USER_INACTIVE_DAYS")), (CharSequence)"30");
        return NumberUtils.createInteger((String)numberOfDays).intValue();
    }

    public void setNumberOfDays(long numberOfDays) {
        this.pluginSettings.put("miniorange.usermanagement.NUMBER_OF_USER_INACTIVE_DAYS", (Object)String.valueOf(numberOfDays));
    }

    public long getNumberOfDaysForNeverLoggedUsers() {
        String numberOfDays = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.NUMBER_OF_DAYS_FOR_NEVER_LOGGED_USERS")), (CharSequence)"30");
        return NumberUtils.createInteger((String)numberOfDays).intValue();
    }

    public void setNumberOfDaysForNeverLoggedUsers(long numberOfDays) {
        this.pluginSettings.put("miniorange.usermanagement.NUMBER_OF_DAYS_FOR_NEVER_LOGGED_USERS", (Object)String.valueOf(numberOfDays));
    }

    public long getDoNotDeactivatePeriod() {
        String numberOfDays = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.DO_NOT_DEACTIVATE_DAYS")), (CharSequence)"0");
        return NumberUtils.createInteger((String)numberOfDays).intValue();
    }

    public void setDoNotDeactivatePeriod(long numberOfDays) {
        this.pluginSettings.put("miniorange.usermanagement.DO_NOT_DEACTIVATE_DAYS", (Object)String.valueOf(numberOfDays));
    }

    public long getMailPeriod() {
        String numberOfDays = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.MAIL_PERIOD")), (CharSequence)"1");
        return NumberUtils.createInteger((String)numberOfDays).intValue();
    }

    public void setMailPeriod(long numberOfDays) {
        this.pluginSettings.put("miniorange.usermanagement.MAIL_PERIOD", (Object)String.valueOf(numberOfDays));
    }

    public String getActionOnUser() {
        String getAction = (String)this.pluginSettings.get("miniorange.usermanagement.ACTION_ON_USER");
        return getAction == null ? "none" : getAction;
    }

    public void setActionOnUser(String actionOnUser) {
        this.pluginSettings.put("miniorange.usermanagement.ACTION_ON_USER", (Object)(actionOnUser != null ? actionOnUser : "none"));
    }

    public String getMailText() {
        String getAction = (String)this.pluginSettings.get("miniorange.usermanagement.MAIL_TEXT");
        return getAction == null || getAction.isEmpty() ? "Hello $$username$$,\n\nWe noticed that you logged in on $$last-login-date$$, and wanted to inform you that your account is set to be deactivated due to In-Active since $$days$$. If you have any questions or require further information, please don't hesitate to contact your Administrator.\n\nThank you." : getAction;
    }

    public void setMailText(String mailtext) {
        this.pluginSettings.put("miniorange.usermanagement.MAIL_TEXT", (Object)(mailtext == null || mailtext.isEmpty() ? "Hello $$username$$,\n\nWe noticed that you logged in on $$last-login-date$$, and wanted to inform you that your account is set to be deactivated due to In-Active since $$days$$. If you have any questions or require further information, please don't hesitate to contact your Administrator.\n\nThank you." : mailtext));
    }

    public String getSubText() {
        String getAction = (String)this.pluginSettings.get("miniorange.usermanagement.MAIL_SUBJECT_TEXT");
        return getAction == null || getAction.isEmpty() ? "Deactivating User" : getAction;
    }

    public void setSubText(String mailtext) {
        this.pluginSettings.put("miniorange.usermanagement.MAIL_SUBJECT_TEXT", (Object)(mailtext == null || mailtext.isEmpty() ? "Deactivating User" : mailtext));
    }

    public List<String> getGroupsToRemoveList() {
        List excludeList = (List)this.pluginSettings.get("miniorange.usermanagement.GROUPS_TO_REMOVE");
        return excludeList != null ? excludeList : new ArrayList();
    }

    public void setGroupsToRemoveList(List<String> excludeGroupsList) {
        this.pluginSettings.put("miniorange.usermanagement.GROUPS_TO_REMOVE", excludeGroupsList);
    }

    public Boolean getAutoDeActivateUsers() {
        String autodeactivatecheck = (String)this.pluginSettings.get("miniorange.usermanagement.AUTO_DEACTIVATE_USER");
        if (StringUtils.isBlank((CharSequence)autodeactivatecheck)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)autodeactivatecheck);
    }

    public void setAutoDeActivateUsers(Boolean autodeactivatecheck) {
        this.pluginSettings.put("miniorange.usermanagement.AUTO_DEACTIVATE_USER", (Object)BooleanUtils.toString((Boolean)autodeactivatecheck, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getAutoDeactivateNeverLoggedInUser() {
        String neverloggedinusers = (String)this.pluginSettings.get("miniorange.usermanagement.AUTO_DEACTIVATE_NEVER_LOGGEDIN_USERS");
        if (StringUtils.isBlank((CharSequence)neverloggedinusers)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)neverloggedinusers);
    }

    public String getStart_date_lastLoginTime() {
        String start_date_lastLoginTime = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.START_DATE_LASTLOGINTIME")), (CharSequence)"1970-01-01");
        return start_date_lastLoginTime;
    }

    public void setStart_date_lastLoginTime(String start_date_lastLoginTime) {
        this.pluginSettings.put("miniorange.usermanagement.START_DATE_LASTLOGINTIME", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)start_date_lastLoginTime, (CharSequence)"1970-01-01"))));
    }

    public Boolean getEnableRegexForGroups() {
        return BooleanUtils.toBoolean((String)((String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.ENABLE_REGEX_FOR_EXCLUDE_GROUPS")), (CharSequence)"false")));
    }

    public void setEnableRegexForGroups(Boolean regexPattern) {
        this.pluginSettings.put("miniorange.usermanagement.ENABLE_REGEX_FOR_EXCLUDE_GROUPS", (Object)BooleanUtils.toString((Boolean)regexPattern, (String)"true", (String)"false", (String)"false"));
    }

    public String getRegexPattenForGroups() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.REGEX_PATTERN_FOR_EXCLUDE_GROUPS")), (CharSequence)"");
    }

    public void setRegexPatternForGroups(String regexPatternForExcludeGroups) {
        this.pluginSettings.put("miniorange.usermanagement.REGEX_PATTERN_FOR_EXCLUDE_GROUPS", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)regexPatternForExcludeGroups, (CharSequence)""))));
    }

    public void setNoOfDaysForUsersDashboard(String noOfDays) {
        this.pluginSettings.put("miniorange.usermanagement.USER_DASHBOARD_PERIOD", (Object)noOfDays);
    }

    public String getNoOfDaysForUsersDashboard() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.USER_DASHBOARD_PERIOD")), (CharSequence)"30");
    }

    public String getSchedulerType() {
        String schedulerType = (String)this.pluginSettings.get("miniorange.usermanagement.SCHEDULER_TYPE");
        return StringUtils.isBlank((CharSequence)schedulerType) ? "custom" : schedulerType;
    }

    public void setSchedulerType(String schedulerType) {
        this.pluginSettings.put("miniorange.usermanagement.SCHEDULER_TYPE", (Object)StringUtils.trimToEmpty((String)schedulerType));
    }

    public Date getLastRunTime() {
        String lastRunTime = (String)this.pluginSettings.get("miniorange.usermanagement.LAST_RUN_TIME");
        String validRunTime = (String)StringUtils.defaultIfBlank((CharSequence)lastRunTime, null);
        if (validRunTime == null) {
            return null;
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(validRunTime);
        }
        catch (ParseException e) {
            LOGGER.error("Error parsing LastRunTime from settings", (Throwable)e);
            return null;
        }
    }

    public void setLastRunTime(Date lastRunTime) {
        if (lastRunTime == null) {
            this.pluginSettings.remove("miniorange.usermanagement.LAST_RUN_TIME");
        } else {
            String formattedTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(lastRunTime);
            this.pluginSettings.put("miniorange.usermanagement.LAST_RUN_TIME", (Object)formattedTime);
        }
    }

    public Date getNextSchedulerRunTime() {
        String nextRunTime = (String)this.pluginSettings.get("miniorange.usermanagement.NEXT_SCHEDULER_RUN_TIME");
        String validRunTime = (String)StringUtils.defaultIfBlank((CharSequence)nextRunTime, null);
        if (validRunTime == null) {
            return null;
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(validRunTime);
        }
        catch (ParseException e) {
            LOGGER.error("Error parsing NextSchedulerRunTime from settings", (Throwable)e);
            return null;
        }
    }

    public void setNextSchedulerRunTime(Date nextRunTime) {
        if (nextRunTime == null) {
            this.pluginSettings.remove("miniorange.usermanagement.NEXT_SCHEDULER_RUN_TIME");
        } else {
            String formattedTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(nextRunTime);
            this.pluginSettings.put("miniorange.usermanagement.NEXT_SCHEDULER_RUN_TIME", (Object)formattedTime);
        }
    }

    public Date getLastSchedulerRunTime() {
        String lastRunTime = (String)this.pluginSettings.get("miniorange.usermanagement.LAST_SCHEDULER_RUN_TIME");
        String validRunTime = (String)StringUtils.defaultIfBlank((CharSequence)lastRunTime, null);
        if (validRunTime == null) {
            return null;
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(validRunTime);
        }
        catch (ParseException e) {
            LOGGER.error("Error parsing LastSchedulerRunTime from settings", (Throwable)e);
            return null;
        }
    }

    public void setLastSchedulerRunTime(Date lastRunTime) {
        if (lastRunTime == null) {
            this.pluginSettings.remove("miniorange.usermanagement.LAST_SCHEDULER_RUN_TIME");
        } else {
            String formattedTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(lastRunTime);
            this.pluginSettings.put("miniorange.usermanagement.LAST_SCHEDULER_RUN_TIME", (Object)formattedTime);
        }
    }

    public Date getNextScheduledRunTime() {
        String nextRunTime = (String)this.pluginSettings.get("miniorange.usermanagement.NEXT_SCHEDULED_RUN_TIME");
        String validRunTime = (String)StringUtils.defaultIfBlank((CharSequence)nextRunTime, null);
        if (validRunTime == null) {
            return null;
        }
        try {
            return new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").parse(validRunTime);
        }
        catch (ParseException e) {
            LOGGER.error("Error parsing NextScheduledRunTime from settings", (Throwable)e);
            return null;
        }
    }

    public void setNextScheduledRunTime(Date nextRunTime) {
        if (nextRunTime == null) {
            this.pluginSettings.remove("miniorange.usermanagement.NEXT_SCHEDULED_RUN_TIME");
        } else {
            String formattedTime = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss").format(nextRunTime);
            this.pluginSettings.put("miniorange.usermanagement.NEXT_SCHEDULED_RUN_TIME", (Object)formattedTime);
        }
    }

    public String getEnd_date_lastLoginTime() {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String expiryDateString = dateFormat.format(new Date(cal.getTimeInMillis()));
        String[] dateAndTime = expiryDateString.split(" ");
        String currentDate = dateAndTime[0];
        String end_date_lastLoginTime = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.END_DATE_LASTLOGINTIME")), (CharSequence)currentDate);
        return end_date_lastLoginTime;
    }

    public void setEnd_date_lastLoginTime(String end_date_lastLoginTime) {
        Calendar cal = Calendar.getInstance();
        SimpleDateFormat dateFormat = new SimpleDateFormat("yyyy-MM-dd HH:mm");
        String expiryDateString = dateFormat.format(new Date(cal.getTimeInMillis()));
        String[] dateAndTime = expiryDateString.split(" ");
        String currentDate = dateAndTime[0];
        this.pluginSettings.put("miniorange.usermanagement.END_DATE_LASTLOGINTIME", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)end_date_lastLoginTime, (CharSequence)currentDate))));
    }

    public void setAutoDeactivateNeverLoggedInUser(Boolean autodeactivatecheck) {
        this.pluginSettings.put("miniorange.usermanagement.AUTO_DEACTIVATE_NEVER_LOGGEDIN_USERS", (Object)BooleanUtils.toString((Boolean)autodeactivatecheck, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getMailNotification() {
        String mailNotificationCheck = (String)this.pluginSettings.get("miniorange.usermanagement.MAIL_NOTIFICATIoN_CHECK");
        if (StringUtils.isBlank((CharSequence)mailNotificationCheck)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)mailNotificationCheck);
    }

    public void setMailNotification(Boolean mailNotificationCheck) {
        this.pluginSettings.put("miniorange.usermanagement.MAIL_NOTIFICATIoN_CHECK", (Object)BooleanUtils.toString((Boolean)mailNotificationCheck, (String)"true", (String)"false", (String)"false"));
    }

    public String getCustomerID() {
        String customerId = StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.CUSTOMER_ID")));
        return customerId;
    }

    public void setCustomerId(String customerId) {
        this.pluginSettings.put("miniorange.usermanagement.CUSTOMER_ID", (Object)customerId);
    }

    public String getCustomerEmail() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.CUSTOMER_EMAIL")));
    }

    public void setCustomerEmail(String email) {
        this.pluginSettings.put("miniorange.usermanagement.CUSTOMER_EMAIL", (Object)StringUtils.trimToEmpty((String)email));
    }

    public String getCustomerAPIKey() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.CUSTOMER_API_KEY")));
    }

    public void setCustomerAPIKey(String customerId) {
        this.pluginSettings.put("miniorange.usermanagement.CUSTOMER_API_KEY", (Object)customerId);
    }

    public String getCustomerTokenKey() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.CUSTOMER_TOKEN_KEY")));
    }

    public void setCustomerTokenKey(String customerId) {
        this.pluginSettings.put("miniorange.usermanagement.CUSTOMER_TOKEN_KEY", (Object)customerId);
    }

    public Boolean isCustomerRegistered() {
        if (StringUtils.isBlank((CharSequence)this.getCustomerID()) || StringUtils.isBlank((CharSequence)this.getCustomerEmail()) || StringUtils.isBlank((CharSequence)this.getCustomerAPIKey()) || StringUtils.isBlank((CharSequence)this.getCustomerTokenKey())) {
            return Boolean.FALSE;
        }
        return Boolean.TRUE;
    }

    public Integer getLicencedUsers() {
        try {
            String licencedUsers = MoEncryptionUtils.decrypt(this.getCustomerTokenKey(), (String)this.pluginSettings.get("miniorange.usermanagement.LICENCED_USERS"));
            return Integer.valueOf(licencedUsers);
        }
        catch (NumberFormatException e) {
            return 0;
        }
    }

    public void setLicencedUsers(Integer userCount) {
        String licencedUsers = userCount.toString();
        String value = MoEncryptionUtils.encrypt(this.getCustomerTokenKey(), licencedUsers);
        this.pluginSettings.put("miniorange.usermanagement.LICENCED_USERS", (Object)value);
    }

    public String getCustomerLicenseKey() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.CUSTOMER_LICENSE_KEY")));
    }

    public void setCustomerLicenseKey(String licenseKey) {
        this.pluginSettings.put("miniorange.usermanagement.CUSTOMER_LICENSE_KEY", (Object)StringUtils.trimToEmpty((String)licenseKey));
    }

    public void setLicenseVerified(Boolean backdoorEnabled) {
        String value = MoEncryptionUtils.encrypt(this.getCustomerTokenKey(), BooleanUtils.toString((Boolean)backdoorEnabled, (String)"true", (String)"false", (String)"false"));
        this.pluginSettings.put("miniorange.usermanagement.LICENSE_VERIFIED", (Object)value);
    }

    public Boolean getLicenseVerified() {
        String value = StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.LICENSE_VERIFIED")));
        return StringUtils.isNotBlank((CharSequence)value) ? BooleanUtils.toBoolean((String)MoEncryptionUtils.decrypt(this.getCustomerTokenKey(), value)) : false;
    }

    public String getLicenseType() {
        String licenseTypeValue = MoEncryptionUtils.decrypt(this.getCustomerTokenKey(), StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.IS_TRIAL_LICENSE"))));
        return licenseTypeValue;
    }

    public void setLicenseType(String licenseType) {
        String licenseTypeValue = MoEncryptionUtils.encrypt(this.getCustomerTokenKey(), licenseType);
        this.pluginSettings.put("miniorange.usermanagement.IS_TRIAL_LICENSE", (Object)licenseTypeValue);
    }

    public void setTrialCount(int count) {
        String encString = MoEncryptionUtils.encrypt("u4JpSz2dti6u5kRB", String.valueOf(count));
        this.pluginSettings.put("miniorange.usermanagement.UMP_TRIAL_COUNT", (Object)encString);
    }

    public int getTrialCount() {
        try {
            String decryptString = MoEncryptionUtils.decrypt("u4JpSz2dti6u5kRB", StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.UMP_TRIAL_COUNT"))));
            return Integer.parseInt(decryptString);
        }
        catch (Exception e) {
            return 0;
        }
    }

    public String getLicenseExpireDate() {
        String licenseExpireDateValue = MoEncryptionUtils.decrypt(this.getCustomerTokenKey(), StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.LICENSE_EXPIRE_DATE"))));
        return licenseExpireDateValue;
    }

    public void setLicenseExpireDate(String licenseExpireDate) {
        String licenseExpireDateValue = MoEncryptionUtils.encrypt(this.getCustomerTokenKey(), licenseExpireDate);
        this.pluginSettings.put("miniorange.usermanagement.LICENSE_EXPIRE_DATE", (Object)licenseExpireDateValue);
    }

    public boolean checkLicenseValidation(HttpServletResponse resp) throws IOException {
        if (this.i18nHelper.getText("plugin.version").equals("1")) {
            return true;
        }
        if (this.getLicenseType().contains("TRIAL")) {
            if (this.getTrialCount() == 0) {
                this.setTrialCount(1);
            }
            if (this.isLicenseExpired().booleanValue()) {
                LOGGER.warn("Your license is expired. Please Contact to atlassiansupport@xecurify.com.");
                if (resp != null) {
                    resp.sendRedirect(this.getBaseUrl() + "/plugins/servlet/crowd-user-mologin/dologin");
                }
                return false;
            }
            return true;
        }
        if (!this.isCustomerRegistered().booleanValue()) {
            if (resp != null) {
                resp.sendRedirect(this.getBaseUrl() + "/plugins/servlet/crowd-user-mologin/dologin");
            }
            return false;
        }
        if (!this.isLicenseValid()) {
            if (resp != null) {
                resp.sendRedirect(this.getBaseUrl() + "/plugins/servlet/crowd-user-molicense/doverify");
            }
            return false;
        }
        if (this.isCustomerRegistered().booleanValue() && this.getLicenseVerified().booleanValue()) {
            this.setTrialCount(5);
            if (!this.isLicenseExpired().booleanValue()) {
                if (this.getLicenseType().contains("TRIAL")) {
                    return true;
                }
                if (!this.isNoOfUserExceed().booleanValue()) {
                    LOGGER.debug("user count?" + this.isNoOfUserExceed());
                    return true;
                }
                return false;
            }
        }
        LOGGER.debug("Invalid License");
        return false;
    }

    public boolean isLicenseValid() {
        if (this.i18nHelper.getText("plugin.version").equals("1")) {
            return true;
        }
        if (this.getLicenseType().contains("TRIAL")) {
            LOGGER.debug("Trial License Found");
            return true;
        }
        if (this.isCustomerRegistered().booleanValue() && this.getLicenseVerified().booleanValue() && !this.isLicenseExpired().booleanValue()) {
            if (this.getLicenseType().contains("TRIAL")) {
                return true;
            }
            if (!this.isNoOfUserExceed().booleanValue()) {
                LOGGER.debug("user count?" + this.isNoOfUserExceed());
                return true;
            }
            return false;
        }
        LOGGER.debug("Invalid License");
        return false;
    }

    public Boolean getSortByLastLogin() {
        String sortByLastLogin = (String)this.pluginSettings.get("miniorange.usermanagement.SORT_BY_LAST_LOGIN_TIME");
        if (StringUtils.isBlank((CharSequence)sortByLastLogin)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)sortByLastLogin);
    }

    public void setSortByLastLogin(Boolean sortByLastLogin) {
        this.pluginSettings.put("miniorange.usermanagement.SORT_BY_LAST_LOGIN_TIME", (Object)BooleanUtils.toString((Boolean)sortByLastLogin, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean isLicenseExpired() {
        try {
            String licenseExpireDateString = this.getLicenseExpireDate();
            Date licenseExpireDate = new SimpleDateFormat("yyyy-MM-dd' 'HH:mm:ss.SSS").parse(licenseExpireDateString);
            LOGGER.debug("licenseExpireDate = " + licenseExpireDate.toString());
            Date currentDate = new Date();
            if (!currentDate.before(licenseExpireDate)) {
                LOGGER.debug("License is expired");
                this.setLicenseVerified(Boolean.FALSE);
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            LOGGER.error("An exception occurs while verifying the license", (Throwable)e);
        }
        return Boolean.FALSE;
    }

    public Boolean isTrialLicense() {
        String licenseType = this.getLicenseType();
        if (StringUtils.equalsIgnoreCase((CharSequence)licenseType, (CharSequence)"TRIAL")) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }

    public List<String> getDefaultGroupsForInitialConfiguration() {
        ArrayList<String> groupList = new ArrayList<String>();
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
        Iterable groupsFromSystem = this.crowdService.search((Query)query);
        for (Group group : groupsFromSystem) {
            if (groupList.contains(group.getName())) continue;
            groupList.add(group.getName());
        }
        ArrayList<String> excludeGroup = new ArrayList<String>();
        if (groupList.size() > 0) {
            excludeGroup.add((String)groupList.get(0));
        }
        LOGGER.debug("Exclude Group::" + excludeGroup);
        return excludeGroup;
    }

    public void removeCustomerAccount() {
        this.pluginSettings.remove("miniorange.usermanagement.CUSTOMER_ID");
        this.pluginSettings.remove("miniorange.usermanagement.CUSTOMER_EMAIL");
        this.pluginSettings.remove("miniorange.usermanagement.CUSTOMER_API_KEY");
        this.pluginSettings.remove("miniorange.usermanagement.CUSTOMER_TOKEN_KEY");
        this.pluginSettings.remove("miniorange.usermanagement.CUSTOMER_LICENSE_KEY");
        this.pluginSettings.remove("miniorange.usermanagement.LICENSE_VERIFIED");
        this.pluginSettings.remove("miniorange.usermanagement.ACTIVE_USERS");
        this.pluginSettings.remove("miniorange.usermanagement.LICENCED_USERS");
        this.pluginSettings.remove("miniorange.usermanagement.LICENSE_EXPIRE_DATE");
        this.pluginSettings.remove("miniorange.usermanagement.IS_TRIAL_LICENSE");
    }

    public String getSpBaseUrl() {
        return (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.SP_BASE_URL")), (CharSequence)this.getBaseUrl());
    }

    public String getBaseUrl() {
        try {
            String baseURL = this.propertyManager.getBaseUrl().toString();
            return baseURL;
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while getting base URL", (Throwable)e);
            return null;
        }
    }

    public Boolean getAutoDeleteAuditLogs() {
        String autoDeleteAuditLogs = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.AUTO_DELETE_AUDIT_LOGS")), (CharSequence)"true");
        return BooleanUtils.toBoolean((String)autoDeleteAuditLogs);
    }

    public void setAutoDeleteAuditLogs(Boolean autoDeleteAuditLogs) {
        this.pluginSettings.put("miniorange.usermanagement.AUTO_DELETE_AUDIT_LOGS", (Object)BooleanUtils.toString((Boolean)autoDeleteAuditLogs, (String)"true", (String)"false", (String)"false"));
    }

    public Integer getAutoDeleteLogsAfterDays() {
        String autoDeleteLogsAfterDays = (String)this.pluginSettings.get("miniorange.usermanagement.AUTO_DELETE_AUDIT_LOGS_AFTER_DAYS");
        if (NumberUtils.isDigits((String)autoDeleteLogsAfterDays)) {
            return NumberUtils.createInteger((String)autoDeleteLogsAfterDays);
        }
        return UserManagementPluginCommonConstants.AUTO_CLEAR_LOG_TIME;
    }

    public void setAutoDeleteLogsAfterDays(Integer autoDeleteLogsAfterDays) {
        this.pluginSettings.put("miniorange.usermanagement.AUTO_DELETE_AUDIT_LOGS_AFTER_DAYS", (Object)String.valueOf(autoDeleteLogsAfterDays));
    }

    public ArrayList<String> convertSelect2StringToList(String groups) {
        ArrayList<String> groupsList = new ArrayList<String>();
        if (StringUtils.isBlank((CharSequence)groups)) {
            return groupsList;
        }
        Collections.addAll(groupsList, StringUtils.split((String)groups, (String)","));
        groupsList.removeAll(Arrays.asList(null, ""));
        return groupsList;
    }

    public Boolean getReActivateUser() {
        String reActivateUser = (String)this.pluginSettings.get("miniorange.usermanagement.AUTO_REACTIVATE_USER");
        if (StringUtils.isBlank((CharSequence)reActivateUser)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)reActivateUser);
    }

    public void setReActivateUser(Boolean reActivateUser) {
        this.pluginSettings.put("miniorange.usermanagement.AUTO_REACTIVATE_USER", (Object)BooleanUtils.toString((Boolean)reActivateUser, (String)"true", (String)"false", (String)"false"));
    }

    public Boolean getAddGroupsToReactiveUser() {
        String addGroupsToReactiveUser = (String)this.pluginSettings.get("miniorange.usermanagement.ADD_GROUPS_TO_REACTIVE_USER");
        if (StringUtils.isBlank((CharSequence)addGroupsToReactiveUser)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)addGroupsToReactiveUser);
    }

    public void setAddGroupsToReactiveUser(Boolean addGroupsToReactiveUser) {
        this.pluginSettings.put("miniorange.usermanagement.ADD_GROUPS_TO_REACTIVE_USER", (Object)BooleanUtils.toString((Boolean)addGroupsToReactiveUser, (String)"true", (String)"false", (String)"false"));
    }

    public void setAddGroups(ArrayList<String> addGroupsList) {
        this.pluginSettings.put("miniorange.usermanagement.ADD_GROUPS_LIST", addGroupsList);
    }

    public ArrayList<String> getAddGroups() {
        ArrayList GroupList = (ArrayList)this.pluginSettings.get("miniorange.usermanagement.ADD_GROUPS_LIST");
        if (GroupList == null) {
            return new ArrayList<String>();
        }
        return GroupList;
    }

    public Boolean getAddGroupsToActiveUser() {
        String addGroupsToActiveUser = (String)this.pluginSettings.get("miniorange.usermanagement.ADD_GROUPS_TO_ACTIVE_USER");
        if (StringUtils.isBlank((CharSequence)addGroupsToActiveUser)) {
            return Boolean.FALSE;
        }
        return BooleanUtils.toBoolean((String)addGroupsToActiveUser);
    }

    public void setAddGroupsToActiveUser(Boolean addGroupsToActiveUser) {
        this.pluginSettings.put("miniorange.usermanagement.ADD_GROUPS_TO_ACTIVE_USER", (Object)BooleanUtils.toString((Boolean)addGroupsToActiveUser, (String)"true", (String)"false", (String)"false"));
    }

    public void setGroupsAssignToActiveUsers(ArrayList<String> groupsAssignToActiveUsers) {
        this.pluginSettings.put("miniorange.usermanagement.GROUPS_ASSIGN_TO_ACTIVE_USER", groupsAssignToActiveUsers);
    }

    public ArrayList<String> getGroupsAssignToActiveUsers() {
        ArrayList GroupList = (ArrayList)this.pluginSettings.get("miniorange.usermanagement.GROUPS_ASSIGN_TO_ACTIVE_USER");
        if (GroupList == null) {
            return new ArrayList<String>();
        }
        return GroupList;
    }

    public int getUserDeactivatedCount() {
        String deactivatedUsers = (String)this.pluginSettings.get("miniorange.usermanagement.NO_OF_USERS_DEACTIVATED");
        if (deactivatedUsers != null) {
            return Integer.parseInt(deactivatedUsers);
        }
        return 0;
    }

    public void setUserDeactivatedCount(int userCount) {
        String value = String.valueOf(userCount);
        this.pluginSettings.put("miniorange.usermanagement.NO_OF_USERS_DEACTIVATED", (Object)value);
    }

    public int getUserActivatedCount() {
        String activatedUsers = (String)this.pluginSettings.get("miniorange.usermanagement.NO_OF_USERS_ACTIVATED");
        if (activatedUsers != null) {
            return Integer.parseInt(activatedUsers);
        }
        return 0;
    }

    public void setUserActivatedCount(int userCount) {
        String value = String.valueOf(userCount);
        this.pluginSettings.put("miniorange.usermanagement.NO_OF_USERS_ACTIVATED", (Object)value);
    }

    public int getUserDeletedCount() {
        String deletedUsers = (String)this.pluginSettings.get("miniorange.usermanagement.NO_OF_USERS_DELETED");
        if (deletedUsers != null) {
            return Integer.parseInt(deletedUsers);
        }
        return 0;
    }

    public void setUserDeletedCount(int userCount) {
        String value = String.valueOf(userCount);
        this.pluginSettings.put("miniorange.usermanagement.NO_OF_USERS_DELETED", (Object)value);
    }

    public int getUserImportedCount() {
        String importedUsers = (String)this.pluginSettings.get("miniorange.usermanagement.NO_OF_USERS_IMPORTED");
        if (importedUsers != null) {
            return Integer.parseInt(importedUsers);
        }
        return 0;
    }

    public void setUserImportedCount(int userCount) {
        String value = String.valueOf(userCount);
        this.pluginSettings.put("miniorange.usermanagement.NO_OF_USERS_IMPORTED", (Object)value);
    }

    public int getDeletedGroupsCount() {
        String deletedGroupsCount = (String)this.pluginSettings.get("miniorange.usermanagement.DELETED_GROUPS_COUNT");
        if (deletedGroupsCount != null) {
            return Integer.parseInt(deletedGroupsCount);
        }
        return 0;
    }

    public void setDeletedGroupsCount(int count) {
        String value = String.valueOf(count);
        this.pluginSettings.put("miniorange.usermanagement.DELETED_GROUPS_COUNT", (Object)value);
    }

    public int getCreatedGroupsCount() {
        String createdGroupsCount = (String)this.pluginSettings.get("miniorange.usermanagement.CREATED_GROUPS_COUNT");
        if (createdGroupsCount != null) {
            return Integer.parseInt(createdGroupsCount);
        }
        return 0;
    }

    public void setCreatedGroupsCount(int count) {
        String value = String.valueOf(count);
        this.pluginSettings.put("miniorange.usermanagement.CREATED_GROUPS_COUNT", (Object)value);
    }

    public int getUsersAddedToGroupCount() {
        String usersAddedCount = (String)this.pluginSettings.get("miniorange.usermanagement.USERS_ADDED_TO_GROUP_COUNT");
        if (usersAddedCount != null) {
            return Integer.parseInt(usersAddedCount);
        }
        return 0;
    }

    public void setUsersAddedToGroupCount(int count) {
        String value = String.valueOf(count);
        this.pluginSettings.put("miniorange.usermanagement.USERS_ADDED_TO_GROUP_COUNT", (Object)value);
    }

    public int getUsersRemovedFromGroupCount() {
        String usersRemovedCount = (String)this.pluginSettings.get("miniorange.usermanagement.USERS_REMOVED_FROM_GROUP_COUNT");
        if (usersRemovedCount != null) {
            return Integer.parseInt(usersRemovedCount);
        }
        return 0;
    }

    public void setUsersRemovedFromGroupCount(int count) {
        String value = String.valueOf(count);
        this.pluginSettings.put("miniorange.usermanagement.USERS_REMOVED_FROM_GROUP_COUNT", (Object)value);
    }

    public List<String> getExcludeUsersList() {
        List excludeList = (List)this.pluginSettings.get("miniorange.usermanagement.EXCLUDE_USERS_LIST");
        return excludeList != null ? excludeList : new ArrayList();
    }

    public void setExcludeUsersList(List<String> excludeUsersList) {
        this.pluginSettings.put("miniorange.usermanagement.EXCLUDE_USERS_LIST", excludeUsersList);
    }

    public List<String> getExcludeGroupsList() {
        List excludeList = (List)this.pluginSettings.get("miniorange.usermanagement.EXCLUDE_GROUPS_LIST");
        return excludeList != null ? excludeList : new ArrayList();
    }

    public void setExcludeGroupsList(List<String> excludeGroupsList) {
        this.pluginSettings.put("miniorange.usermanagement.EXCLUDE_GROUPS_LIST", excludeGroupsList);
    }

    public void setRefreshInterval(String refreshInterval) {
        this.pluginSettings.put("miniorange.usermanagement.REFRESH_INTERVAL", (Object)StringUtils.trimToEmpty((String)refreshInterval));
    }

    public String getRefreshInterval() {
        String refreshInterval = (String)this.pluginSettings.get("miniorange.usermanagement.REFRESH_INTERVAL");
        return refreshInterval == null ? "daily" : refreshInterval;
    }

    public void setCustomRefreshInterval(String customRefreshInterval) {
        this.pluginSettings.put("miniorange.usermanagement.CUSTOM_REFRESH_INTERVAL", (Object)(customRefreshInterval != null ? customRefreshInterval : "60"));
    }

    public int getCustomRefreshInterval() {
        String refreshIntervalUnit = (String)this.pluginSettings.get("miniorange.usermanagement.CUSTOM_REFRESH_INTERVAL");
        LOGGER.debug("Refresh Interval Unit is: " + refreshIntervalUnit);
        if (refreshIntervalUnit == null || refreshIntervalUnit.trim().isEmpty()) {
            return 60;
        }
        try {
            return Integer.parseInt(refreshIntervalUnit);
        }
        catch (NumberFormatException e) {
            LOGGER.warn("Invalid refresh interval value: " + refreshIntervalUnit + ". Defaulting to 60.");
            return 60;
        }
    }

    public void setCustomRefreshIntervalUnit(String customRefreshIntervalUnit) {
        if (customRefreshIntervalUnit == null || customRefreshIntervalUnit.isEmpty()) {
            this.pluginSettings.put("miniorange.usermanagement.CUSTOM_REFRESH_INTERVAL_UNIT", (Object)"minutes");
        } else {
            this.pluginSettings.put("miniorange.usermanagement.CUSTOM_REFRESH_INTERVAL_UNIT", (Object)StringUtils.trimToEmpty((String)customRefreshIntervalUnit));
        }
    }

    public String getCustomRefreshIntervalUnit() {
        String refreshIntervalUnit = (String)this.pluginSettings.get("miniorange.usermanagement.CUSTOM_REFRESH_INTERVAL_UNIT");
        return refreshIntervalUnit == null ? "minutes" : refreshIntervalUnit;
    }

    public String getUserManagementSelectedAction() {
        String groupManagementSelectedAction = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.GROUP_MANAGEMENT_SELECTION")), (CharSequence)"groupCreationAction");
        groupManagementSelectedAction = groupManagementSelectedAction.replaceAll(" ", "");
        return groupManagementSelectedAction;
    }

    public void setUserManagementSelectedAction(String groupManagementSelectedAction) {
        groupManagementSelectedAction = groupManagementSelectedAction.replaceAll(" ", "");
        this.pluginSettings.put("miniorange.usermanagement.GROUP_MANAGEMENT_SELECTION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)groupManagementSelectedAction, (CharSequence)"groupCreationAction"))));
    }

    public String getCreationSelection() {
        String groupCreation = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.GROUP_CREATION_SELECTION")), (CharSequence)"manuallyAdding");
        return groupCreation;
    }

    public void setCreationSelection(String groupCreation) {
        this.pluginSettings.put("miniorange.usermanagement.GROUP_CREATION_SELECTION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)groupCreation, (CharSequence)"manuallyAdding"))));
    }

    public String getGroupsToCreate() {
        String groupToCreate = (String)StringUtils.defaultIfBlank((CharSequence)((String)this.pluginSettings.get("miniorange.usermanagement.MANUALLY_GROUP_CREATION")), (CharSequence)"");
        return groupToCreate;
    }

    public void setGroupsToCreate(String groupToCreate) {
        this.pluginSettings.put("miniorange.usermanagement.MANUALLY_GROUP_CREATION", (Object)StringUtils.trimToEmpty((String)((String)StringUtils.defaultIfBlank((CharSequence)groupToCreate, (CharSequence)""))));
    }

    public Object getGroupsToDelete() {
        if (this.pluginSettings.get("miniorange.usermanagement.GROUPS_TO_DELETE") == null) {
            List<String> defaultGroups = this.getDefaultGroupsForInitialConfiguration();
            return defaultGroups;
        }
        return this.pluginSettings.get("miniorange.usermanagement.GROUPS_TO_DELETE");
    }

    public void setGroupsToDelete(ArrayList<String> defaultGroups) {
        this.pluginSettings.put("miniorange.usermanagement.GROUPS_TO_DELETE", defaultGroups);
    }

    public String getCsvUploadStatus() {
        return StringUtils.defaultString((String)((String)this.pluginSettings.get("miniorange.usermanagement.CSV_UPLOAD_STATUS")), (String)"notUploaded");
    }

    public void setCsvUploadStatus(String csvUploadStatus) {
        this.pluginSettings.put("miniorange.usermanagement.CSV_UPLOAD_STATUS", (Object)StringUtils.trimToEmpty((String)csvUploadStatus));
    }

    public Boolean getEnableDebugLogs() {
        return BooleanUtils.toBooleanDefaultIfNull((Boolean)BooleanUtils.toBooleanObject((String)((String)this.pluginSettings.get("miniorange.usermanagement.ENABLE_DEBUG_LOGS"))), (boolean)false);
    }

    public void setEnableDebugLogs(Boolean enableDebugLogs) {
        this.pluginSettings.put("miniorange.usermanagement.ENABLE_DEBUG_LOGS", (Object)BooleanUtils.toString((Boolean)enableDebugLogs, (String)"true", (String)"false", (String)"false"));
    }

    public static String sanitizeText(String text) {
        if (StringUtils.isBlank((CharSequence)text)) {
            return text;
        }
        text = HtmlUtils.htmlEscape((String)text);
        return text;
    }

    public Boolean isNoOfUserExceed() {
        try {
            Integer licencedUsers = this.getLicencedUsers();
            LOGGER.debug("licensed users are: " + licencedUsers);
            int crowdUserTier = this.getCrowdUserTier();
            LOGGER.debug("crowd user tier: " + crowdUserTier);
            if (crowdUserTier >= licencedUsers) {
                LOGGER.debug("No of Crowd user exceeded");
                return Boolean.TRUE;
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while licensed user check ", (Throwable)e);
        }
        return Boolean.FALSE;
    }

    public Integer getCrowdUserTier() {
        return this.propertyManager.getCurrentLicenseResourceTotal();
    }

    public List<String> getAuditLogs() {
        if (this.pluginSettings.get("miniorange.usermanagement.AUDIT_LOGS") != null) {
            return (List)this.pluginSettings.get("miniorange.usermanagement.AUDIT_LOGS");
        }
        return new ArrayList<String>();
    }

    public void setAuditLogs(List<String> auditLogList) {
        this.pluginSettings.put("miniorange.usermanagement.AUDIT_LOGS", auditLogList);
    }

    public Integer getNumberOfEntriesToRetain() {
        String value = (String)this.pluginSettings.get("miniorange.usermanagement.NUMBER_OF_ENTRIES_TO_RETAIN");
        if (NumberUtils.isDigits((String)value)) {
            return Integer.parseInt(value);
        }
        return 1000;
    }

    public void setNumberOfEntriesToRetain(Integer numberOfEntriesToRetain) {
        if (numberOfEntriesToRetain == null || numberOfEntriesToRetain <= 0) {
            numberOfEntriesToRetain = 1000;
        }
        this.pluginSettings.put("miniorange.usermanagement.NUMBER_OF_ENTRIES_TO_RETAIN", (Object)String.valueOf(numberOfEntriesToRetain));
    }

    public List<String> getLogsToDisplay(List<String> auditLogsList, String username, String ip, String action, String status, String period) throws ParseException {
        ArrayList<String> filteredAuditLogsList = new ArrayList<String>();
        List<Object> listOfAuditLogsObjects = new ArrayList();
        Collections.reverse(auditLogsList);
        LOGGER.debug("auditlog size: " + auditLogsList.size());
        listOfAuditLogsObjects = AuditLogDetailsUtils.fromJsonStringList(auditLogsList);
        Calendar calendar = Calendar.getInstance();
        long timeMilliSecs = calendar.getTimeInMillis();
        for (int counter = 0; counter < listOfAuditLogsObjects.size(); ++counter) {
            if (!StringUtils.isBlank((CharSequence)username) && !StringUtils.containsIgnoreCase((CharSequence)((AuditLogDetailsUtils)listOfAuditLogsObjects.get(counter)).getUsername(), (CharSequence)username) || !StringUtils.isBlank((CharSequence)ip) && !StringUtils.equals((CharSequence)((AuditLogDetailsUtils)listOfAuditLogsObjects.get(counter)).getIpAddress(), (CharSequence)ip) || !StringUtils.equals((CharSequence)"All Actions", (CharSequence)action) && !StringUtils.equals((CharSequence)((AuditLogDetailsUtils)listOfAuditLogsObjects.get(counter)).getAction(), (CharSequence)action) || !StringUtils.equals((CharSequence)"All Status", (CharSequence)status) && !StringUtils.equals((CharSequence)((AuditLogDetailsUtils)listOfAuditLogsObjects.get(counter)).getStatus(), (CharSequence)status)) continue;
            if (StringUtils.equals((CharSequence)"All Days", (CharSequence)period)) {
                filteredAuditLogsList.add(auditLogsList.get(counter));
                continue;
            }
            long intervalSelected = NumberUtils.createInteger((String)String.valueOf(period)).intValue();
            long intervalSelectedInMilliSecs = intervalSelected * 86400000L;
            long timeInPast = timeMilliSecs - intervalSelectedInMilliSecs;
            Date dateBeforeInterval = new Date(timeInPast);
            SimpleDateFormat formatter = new SimpleDateFormat(" dd MMM yyyy HH:mm:ss z");
            Date StringToDateForDatabaseEntry = new SimpleDateFormat("dd MMM yyyy HH:mm:ss z").parse(((AuditLogDetailsUtils)listOfAuditLogsObjects.get(counter)).getDateAndTime());
            int isLoginAfterInterval = StringToDateForDatabaseEntry.compareTo(dateBeforeInterval);
            if (isLoginAfterInterval < 0) continue;
            filteredAuditLogsList.add(auditLogsList.get(counter));
        }
        LOGGER.debug("filterauditlog size :" + filteredAuditLogsList.size());
        return filteredAuditLogsList;
    }
}

