/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoAjaxExportUser
implements Runnable {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAjaxExportUser.class);
    private Boolean Username = false;
    private Boolean Email = false;
    private Boolean FullName = false;
    private Boolean Groups = false;
    private Boolean Status = false;
    private Boolean Directory = false;
    private Boolean LastLoginDate = false;
    private String username;
    private File exportFile;
    private Map<String, Boolean> exportOptions;
    private Map<String, String> exportParams;
    private UserManager userManager;
    private DirectoryManager directoryManager;
    private UserManagementPluginSettings settings;
    private CommonUserUtils commonUserUtils;
    private CrowdService crowdService;
    private UserManagementPluginHandler userManagementPluginHandler;
    private List<UserTemplate> userTemplates = new ArrayList<UserTemplate>();
    private Map<String, List<String>> usersAndGroup = Collections.synchronizedMap(new HashMap());
    private List<UserTemplate> users = new ArrayList<UserTemplate>();

    public MoAjaxExportUser(String username, File exportFile, UserManager userManager, DirectoryManager directoryManager, UserManagementPluginSettings settings, CommonUserUtils commonUserUtils, CrowdService crowdService, UserManagementPluginHandler userManagementPluginHandler, Map<String, Boolean> exportOptions, List<UserTemplate> users, Map<String, List<String>> usersAndGroup) {
        this.username = username;
        this.exportFile = exportFile;
        this.userManager = userManager;
        this.directoryManager = directoryManager;
        this.settings = settings;
        this.commonUserUtils = commonUserUtils;
        this.crowdService = crowdService;
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.exportOptions = exportOptions;
        this.users = users;
        this.usersAndGroup = usersAndGroup;
    }

    @Override
    public void run() {
        boolean includeAll;
        LOGGER.debug("Run function is called for Export Users...");
        this.Username = this.exportOptions.get("Username");
        this.Email = this.exportOptions.get("Email");
        this.FullName = this.exportOptions.get("FullName");
        this.Groups = this.exportOptions.get("Groups");
        this.Status = this.exportOptions.get("Status");
        this.Directory = this.exportOptions.get("Directory");
        this.LastLoginDate = this.exportOptions.get("LastLoginDate");
        boolean bl = includeAll = this.Username == false && this.Email == false && this.FullName == false && this.Groups == false && this.Status == false && this.Directory == false && this.LastLoginDate == false;
        if (includeAll) {
            this.Directory = this.LastLoginDate = Boolean.valueOf(true);
            this.Status = this.LastLoginDate;
            this.Groups = this.LastLoginDate;
            this.FullName = this.LastLoginDate;
            this.Email = this.LastLoginDate;
            this.Username = this.LastLoginDate;
        }
        ArrayList<String> activeHeaders = new ArrayList<String>();
        if (this.Username.booleanValue()) {
            activeHeaders.add("Username");
        }
        if (this.Email.booleanValue()) {
            activeHeaders.add("Email");
        }
        if (this.FullName.booleanValue()) {
            activeHeaders.add("FullName");
        }
        if (this.Groups.booleanValue()) {
            activeHeaders.add("Groups");
        }
        if (this.Status.booleanValue()) {
            activeHeaders.add("Status");
        }
        if (this.Directory.booleanValue()) {
            activeHeaders.add("Directory");
        }
        if (this.LastLoginDate.booleanValue()) {
            activeHeaders.add("LastLoginDate");
        }
        try (BufferedWriter writer = new BufferedWriter(new FileWriter(this.exportFile));
             CSVPrinter printer = new CSVPrinter(writer, CSVFormat.DEFAULT.withHeader(activeHeaders.toArray(new String[0])));){
            ExecutorService executor = Executors.newFixedThreadPool(Runtime.getRuntime().availableProcessors());
            ArrayList<Future<Void>> futures = new ArrayList<Future<Void>>();
            for (UserTemplate userTemplate : this.users) {
                if (userTemplate == null) {
                    LOGGER.warn("Encountered null user object. Skipping.");
                    continue;
                }
                futures.add(executor.submit(() -> {
                    try {
                        ArrayList<Object> record = new ArrayList<Object>();
                        if (this.Username.booleanValue()) {
                            record.add(user.getName());
                        }
                        if (this.Email.booleanValue()) {
                            record.add(user.getEmailAddress());
                        }
                        if (this.FullName.booleanValue()) {
                            record.add(user.getDisplayName());
                        }
                        if (this.Groups.booleanValue()) {
                            List<String> userGroups = this.usersAndGroup.get(user.getName());
                            record.add("[" + String.join((CharSequence)",", userGroups) + "]");
                        }
                        if (this.Status.booleanValue()) {
                            record.add(user.isActive() ? "Active" : "Inactive");
                        }
                        if (this.Directory.booleanValue()) {
                            String dirName = this.directoryManager.findDirectoryById(user.getDirectoryId()).getName();
                            record.add(dirName);
                        }
                        if (this.LastLoginDate.booleanValue()) {
                            Date lastLoginDate = CommonUserUtils.getLastLoginDate(user.getName(), user.getDirectoryId());
                            record.add(lastLoginDate != null ? lastLoginDate : "Never Logged In");
                        }
                        CSVPrinter cSVPrinter = printer;
                        synchronized (cSVPrinter) {
                            printer.printRecord(record.toArray());
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("Error occurred while exporting user: " + user.getName(), (Throwable)e);
                    }
                    return null;
                }));
            }
            for (Future future : futures) {
                try {
                    future.get(300L, TimeUnit.SECONDS);
                }
                catch (Exception e) {
                    LOGGER.warn("Task timeout or failure", (Throwable)e);
                }
            }
            executor.shutdown();
            LOGGER.debug("All users processed, flushing and closing printer.");
            printer.flush();
            File doneMarker = new File(this.exportFile.getAbsolutePath() + ".done");
            doneMarker.createNewFile();
            this.userManagementPluginHandler.storeAuditLogs(this.username, InetAddress.getLocalHost().getHostAddress(), "Exported Users", "Users are Successfully Exported.", "Success");
            LOGGER.debug("Users CSV exported successfully.");
        }
        catch (Exception e) {
            LOGGER.error("Exception in MoAjaxExportUser.run()", (Throwable)e);
            try {
                this.userManagementPluginHandler.storeAuditLogs(this.username, InetAddress.getLocalHost().getHostAddress(), "Exported Users", "Error Occurred during exporting users.", "Error");
            }
            catch (UnknownHostException ex) {
                throw new RuntimeException(ex);
            }
        }
    }
}

