/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.manager.permission.PermissionManager;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.group.InternalGroup;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.json.jsonorg.JSONArray;
import com.atlassian.json.jsonorg.JSONException;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import java.util.stream.IntStream;
import java.util.stream.Stream;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.text.StringEscapeUtils;
import org.json.JSONObject;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxCallServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AjaxCallServlet.class);
    private CrowdService crowdService;
    private UserManager userManager;
    private DirectoryManager directoryManager;
    private UserManagementPluginSettings settings;
    private CommonUserUtils commonUserUtils;
    private PermissionManager permissionManager;
    private UserManagementPluginHandler userManagementPluginHandler;

    public AjaxCallServlet(CommonUserUtils commonUserUtils, UserManager userManager, DirectoryManager directoryManager, UserManagementPluginSettings settings, CrowdService crowdService, PermissionManager permissionManager, UserManagementPluginHandler userManagementPluginHandler) {
        this.userManager = userManager;
        this.directoryManager = directoryManager;
        this.settings = settings;
        this.commonUserUtils = commonUserUtils;
        this.crowdService = crowdService;
        this.permissionManager = permissionManager;
        this.userManagementPluginHandler = userManagementPluginHandler;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Ajax call servlet doPost Called");
        if (this.userManager.getRemoteUserKey() != null && this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            String userNames = req.getParameter("userNames");
            JSONArray jsonUsernames = new JSONArray(userNames);
            LinkedHashMap<String, Long> userList = new LinkedHashMap<String, Long>();
            IntStream.range(0, jsonUsernames.length()).mapToObj(jsonUsernames::optJSONArray).filter(user -> user != null && user.length() >= 2).forEach(user -> {
                String userName = user.optString(0);
                Long userId = user.optLong(1);
                userList.put(userName, userId);
            });
            String action = req.getParameter("action");
            if (userNames != null && action != null && this.settings.checkLicenseValidation(resp)) {
                switch (action) {
                    case "activate": 
                    case "deactivate": {
                        this.activateOrDeactivateUser(userList, action, resp);
                        break;
                    }
                    case "delete": {
                        this.deleteUsers(userList, resp);
                        break;
                    }
                    case "RemoveGroupsFromUser": {
                        this.removeGroupsFromUser(userList, req, resp);
                        break;
                    }
                    case "AddGroupsInUser": {
                        this.addGroupsInUser(userList, req, resp);
                        break;
                    }
                    case "userAndGroupAction": {
                        this.userAndGroupAction(userList, req, resp);
                        break;
                    }
                    default: {
                        LOGGER.error("Invalid action");
                        this.sendErrorResponse("Invalid Action", 400, resp);
                        break;
                    }
                }
            } else {
                LOGGER.error("Invalid License/Username");
                this.sendErrorResponse("Invalid License check logs for more details", 400, resp);
            }
        } else {
            LOGGER.error("Admin access required");
            this.sendErrorResponse("Admin Access Required", 400, resp);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Ajax call servlet doGet Called");
        if (this.userManager.getRemoteUserKey() != null && this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            String search = StringUtils.trim((String)req.getParameter("search"));
            String action = req.getParameter("action");
            LOGGER.debug("Action:" + action + " userName:" + search);
            switch (action) {
                case "CheckEvalLicense": {
                    if (this.settings.checkLicenseValidation(resp)) break;
                    LOGGER.error("Evaluation license found for app. Operations will be allowed for only 10 users");
                    try {
                        this.sendErrorResponse("Error_User_eval_License", 400, resp);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
                case "getUsers": {
                    this.getUsers(search, resp);
                    break;
                }
                case "fetchGroups": {
                    this.fetchGroups(search, resp);
                    break;
                }
                case "changeSortLastLoginButton": {
                    this.changeSortLastLoginButton(req, resp);
                    break;
                }
                case "bulkCreationGroup": {
                    this.bulkCreationGroup(req, resp);
                    break;
                }
                case "ChangeGroupManagementSelectedAction": {
                    this.changeGroupManagementSelectedAction(req, resp);
                    break;
                }
                case "changeGroupManagementCreationSelectedAction": {
                    this.changeGroupManagementCreationSelectedAction(req, resp);
                    break;
                }
                case "BulkDeletionGroup": {
                    this.bulkDeletionGroup(req, resp);
                    break;
                }
                case "exportGroupsCsv": {
                    try {
                        this.exportGroupsCsv(req, resp);
                    }
                    catch (Exception e) {
                        LOGGER.error(e.getMessage());
                    }
                    break;
                }
                case "regexTestingExcludeGroups": {
                    this.showRegexTestForExcludeGroups(req, resp);
                    break;
                }
                case "clearAuditLogs": {
                    this.clearAuditLogs();
                }
            }
        } else {
            LOGGER.debug("Not an admin user");
        }
    }

    private void activateOrDeactivateUser(Map<String, Long> userNames, String action, HttpServletResponse resp) throws IOException {
        try {
            List<String> actionResult = this.activateDeactivateUserResult(userNames, action);
            if (action.equals("deactivate")) {
                this.sendSuccessFullResponse("User Deactivation Process Executed Successfully", actionResult, resp);
            } else {
                this.sendSuccessFullResponse("User Activation Process Executed Successfully", actionResult, resp);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Issue while perform : " + action + " : " + e);
            this.sendErrorResponse("Failed to " + action + " users", 500, resp);
        }
    }

    public void showRegexTestForExcludeGroups(HttpServletRequest request, HttpServletResponse response) throws IOException {
        StringBuilder output = new StringBuilder("<div style='display:none'>");
        String regexp = request.getParameter("regexp");
        String groupName = request.getParameter("groupName");
        Boolean result = Boolean.FALSE;
        regexp = StringEscapeUtils.escapeEcmaScript((String)regexp);
        groupName = StringEscapeUtils.escapeEcmaScript((String)groupName);
        if (StringUtils.isNotEmpty((CharSequence)regexp) && StringUtils.isNotEmpty((CharSequence)groupName)) {
            result = this.testRegexForExcludeGroups(regexp, groupName);
            LOGGER.debug(" Regex test result is :- " + result);
        }
        output.append("</div>");
        if (StringUtils.isBlank((CharSequence)regexp) || StringUtils.isBlank((CharSequence)groupName)) {
            output.append("<div style=\"color: #a94442;background-color: #f2dede;padding: 15px;margin-bottom: 20px;text-align:center;border:1px solid #E6B3B2;font-size:18pt;\">TEST FAILED</div><div style=\"color: #a94442;font-size:14pt; margin-bottom:20px;\">Error message: <br> ");
            if (StringUtils.isBlank((CharSequence)regexp)) {
                output.append("<li>Regular Expression field can't left blank</li><br>");
            }
            if (StringUtils.isBlank((CharSequence)groupName)) {
                output.append("<li>Group Name field can't left blank</li><br>");
            }
            output.append("</div>");
        } else if (StringUtils.isNotBlank((CharSequence)groupName)) {
            output.append("<div style='color: #3c763d;background-color: #dff0d8; padding:2%;margin-bottom:20px;text-align:center; border:1px solid #AEDB9A; font-size:18pt;'>Test Regex Result</div>");
            if (result == Boolean.TRUE) {
                output.append("<table border=\"1\" style=\"width: 100%;\">\n     <tbody><tr>\n        <th>Result</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td align=\"center\" style=\"color:green;\">SUCCESS</td>\n        <td align=\"center\">PATTERN FOUND</td>\n    </tr>    \n    </tbody></table>");
            } else {
                output.append("<table border=\"1\" style=\"width: 100%;\">\n     <tbody><tr>\n        <th>Result</th>\n        <th>Description</th>\n    </tr>\n    <tr>\n        <td align=\"center\" style=\"color:red;\">FAILURE</td>\n        <td align=\"center\">PATTERN NOT FOUND</td>\n    </tr>    \n    </tbody></table>");
            }
        }
        response.setContentType("text/html");
        response.getOutputStream().write(output.toString().getBytes("UTF-8"));
    }

    private Boolean testRegexForExcludeGroups(String regExp, String groupname) {
        try {
            Pattern pattern = Pattern.compile(regExp, 2);
            Matcher matcher = pattern.matcher(groupname);
            return matcher.find();
        }
        catch (Exception e) {
            LOGGER.error("Exception while applying regex on exclude group name...", (Throwable)e);
            return false;
        }
    }

    private void changeSortLastLoginButton(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String CreationSelectedAction = req.getParameter("selectedAction");
            this.settings.setSortByLastLogin(BooleanUtils.toBoolean((String)CreationSelectedAction));
            this.sendSuccessFullResponse("Success", resp);
        }
        catch (Exception e) {
            LOGGER.error("Error while updating Sort By Last Login " + e.getMessage());
            this.sendErrorResponse("Error", 500, resp);
        }
    }

    private void fetchGroups(String search, HttpServletResponse resp) {
        LOGGER.debug("Ajax Servlet fetchGroup Called");
        try {
            if (StringUtils.equalsIgnoreCase((CharSequence)search, (CharSequence)"*")) {
                search = "";
            }
            this.crowdService = (CrowdService)ComponentLocator.getComponent(CrowdService.class);
            EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"")).returningAtMost(Integer.MAX_VALUE);
            ArrayList finalGroups = new ArrayList();
            List allDirectories = this.directoryManager.findAllDirectories();
            for (Directory directory : allDirectories) {
                List groups = this.directoryManager.searchGroups(directory.getId().longValue(), query);
                finalGroups.addAll(groups);
            }
            JSONObject data = new JSONObject();
            JSONArray resultArray = new JSONArray();
            HashSet<String> uniqueGroupNames = new HashSet<String>();
            for (Group group : finalGroups) {
                String groupName = group.getName();
                if (!uniqueGroupNames.add(groupName)) continue;
                JSONObject groupObj = new JSONObject();
                groupObj.put("id", (Object)groupName);
                groupObj.put("text", (Object)groupName);
                resultArray.put(groupObj);
            }
            data.put("results", (Object)resultArray);
            this.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (JSONException | IOException e) {
            e.printStackTrace();
            LOGGER.error("An error occurred while fetching groups ", (Throwable)e);
        }
        catch (DirectoryNotFoundException e) {
            throw new RuntimeException(e);
        }
        catch (OperationFailedException e) {
            throw new RuntimeException(e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void bulkCreationGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            LOGGER.debug("Bulk group Creation called");
            String groupsToAdd = request.getParameter("groupsToAdd");
            Object[] roleValuesList = StringUtils.split((String)groupsToAdd.trim(), (String)";");
            String selectDirectory = request.getParameter("selectedDirectory");
            if (StringUtils.isNotBlank((CharSequence)selectDirectory)) {
                selectDirectory = selectDirectory.trim();
            }
            LOGGER.debug("selectDirectory : " + selectDirectory);
            LOGGER.debug("groupsToAdd : " + groupsToAdd + " : List : " + Arrays.toString(roleValuesList));
            Directory directory = null;
            try {
                if (!selectDirectory.contains("directoryNotSelected") && selectDirectory != "") {
                    directory = this.directoryManager.findDirectoryByName(selectDirectory);
                }
            }
            catch (Exception exp) {
                LOGGER.error("Directory was not found:" + exp.getMessage());
                return;
            }
            long directoryID = directory.getId();
            String groupsAlreadyExist = "";
            Object groupsCreated = "";
            LOGGER.debug(" directoryID : " + directoryID);
            InetAddress ip = InetAddress.getLocalHost();
            try {
                for (Object groupName : roleValuesList) {
                    if (((String)groupName).length() <= 0) continue;
                    Boolean groupExist = Boolean.FALSE;
                    try {
                        this.directoryManager.findGroupByName(directoryID, ((String)groupName).trim());
                        groupExist = Boolean.TRUE;
                        LOGGER.debug("Group Exist :" + (String)groupName);
                    }
                    catch (Exception groupTemplate) {
                    }
                    finally {
                        if (!groupExist.booleanValue()) {
                            this.settings.setCreatedGroupsCount(this.settings.getCreatedGroupsCount() + 1);
                            LOGGER.debug("Creating new Group with name : " + (String)groupName);
                            GroupTemplate groupTemplate = new GroupTemplate(((String)groupName).trim(), directoryID);
                            this.directoryManager.addGroup(directoryID, groupTemplate);
                            LOGGER.debug("Group added " + (String)groupName);
                            groupsCreated = ((String)groupsCreated).isEmpty() ? groupName : (String)groupsCreated + ", " + (String)groupName;
                            this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "Group Created", "Group created :" + (String)groupName, "Success");
                        } else {
                            groupsAlreadyExist = groupsAlreadyExist + ',' + ((String)groupName).trim();
                            this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "Group Created", "Group Already Exist :" + (String)groupName, "Error");
                        }
                    }
                }
            }
            catch (Exception e) {
                LOGGER.error("Error while creating groups : " + e.getMessage());
            }
            JSONObject data = new JSONObject();
            data.put("groupsAlreadyExist", (Object)groupsAlreadyExist);
            data.put("groupsCreated", groupsCreated);
            LOGGER.debug("Sending groups creation response :");
            this.sendSuccessFullResponse(data.toString(), response);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void changeGroupManagementSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String selectedAction = request.getParameter("selectedAction");
            this.settings.setUserManagementSelectedAction(selectedAction);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("Group management selection :" + e.getMessage());
            this.sendErrorResponse("Error in Group management selection", 500, response);
        }
    }

    private void changeGroupManagementCreationSelectedAction(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            String CreationSelectedAction = request.getParameter("CreationSelectedAction");
            this.settings.setCreationSelection(CreationSelectedAction);
            this.sendSuccessFullResponse("Success", response);
        }
        catch (Exception e) {
            e.printStackTrace();
            this.sendErrorResponse("Error in Group creation selection", 500, response);
        }
    }

    private void getUsers(String searchString, HttpServletResponse resp) {
        try {
            LOGGER.debug("Fetching all users...");
            List<UserTemplate> users = this.commonUserUtils.getAllUsers(searchString, false, false, 0L, 0);
            JSONObject data = new JSONObject();
            JSONArray resultArray = new JSONArray();
            for (UserTemplate user : users) {
                HashMap<String, Object> userResultsMap = new HashMap<String, Object>();
                userResultsMap.put("id", user.getName());
                userResultsMap.put("text", user.getName());
                resultArray.put(userResultsMap);
            }
            data.put("results", (Object)resultArray);
            this.sendSuccessFullResponse(data.toString(), resp);
        }
        catch (Exception e) {
            e.printStackTrace();
            LOGGER.error("An error occurred while fetching users via Ajax calls", (Throwable)e);
        }
    }

    private void bulkDeletionGroup(HttpServletRequest request, HttpServletResponse response) throws IOException {
        int userLimit = this.settings.getLicenseType().contains("TRIAL") ? 50 : Integer.MAX_VALUE;
        try {
            String groupsToDelete = request.getParameter("groupsToDelete");
            String directoryName = request.getParameter("selectedDirectory");
            InetAddress ip = InetAddress.getLocalHost();
            Directory directory = null;
            try {
                if (directoryName != "") {
                    directory = this.directoryManager.findDirectoryByName(directoryName);
                }
            }
            catch (Exception exp) {
                LOGGER.error("Directory was not found:" + exp.getMessage());
            }
            ArrayList<String> groupToDeleteList = this.settings.convertSelect2StringToList(groupsToDelete);
            for (String groupsName : groupToDeleteList) {
                LOGGER.debug("Deleting Group :" + groupsName);
                if (groupsName.contains("crowd-administrators")) continue;
                if (this.settings.getDeletedGroupsCount() < userLimit) {
                    this.directoryManager.removeGroup(directory.getId().longValue(), groupsName);
                    this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "Group Deleted", "Deleting group :" + groupsName, "Success");
                    this.settings.setDeletedGroupsCount(this.settings.getDeletedGroupsCount() + 1);
                    continue;
                }
                LOGGER.error("Please upgrade to premium license to unlock the full feature.");
                this.sendErrorResponse("Trial_limit_exceeded", 400, response);
                this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "Group Deleted", " Can not delete group with administrator access :" + groupsName, "Error Logs");
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void deleteUsers(Map<String, Long> userNames, HttpServletResponse resp) throws IOException {
        try {
            List<String> actionResult = this.deleteUserResult(userNames);
            this.sendSuccessFullResponse("User Deletion Executed Successfully", actionResult, resp);
        }
        catch (IOException e) {
            LOGGER.debug("Issue while perform deletion : " + e);
            this.sendErrorResponse("Failed to delete users", 500, resp);
        }
    }

    private void removeGroupsFromUser(Map<String, Long> userNames, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String[] groupsToRemove = req.getParameterValues("groupsToRemove");
            List<String> actionResult = this.removeGroupsFromUserResult(userNames, groupsToRemove);
            this.sendSuccessFullResponse("The 'Remove from Group' action was successfully executed", actionResult, resp);
        }
        catch (Exception e) {
            this.sendErrorResponse("Failed to remove users from the group", 500, resp);
        }
    }

    private void addGroupsInUser(Map<String, Long> userNames, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        try {
            String[] groupList = req.getParameterValues("groupsToAdd");
            List<String> actionResult = this.addGroupsInUserResult(userNames, groupList);
            this.sendSuccessFullResponse("The 'Add User to Group' action was successfully executed", actionResult, resp);
        }
        catch (Exception e) {
            this.sendErrorResponse("Failed to Add users to the group", 500, resp);
        }
    }

    private void userAndGroupAction(Map<String, Long> userNames, HttpServletRequest req, HttpServletResponse resp) throws IOException {
        String userAction = req.getParameter("userAction");
        String groupAction = req.getParameter("groupAction");
        String[] selectedGroup = req.getParameterValues("selectedGroup");
        try {
            List<String> resultList = new ArrayList<String>();
            if (userAction != null && groupAction != null) {
                switch (userAction) {
                    case "activate": 
                    case "deactivate": {
                        resultList = this.activateDeactivateUserResult(userNames, userAction);
                        break;
                    }
                    case "delete": {
                        resultList = this.deleteUserResult(userNames);
                        break;
                    }
                    default: {
                        LOGGER.debug("No option for user action has been selected.");
                    }
                }
                switch (groupAction) {
                    case "Remove Groups from User": {
                        resultList = Stream.concat(resultList.stream(), this.removeGroupsFromUserResult(userNames, selectedGroup).stream()).collect(Collectors.toList());
                        break;
                    }
                    case "Add Groups to the User": {
                        resultList = Stream.concat(resultList.stream(), this.addGroupsInUserResult(userNames, selectedGroup).stream()).collect(Collectors.toList());
                        break;
                    }
                    default: {
                        LOGGER.debug("No option for group action has been selected.");
                    }
                }
            }
            this.sendSuccessFullResponse("Both User and Group action was successfully executed", resultList, resp);
        }
        catch (IOException e) {
            this.sendErrorResponse("Failed to Execute Both User and Group Action", 500, resp);
        }
    }

    private List<String> activateDeactivateUserResult(Map<String, Long> userList, String action) throws UnknownHostException {
        int userLimit = this.settings.getLicenseType().contains("TRIAL") ? 50 : Integer.MAX_VALUE;
        InetAddress ip = InetAddress.getLocalHost();
        ArrayList<String> actionResult = new ArrayList<String>();
        for (Map.Entry<String, Long> entry : userList.entrySet()) {
            String userName = entry.getKey();
            Long directoryId = entry.getValue();
            User user = null;
            try {
                user = this.directoryManager.findRemoteUserByName(directoryId, userName);
            }
            catch (Exception e) {
                LOGGER.debug("Issue while fetching user : " + userName + " from directory : " + e);
                actionResult.add(userName + ";Failure;Unable to fetch User From Directory");
                continue;
            }
            UserTemplate userTemplate = new UserTemplate(user);
            Boolean isAdmin = false;
            try {
                isAdmin = this.directoryManager.isUserDirectGroupMember(directoryId.longValue(), userName, "crowd-administrators");
            }
            catch (Exception e) {
                LOGGER.debug("Issue while fetching admin details for user: " + userName + " : " + e);
                actionResult.add(userName + ";Failure;Operation failed");
                continue;
            }
            if (isAdmin.booleanValue() && action.equals("deactivate")) {
                actionResult.add(userName + ";Failure;User is Admin");
                continue;
            }
            if (!isAdmin.booleanValue() && action.equals("deactivate")) {
                if (this.settings.getUserDeactivatedCount() < userLimit) {
                    if (userTemplate.isActive()) {
                        userTemplate.setActive(false);
                        try {
                            this.directoryManager.updateUser(directoryId.longValue(), userTemplate);
                            this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "User Deactivated", "Deactivated user: " + userName, "Success");
                            this.settings.setUserDeactivatedCount(this.settings.getUserDeactivatedCount() + 1);
                            LOGGER.debug("User : " + userName + " is deactivate successfully");
                            actionResult.add(userName + ";Success;Deactivate Successfully");
                        }
                        catch (Exception e) {
                            LOGGER.error("Issue while updating user's detail in directory for the user : " + userName + " : " + e);
                            actionResult.add(userName + ";Failure;Failed to update user\u2019s details.");
                        }
                        continue;
                    }
                    actionResult.add(userName + ";Failure;Already Deactivated");
                    this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "User Deactivated", "User are already deactivated: " + userName, "Error");
                    continue;
                }
                LOGGER.error(userName + ";Failure;Trial limit exceeded for deactivation");
                actionResult.add(userName + ";Failure;Trial limit exceeded for deactivations");
                this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "User Deactivated", "Trial limit exceeded for deactivations", "Error");
                continue;
            }
            if (this.settings.getUserActivatedCount() < userLimit) {
                if (!userTemplate.isActive()) {
                    userTemplate.setActive(true);
                    try {
                        this.directoryManager.updateUser(directoryId.longValue(), userTemplate);
                        this.settings.setUserActivatedCount(this.settings.getUserActivatedCount() + 1);
                        actionResult.add(userName + ";Success;Activate Successfully");
                        this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "User Activated", "Activated user: " + userName, "Success");
                    }
                    catch (Exception e) {
                        LOGGER.error("Issue while updating user's detail in directory for the user : " + userName + " : " + e);
                        actionResult.add(userName + ";Failure;Failed to update user\u2019s details.");
                    }
                    continue;
                }
                actionResult.add(userName + ";Failure;Already Activated");
                this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "User Activated", "User are already activated: " + userName, "Error");
                continue;
            }
            actionResult.add(userName + ";Failure;Trial limit exceeded for activations");
            LOGGER.error(userName + ";Failure;Trial limit exceeded for activations");
            this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "User Activated", "Trial limit exceeded for deactivations", "Error");
        }
        return actionResult;
    }

    private List<String> deleteUserResult(Map<String, Long> userList) throws UnknownHostException {
        InetAddress ip = InetAddress.getLocalHost();
        int userLimit = this.settings.getLicenseType().contains("TRIAL") ? 50 : Integer.MAX_VALUE;
        ArrayList<String> actionResult = new ArrayList<String>();
        for (Map.Entry<String, Long> entry : userList.entrySet()) {
            String userName = entry.getKey();
            Long directoryId = entry.getValue();
            boolean isAdmin = false;
            try {
                isAdmin = this.directoryManager.isUserDirectGroupMember(directoryId.longValue(), userName, "crowd-administrators");
            }
            catch (Exception e) {
                LOGGER.debug("Issue while fetching admin details for user: " + userName + " : " + e);
                actionResult.add(userName + ";Failure;Operation failed");
            }
            if (!isAdmin) {
                if (this.settings.getUserDeletedCount() < userLimit) {
                    try {
                        this.directoryManager.removeUser(directoryId.longValue(), userName);
                        this.settings.setUserDeletedCount(this.settings.getUserDeletedCount() + 1);
                        actionResult.add(userName + ";Success;User deleted successfully.");
                        this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "User Deleted", " User deleted: " + userName, "Success");
                    }
                    catch (Exception e) {
                        LOGGER.debug("Issue while Deleting user: " + userName + " : " + e);
                        actionResult.add(userName + ";Failure;Operation failed");
                    }
                    continue;
                }
                actionResult.add(userName + ";Failure;Trial limit exceeded for deletions");
                LOGGER.error(userName + ";Failure;Trial limit exceeded for deletions");
                this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "User Deleted", "Operation failed: Trial limit exceeded for deletions", "Error Logs");
                continue;
            }
            actionResult.add(userName + ";Failure;User is Admin");
            this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "User Deleted", "Operation failed: " + userName + " is Admin", "Error");
        }
        return actionResult;
    }

    private List<String> removeGroupsFromUserResult(Map<String, Long> userList, String[] groupsToRemove) throws UnknownHostException {
        int userLimit = this.settings.getLicenseType().contains("TRIAL") ? 50 : Integer.MAX_VALUE;
        InetAddress ip = InetAddress.getLocalHost();
        ArrayList<String> actionResult = new ArrayList<String>();
        for (Map.Entry<String, Long> entry : userList.entrySet()) {
            String username = entry.getKey();
            Long directoryId = entry.getValue();
            boolean isAdmin = false;
            try {
                isAdmin = this.directoryManager.isUserDirectGroupMember(directoryId.longValue(), username, "crowd-administrators");
            }
            catch (Exception e) {
                LOGGER.debug("Issue while fetching admin details for user: " + username + " : " + e);
                actionResult.add(username + ";Failure;Operation failed");
            }
            if (!isAdmin) {
                if (this.settings.getUsersRemovedFromGroupCount() < userLimit) {
                    this.settings.setUsersRemovedFromGroupCount(this.settings.getUsersRemovedFromGroupCount() + 1);
                    if (groupsToRemove != null) {
                        for (String group : groupsToRemove) {
                            boolean isGroupPresent = false;
                            try {
                                isGroupPresent = this.directoryManager.isUserDirectGroupMember(directoryId.longValue(), username, group);
                            }
                            catch (Exception e) {
                                actionResult.add(username + ";Failure;Unable to fetch group details for user in group: " + group);
                            }
                            if (isGroupPresent) {
                                try {
                                    this.directoryManager.removeUserFromGroup(directoryId.longValue(), username, group);
                                    actionResult.add(username + ";Success;User successfully removed from group: " + group);
                                    this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "Removed from Group", username + " successfully removed from group: " + group, "Success");
                                    LOGGER.debug("removed user" + username + "from group: " + group);
                                }
                                catch (Exception e) {
                                    LOGGER.debug("Issue while removing user " + username + " from group " + group + " : " + e);
                                    actionResult.add(username + ";Failure;Unable to Remove the group. Please check the logs for more details.");
                                    this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "Removed from Group", username + " failed to remove from group: " + group, "Error");
                                }
                                continue;
                            }
                            this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "Removed from Group", username + " User not found in group: " + group, "Error");
                            actionResult.add(username + ";Failure;User not found in group: " + group);
                        }
                        continue;
                    }
                    actionResult.add(username + ";Failure;Groups not selected");
                    continue;
                }
                actionResult.add(username + ";Failure;Unable to remove the group. Trial limit exceeded. Please upgrade to unlock this feature.");
                this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "Removed from Group", "Trial limit exceeded", "Error");
                continue;
            }
            actionResult.add(username + ";Failure;User is Admin");
        }
        return actionResult;
    }

    private List<String> addGroupsInUserResult(Map<String, Long> userList, String[] groupList) throws UnknownHostException {
        int userLimit = this.settings.getLicenseType().contains("TRIAL") ? 50 : Integer.MAX_VALUE;
        InetAddress ip = InetAddress.getLocalHost();
        ArrayList<String> actionResult = new ArrayList<String>();
        for (Map.Entry<String, Long> entry : userList.entrySet()) {
            String username = entry.getKey();
            Long directoryId = entry.getValue();
            if (this.settings.getUsersAddedToGroupCount() < userLimit) {
                this.settings.setUsersAddedToGroupCount(this.settings.getUsersAddedToGroupCount() + 1);
                for (String group : groupList) {
                    boolean isUserPresentInGroup = false;
                    try {
                        isUserPresentInGroup = this.directoryManager.isUserDirectGroupMember(directoryId.longValue(), username, group);
                    }
                    catch (Exception e) {
                        actionResult.add(username + ";Failure;Unable to fetch group details for user in group: " + group);
                    }
                    if (!isUserPresentInGroup) {
                        try {
                            this.directoryManager.addUserToGroup(directoryId.longValue(), username, group);
                            LOGGER.debug("group: " + group + " Added Successfully in user: " + username);
                            actionResult.add(username + ";Success;Successfully added to group : " + group);
                            this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "Added to Group", username + " successfully added to group: " + group, "Success");
                        }
                        catch (Exception e) {
                            LOGGER.debug("Issue while adding user " + username + " to group " + group + " : " + e);
                            actionResult.add(username + ";Failure;Unable to add the group. Please check the logs for more details.");
                            this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "Added to Group", username + " Unable to add the group: " + group, "Error");
                        }
                        continue;
                    }
                    actionResult.add(username + ";Failure;Already present in Group : " + group);
                    this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "Added to Group", username + " is already a member of group: " + group, "Error");
                }
                continue;
            }
            actionResult.add(username + ";Failure;Trial limit exceeded. Please upgrade to unlock this feature.");
            this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), ip.getHostAddress(), "Added to Group", "Trial limit exceeded", "Error");
        }
        return actionResult;
    }

    private void exportGroupsCsv(HttpServletRequest req, HttpServletResponse resp) throws IOException, DirectoryNotFoundException, OperationFailedException {
        LOGGER.debug("Exporting group CSV");
        resp.setContentType("text/csv");
        resp.setHeader("Content-Disposition", "attachment; filename=\"CrowdGroupList.csv\"");
        resp.setHeader("Cache-Control", "no-store, no-cache, must-revalidate, max-age=0");
        resp.setHeader("Pragma", "no-cache");
        try (CSVPrinter printer = new CSVPrinter(resp.getWriter(), CSVFormat.DEFAULT);){
            List directoriesFromSystem = this.directoryManager.findAllDirectories();
            printer.printRecord("Groups", "Directory");
            for (Directory directory : directoriesFromSystem) {
                EntityQuery groupQuery = QueryBuilder.queryFor(InternalGroup.class, (EntityDescriptor)EntityDescriptor.group()).returningAtMost(-1);
                List groups = this.directoryManager.searchGroups(directory.getId().longValue(), groupQuery);
                for (InternalGroup group : groups) {
                    String groupName = '[' + group.getName() + ']';
                    printer.printRecord(groupName, directory.getName());
                }
            }
            printer.flush();
            resp.flushBuffer();
            this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), InetAddress.getLocalHost().getHostAddress(), "Exported Groups", "Groups are Successfully Exported.", "Success");
            LOGGER.debug("The user export process has been successfully completed.");
        }
        catch (Exception e) {
            LOGGER.error("Error during exportGroupsCsv: ", (Throwable)e);
            this.userManagementPluginHandler.storeAuditLogs(this.userManager.getRemoteUser().getUsername(), InetAddress.getLocalHost().getHostAddress(), "Exported Groups", "Error Occurred during exporting groups.", "Error");
            resp.sendError(500, "Unable to generate CSV file");
        }
    }

    private void clearAuditLogs() {
        try {
            ArrayList<String> updateAuditList = new ArrayList<String>();
            this.settings.setAuditLogs(updateAuditList);
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
    }

    private void sendErrorResponseForUsers(String group, String errorMessages, int errorCode, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(errorCode);
        resp.getOutputStream().write(group.getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().write(" ".getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().write(errorMessages.getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().close();
    }

    private void sendErrorResponse(String errorMessages, int errorCode, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(errorCode);
        resp.getOutputStream().write(errorMessages.getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().close();
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().close();
        }
    }

    private void sendSuccessFullResponse(String result, List<String> resultList, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null && resultList != null) {
            JSONObject jsonResponse = new JSONObject();
            jsonResponse.put("message", (Object)result);
            jsonResponse.put("resultList", (Object)new JSONArray(resultList));
            resp.getOutputStream().write(jsonResponse.toString().getBytes(StandardCharsets.UTF_8));
        }
        resp.getOutputStream().close();
    }

    private Boolean isSystemAdmin(String username) {
        UserProfile userProfile = this.userManager.getUserProfile(username);
        if (userProfile != null && this.userManager.isAdmin(userProfile.getUserKey())) {
            return Boolean.TRUE;
        }
        return Boolean.FALSE;
    }
}

