/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.actions;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.constants.UserManagementPluginCommonConstants;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.scheduler.AuditLogScheduler;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.AuditLogDetailsUtils;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.IOException;
import java.io.Writer;
import java.net.InetAddress;
import java.text.ParseException;
import java.time.LocalDateTime;
import java.time.ZoneId;
import java.time.format.DateTimeFormatter;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AuditLogsAction
extends HttpServlet {
    private static final String AUDIT_LOG_ACTION_PATH = "/templates/auditlogs.vm";
    private static final Logger LOGGER = LoggerFactory.getLogger(AuditLogsAction.class);
    private static final DateTimeFormatter DATE_TIME_FORMATTER = DateTimeFormatter.ofPattern("dd MMM yyyy HH:mm:ss ");
    private UserManager userManager;
    private CommonUserUtils commonUserUtils;
    private final UserManagementPluginSettings settings;
    private TemplateRenderer renderer;
    private LoginUriProvider loginUriProvider;
    private UserManagementPluginHandler userManagementPluginHandler;
    private String message;
    private Boolean auditLogsUserDetailsSubmitted;
    private AuditLogScheduler auditLogScheduler;
    private String schedulerType;
    private String numberOfEntriesToRetainStr;
    private String lastExecutionTime;
    private String nextSchedulerRunTime;
    private String auditLogUsernameSearchKeyword;
    private String auditLogIpSearchKeyword;
    private String filterUsersByPeriod;
    private String filterUsersByAction;
    private String filterByStatus;
    private List<String> auditLogs;
    private Boolean autoDeleteAuditLogs;
    private Boolean autoDeleteAuditLogsDetailsSubmitted;
    private String autoDeleteLogsAfterDays;
    private List<String> numberOfPagesList;
    private Integer numberOfRecordsPerPage;
    private List<String> currentPageUsersList;
    private Integer selectedPage;
    private Integer startIndex;
    private Integer endIndex;
    private Integer numberOfPages;
    private List<String> auditLogsAfterAllFilters = new ArrayList<String>();
    private List<AuditLogDetailsUtils> auditLogsToDisplay = new ArrayList<AuditLogDetailsUtils>();

    public AuditLogsAction(UserManager userManager, CommonUserUtils commonUserUtils, UserManagementPluginSettings settings, TemplateRenderer renderer, LoginUriProvider loginUriProvider, UserManagementPluginHandler userManagementPluginHandler, AuditLogScheduler auditLogScheduler) {
        this.userManager = userManager;
        this.commonUserUtils = commonUserUtils;
        this.settings = settings;
        this.renderer = renderer;
        this.loginUriProvider = loginUriProvider;
        this.userManagementPluginHandler = userManagementPluginHandler;
        this.auditLogScheduler = auditLogScheduler;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        if (!this.settings.isCustomerRegistered().booleanValue()) {
            LOGGER.debug("Customer is not registered");
            resp.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/crowd-user-mologin/dologin");
            return;
        }
        if (!this.settings.isLicenseValid()) {
            resp.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/crowd-user-molicense/doverify");
            return;
        }
        if (this.doValidate().booleanValue()) {
            LOGGER.debug("After user validation....");
            this.fetchValuesFromRequest(req);
            String startIndexAsString = "";
            String endIndexAsString = "";
            if (StringUtils.isBlank((CharSequence)this.auditLogUsernameSearchKeyword)) {
                this.auditLogUsernameSearchKeyword = "";
            }
            if (StringUtils.isBlank((CharSequence)this.auditLogIpSearchKeyword)) {
                this.auditLogIpSearchKeyword = "";
            }
            if (BooleanUtils.toBoolean((String)req.getParameter("submitted"))) {
                this.initializeAuditLogs();
                startIndexAsString = "";
                endIndexAsString = "";
            } else {
                String usernameSearchKeyword = req.getParameter("logsUsernameSearchKeywordUrl");
                String ipSearchKeyword = req.getParameter("logsIpSearchKeywordUrl");
                String actionSearchFilter = req.getParameter("actionSearchFilter");
                String periodSearchFilter = req.getParameter("periodSearchFilter");
                String statusSearchFilter = req.getParameter("statusSearchFilter");
                String schedulerTypeFromRequest = req.getParameter("schedulerType");
                this.schedulerType = ((String)StringUtils.defaultIfBlank((CharSequence)schedulerTypeFromRequest, (CharSequence)this.settings.getSchedulerType())).trim();
                if (StringUtils.isNotBlank((CharSequence)usernameSearchKeyword)) {
                    this.auditLogUsernameSearchKeyword = usernameSearchKeyword.trim();
                }
                if (StringUtils.isNotBlank((CharSequence)ipSearchKeyword)) {
                    this.auditLogIpSearchKeyword = ipSearchKeyword.trim();
                }
                if (StringUtils.isNotBlank((CharSequence)actionSearchFilter)) {
                    this.filterUsersByAction = actionSearchFilter.trim();
                }
                if (StringUtils.isNotBlank((CharSequence)periodSearchFilter)) {
                    this.filterUsersByPeriod = periodSearchFilter.trim();
                }
                if (StringUtils.isNotBlank((CharSequence)statusSearchFilter)) {
                    this.filterByStatus = statusSearchFilter.trim();
                }
                startIndexAsString = req.getParameter("startIndex");
                endIndexAsString = req.getParameter("endIndex");
            }
            this.auditLogUsernameSearchKeyword = this.auditLogUsernameSearchKeyword.trim();
            this.auditLogIpSearchKeyword = this.auditLogIpSearchKeyword.trim();
            String recordsPerPage = req.getParameter("numberOfRecordsPerPage");
            this.numberOfRecordsPerPage = StringUtils.isNotBlank((CharSequence)recordsPerPage) ? Integer.valueOf(Integer.parseInt(recordsPerPage)) : UserManagementPluginCommonConstants.MO_NUMBER_OF_AUDIT_LOGS_PER_PAGE;
            if (StringUtils.isBlank((CharSequence)startIndexAsString) && StringUtils.isBlank((CharSequence)endIndexAsString)) {
                this.selectedPage = 1;
                this.startIndex = 1;
                this.endIndex = this.numberOfRecordsPerPage;
            } else {
                this.startIndex = Integer.parseInt(startIndexAsString);
                this.endIndex = Integer.parseInt(endIndexAsString);
                this.selectedPage = this.endIndex / this.numberOfRecordsPerPage;
            }
            if (StringUtils.isBlank((CharSequence)this.filterUsersByAction)) {
                this.filterUsersByAction = "All Actions";
            }
            if (StringUtils.isBlank((CharSequence)this.filterUsersByPeriod)) {
                this.filterUsersByPeriod = "All Days";
            }
            if (StringUtils.isBlank((CharSequence)this.filterByStatus)) {
                this.filterByStatus = "All Status";
            }
            ArrayList<String> auditLogs = new ArrayList<String>(this.settings.getAuditLogs());
            LOGGER.info("Audit Log Filters => Username: " + this.auditLogUsernameSearchKeyword + ", IP: " + this.auditLogIpSearchKeyword + ", Action: " + this.filterUsersByAction + ", Period: " + this.filterUsersByPeriod + ", Status: " + this.filterByStatus);
            try {
                LOGGER.debug("call audit logs AfterAllFilters ");
                this.auditLogsAfterAllFilters = this.settings.getLogsToDisplay(auditLogs, this.auditLogUsernameSearchKeyword, this.auditLogIpSearchKeyword, this.filterUsersByAction, this.filterByStatus, this.filterUsersByPeriod);
            }
            catch (ParseException e) {
                throw new RuntimeException(e);
            }
            this.currentPageUsersList = this.getSelectedDetailsForPaginationForLogs(this.auditLogsAfterAllFilters, this.startIndex - 1, this.endIndex - 1);
            this.auditLogsToDisplay = this.currentPageUsersList.stream().map(AuditLogDetailsUtils::fromJsonString).collect(Collectors.toList());
            this.numberOfPages = this.auditLogsAfterAllFilters.size() / this.numberOfRecordsPerPage;
            if (this.auditLogsAfterAllFilters.size() > this.numberOfPages * this.numberOfRecordsPerPage) {
                Integer n = this.numberOfPages;
                this.numberOfPages = this.numberOfPages + 1;
            }
            this.numberOfPagesList = this.getNumberOfPagesList();
            LOGGER.debug("number of pages = " + this.numberOfPages);
            this.formatSchedulerTimes();
            this.message = "";
            resp.setContentType("text/html;charset=utf-8");
            this.initializeAuditLogs();
            this.renderer.render(AUDIT_LOG_ACTION_PATH, this.initializeAuditLogConfig(), (Writer)resp.getWriter());
        } else {
            resp.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.commonUserUtils.getUri(req), UserRole.ADMIN).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        LOGGER.debug("Audit Logs Action doPost method called..");
        InetAddress ip = InetAddress.getLocalHost();
        try {
            if (this.doValidate().booleanValue()) {
                this.autoDeleteAuditLogsDetailsSubmitted = Boolean.parseBoolean(request.getParameter("autoDeleteAuditLogsDetailsSubmitted"));
                this.autoDeleteAuditLogs = Boolean.parseBoolean(request.getParameter("autoDeleteAuditLogs"));
                this.autoDeleteLogsAfterDays = request.getParameter("autoDeleteLogsAfterDays");
                this.schedulerType = request.getParameter("schedulerType");
                this.numberOfEntriesToRetainStr = request.getParameter("numberOfEntriesToRetain");
                if (StringUtils.isNotBlank((CharSequence)this.numberOfEntriesToRetainStr)) {
                    this.settings.setNumberOfEntriesToRetain(Integer.parseInt(this.numberOfEntriesToRetainStr));
                }
                if (BooleanUtils.toBoolean((Boolean)this.autoDeleteAuditLogsDetailsSubmitted)) {
                    this.settings.setAutoDeleteAuditLogs(BooleanUtils.toBoolean((Boolean)this.autoDeleteAuditLogs));
                    this.settings.setSchedulerType(this.schedulerType);
                    Date currentTime = new Date();
                    if (BooleanUtils.toBoolean((Boolean)this.autoDeleteAuditLogs)) {
                        if ("daily".equalsIgnoreCase(this.schedulerType)) {
                            this.settings.setAutoDeleteLogsAfterDays(1);
                            LOGGER.debug("Scheduling Daily Task");
                            this.auditLogScheduler.schedule();
                            this.settings.setLastRunTime(currentTime);
                        } else if ("custom".equalsIgnoreCase(this.schedulerType)) {
                            int days = Integer.parseInt(this.autoDeleteLogsAfterDays);
                            this.settings.setAutoDeleteLogsAfterDays(days);
                            LOGGER.debug("Scheduling Task");
                            this.auditLogScheduler.schedule();
                            this.settings.setLastRunTime(currentTime);
                        } else {
                            LOGGER.error("Invalid scheduler type: " + this.schedulerType);
                        }
                    } else {
                        this.settings.setAutoDeleteAuditLogs(false);
                        LOGGER.debug("Un-scheduling Task");
                        this.auditLogScheduler.unschedule();
                    }
                }
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        response.sendRedirect(request.getContextPath() + "/plugins/servlet/usermanagement/auditlogs?submitted=true");
    }

    public Boolean doValidate() {
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            return true;
        }
        return false;
    }

    private void formatSchedulerTimes() {
        Date lastRunTime = this.settings.getLastRunTime();
        Date nextRunTime = this.settings.getNextSchedulerRunTime();
        this.lastExecutionTime = lastRunTime != null ? DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(lastRunTime.toInstant(), ZoneId.systemDefault())) : "Never";
        this.nextSchedulerRunTime = nextRunTime != null ? DATE_TIME_FORMATTER.format(LocalDateTime.ofInstant(nextRunTime.toInstant(), ZoneId.systemDefault())) : "Not Scheduled";
    }

    private void initializeAuditLogs() {
        this.autoDeleteAuditLogs = this.settings.getAutoDeleteAuditLogs();
        this.autoDeleteLogsAfterDays = this.settings.getAutoDeleteLogsAfterDays().toString();
        this.schedulerType = this.settings.getSchedulerType();
        this.formatSchedulerTimes();
    }

    private void fetchValuesFromRequest(HttpServletRequest request) {
        this.autoDeleteAuditLogsDetailsSubmitted = Boolean.parseBoolean(request.getParameter("autoDeleteAuditLogsDetailsSubmitted"));
        this.autoDeleteAuditLogs = Boolean.parseBoolean(request.getParameter("autoDeleteAuditLogs"));
        this.autoDeleteLogsAfterDays = request.getParameter("autoDeleteLogsAfterDays");
        this.schedulerType = request.getParameter("schedulerType");
        this.auditLogsUserDetailsSubmitted = Boolean.parseBoolean(request.getParameter("auditLogsUserDetailsSubmitted"));
        this.auditLogUsernameSearchKeyword = request.getParameter("auditLogUsernameSearchKeyword");
        this.filterUsersByAction = request.getParameter("filterUsersByAction");
        this.filterByStatus = request.getParameter("filterByStatus");
        this.filterUsersByPeriod = request.getParameter("filterUsersByPeriod");
        this.auditLogIpSearchKeyword = request.getParameter("auditLogIpSearchKeyword");
        this.numberOfEntriesToRetainStr = request.getParameter("numberOfEntriesToRetain");
    }

    public List<String> getSelectedDetailsForPaginationForLogs(List<String> detailsList, int startIndex, int endIndex) {
        if (detailsList == null || detailsList.isEmpty() || startIndex >= detailsList.size()) {
            return Collections.emptyList();
        }
        endIndex = Math.min(endIndex, detailsList.size() - 1);
        int size = endIndex - startIndex + 1;
        ArrayList<String> selectedDetails = new ArrayList<String>(size);
        selectedDetails.addAll(detailsList.subList(startIndex, endIndex + 1));
        return selectedDetails;
    }

    public List<String> getNumberOfPagesList() {
        LOGGER.debug("getNumberOfPagesList ....");
        this.numberOfPagesList = new ArrayList<String>();
        for (int i = 1; i <= this.numberOfPages; ++i) {
            this.numberOfPagesList.add("" + i);
        }
        return this.numberOfPagesList;
    }

    public Map<String, Object> initializeAuditLogConfig() {
        LOGGER.debug("Size of the current page user list in initializeAuditLogConfig: " + this.currentPageUsersList.size());
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", "");
        context.put("settings", this.settings);
        context.put("auditLogUsernameSearchKeyword", this.auditLogUsernameSearchKeyword);
        context.put("auditLogIpSearchKeyword", this.auditLogIpSearchKeyword);
        context.put("filterUsersByPeriod", this.filterUsersByPeriod);
        context.put("filterUsersByAction", this.filterUsersByAction);
        context.put("filterByStatus", this.filterByStatus);
        context.put("autoDeleteAuditLogs", this.autoDeleteAuditLogs);
        context.put("schedulerType", this.schedulerType);
        context.put("autoDeleteAuditLogsDetailsSubmitted", this.autoDeleteAuditLogsDetailsSubmitted);
        context.put("autoDeleteLogsAfterDays", this.autoDeleteLogsAfterDays);
        context.put("auditLogs", this.auditLogs);
        context.put("currentPageUsersList", this.currentPageUsersList);
        context.put("auditLogsAfterAllFilters", this.auditLogsAfterAllFilters);
        context.put("startIndex", this.startIndex);
        context.put("endIndex", this.endIndex);
        context.put("selectedPage", this.selectedPage);
        context.put("numberOfPagesList", this.numberOfPagesList);
        context.put("numberOfPages", this.numberOfPages);
        context.put("numberOfRecordsPerPage", this.numberOfRecordsPerPage);
        context.put("auditLogsToDisplay", this.auditLogsToDisplay);
        context.put("contextPath", this.settings.getBaseUrl());
        context.put("lastExecutionTime", this.lastExecutionTime);
        context.put("nextSchedulerRunTime", this.nextSchedulerRunTime);
        context.put("numberOfEntriesToRetain", this.settings.getNumberOfEntriesToRetain());
        context.put("remainingLicenseDays", this.commonUserUtils.getRemainingLicenseDays());
        return context;
    }
}

