/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.actions;

import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.handlers.UserManagementPluginHandler;
import com.miniorange.usermanagement.scheduler.UserDeactivateService;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.BooleanUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserDeactivateAction
extends HttpServlet {
    private static final String USER_DEACTIVATION_ACTION_PATH = "/templates/userDeactivate.vm";
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDeactivateAction.class);
    private final LoginUriProvider loginUriProvider;
    private final TemplateRenderer renderer;
    private final CommonUserUtils commonUserUtils;
    private final UserManager userManager;
    private final UserManagementPluginSettings settings;
    private final UserManagementPluginHandler pluginHandler;
    private final UserDeactivateService schedulerService;
    private boolean autoDeactivateSubmitted;
    private String actionOnUser;
    private String limitDays;
    private String limitDaysForNeverLoggedUsers;
    private String dndPeriod = "0";
    private String mailPeriod = "0";
    private String mailtext;
    private String mailsubject;
    private boolean neverLoggedinUsers;
    private boolean mailNotification;
    private String[] excludeUsers;
    private List<String> excludeUsersList = new ArrayList<String>();
    private String[] excludeGroups;
    private List<String> excludeGroupsList = new ArrayList<String>();
    private String refreshInterval;
    private Integer customRefreshInterval;
    private String customRefreshIntervalUnit;
    private Boolean enableDebugLogs;
    private Boolean autoActivateSubmited;
    private Boolean reActivateUser;
    private Boolean addGroupsToReactiveUser;
    private String AddGroups = "";
    private ArrayList<String> addGroupsList;
    private Boolean addGroupsToActiveUser;
    private String groupsAssignToActiveUsers = "";
    private ArrayList<String> groupsListAssignToActiveUsers;
    private String[] groupSearchKey;
    private Boolean enableRegexForGroupsToRemove;
    private String regexPatternForExcludeGroups;
    private List<String> groupSearchList = new ArrayList<String>();
    private boolean licenseValid;

    public UserDeactivateAction(LoginUriProvider loginUriProvider, TemplateRenderer renderer, CommonUserUtils commonUserUtils, UserDeactivateService schedulerService, UserManager userManager, UserManagementPluginSettings settings, UserManagementPluginHandler pluginHandler) {
        this.loginUriProvider = loginUriProvider;
        this.renderer = renderer;
        this.commonUserUtils = commonUserUtils;
        this.userManager = userManager;
        this.settings = settings;
        this.pluginHandler = pluginHandler;
        this.schedulerService = schedulerService;
    }

    public Boolean doValidate() {
        UserProfile user = this.userManager.getRemoteUser();
        return user != null && this.userManager.isAdmin(user.getUserKey());
    }

    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        if (!this.settings.checkLicenseValidation(response)) {
            return;
        }
        if (this.doValidate().booleanValue()) {
            try {
                LOGGER.info("Loading User Deactivate page");
                if (!this.settings.getLicenseType().equalsIgnoreCase("TRIAL")) {
                    if (!this.settings.isCustomerRegistered().booleanValue()) {
                        LOGGER.info("Customer not registered. Redirecting to Login Page.");
                        response.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/crowd-user-mologin/dologin");
                        return;
                    }
                    if (!this.settings.getLicenseVerified().booleanValue() || this.settings.isLicenseExpired().booleanValue()) {
                        response.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/crowd-user-molicense/doverify");
                        return;
                    }
                }
                this.groupSearchList = new ArrayList<String>();
                if (request.getParameterValues("groupSearchKey") != null) {
                    this.groupSearchKey = request.getParameterValues("groupSearchKey");
                    this.groupSearchList.addAll(Arrays.asList(this.excludeUsers));
                }
                LOGGER.debug("group search list: " + this.groupSearchList);
                this.initiailizeForm();
                this.renderUserDeactivationPage(response);
            }
            catch (Exception e) {
                LOGGER.error("An error occurred while loading the settings page: " + e.getMessage(), (Throwable)e);
                response.sendError(500, "An error occurred while loading the settings page. Please try again.");
            }
        } else {
            response.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.commonUserUtils.getUri(request), UserRole.ADMIN).toASCIIString());
        }
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        try {
            LOGGER.debug("User Deactivate execute action submitted");
            this.autoActivateSubmited = BooleanUtils.toBoolean((String)request.getParameter("autoActivateSubmited"));
            if (BooleanUtils.toBoolean((Boolean)this.autoActivateSubmited)) {
                LOGGER.debug("autoActivateSubmited...");
                this.reActivateUser = BooleanUtils.toBoolean((String)request.getParameter("reActivateUser"));
                this.settings.setReActivateUser(this.reActivateUser);
            }
            this.autoDeactivateSubmitted = BooleanUtils.toBoolean((String)request.getParameter("autoDeactivateSubmitted"));
            if (this.autoDeactivateSubmitted && this.doValidate().booleanValue()) {
                LOGGER.debug("Auto Deactivate submitted");
                this.groupSearchList = new ArrayList<String>();
                if (request.getParameterValues("groupSearchKey") != null) {
                    this.groupSearchKey = request.getParameterValues("groupSearchKey");
                    this.groupSearchList.addAll(Arrays.asList(this.groupSearchKey));
                }
                this.excludeUsersList = new ArrayList<String>();
                this.excludeGroupsList = new ArrayList<String>();
                if (request.getParameterValues("excludeUsers") != null) {
                    this.excludeUsers = request.getParameterValues("excludeUsers");
                    this.excludeUsersList.addAll(Arrays.asList(this.excludeUsers));
                }
                if (request.getParameterValues("excludeGroups") != null) {
                    this.excludeGroups = request.getParameterValues("excludeGroups");
                    this.excludeGroupsList.addAll(Arrays.asList(this.excludeGroups));
                }
                LOGGER.debug("group search list: " + this.groupSearchList);
                LOGGER.info("Number of days: " + request.getParameter("limitDays") + " actionOnUser: " + request.getParameter("actionOnUser") + " deactivateNeverLoggedInUser: " + request.getParameter("neverLoggedinUsers") + " noOfDaysForNeverLoggedUsers: " + request.getParameter("limitDaysForNeverLoggedUsers") + " excludeUsersList: " + this.excludeUsersList + " excludeGroupsList: " + this.excludeGroupsList + "mailPeriod: " + request.getParameter("mailPeriod"));
                this.pluginHandler.saveUserManagementSettings(this.parseLongOrDefault(request.getParameter("limitDays"), 30L), this.parseLongOrDefault(request.getParameter("limitDaysForNeverLoggedUsers"), 0L), this.parseLongOrDefault(request.getParameter("dndPeriod"), 0L), this.parseLongOrDefault(request.getParameter("mailPeriod"), 0L), Boolean.parseBoolean(request.getParameter("neverLoggedinUsers")), Boolean.parseBoolean(request.getParameter("mailNotification")), request.getParameter("mailtext"), request.getParameter("mailsubject"), this.excludeUsersList, this.excludeGroupsList, this.groupSearchList, request.getParameter("actionOnUser"), request.getParameter("refreshInterval"), request.getParameter("customRefreshInterval"), request.getParameter("customRefreshIntervalUnit"), Boolean.parseBoolean(request.getParameter("enableRegexForGroupsToRemove")), request.getParameter("regexPatternForExcludeGroups"));
                this.handleActionOnUser(request.getParameter("actionOnUser"));
                LOGGER.debug("Settings Saved");
            }
        }
        catch (Exception e) {
            LOGGER.error("An error occurred while saving settings, please refer logs for more info", (Throwable)e);
            response.sendError(500, "An error occurred while saving settings, please refer logs for more info");
        }
        this.renderUserDeactivationPage(response);
    }

    private void handleActionOnUser(String actionOnUser) {
        if ("none".equals(actionOnUser)) {
            this.schedulerService.unschedule();
        } else {
            LOGGER.debug("Invoking the schedulerService...");
            this.schedulerService.schedule();
        }
    }

    private long parseLongOrDefault(String value, long defaultValue) {
        try {
            return value != null ? Long.parseLong(value) : defaultValue;
        }
        catch (NumberFormatException e) {
            LOGGER.debug("Failed to parse long from value: {}. Using default: {}", (Object)(value + defaultValue + e));
            return defaultValue;
        }
    }

    private void renderUserDeactivationPage(HttpServletResponse response) throws IOException {
        HashMap<String, Object> context = this.initialiseUserDeactivationAction();
        response.setContentType("text/html;charset=utf-8");
        this.renderer.render(USER_DEACTIVATION_ACTION_PATH, context, (Writer)response.getWriter());
    }

    public void initiailizeForm() {
        LOGGER.debug("initializing form...");
        this.limitDays = String.valueOf(this.settings.getNumberOfDays());
        this.limitDaysForNeverLoggedUsers = String.valueOf(this.settings.getNumberOfDaysForNeverLoggedUsers());
        this.dndPeriod = String.valueOf(this.settings.getDoNotDeactivatePeriod());
        this.mailPeriod = String.valueOf(this.settings.getMailPeriod());
        this.mailtext = String.valueOf(this.settings.getMailText());
        this.mailsubject = String.valueOf(this.settings.getSubText());
        this.neverLoggedinUsers = this.settings.getAutoDeactivateNeverLoggedInUser();
        this.mailNotification = this.settings.getMailNotification();
        this.excludeUsersList = this.settings.getExcludeUsersList();
        this.excludeGroupsList = this.settings.getExcludeGroupsList();
        this.groupSearchList = this.settings.getGroupsToRemoveList();
        this.actionOnUser = this.settings.getActionOnUser();
        this.refreshInterval = this.settings.getRefreshInterval();
        this.customRefreshInterval = this.settings.getCustomRefreshInterval();
        this.customRefreshIntervalUnit = this.settings.getCustomRefreshIntervalUnit();
        this.reActivateUser = this.settings.getReActivateUser();
        this.addGroupsToReactiveUser = this.settings.getAddGroupsToReactiveUser();
        this.addGroupsList = this.settings.getAddGroups();
        this.addGroupsToActiveUser = this.settings.getAddGroupsToActiveUser();
        this.groupsListAssignToActiveUsers = this.settings.getGroupsAssignToActiveUsers();
        this.enableRegexForGroupsToRemove = this.settings.getEnableRegexForGroups();
        this.regexPatternForExcludeGroups = this.settings.getRegexPattenForGroups();
    }

    public HashMap<String, Object> initialiseUserDeactivationAction() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("limitDays", String.valueOf(this.settings.getNumberOfDays()));
        context.put("limitDaysForNeverLoggedUsers", String.valueOf(this.settings.getNumberOfDaysForNeverLoggedUsers()));
        context.put("dndPeriod", String.valueOf(this.settings.getDoNotDeactivatePeriod()));
        context.put("mailPeriod", String.valueOf(this.settings.getMailPeriod()));
        context.put("mailtext", this.settings.getMailText());
        context.put("mailsubject", this.settings.getSubText());
        context.put("neverLoggedinUsers", this.settings.getAutoDeactivateNeverLoggedInUser());
        context.put("mailNotification", this.settings.getMailNotification());
        context.put("excludeUsersList", this.settings.getExcludeUsersList());
        context.put("excludeGroupsList", this.settings.getExcludeGroupsList());
        context.put("groupSearchList", this.settings.getGroupsToRemoveList());
        context.put("actionOnUser", this.settings.getActionOnUser());
        context.put("refreshInterval", this.settings.getRefreshInterval());
        context.put("customRefreshInterval", this.settings.getCustomRefreshInterval());
        context.put("customRefreshIntervalUnit", this.settings.getCustomRefreshIntervalUnit());
        context.put("reActivateUser", this.settings.getReActivateUser());
        context.put("addGroupsToReactiveUser", this.settings.getAddGroupsToReactiveUser());
        context.put("addGroupsList", this.settings.getAddGroups());
        context.put("addGroupsToActiveUser", this.settings.getAddGroupsToActiveUser());
        context.put("groupsListAssignToActiveUsers", this.settings.getGroupsAssignToActiveUsers());
        context.put("enableRegexForGroupsToRemove", this.settings.getEnableRegexForGroups());
        context.put("regexPatternForExcludeGroups", this.settings.getRegexPattenForGroups());
        context.put("settings", this.settings);
        context.put("crowdUserGroups", this.commonUserUtils.getAllGroups());
        context.put("crowdUsers", this.commonUserUtils.getAllUsers("", false, false, 0L, 0));
        return context;
    }
}

