/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.scheduler;

import com.atlassian.sal.api.lifecycle.LifecycleAware;
import com.atlassian.scheduler.JobRunner;
import com.atlassian.scheduler.SchedulerService;
import com.atlassian.scheduler.SchedulerServiceException;
import com.atlassian.scheduler.config.JobConfig;
import com.atlassian.scheduler.config.JobId;
import com.atlassian.scheduler.config.JobRunnerKey;
import com.atlassian.scheduler.config.RunMode;
import com.atlassian.scheduler.config.Schedule;
import com.miniorange.usermanagement.scheduler.UserDeactivateTask;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.Serializable;
import java.time.Instant;
import java.util.Date;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class UserDeactivateService
implements LifecycleAware,
Serializable {
    private static final Logger LOGGER = LoggerFactory.getLogger(UserDeactivateService.class);
    private SchedulerService schedulerService;
    private CommonUserUtils commonUserUtils;
    private UserManagementPluginSettings settings;
    private static final JobId JOB_ID = JobId.of((String)UserDeactivateTask.class.getName());
    private static final JobRunnerKey JOB_RUNNER_KEY = JobRunnerKey.of((String)UserDeactivateTask.class.getName());
    long refreshIntervalInMiliseconds = 86400000L;
    private String actionOnUser;

    @Autowired
    public UserDeactivateService(CommonUserUtils commonUserUtils, UserManagementPluginSettings settings, SchedulerService schedulerService) {
        this.schedulerService = schedulerService;
        this.commonUserUtils = commonUserUtils;
        this.settings = settings;
    }

    public void schedule() {
        LOGGER.debug("Scheduling scheduler for deactivation task");
        this.schedulerService.registerJobRunner(JOB_RUNNER_KEY, (JobRunner)new UserDeactivateTask(this.commonUserUtils, this.settings));
        this.refreshIntervalInMiliseconds = this.getRefreshIntervalInMilis();
        LOGGER.debug("Refresh Interval in millis=" + this.refreshIntervalInMiliseconds);
        Date firstRun = Date.from(Instant.now().plusMillis(this.refreshIntervalInMiliseconds));
        JobConfig jobConfig = JobConfig.forJobRunnerKey((JobRunnerKey)JOB_RUNNER_KEY).withRunMode(RunMode.RUN_LOCALLY).withSchedule(Schedule.forInterval((long)this.refreshIntervalInMiliseconds, null));
        try {
            this.schedulerService.scheduleJob(JOB_ID, jobConfig);
        }
        catch (SchedulerServiceException e) {
            LOGGER.error("An error occurred while scheduling user deactivation task ", (Throwable)e);
            e.printStackTrace();
        }
    }

    public void onStart() {
        LOGGER.debug("On start called");
        this.actionOnUser = this.settings.getActionOnUser();
        if (this.actionOnUser.equals("autoDeactivateUser") || this.actionOnUser.equals("removeGroupsFromUsers") || this.actionOnUser.equals("removeGroupsAndAutoDeactivate")) {
            this.schedule();
            return;
        }
        this.unschedule();
    }

    public void onStop() {
        LOGGER.debug("On stop called");
        this.unschedule();
        this.schedulerService.unregisterJobRunner(JOB_RUNNER_KEY);
    }

    public void unschedule() {
        LOGGER.debug("Initiating the unschedule operation " + JOB_ID);
        this.schedulerService.unscheduleJob(JOB_ID);
    }

    public long getRefreshIntervalInMilis() {
        String refreshInterval = this.settings.getRefreshInterval();
        int customRefreshInterval = this.settings.getCustomRefreshInterval();
        String customRefreshIntervalUnit = this.settings.getCustomRefreshIntervalUnit();
        LOGGER.debug("getRefreshIntervalInMills called.");
        long interval = StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"hourly") ? 60L : (StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"twicedaily") ? 720L : (StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"daily") ? 1440L : (StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"weekly") ? 10080L : (StringUtils.equalsIgnoreCase((CharSequence)refreshInterval, (CharSequence)"monthly") ? 43200L : (StringUtils.equalsIgnoreCase((CharSequence)customRefreshIntervalUnit, (CharSequence)"hours") ? (long)(customRefreshInterval * 60) : (StringUtils.equalsIgnoreCase((CharSequence)customRefreshIntervalUnit, (CharSequence)"days") ? (long)(customRefreshInterval * 24 * 60) : (long)customRefreshInterval))))));
        return interval * 60L * 1000L;
    }
}

