/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.Group;
import com.atlassian.crowd.embedded.api.OperationType;
import com.atlassian.crowd.embedded.api.PasswordCredential;
import com.atlassian.crowd.embedded.api.Query;
import com.atlassian.crowd.embedded.api.User;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.exception.OperationFailedException;
import com.atlassian.crowd.exception.OperationNotPermittedException;
import com.atlassian.crowd.exception.UserNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.group.GroupTemplate;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.query.membership.MembershipQuery;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.opencsv.CSVReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.atomic.AtomicInteger;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.struts2.ServletActionContext;
import org.apache.struts2.dispatcher.multipart.MultiPartRequestWrapper;
import org.apache.struts2.dispatcher.multipart.UploadedFile;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UploadCSVServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(UploadCSVServlet.class);
    private Integer totalUpdations = 0;
    private Integer totalCreations = 0;
    private Boolean groupsCsvUpload;
    private DirectoryManager directoryManager;
    private UserManager userManager;
    private CrowdService crowdService;
    private UserManagementPluginSettings settings;
    private static final int BATCH_SIZE = 1000;
    private static final int NUM_THREADS = 10;
    volatile boolean stopProcessing = false;

    UploadCSVServlet(DirectoryManager directoryManager, UserManager userManager, CrowdService crowdService, UserManagementPluginSettings settings) {
        this.directoryManager = directoryManager;
        this.userManager = userManager;
        this.crowdService = crowdService;
        this.settings = settings;
    }

    protected void doPost(HttpServletRequest request, HttpServletResponse response) throws IOException {
        HttpServletRequest req = ServletActionContext.getRequest();
        ExecutorService executor = Executors.newFixedThreadPool(10);
        this.groupsCsvUpload = Boolean.parseBoolean(req.getParameter("groupsCsvUpload"));
        if (this.groupsCsvUpload == null) {
            this.groupsCsvUpload = false;
        }
        LOGGER.debug("Groups upload by csv: " + this.groupsCsvUpload);
        try {
            MultiPartRequestWrapper wrapper = (MultiPartRequestWrapper)ServletActionContext.getRequest();
            UploadedFile uploadedFile = wrapper.getFiles("csvFile")[0];
            File file = (File)uploadedFile.getContent();
            if (file == null) {
                LOGGER.error("Uploaded CSV file is null");
            } else {
                CSVReader csvReader = new CSVReader(new FileReader(file));
                int UserNameIndex = 10;
                int UserEmailIndex = 10;
                int FullNameIndex = 10;
                int GroupsIndex = 10;
                int StatusIndex = 10;
                int DirectoryIndex = 10;
                String[] nextLine = csvReader.readNext();
                if (nextLine != null) {
                    int colCount = nextLine.length;
                    block24: for (int i = 0; i < colCount; ++i) {
                        switch (nextLine[i].toString()) {
                            case "Username": 
                            case "username": {
                                UserNameIndex = i;
                                continue block24;
                            }
                            case "Email": 
                            case "email": {
                                UserEmailIndex = i;
                                continue block24;
                            }
                            case "FullName": 
                            case "fullname": {
                                FullNameIndex = i;
                                continue block24;
                            }
                            case "Groups": 
                            case "groups": {
                                GroupsIndex = i;
                                continue block24;
                            }
                            case "Status": 
                            case "status": {
                                StatusIndex = i;
                                continue block24;
                            }
                            case "Directory": 
                            case "directory": {
                                DirectoryIndex = i;
                            }
                        }
                    }
                }
                List<String[]> rowsData = csvReader.readAll();
                int numBatches = (rowsData.size() - 1) / 1000 + 1;
                AtomicInteger updations = new AtomicInteger(0);
                AtomicInteger creations = new AtomicInteger(0);
                int k = 0;
                while (k < numBatches && !this.stopProcessing) {
                    int batchNum = k++;
                    int finalUserEmailIndex = UserEmailIndex;
                    int finalUserNameIndex = UserNameIndex;
                    int finalFullNameIndex = FullNameIndex;
                    int finalGroupsIndex = GroupsIndex;
                    int finalStatusIndex = StatusIndex;
                    int finalDirectoryIndex = DirectoryIndex;
                    executor.submit(() -> {
                        int start = batchNum * 1000;
                        int end = Math.min(start + 1000, rowsData.size());
                        try {
                            block18: for (int j = start; j < end; ++j) {
                                String[] rows = (String[])rowsData.get(j);
                                LOGGER.debug("Uploaded CSV file size = " + rows.length);
                                if (rows == null) continue;
                                LOGGER.debug("CSV file is not null starting thread");
                                String UserName = "";
                                String UserEmail = "";
                                String FullName = "";
                                String Groups = "";
                                String Status = "";
                                String Directory2 = "";
                                for (int i = 0; i < rows.length && !this.stopProcessing; ++i) {
                                    String str;
                                    if (!this.groupsCsvUpload.booleanValue()) {
                                        if (finalUserNameIndex != 10) {
                                            UserName = rows[finalUserNameIndex].toString().trim();
                                            if (UserName.isEmpty()) {
                                                LOGGER.error(" Username is empty cant create user  ");
                                                continue;
                                            }
                                        } else {
                                            LOGGER.error(" Username is empty cant create user  ");
                                            continue;
                                        }
                                        if (finalUserEmailIndex != 10) {
                                            UserEmail = rows[finalUserEmailIndex].toString();
                                            if (UserEmail.isEmpty()) {
                                                LOGGER.error(" Email is empty cant create user  ");
                                                continue;
                                            }
                                        } else {
                                            LOGGER.error(" Email is empty cant create user  ");
                                            continue;
                                        }
                                        FullName = finalFullNameIndex != 10 ? rows[finalFullNameIndex].toString() : UserName;
                                    }
                                    List<Object> defaultGroupList = new ArrayList();
                                    if (finalGroupsIndex != 10) {
                                        Groups = rows[finalGroupsIndex].toString().replaceAll(",+\\s+", ",");
                                        if (!Groups.isEmpty()) {
                                            defaultGroupList = Arrays.asList(StringUtils.split((String)Groups, (String)","));
                                        } else {
                                            Groups = "";
                                            defaultGroupList = Collections.singletonList("");
                                        }
                                    } else {
                                        Groups = "";
                                        defaultGroupList = Collections.singletonList("");
                                    }
                                    if (defaultGroupList.size() > 0 && (str = (String)defaultGroupList.get(0)).length() > 0) {
                                        str = str.substring(1);
                                        defaultGroupList.set(0, str);
                                        str = (String)defaultGroupList.get(defaultGroupList.size() - 1);
                                        str = str.substring(0, str.length() - 1);
                                        defaultGroupList.set(defaultGroupList.size() - 1, str);
                                    }
                                    Status = finalStatusIndex != 10 ? rows[finalStatusIndex].toString() : "";
                                    Long Directory_ID = null;
                                    Directory UserDirectory = null;
                                    if (finalDirectoryIndex != 10) {
                                        Directory2 = rows[finalDirectoryIndex].toString();
                                        if (!Directory2.isEmpty()) {
                                            try {
                                                UserDirectory = this.directoryManager.findDirectoryByName(Directory2.trim());
                                                Directory_ID = UserDirectory.getId();
                                            }
                                            catch (DirectoryNotFoundException e) {
                                                LOGGER.error("Directory of user  Doesn't exist", (Throwable)e);
                                                Directory2 = "";
                                            }
                                        } else {
                                            Directory2 = "";
                                        }
                                    } else {
                                        Directory2 = "";
                                    }
                                    InetAddress ip = null;
                                    try {
                                        ip = InetAddress.getLocalHost();
                                    }
                                    catch (UnknownHostException e) {
                                        throw new RuntimeException(e);
                                    }
                                    List<Object> groupsKeepAsItIs = defaultGroupList;
                                    Boolean isUserPresent = Boolean.FALSE;
                                    com.atlassian.crowd.model.user.User user = null;
                                    if (!this.groupsCsvUpload.booleanValue() && Directory_ID != null) {
                                        try {
                                            user = this.directoryManager.findUserByName(Directory_ID.longValue(), UserName);
                                            isUserPresent = Boolean.TRUE;
                                        }
                                        catch (DirectoryNotFoundException | OperationFailedException | UserNotFoundException throwable) {
                                            // empty catch block
                                        }
                                    }
                                    if (isUserPresent.booleanValue()) {
                                        LOGGER.debug("User " + UserName + " Already Exists. Updating user info.");
                                        LOGGER.debug("user email = " + UserEmail + " full name = " + FullName);
                                        if (this.userManager.getRemoteUserKey() != null && this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
                                            UserTemplate userTemplate = new UserTemplate((User)user);
                                            if (user.isActive() && (Status.equalsIgnoreCase("Inactive") || Status.equalsIgnoreCase("false"))) {
                                                LOGGER.debug("deactivating user from import action :" + user);
                                                userTemplate.setActive(false);
                                            }
                                            if (!user.isActive() && (Status.equalsIgnoreCase("Active") || Status.equalsIgnoreCase("true"))) {
                                                LOGGER.debug("activating user from import action :" + user);
                                                userTemplate.setActive(true);
                                            }
                                            if (this.canGroupsBeUpdated((User)user) && finalGroupsIndex != 10) {
                                                Object gp2;
                                                MembershipQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).parentsOf(EntityDescriptor.user()).withName(UserName).returningAtMost(Integer.MAX_VALUE);
                                                Iterable groups = this.crowdService.search((Query)query);
                                                ArrayList<String> currentGroups = new ArrayList<String>();
                                                for (Object gp2 : groups) {
                                                    currentGroups.add(gp2.getName());
                                                }
                                                LOGGER.debug("Current Groups of the user " + currentGroups);
                                                ArrayList<String> groupsToRemove = new ArrayList<String>();
                                                gp2 = currentGroups.iterator();
                                                while (gp2.hasNext()) {
                                                    String groupName = (String)gp2.next();
                                                    if (groupsKeepAsItIs.contains(groupName) || groupName.contains("crowd-administrators")) continue;
                                                    groupsToRemove.add(groupName);
                                                }
                                                LOGGER.debug("Groups to Remove from " + UserName + " are :- " + groupsToRemove);
                                                try {
                                                    this.removeUserFromGroups((User)user, groupsToRemove, ip.getHostAddress());
                                                }
                                                catch (OperationNotPermittedException e) {
                                                    throw new RuntimeException(e);
                                                }
                                                ArrayList groupsToAssign = (ArrayList)this.createAndAssignNewGroupsUser(groupsKeepAsItIs, userTemplate.getDirectoryId());
                                                LOGGER.debug("groupsToAssign := " + groupsToAssign);
                                                try {
                                                    this.addUserToGroups((User)user, groupsToAssign);
                                                }
                                                catch (OperationNotPermittedException e) {
                                                    throw new RuntimeException(e);
                                                }
                                                updations.incrementAndGet();
                                            }
                                            if (!user.getDisplayName().equals(FullName) || !user.getEmailAddress().equals(UserEmail)) {
                                                Long dirId = userTemplate.getDirectoryId();
                                                userTemplate.setEmailAddress(UserEmail);
                                                userTemplate.setDisplayName(FullName);
                                                updations.incrementAndGet();
                                            }
                                            this.directoryManager.updateUser(userTemplate.getDirectoryId(), userTemplate);
                                        }
                                    } else {
                                        if (Directory2.isEmpty()) {
                                            Directory internalDir = (Directory)this.directoryManager.findAllDirectories().get(0);
                                            Directory_ID = internalDir.getId();
                                        }
                                        if (!this.groupsCsvUpload.booleanValue()) {
                                            LOGGER.debug("User " + UserName + " does Not Exist. Creating User ");
                                            try {
                                                UserTemplate newuserTemplate = new UserTemplate(UserName, Directory_ID.longValue());
                                                newuserTemplate.setDisplayName(FullName);
                                                newuserTemplate.setEmailAddress(UserEmail);
                                                newuserTemplate.setDirectoryId(Directory_ID.longValue());
                                                if (Status.equalsIgnoreCase("Inactive") || Status.equalsIgnoreCase("false")) {
                                                    newuserTemplate.setActive(Boolean.FALSE.booleanValue());
                                                } else {
                                                    newuserTemplate.setActive(Boolean.TRUE.booleanValue());
                                                }
                                                this.directoryManager.addUser(Directory_ID.longValue(), newuserTemplate, PasswordCredential.NONE);
                                                creations.incrementAndGet();
                                            }
                                            catch (Exception e) {
                                                e.printStackTrace();
                                            }
                                            try {
                                                user = this.directoryManager.findUserByName(Directory_ID.longValue(), UserName);
                                            }
                                            catch (Exception e) {
                                                // empty catch block
                                            }
                                        }
                                        LOGGER.debug("Creating groups");
                                        LOGGER.debug("Group/s " + defaultGroupList + "    Directory_ID : " + Directory_ID);
                                        ArrayList groupsToAssignToNewUser = (ArrayList)this.createAndAssignNewGroupsUser(defaultGroupList, Directory_ID);
                                        LOGGER.debug("Should add groups = " + (this.groupsCsvUpload == false));
                                        if (!this.groupsCsvUpload.booleanValue()) {
                                            try {
                                                this.addUserToGroups((User)user, groupsToAssignToNewUser);
                                            }
                                            catch (Exception e) {
                                                LOGGER.error(e.getMessage());
                                            }
                                        }
                                    }
                                    this.totalCreations = creations.get();
                                    this.totalUpdations = updations.get();
                                    if (!StringUtils.equalsIgnoreCase((CharSequence)this.settings.getLicenseType(), (CharSequence)"TRIAL") || this.totalCreations + this.totalUpdations < 10) continue;
                                    LOGGER.debug("license type is: " + this.settings.getLicenseType() + " total user creation: " + this.totalCreations + " total updation:" + this.totalUpdations);
                                    this.stopProcessing = true;
                                    continue block18;
                                }
                            }
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                        LOGGER.debug("license type is: " + this.settings.getLicenseType() + " total user creation: " + this.totalCreations + " total updation:" + this.totalUpdations);
                    });
                }
                if (this.groupsCsvUpload.booleanValue()) {
                    LOGGER.debug("Groups Imported Successfully");
                } else {
                    LOGGER.debug("Users Imported Successfully");
                }
                LOGGER.debug("Updations = " + this.totalUpdations + " Creations = " + this.totalCreations);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while Uploading CSV" + e);
            this.settings.setCsvUploadStatus("error");
        }
        this.settings.setCsvUploadStatus("success");
        if (this.groupsCsvUpload.booleanValue()) {
            response.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/usermanagement/groupmanagement");
        } else {
            response.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/usermanagement/importexport");
        }
    }

    private boolean canGroupsBeUpdated(User user) {
        LOGGER.debug("checking if groups of the user can be updated");
        Directory directory = null;
        try {
            directory = this.directoryManager.findDirectoryById(user.getDirectoryId());
        }
        catch (Exception e) {
            LOGGER.error("Issue in updating groups for user " + user.getName());
            return false;
        }
        return directory != null && directory.getAllowedOperations().contains(OperationType.UPDATE_GROUP);
    }

    private void removeUserFromGroups(User user, List<String> groupsToRemove, String ip) throws OperationNotPermittedException {
        try {
            LOGGER.debug("Removing user from groups");
            for (String group : groupsToRemove) {
                LOGGER.debug("Removing user " + user + " from " + group);
                LOGGER.debug("Removing user [" + user + "] from group [" + group + "]");
                this.directoryManager.removeUserFromGroup(user.getDirectoryId(), user.getName(), group);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occured while removing groups for user " + user + " error= " + e.getMessage());
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private List<String> createAndAssignNewGroupsUser(List<String> roleValuesList, Long directoryID) {
        ArrayList<String> groupsToAssign = new ArrayList<String>();
        try {
            for (String groupName : roleValuesList) {
                if (groupName.length() <= 0) continue;
                Boolean groupExist = Boolean.FALSE;
                try {
                    this.directoryManager.findGroupByName(directoryID.longValue(), groupName.trim());
                    groupExist = Boolean.TRUE;
                    LOGGER.debug(groupName + " : this group is already present");
                }
                catch (Exception e) {
                    LOGGER.error(e.getMessage());
                }
                finally {
                    if (!groupExist.booleanValue()) {
                        try {
                            LOGGER.debug("Creating new Group with name : " + groupName);
                            GroupTemplate groupTemplate = new GroupTemplate(groupName.trim(), directoryID.longValue());
                            this.directoryManager.addGroup(directoryID.longValue(), groupTemplate);
                        }
                        catch (Exception e) {
                            LOGGER.error(e.getMessage());
                        }
                    }
                }
                groupsToAssign.add(groupName.trim());
            }
        }
        catch (Exception e) {
            LOGGER.error(e.getMessage());
        }
        return groupsToAssign;
    }

    public void addUserToGroups(User user, List<String> groupsToAssign) throws OperationNotPermittedException {
        LOGGER.debug("Adding user to groups");
        try {
            for (String group : groupsToAssign) {
                if (group.length() <= 0) continue;
                LOGGER.debug("Adding user " + user.getName() + " to " + group + ";");
                this.directoryManager.addUserToGroup(user.getDirectoryId(), user.getName(), group);
            }
        }
        catch (Exception e) {
            LOGGER.debug("Error adding user to groups");
            e.printStackTrace();
        }
    }

    public Integer getTotalUpdations() {
        return this.totalUpdations;
    }

    public void setTotalUpdations(Integer totalUpdations) {
        this.totalUpdations = totalUpdations;
    }

    public Integer getTotalCreations() {
        return this.totalCreations;
    }

    public void setTotalCreations(Integer totalCreations) {
        this.totalCreations = totalCreations;
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().close();
        }
    }
}

