AJS.$(function(){

     var helpButton = document.getElementById("Help_Button");
     var sticky = helpButton.offsetTop;
     helpButton.classList.add("sticky");

    AJS.$("#downloadSampleCSV").on("click", function(e)
    {
        e.preventDefault();
        var location = window.location.href;
        var fst = location.split("/crowd-importexport")[0];
        var next = "/downloadsample?csvtype=sample&groupcsv=false";
        window.location.href = fst + next;
    })
    AJS.$("#exportUsers").on("click" , function(e)
    {
         e.preventDefault();
        var location = window.location.href;
        var fst = location.split("/crowd-importexport")[0];
        var next = "/crowd-downloadsample/downloadsample.action?csvType=exportUsers";
        window.location.href = fst + next;
    })
    });

function IsLicenseValid() {
    var licenseValid = true;
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
        data: {
            "action": "CheckEvalLicense"
        },
        type: "GET",
        async: false,
        error: function (response) {
            if (response.responseText == "Error_User_eval_License") {
                licenseValid = false;
                require('aui/flag')({
                    title: 'Exceeded Crowd User Limit',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Please upgrade the license</p>'
                });
            }
        }
    });
    return licenseValid;
}

function downloaddirectfile() {
    var licenseValid = IsLicenseValid();
    if (licenseValid) {

        var BASE_CSV_EXPORT_URL = AJS.contextPath() + "/plugins/servlet/usermanagement/moapiuserexport";
        var dialog = new AJS.Dialog({
            width: 600,
            height: 400,
            id: "export-dialog",
            closeOnOutsideClick: true
        });
        dialog.addPanel("Panel", "<p>Select the user details which you want to export <b> </b></p> \n\n " +
            "<p> </p>" +
            "<p> <label > <input id='UserName' checked='true'  type='checkbox'/> UserName</label> </p>" +
            "<p> <label > <input id='Email' checked='true'  type='checkbox'/> Email</label> </p>" +
            "<p> <label > <input id='FullName' checked='true'  type='checkbox'/> FullName</label> </p>" +
            "<p> <label > <input id='Groups' checked='true'  type='checkbox'/> Groups</label> </p>" +
            "<p> <label > <input id='Status' checked='true' type='checkbox'/> Status</label> </p>" +
            "<p> <label > <input id='Directory' checked='true' type='checkbox'/> Directory</label> </p>" +
            "<p> <label > <input id='LastLoginDate' checked='true' type='checkbox'/> Last Login Date</label> </p>"
            , "panel-body");

        dialog.addButton("Export", function (dialog) {
            var UserName = document.getElementById("UserName").checked;
            var Email = document.getElementById("Email").checked;
            var FullName = document.getElementById("FullName").checked;
            var Groups = document.getElementById("Groups").checked;
            var Status = document.getElementById("Status").checked;
            var Directory = document.getElementById("Directory").checked;
            var LastLoginDate = document.getElementById("LastLoginDate").checked;

           var CSV_EXPORT_URL = BASE_CSV_EXPORT_URL + "?name=" + UserName + "&email=" + Email + "&FullName=" + FullName + "&Groups=" + Groups + "&Status=" + Status + "&Directory=" + Directory + "&LastLoginDate=" + LastLoginDate;
           window.location.href = CSV_EXPORT_URL;
           dialog.hide();
           dialog.remove();
        });
        dialog.addLink("Cancel", function (dialog) {
            dialog.hide();
        }, "#");
        dialog.show();
        const exportButton = document.getElementsByClassName("button-panel-button")[0];
        exportButton.style.backgroundColor = "#0052CC";
        exportButton.style.color = "white";
    }
}



    function validateFileUpload(){
                 if($("#csvFile").val() == ''){
                     // your validation error action
                    return false;

                 }
                return true;
            }

function importLoadingFlag() {
    var licenseValid = IsLicenseValid();
    if (licenseValid) {
        if (checkSize(2097152) && validateFileUpload()) {
            console.log("started importing");
            require('aui/flag')({
                title: 'Importing userdata',
                type: 'info',
                close: 'never',
                body: '<p><aui-spinner size="large"></aui-spinner></p>'
            });
        } else {
            event.preventDefault();
            console.log("No file uploaded");
            require('aui/flag')({
                title: 'Error: No File Uploaded',
                type: 'error',
                close: 'auto',
                body: '<p>Please upload a CSV file to import users.</p>'
            });
        }
    }
}

function checkSize(max_img_size) {
  var input = document.getElementById("csvFile");
  if (input.files && input.files.length == 1) {
    if (input.files[0].size > max_img_size) {
      var fileSizeMB = (max_img_size / 1024 / 1024).toFixed(2);
      var errorMessage = "The file must be less than " + fileSizeMB + " MB";
      showErrorMessage(errorMessage);
      return false;
    }
  }
  return true;
}


function showErrorMessage(message) {
        AJS.flag({
            title: 'Error!',
            type: 'error',
            close: 'auto',
            body: '<p>'+message+'</p><br/>'
        });
    }

