AJS.$(function () {

    var helpButton = document.getElementById("Help_Button");
    var sticky = helpButton.offsetTop;
    helpButton.classList.add("sticky");

    AJS.$("#downloadSampleGroupsCSV").on("click", function (e) {
        e.preventDefault();
        var location = window.location.href;
        var fst = location.split("/crowd-bulkgroupmanagement")[0];
        var next ="/downloadsample?csvtype=sample&groupcsv=true";
        window.location.href = fst + next;

    })
});

function validateFileUpload() {
    if (AJS.$("#csvFile").val() == '') {
        // your validation error action
        return false;
    }
    return true;
}

function IsLicenseValid() {
    console.log("inside is license valid check");
    var licenseValid = true;
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
        data: {
            "action": "CheckEvalLicense"
        },
        type: "GET",
        async: false,
        error: function (response) {
            if (response.responseText == "Error_User_eval_License") {
                licenseValid = false;
                require('aui/flag')({
                    title: 'Exceeded Crowd User Limit',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Please upgrade the license</p>'
                });
            }
        }
    });
    return licenseValid;
}

function importLoadingFlag() {
    var licenseValid = IsLicenseValid();
    console.log("is license valid: " + licenseValid);
    if (licenseValid) {
        if (validateFileUpload()) {
            console.log("started importing");
            require('aui/flag')({
                title: 'Importing Groups',
                type: 'info',
                close: 'never',
                body: '<p><aui-spinner size="large"></aui-spinner></p>'
            });
        }
        else {
            event.preventDefault();
            console.log("No file uploaded");
            require('aui/flag')({
                title: 'Error: No File Uploaded',
                type: 'error',
                close: 'auto',
                body: '<p>Please upload a CSV file to import groups.</p>'
            });
        }
    }
}

function performActionChange(selectedAction) {
    console.log("Calling performActionChange For : " + selectedAction);
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
        timeout: 0,
        data: {
            "action": "ChangeGroupManagementSelectedAction",
            "selectedAction": selectedAction
        },
        type: "GET",
        success: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        error: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        async: true
    });
}

function performCreationActionChange(selectedAction) {
    console.log("Calling performCreationActionChange For : " + selectedAction);
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
        timeout: 0,
        data: {
            "action": "changeGroupManagementCreationSelectedAction",
            "CreationSelectedAction": selectedAction
        },
        type: "GET",
        success: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        error: function (response) {
            var currentLocation = window.location.pathname;
            window.location.href = currentLocation;
        },
        async: true
    });
}

function performBulkGroupAction() {
    var licenseValid = IsLicenseValid();
    console.log("is license valid: " + licenseValid);
    if (licenseValid) {
        var groupsToAdd = AJS.$('#groupsToCreate').val();
        var selectedDirectory = AJS.$('#selectedDirectory').val();
        if (selectedDirectory == "directoryNotSelected") {
            require('aui/flag')({
                title: 'Directory Not selected',
                type: 'error',
                close: 'auto',
                body: '<p>Please Select the Directory to perform the Action </p>'
            });
            return;
        }
        if (groupsToAdd == "") {
            require('aui/flag')({
                title: ' Provide Groups Name ',
                type: 'error',
                close: 'auto',
                body: ''
            });
            return;
        }
        if (groupsToAdd.includes(",")) {
            require('aui/flag')({
                title: 'Invalid Separator',
                type: 'error',
                close: 'auto',
                body: '<p>Group names must be separated by a semicolon (;). Commas (,) are not allowed.</p>'
            });
            return;
        }
        console.log("Calling Group creations");
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
            data: {
                "action": "bulkCreationGroup",
                "groupsToAdd": groupsToAdd,
                "selectedDirectory": selectedDirectory
            },
            type: "GET",
            success: function (response) {
                console.log("Calling success");
                if (response.groupsCreated.length > 0) {
                    require('aui/flag')({
                        title: 'Creating Groups',
                        type: 'success',
                        close: 'auto',
                        body: '<p>Successfully Created Groups: ' + response.groupsCreated + '</p>'
                    });
                }
                if (response.groupsAlreadyExist.length > 0) {
                    require('aui/flag')({
                        title: 'Groups Already Exist!',
                        type: 'error',
                        close: 'auto',
                        body: '<p> ' + response.groupsAlreadyExist + '</p>'
                    });
                }
                setTimeout(function () {
                    location.reload();
                }, 5000);
            },
            error: function (response) {
                if (response.responseText == "Trial_limit_exceeded") {
                    licenseValid = false;
                    require('aui/flag')({
                        title: 'Trial Limit Exceeded',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Please upgrade the license</p>'
                    });
                }
                setTimeout(function () {
                    location.reload();
                }, 5000);
            },
        });
    }

}


function PerformBulkGroupDeletionAction(group, loopCount) {
    var licenseValid = IsLicenseValid();
    if (loopCount === undefined) {
        loopCount = 0;
    }
    if (licenseValid || (!licenseValid && loopCount <= 10)) {
        console.log("Calling Group Deletion");
        var selectedDirectory = document.getElementById("deleteFromDirectory").value;
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
            data: {
                "action": "BulkDeletionGroup",
                "groupsToDelete": group,
                "selectedDirectory": selectedDirectory
            },
            type: "GET",
            success: function (response) {
                console.log("Calling success");
                require('aui/flag')({
                    title: 'Deleting Groups',
                    type: 'success',
                    close: 'auto',
                    body: '<p>Successfully Deleted Groups: ' + group + '</p>'
                });
                setTimeout(function () {
                    location.reload();
                }, 2000);
            },
            error: function (response) {
                console.log("Calling error");

                if (response.responseText == "Error_User_Is_Admin") {
                    require('aui/flag')({
                        title: 'Deleting Administrator Group',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Cant delete Group With Administrator Access: ' + group + '</p>'
                    });
                } else if (response.responseText == "Error_Admin_Privilege") {
                    require('aui/flag')({
                        title: 'You do not have administrator Privilege.',
                        type: 'error',
                        close: 'auto',
                        body: '<p>Cant delete group. : ' + group + '</p>'
                    });
                }else if (response.responseText == "Trial_limit_exceeded") {
                        licenseValid = false;
                        require('aui/flag')({
                            title: 'Trial Limit Exceeded',
                            type: 'error',
                            close: 'auto',
                            body: '<p>Please upgrade the license</p>'
                        });
                }else {
                    require('aui/flag')({
                        title: 'Deleting Group',
                        type: 'error',
                        close: 'auto',
                        body: '<p>An error occurred while deleting group :  ' + group + '</p>'
                    });
                }
            },
        });

    }


}

AJS.$(document).ready(function () {
    window.onbeforeunload = null;
});

function pageRedirection(groupSearchKeyword, StartIndex, EndIndex, deleteFromDirectory) {
    console.log("pageRedirection of groups")
    var endIndex = parseInt(document.getElementById("endIndex").value, 10);
    var startIndex = parseInt(document.getElementById("startIndex").value, 10);
    var groupPerPage = parseInt(document.getElementById("groupPerPage").value, 10);
    var currentGroupPerPage = parseInt(document.getElementById("currentGroupPerPage").value, 10);
    var groupPerPageurl = parseInt(document.getElementById("groupPerPage").value, 10);

    if (groupSearchKeyword == 0) {
        groupSearchKeyword = "";
    }
    location.replace("groupmanagement?startIndex=" + StartIndex + "&endIndex=" + EndIndex + "&groupPerPageurl=" + groupPerPage + "&groupSearchKeywordUrl=" + groupSearchKeyword + "&selectedDirectoryInUrl=" + deleteFromDirectory + "&groupPerPageurl=" + groupPerPageurl)
}

function toggleAllGroups() {
    var isChecked = document.getElementById("selectAllGroups").checked;
    var startIndex = document.getElementById("startIndex").value;
    var endIndex = document.getElementById("endIndex").value;

    for (var i = startIndex; i < endIndex; i++) {
        document.getElementById("selectedGroup" + i).checked = isChecked;
    }
}

function performBulkGroupDeletion() {
    var action = document.getElementById("bulkdeleteAction");
    if (action.value == "Action") {
        document.getElementById("bulkdeleteAction").style.borderColor = "red";
        var dialog = new AJS.Dialog({
            width: 400,
            height: 150,
            id: "delete-dialog",
            closeOnOutsideClick: true
        });
        dialog.addPanel("Panel 1", "<p> Please select valid Bulk Action. <b> </b></p>", "panel-body");
        dialog.addLink("Retry", function (dialog) {
            dialog.hide();
        }, "#");

        dialog.show();
    } else {
        document.getElementById("bulkdeleteAction").style.borderColor = "";
        console.log("Selected Action : " + action.value);
        var startIndex = document.getElementById("startIndex").value;
        var lastIndexGroup = document.getElementById("lastIndexGroup").value - 1;
        var endIndex = document.getElementById("endIndex").value;
        var startIndexLoop = parseInt(document.getElementById("startIndex").value, 10);
        var userPerPageLoop = parseInt(document.getElementById("groupPerPage").value, 10);
        var loopVariable = startIndexLoop + userPerPageLoop;
        var AllowedUsers = endIndex;
        var licenseValid = IsLicenseValid();

        if (licenseValid) {
            switch (action.value) {
                case "DeleteSelectedGroup":

                    var dialog = new AJS.Dialog({
                        width: 400,
                        height: 150,
                        id: "delete-dialog",
                        closeOnOutsideClick: true
                    });
                    dialog.addPanel("Panel 1", "<p>Are you sure you want to delete the Group? <b> </b></p>", "panel-body");
                    dialog.addButton("Yes", function (dialog) {

                        var isCustomerSelected = false;

                        for (var i = startIndex; i < endIndex; i++) {
                            var isChecked = document.getElementById("selectedGroup" + i).checked;
                            if (isChecked == true) {
                                if(isCustomerSelected == false){
                                    document.getElementById("spin").style.display="block";
                                }
                                isCustomerSelected = true;
                                if (i <= loopVariable) {
                                    PerformBulkGroupDeletionAction(document.getElementById("selectedGroup" + i).value);
                                }
                            }
                        }
                        noGroupSelectedErrorMsg(isCustomerSelected);
                        dialog.hide();

                        setTimeout(function () {
                            location.reload();
                        }, 5000);

                    });
                    dialog.addLink("No", function (dialog) {
                        dialog.hide();
                    }, "#");

                    dialog.show();

                    break;
            }
        }
    }

}

function noGroupSelectedErrorMsg(isCustomerSelected) {
    if (!isCustomerSelected) {
        require('aui/flag')({
            title: 'Group Not selected',
            type: 'error',
            close: 'auto',
            body: '<p>Please Select the Group to perform the Action </p>'
        });
    }
}

// AJS.$(document).on('click', '#exportGroup', function (e) {
//     e.preventDefault();
//     var licenseValid = IsLicenseValid();
//     if (licenseValid) {
//         window.location.href = AJS.contextPath() + "/plugins/servlet/usermanagement/moapi?action=exportGroupsCsv";
//     }
// });

function downloaddirectgroupfile(){
    var licenseValid = IsLicenseValid();
    if (licenseValid) {
        window.location.href = AJS.contextPath() + "/plugins/servlet/usermanagement/moapi?action=exportGroupsCsv";
    }
}

function resetFilters(){
      document.getElementById("spin").style.display="block";
      window.location.replace(AJS.contextPath() + "/plugins/servlet/usermanagement/groupmanagement");
}

function LoadingFlag(){
    document.getElementById("spin").style.display="block";
}

/*
function downloaddirectgroupfile() {
        var val = document.getElementById("exportGroup").value;
        var location = window.location.href;
        if(val == "ExportGroupInCSV") {
            var dialog = new AJS.Dialog({
                width: 600,
                height: 400,
                id: "export-dialog",
                closeOnOutsideClick: true
            });
             dialog.addPanel("Panel", "<p>Selecte the user details which you want to export <b> </b></p> \n\n " +
                    "<p> </p>" +
                    "<p> <label > <input id='Group' checked='true'  type='checkbox' disabled/>Group</label> </p>" +
                    "<p> <label > <input id='NoOfUserInGroup' checked='true'  type='checkbox'/>No. of Users in Group</label> </p>"
                    , "panel-body");

            dialog.addButton("Export", function (dialog) {
                var Group = true;
                var NoOfUserInGroup = document.getElementById("NoOfUserInGroup").checked;
                var fst = location.split("/crowd-bulkgroupmanagement")[0];
                var next = "/crowd-downloadsample/downloadsample.action?csvType=exportGroups";
                window.location.href = fst + next + "&group="+Group+"&NoOfUserInGroup="+NoOfUserInGroup;
                dialog.hide();
            });
            dialog.addLink("Cancel", function (dialog) {
                dialog.hide();
            }, "#");
            dialog.show();
        }
        else if(val == "Action"){
            location.reload();
        }
        const exportButton = document.getElementsByClassName("button-panel-button")[0];
        exportButton.style.backgroundColor = "#0052CC";
        exportButton.style.color = "white";
}*/
