/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.actions;

import com.miniorange.usermanagement.actions.BulkUserManagementAction;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import java.io.IOException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class DownloadCSVFile
extends HttpServlet {
    private UserManagementPluginSettings settings;
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkUserManagementAction.class);

    public DownloadCSVFile(UserManagementPluginSettings settings) {
        this.settings = settings;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        String csvType = req.getParameter("csvtype");
        if (StringUtils.equalsIgnoreCase((CharSequence)csvType, (CharSequence)"sample")) {
            this.downloadSampleCsv(req, resp);
        }
        resp.sendRedirect(this.settings.getBaseUrl() + "/plugins/servlet/usermanagement/importexport");
    }

    private void downloadSampleCsv(HttpServletRequest req, HttpServletResponse resp) {
        block17: {
            try {
                if (req.getParameter("groupcsv") != null && StringUtils.equalsIgnoreCase((CharSequence)req.getParameter("groupcsv"), (CharSequence)"true")) {
                    LOGGER.debug("Downloading a sample CSV of groups");
                    String fileName = "exampleGroups.csv";
                    resp.setContentType("text/csv");
                    resp.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                    try (CSVPrinter printer = new CSVPrinter(resp.getWriter(), CSVFormat.DEFAULT);){
                        printer.printRecord("Groups", "Directory");
                        printer.printRecord("[groupNameInSquareBrackets1]", "directoryName1");
                        printer.printRecord("[groupNameInSquareBrackets2]", "directoryName2");
                        printer.printRecord("[groupNameInSquareBrackets3]", "directoryName3");
                        break block17;
                    }
                    catch (IOException e) {
                        LOGGER.error("Error while writing CSV", (Throwable)e);
                    }
                    break block17;
                }
                LOGGER.debug("Downloading a sample CSV of users.");
                String fileName = "exampleUsers.csv";
                resp.setContentType("text/csv");
                resp.setHeader("Content-Disposition", "attachment; filename=\"" + fileName + "\"");
                try (CSVPrinter printer = new CSVPrinter(resp.getWriter(), CSVFormat.DEFAULT);){
                    printer.printRecord("Username", "Email", "FullName", "Groups", "Status", "Directory");
                    printer.printRecord("Temp1", "temp1@gmail.com", "Temp 1", "[crowd-administrators, Temp group]", "Active", "mn Crowd server");
                    printer.printRecord("Temp2", "temp2@gmail", "Temp 2", "[Temp group]", "Active", "mn Crowd server");
                    printer.printRecord("Temp3", "temp3@gmail.com", "Temp 3", "[crowd-administrators]", "Active", "mn Crowd server");
                }
                catch (IOException e) {
                    LOGGER.error("Error while writing CSV", (Throwable)e);
                }
            }
            catch (Exception e) {
                LOGGER.error("An Error occurred while downloading sample file. " + e);
            }
        }
    }
}

