AJS.$(function(){
    var helpButton = document.getElementById("Help_Button");
    var sticky = helpButton.offsetTop;
    helpButton.classList.add("sticky");

    var hide = 0;
    var lastClickTime = Date.now();
    document.getElementById("page").onclick = function() {
        var currentTime = Date.now();
        var elapsedTime = currentTime - lastClickTime;
        lastClickTime = currentTime;

        if (elapsedTime >= 1000) {
            hide+=1;
            var groupSearchKeyHide = AJS.$('#groupSearchKeyHide');
            if (!groupSearchKeyHide.is(":hidden") && hide != 1) {
                hide=0;
                groupSearchKeyHide.hide("slow");
            }
        }
    };

    window.onload = function() {
        var spinElement = document.getElementById("spin");
        var groupSearchKeyHideElement = document.getElementById("groupSearchKeyHide");
        var groupSearchKeyValueID = document.getElementById("groupSearchKeyButton").value;
        if(groupSearchKeyValueID == "Group      🞃"){
            document.getElementById("groupSearchKeyButton").value  = "Group            🞃";
        }

    if(spinElement != null){
        if (spinElement.style.display == "block") {
            spinElement.style.display = "none";
        }
    }

        if (groupSearchKeyHideElement) {
            groupSearchKeyHideElement.style.display = "none";
        } else {
            console.error("Element with ID 'groupSearchKeyHide' not found");
        }
    };

    AJS.$(document).on("change", "#sortByLastLogin", function () {
        var selectedAction = document.getElementById("sortByLastLogin").value;
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
            timeout: 0,
            data: {
                "action": "changeSortLastLoginButton",
                "selectedAction": selectedAction
            },
            type: "GET",
            success: function (response) {
                var currentLocation = window.location.pathname;
                window.location.href = currentLocation;
            },
            error: function (response) {
                var currentLocation = window.location.pathname;
                window.location.href = currentLocation;
            },
            async: true
        });
    });

    AJS.$("#selectAll").on('click', function () {
        var selectAll = AJS.$("#selectAll").is(':checked'); ;
        var inputs = document.querySelectorAll("input[type='checkbox']");
        for(var i = 1; i < inputs.length; i++) {
            inputs[i].checked = selectAll;
        }
    });

    AJS.$(document).ready(function() {
        var selectElement = AJS.$('#bulkActionongroup');
        var exportButton = AJS.$('#export-users');
        selectElement.on('change', function() {
            var selectedOption = selectElement.val();
            if (selectedOption === "Remove Groups from User" || selectedOption === "Add Groups to the User") {
                exportButton.hide();
            } else {
                exportButton.show();
            }
        });
    });

    AJS.$("#groupSearchKeyButton").on('click', function () {
        var valueGroup = document.getElementById("groupSearchKeyHide");
        if (valueGroup.style.display === "none") {
            AJS.$('#groupSearchKeyHide').show("slow");
        }else{
            AJS.$('#groupSearchKeyHide').hide("slow");
        }
    });

    AJS.$("#dateButton").on('click', function () {
        var valueGroup = document.getElementById("dateHide");
        if (valueGroup.style.display === "none") {
            AJS.$('#dateHide').show("slow");
        }else{
            AJS.$('#dateHide').hide("slow");
        }
    });

    AJS.$("#apply").on('click', function () {
        var bulkAction = AJS.$("#bulkActiononuser").val();
        var bulkActionOnGroup = AJS.$("#bulkActionongroup").val();
        var element = AJS.$("input[class='checkbox']:checked");

        if ((bulkAction =="Action" || bulkAction.trim() === "") && (bulkActionOnGroup == "Action" || bulkActionOnGroup.trim() === "")){
            var dialog = new AJS.Dialog({
                width: 400,
                height: 150,
                id: "delete-dialog",
                closeOnOutsideClick: true
            });
            dialog.addPanel("Panel 1", "<p> Please select valid Action on User and Group. <b> </b></p>", "panel-body");
            dialog.addLink("Retry", function (dialog) {
                dialog.hide();
            }, "#");
            dialog.show();
        }
        else if((bulkAction != "Action" && bulkAction.trim() != "") && (bulkActionOnGroup != "Action" && bulkActionOnGroup.trim() != "")){
            userAndGroupAction(bulkAction , bulkActionOnGroup, element);
        }
        else{
            var userList = [];
            var isCustomerSelected = false;
            for(var i = 0; i < element.length; i++){
                var isChecked = element[i].checked;
                var userDetail = [];
                if (isChecked == true) {
                    isCustomerSelected = true;
                    userDetail.push(element[i].id);
                    userDetail.push(element[i].getAttribute("data-directory"));
                }
                userList.push(userDetail);
            }
            noUserSelectedErrorMsg(isCustomerSelected);
            if(isCustomerSelected){
                switch(bulkAction){
                    case "activate":
                        document.getElementById("spin").style.display="block";
                        activateUsers(userList);
                    break;
                    case "deactivate":
                        document.getElementById("spin").style.display="block";
                        deActivateUsers(userList);
                    break;
                    case "delete":
                        var dialog = new AJS.Dialog({
                            width: 400,
                            height: 150,
                            id: "delete-dialog",
                            closeOnOutsideClick: true
                        });
                        dialog.addPanel("Panel 1", "<p>Are you sure you want to delete the users? <b> </b></p>", "panel-body");
                        dialog.addButton("Yes", function (dialog){
                            document.getElementById("spin").style.display="block";
                            deleteUsers(userList);
                            dialog.hide();
                        });
                        dialog.addLink("No", function (dialog) {
                            dialog.hide();
                        }, "#");
                        dialog.show();
                        break;
                }
                switch(bulkActionOnGroup){
                    case "Remove Groups from User":
                        var groupsToRemove = $('#deactivateGroupSearchKeyTrigger').val();
                        if(groupsToRemove === "" || groupsToRemove === null){
                            var dialog = new AJS.Dialog({
                                width: 400,
                                height: 150,
                                id: "delete-dialog",
                                closeOnOutsideClick: true
                            });
                            dialog.addPanel("Panel 1", "<p> Please select Groups to perform Bulk Action. <b> </b></p>", "panel-body");
                            dialog.addLink("Retry", function (dialog) {
                                dialog.hide();
                            }, "#");

                            dialog.show();
                            return;
                        }
                        document.getElementById("spin").style.display="block";
                        RemoveGroupsFromUser(userList , groupsToRemove);
                        break;
                    case "Add Groups to the User":
                        var groupsToAdd = $('#deactivateGroupSearchKeyTrigger').val();
                        if(groupsToAdd === "" || groupsToAdd === null){
                            var dialog = new AJS.Dialog({
                                width: 400,
                                height: 150,
                                id: "delete-dialog",
                                closeOnOutsideClick: true
                            });
                            dialog.addPanel("Panel 1", "<p> Please select Groups to perform Bulk Action. <b> </b></p>", "panel-body");
                            dialog.addLink("Retry", function (dialog) {
                                dialog.hide();
                            }, "#");
                            dialog.show();
                            return;
                        }
                        document.getElementById("spin").style.display="block";
                        AddGroupsInUser(userList , groupsToAdd);
                        break;
                }
            }
        }
    });

    function AddGroupsInUser(userList,groupsToAdd){
        var jsonUserList = JSON.stringify(userList);
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
            data: { "action":"AddGroupsInUser",
                "userNames":jsonUserList,
                "groupsToAdd":groupsToAdd
            },
            async:true,
            type: 'POST',
            success: function (response) {
                var resultMessage = response.message;
                var resultList = response.resultList;
                showSuccessMessage("AddGroupsInUser",resultMessage, resultList);
            },
            error: function(response) {
                document.getElementById("spin").style.display = "none";
                showErrorMessage(response);
            }
        });
    }

    function RemoveGroupsFromUser(userList,groupsToRemove){
    var jsonUserList = JSON.stringify(userList);
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
            data: { "action":"RemoveGroupsFromUser",
                "userNames":jsonUserList,
                "groupsToRemove":groupsToRemove
            },
            async:true,
            type: 'POST',
            success: function (response) {
                var resultMessage = response.message;
                var resultList = response.resultList;
                showSuccessMessage("RemoveGroupsFromUser",resultMessage, resultList);
            },
            error: function(response) {
                document.getElementById("spin").style.display = "none";
                showErrorMessage(response);
            }
        });
    }

    function deActivateUsers(userList){
        var jsonUserList = JSON.stringify(userList);
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
            data: { "action":"deactivate",
                "userNames": jsonUserList},
            async:true,
            type:'POST',
            success: function (response) {
                var resultMessage = response.message;
                var resultList = response.resultList;
                showSuccessMessage("Deactivation",resultMessage, resultList);
            },
            error: function(response) {
                document.getElementById("spin").style.display = "none";
                showErrorMessage(response);
            }
        });
    }

    function activateUsers(userList){
        var jsonUserList = JSON.stringify(userList);
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
            data: { "action":"activate",
                "userNames": jsonUserList},
            async:true,
            type:'POST',
            success: function (response) {
                var resultMessage = response.message;
                var resultList = response.resultList;
                showSuccessMessage("Activate",resultMessage, resultList);
            },
            error: function(response) {
                document.getElementById("spin").style.display = "none";
                showErrorMessage(response);
            }
        });
    }

    function deleteUsers(userList){
        var jsonUserList = JSON.stringify(userList);
        jQuery.ajax({
            url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
            data: { "action":"delete",
                "userNames":jsonUserList
            },
            async:true,
            type:'POST',
            success: function (response) {
                var resultMessage = response.message;
                var resultList = response.resultList;
                showSuccessMessage("deletion",resultMessage, resultList);
            },
            error: function(response) {
                document.getElementById("spin").style.display = "none";
                showErrorMessage(response);
            }
        });
    }

    function userAndGroupAction(bulkActionOnUser , bulkActionOnGroup , element){
        var isCustomerSelected = false;
        var selectedGroup = $('#deactivateGroupSearchKeyTrigger').val();
        if(selectedGroup === "" || selectedGroup === null){
            var dialog = new AJS.Dialog({
                width: 400,
                height: 150,
                id: "delete-dialog",
                closeOnOutsideClick: true
            });
            dialog.addPanel("Panel 1", "<p> Please select Groups to perform Bulk Action. <b> </b></p>", "panel-body");
            dialog.addLink("Retry", function (dialog) {
                dialog.hide();
            }, "#");
            dialog.show();
            return;
        }
        var userList = [];
        for(var i = 0; i < element.length; i++){
            var isChecked = element[i].checked;
            var userDetail = [];
            if (isChecked == true) {
                isCustomerSelected = true;
                userDetail.push(element[i].id);
                userDetail.push(element[i].getAttribute("data-directory"));
            }
            userList.push(userDetail);
        }
        noUserSelectedErrorMsg(isCustomerSelected);
        if(isCustomerSelected){
            document.getElementById("spin").style.display="block";
            var jsonUserList = JSON.stringify(userList);
            jQuery.ajax({
                url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
                data: { "action":"userAndGroupAction",
                    "userNames":jsonUserList,
                    "userAction" : bulkActionOnUser,
                    "groupAction" : bulkActionOnGroup,
                    "selectedGroup" : selectedGroup
                },
                async:true,
                type:'POST',
                success: function (response) {
                    var resultMessage = response.message;
                    var resultList = response.resultList;
                    showSuccessMessage("userAndGroupAction",resultMessage, resultList);
                },
                error: function(response) {
                    document.getElementById("spin").style.display = "none";
                    showErrorMessage(response);
                }
            });
        }
    }

    function showErrorMessage(message) {
        AJS.flag({
            title: 'Error!',
            type: 'error',
            close: 'auto',
            body: '<p>'+message.responseText+'</p><br/>'
        });
    }

    function showSuccessMessage(action, message , resultList) {
      var userClicked = false;
      var successFlag = AJS.flag({
          title: 'Success!',
          type: 'success',
          close: 'auto',
          body: '<p>' + message +
                '. <a href="#" id="view-details">Click here</a> to view the details.</p>'
      });
      AJS.$("#view-details").data('flagInstance', successFlag);

      AJS.$("#view-details").on('click', function(event) {
          event.preventDefault();
          userClicked = true;
          var flag = AJS.$(this).data('flagInstance');
          openDialog(action,flag, resultList);
      });

      setTimeout(function() {
          if (!userClicked) {
              location.reload();
          }
      }, 6000);
    }

});

AJS.$(document).ready(function() {
    if ( window.history.replaceState ) {
        window.history.replaceState( null, null, window.location.href );
    }
    if(document.getElementById("groupSearchKey").value){
        var valueGroup = document.getElementById("groupSearchKeyHide");
        if (valueGroup.style.display === "none") {
            valueGroup.style.display = "flex";
        }
    }
    if(document.getElementById("start_date_lastLoginTime").value != "1970-01-01" || document.getElementById("end_date_lastLoginTime").value != document.getElementById("currentDate").value){
        var valueGroup = document.getElementById("dateHide");
        if (valueGroup.style.display === "none") {
            valueGroup.style.display = "flex";
        }
    }
});

function LoadingFlag(){
    var spin = document.getElementById("spin");
    if(spin){
        spin.style.display="block";
    }
}

function submitFilterForm(){
    LoadingFlag();
    var selectedOptions = $('#groupSearchKey').val();
    if (!selectedOptions || selectedOptions.length === 0) {
        AJS.$("#hasFilteredGroups").val("false");
    }
    AJS.$('#managementForm').submit();
}

/*
function mOFetchGroups(textboxid) {
  console.log("inside fetch group: "+textboxid)
    AJS.$("#"+textboxid).auiSelect2({
        ajax: {
             url: AJS.contextPath() + '/plugins/servlet/usermanagement/moapi',
             data: function (params) {
                 var query = {
                     search: params,
                     action: 'fetchGroups'
                 }
                 return query;
                 },
                 results: function (data, page) {
                       return {
                       results: data.results
                       };
                 },
             },
             multiple: true
    });
    var groupSearchKey = [];
}
*/

function selectUserAction() {
    $('body').on('change','#bulkActiononuser', function() {
        switch (this.value) {
            case "delete":
                hideDevTriggerAction("addRemoveMembership");
                document.getElementById('bulkActionongroup').setAttribute("disabled","disabled");
                $("#bulkActionongroup").val("Action");
                break;

            case "activate":
            case "deactivate":
                document.getElementById('bulkActionongroup').removeAttribute("disabled");
                break;
        }
    });
}

function showDevTriggerAction (divid) {
    document.getElementById("bulkActionongroup");
    var value = document.getElementById(divid);
    if (value.style.display === "none") {
        value.style.display = "flex";
        AJS.$('#'+divid).show("slow");
    }
}

function hideDevTriggerAction (divid) {
    var value = document.getElementById(divid);
    if (value.style.display != "none"){
        AJS.$('#'+divid).hide("slow");
    }
}

function selectUserGroup() {
    var action = document.getElementById("bulkActionongroup");
    switch (action.value) {
        case "Action":
            hideDevTriggerAction("addRemoveMembership");
            break;

        case "Remove Groups from User":
        case "Add Groups to the User":
            showDevTriggerAction("addRemoveMembership");
            break;
    }
}

function noUserSelectedErrorMsg(isCustomerSelected) {
    if (!isCustomerSelected) {
        require('aui/flag')({
            title: 'User Not selected',
            type: 'error',
            close: 'auto',
            body: '<p>Please Select the User to perform the Action </p>'
        });
    }
}

function IsLicenseValid(){
    console.log("inside is license valid check");
    var licenseValid = true;
    jQuery.ajax({
        url: AJS.contextPath() + "/plugins/servlet/usermanagement/moapi",
        data: {
            "action": "CheckEvalLicense"
        },
        type: "GET",
        async: true,
        error: function (response) {
            if (response.responseText == "Error_User_eval_License") {
                licenseValid = false;
                require('aui/flag')({
                    title: 'Exceeded Crowd User Limit',
                    type: 'error',
                    close: 'auto',
                    body: '<p>Please upgrade the license</p>'
                });
            }
        }
    });
    return licenseValid;
}


function exportUsers(){
    var licenseValid = IsLicenseValid();
    if(licenseValid) {
        var usernameSearchKeyword = document.getElementById("searchUser").value;
        var groupSearchKey = document.getElementById("groupSearchKey").value;
        var userSearchFilter = document.getElementById("userFilter").value;
        var sortByLastLogin = document.getElementById("sortByLastLogin").value;
        var directory = document.getElementById("selectedDirectory").value;
        var loginBasedFilter = document.getElementById("loginBasedFilter").value;
        window.location.href = AJS.contextPath() + "/plugins/servlet/usermanagement/moapiuserexport" + "?usernameSearchKeyword=" + usernameSearchKeyword + "&groupSearchKey=" + groupSearchKey + "&userSearchFilter=" + userSearchFilter + "&sortByLastLogin=" + sortByLastLogin + "&directory=" + directory + "&loginBasedFilter="+ loginBasedFilter;
    }
}

function resetFilters() {
    if(document.getElementById("spin") != null){
        document.getElementById("spin").style.display="block";
    }
    document.getElementById("selectedDirectory").value="All Directories";
    window.location.href = AJS.contextPath() + "/plugins/servlet/usermanagement/configure";

//    var currentDate = document.getElementById("currentDate").value;
//    AJS.$("#searchUser").val("");
//    AJS.$("#groupSearchKey").val("");
//    AJS.$("#userFilter").val("all");
//    AJS.$("#selectedDirectory").val("All Directories");
//    AJS.$("#userPerPage").val("10");
//    AJS.$("#start_date_lastLoginTime").val("1970-01-01");
//    AJS.$("#end_date_lastLoginTime").val(currentDate);
//    AJS.$("#loginBasedFilter").val("bothUser");
//    document.getElementById("userSearchFilter").checked = true;
}

function showMoreGroup(){
       var showMoreButton = document.getElementById("showMoreButton");
       if(showMoreButton.textContent == "Show more..."){
         showMoreButton.textContent = "Show less";
         var hiddenGroups = document.getElementsByClassName('hiddenGroups');
               Array.from(hiddenGroups).forEach(function (group) {
                   group.style.display = 'block';
               });
       }else{
        showMoreButton.textContent = "Show more...";
        var hiddenGroups = document.getElementsByClassName('hiddenGroups');
        Array.from(hiddenGroups).forEach(function (group) {
            group.style.display = 'none';
        });
       }
}

function openDialog(action, flag ,resultList ) {
    flag.close();
    document.getElementById("spin").style.display = "none";
    var tableBody = document.getElementById('user-action-details');
    var usersArray = JSON.parse(resultList);

    var actionDetails = {
        deletion: "User Deletion Details",
        Activate: "User Activation Details",
        Deactivation: "User Deactivation Details",
        RemoveGroupsFromUser : " User Group Removal details",
        AddGroupsInUser : "User Group added details",
        userAndGroupAction : "User and Group Actions Details"
    };
    document.getElementById("action-dialog-header").textContent = actionDetails[action];

    usersArray.forEach(function(user) {
        var actionDetails = user.split(';');
        var newRow = document.createElement('tr');

        actionDetails.forEach(function(detail, index) {
            var newCell = document.createElement('td');
            newCell.style.textAlign = 'center';
            newCell.textContent = detail.trim();
            if (index === 1) {
                if (detail.trim().toLowerCase() === "success") {
                    newCell.style.color = 'green';
                } else if (detail.trim().toLowerCase() === "failure") {
                    newCell.style.color = 'red';
                }
            }
            newRow.appendChild(newCell);
        });
        tableBody.appendChild(newRow);
    });
    AJS.dialog2("#user-action-dialog").show();
}

function closeDialog(){
    AJS.dialog2("#user-action-dialog").hide();
    location.reload();
}

