/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.embedded.api.SearchRestriction;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.DirectoryEntity;
import com.atlassian.crowd.model.group.Group;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.crowd.search.EntityDescriptor;
import com.atlassian.crowd.search.builder.Combine;
import com.atlassian.crowd.search.builder.QueryBuilder;
import com.atlassian.crowd.search.builder.Restriction;
import com.atlassian.crowd.search.query.entity.EntityQuery;
import com.atlassian.crowd.search.query.entity.restriction.Property;
import com.atlassian.crowd.search.query.entity.restriction.constants.GroupTermKeys;
import com.atlassian.crowd.search.query.entity.restriction.constants.UserTermKeys;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVPrinter;
import org.apache.commons.lang3.BooleanUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class MoAjaxExportUser
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(MoAjaxExportUser.class);
    private UserManager userManager;
    private DirectoryManager directoryManager;
    private UserManagementPluginSettings settings;
    private CommonUserUtils commonUserUtils;
    private CrowdService crowdService;
    private Date date;
    private String searchUser;

    public MoAjaxExportUser(CrowdService crowdService, UserManager userManager, DirectoryManager directoryManager, UserManagementPluginSettings settings, CommonUserUtils commonUserUtils) {
        this.userManager = userManager;
        this.directoryManager = directoryManager;
        this.settings = settings;
        this.commonUserUtils = commonUserUtils;
        this.crowdService = crowdService;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void doGet(HttpServletRequest request, HttpServletResponse response) throws IOException {
        List<Object> userTemplates;
        int count;
        Object[] ExportUserPrintRecord;
        CSVPrinter printer;
        boolean LastLoginDate;
        boolean Directory2;
        boolean Status;
        boolean Groups;
        boolean FullName;
        boolean Email;
        boolean Username;
        block39: {
            response.setContentType("text/csv");
            response.setHeader("Content-Disposition", "attachment; filename=\"CrowdUserList.csv\"");
            Username = Boolean.parseBoolean(request.getParameter("name"));
            Email = Boolean.parseBoolean(request.getParameter("email"));
            FullName = Boolean.parseBoolean(request.getParameter("FullName"));
            Groups = Boolean.parseBoolean(request.getParameter("Groups"));
            Status = Boolean.parseBoolean(request.getParameter("Status"));
            Directory2 = Boolean.parseBoolean(request.getParameter("Directory"));
            LastLoginDate = Boolean.parseBoolean(request.getParameter("LastLoginDate"));
            printer = new CSVPrinter(response.getWriter(), CSVFormat.DEFAULT);
            LOGGER.debug("User details: " + Username + " " + Email + " " + FullName + " " + Groups + " " + Status + " " + Directory2 + " " + LastLoginDate);
            String startDate = this.settings.getStart_date_lastLoginTime();
            String endDate = this.settings.getEnd_date_lastLoginTime();
            LOGGER.debug("StartDate & EndDate:" + startDate + ":" + endDate);
            ExportUserPrintRecord = new Object[7];
            count = 0;
            ArrayList<String> groupSearchKeyList = null;
            userTemplates = new ArrayList();
            String usernameSearchKeyword = null;
            String userSearchFilter = null;
            String selectedDirectory = "";
            long selectedDirectoryId = 0L;
            String loginBasedFilter = null;
            if (request.getHeader("Referer").contains("/servlet/usermanagement/configure")) {
                LOGGER.debug("referer: " + request.getHeader("Referer"));
                String[] groupSearchKey = request.getParameterValues("groupSearchKey");
                if (groupSearchKey == null || groupSearchKey.length == 0) {
                    groupSearchKeyList = null;
                } else {
                    groupSearchKeyList = new ArrayList<String>(Arrays.asList(groupSearchKey));
                    groupSearchKeyList.removeAll(Arrays.asList(null, ""));
                }
                LOGGER.debug("group search list: " + groupSearchKeyList);
                usernameSearchKeyword = request.getParameter("usernameSearchKeyword") == null ? "" : request.getParameter("usernameSearchKeyword");
                LOGGER.debug("usernameSearchKeyword: " + usernameSearchKeyword);
                loginBasedFilter = request.getParameter("loginBasedFilter");
                if (loginBasedFilter == null) {
                    loginBasedFilter = "bothUser";
                }
                if (request.getParameter("directory") == null) {
                    selectedDirectory = "";
                    selectedDirectoryId = -1L;
                } else {
                    selectedDirectory = request.getParameter("directory");
                    try {
                        selectedDirectoryId = this.directoryManager.findDirectoryByName(selectedDirectory).getId();
                    }
                    catch (Exception e) {
                        LOGGER.debug("Error in finding Selected Directory:" + e.getMessage());
                        selectedDirectoryId = -1L;
                    }
                }
                LOGGER.debug("selected directory and directoryID is: " + selectedDirectory + " id is:" + selectedDirectoryId);
                userSearchFilter = request.getParameter("userSearchFilter");
                boolean sortByLastLogin = BooleanUtils.toBoolean((String)request.getParameter("sortByLastLogin"));
                String startIndexOfPage = request.getParameter("startIndex");
                int startIndex = StringUtils.isBlank((CharSequence)startIndexOfPage) ? 0 : Integer.parseInt(startIndexOfPage);
                if (userSearchFilter == null) {
                    userSearchFilter = "all";
                }
                try {
                    if (groupSearchKeyList == null || groupSearchKeyList.size() == 0) {
                        userTemplates = selectedDirectoryId == -1L ? (userSearchFilter.equals("all") ? this.commonUserUtils.getAllUsersWithAllUserCase(usernameSearchKeyword, sortByLastLogin, Boolean.FALSE, 0L, startDate, endDate, startIndex, loginBasedFilter) : (userSearchFilter.equals("active") ? this.commonUserUtils.getAllUsers(usernameSearchKeyword, sortByLastLogin, Boolean.FALSE, 0L, startIndex, true, true, startDate, endDate, loginBasedFilter) : this.commonUserUtils.getAllUsers(usernameSearchKeyword, sortByLastLogin, Boolean.FALSE, 0L, startIndex, false, true, startDate, endDate, loginBasedFilter))) : (userSearchFilter.equals("all") ? this.commonUserUtils.getAllUsersWithAllUserCase(usernameSearchKeyword, sortByLastLogin, Boolean.TRUE, selectedDirectoryId, startDate, endDate, startIndex, loginBasedFilter) : (userSearchFilter.equals("active") ? this.commonUserUtils.getAllUsers(usernameSearchKeyword, sortByLastLogin, Boolean.TRUE, selectedDirectoryId, startIndex, true, true, startDate, endDate, loginBasedFilter) : this.commonUserUtils.getAllUsers(usernameSearchKeyword, sortByLastLogin, Boolean.TRUE, selectedDirectoryId, startIndex, false, true, startDate, endDate, loginBasedFilter)));
                        break block39;
                    }
                    if (selectedDirectoryId == -1L) {
                        userTemplates = userSearchFilter.equals("all") ? this.commonUserUtils.getAllUsersWithGroupsForAll(usernameSearchKeyword, sortByLastLogin, groupSearchKeyList, Boolean.FALSE, 0L, startDate, endDate, startIndex, loginBasedFilter) : (userSearchFilter.equals("active") ? this.commonUserUtils.getAllUsersWithGroups(usernameSearchKeyword, sortByLastLogin, groupSearchKeyList, Boolean.FALSE, 0L, startIndex, true, true, startDate, endDate, loginBasedFilter) : this.commonUserUtils.getAllUsersWithGroups(usernameSearchKeyword, sortByLastLogin, groupSearchKeyList, Boolean.FALSE, 0L, startIndex, false, true, startDate, endDate, loginBasedFilter));
                        break block39;
                    }
                    if (userSearchFilter.equals("all")) {
                        userTemplates = this.commonUserUtils.getAllUsersWithGroupsForAll(usernameSearchKeyword, sortByLastLogin, groupSearchKeyList, Boolean.TRUE, selectedDirectoryId, startDate, endDate, startIndex, loginBasedFilter);
                        break block39;
                    }
                    if (userSearchFilter.equals("active")) {
                        userTemplates = this.commonUserUtils.getAllUsersWithGroups(usernameSearchKeyword, sortByLastLogin, groupSearchKeyList, Boolean.TRUE, selectedDirectoryId, startIndex, true, true, startDate, endDate, loginBasedFilter);
                        break block39;
                    }
                    userTemplates = this.commonUserUtils.getAllUsersWithGroups(usernameSearchKeyword, sortByLastLogin, groupSearchKeyList, Boolean.TRUE, selectedDirectoryId, startIndex, false, true, startDate, endDate, loginBasedFilter);
                }
                catch (Exception e) {
                    LOGGER.debug("e :" + e);
                }
            } else {
                EntityQuery query = QueryBuilder.queryFor(User.class, (EntityDescriptor)EntityDescriptor.user()).with((SearchRestriction)Combine.allOf((SearchRestriction[])new SearchRestriction[]{Combine.anyOf((SearchRestriction[])new SearchRestriction[]{Restriction.on((Property)UserTermKeys.USERNAME).containing((Object)""), Restriction.on((Property)UserTermKeys.EMAIL).containing((Object)"")})})).startingAt(0).returningAtMost(Integer.MAX_VALUE);
                ArrayList userList = new ArrayList();
                try {
                    List directories = this.directoryManager.findAllDirectories();
                    for (Directory directory : directories) {
                        userList.addAll(this.directoryManager.searchUsers(directory.getId().longValue(), query));
                    }
                }
                catch (Exception e) {
                    LOGGER.error("An error occurred while fetching all users ", (Throwable)e);
                }
                try {
                    userTemplates = userList.parallelStream().map(UserTemplate::new).collect(Collectors.toList());
                }
                catch (Exception e) {
                    LOGGER.debug("Exception:  " + e);
                }
                LOGGER.debug("total users are: " + userTemplates.size());
            }
        }
        try {
            boolean includeHeaders;
            boolean bl = includeHeaders = !Username && !Email && !FullName && !Groups && !Status && !Directory2 && !LastLoginDate;
            if (includeHeaders) {
                List<String> finalGroups = this.fetchAllGroups();
                CSVPrinter e = printer;
                synchronized (e) {
                    printer.printRecord("Username", "Email", "FullName", "Groups", "Status", "Directory", "LastLoginDate");
                }
                userTemplates.parallelStream().forEach(user -> {
                    String username = "";
                    String email = "";
                    String fullname = "";
                    String groups = "";
                    String status = "";
                    String directory = "";
                    Date lastLoginDate = CommonUserUtils.getLastLoginDate(user.getName(), user.getDirectoryId());
                    try {
                        username = user.getName();
                        email = user.getEmailAddress();
                        fullname = user.getDisplayName();
                        groups = "[";
                        for (String groupName : finalGroups) {
                            if (!this.directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), groupName)) continue;
                            groups = groups + groupName + ",";
                        }
                        if (groups.length() > 1) {
                            groups = groups.substring(0, groups.length() - 1);
                        }
                        groups = groups + "]";
                        status = user.isActive() ? "Active" : "Inactive";
                        directory = this.directoryManager.findDirectoryById(user.getDirectoryId()).getName();
                        CSVPrinter cSVPrinter = printer;
                        synchronized (cSVPrinter) {
                            if (lastLoginDate != null) {
                                printer.printRecord(username, email, fullname, groups, status, directory, lastLoginDate);
                            } else {
                                printer.printRecord(username, email, fullname, groups, status, directory, "Never Logged In");
                            }
                        }
                    }
                    catch (Exception e) {
                        LOGGER.error("error occurred while exporting user " + user.getName() + " " + e);
                    }
                });
            } else {
                if (Username) {
                    ExportUserPrintRecord[count] = "Username";
                    ++count;
                }
                if (Email) {
                    ExportUserPrintRecord[count] = "Email";
                    ++count;
                }
                if (FullName) {
                    ExportUserPrintRecord[count] = "FullName";
                    ++count;
                }
                if (Groups) {
                    ExportUserPrintRecord[count] = "Groups";
                    ++count;
                }
                if (Status) {
                    ExportUserPrintRecord[count] = "Status";
                    ++count;
                }
                if (Directory2) {
                    ExportUserPrintRecord[count] = "Directory";
                    ++count;
                }
                if (LastLoginDate) {
                    ExportUserPrintRecord[count] = "LastLoginDate";
                }
                Object finalGroups = printer;
                synchronized (finalGroups) {
                    printer.printRecord(ExportUserPrintRecord);
                }
                finalGroups = this.fetchAllGroups();
                Object[] InformationOfUser = new Object[7];
                LOGGER.debug("Processing users...");
                if (userTemplates == null || userTemplates.isEmpty()) {
                    LOGGER.warn("No users found in userTemplates. Check the userTemplates list.");
                }
                userTemplates.parallelStream().forEach(arg_0 -> this.lambda$doGet$1(Username, InformationOfUser, Email, FullName, Groups, (List)finalGroups, Status, Directory2, LastLoginDate, printer, arg_0));
            }
            printer.flush();
            printer.close();
            LOGGER.debug("The user export process has been successfully completed.");
        }
        catch (Exception e) {
            LOGGER.debug("exception while exporting user:" + e);
        }
    }

    public List<String> fetchAllGroups() {
        List allDirectories = this.directoryManager.findAllDirectories();
        EntityQuery query = QueryBuilder.queryFor(Group.class, (EntityDescriptor)EntityDescriptor.group()).with((SearchRestriction)Restriction.on((Property)GroupTermKeys.NAME).startingWith((Object)"")).returningAtMost(Integer.MAX_VALUE);
        ArrayList groupsList = new ArrayList();
        for (Directory directory : allDirectories) {
            try {
                List groups = this.directoryManager.searchGroups(directory.getId().longValue(), query);
                groupsList.addAll(groups);
            }
            catch (Exception e) {
                LOGGER.debug("exception: " + e);
            }
        }
        List<String> groupNames = groupsList.stream().map(DirectoryEntity::getName).distinct().collect(Collectors.toList());
        return groupNames;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private /* synthetic */ void lambda$doGet$1(boolean Username, Object[] InformationOfUser, boolean Email, boolean FullName, boolean Groups, List finalGroups, boolean Status, boolean Directory2, boolean LastLoginDate, CSVPrinter printer, UserTemplate user) {
        if (user == null) {
            LOGGER.warn("Encountered a null user object. Skipping.");
            return;
        }
        try {
            int count1 = 0;
            if (Username) {
                InformationOfUser[count1] = user.getName();
                ++count1;
            }
            if (Email) {
                InformationOfUser[count1] = user.getEmailAddress();
                ++count1;
            }
            if (FullName) {
                InformationOfUser[count1] = user.getDisplayName();
                ++count1;
            }
            if (Groups) {
                ArrayList<String> userGroups = new ArrayList<String>();
                String groups = "[";
                for (String groupName : finalGroups) {
                    if (!this.directoryManager.isUserDirectGroupMember(user.getDirectoryId(), user.getName(), groupName)) continue;
                    userGroups.add(groupName);
                    groups = groups + groupName + ",";
                }
                if (groups.length() > 1) {
                    groups = groups.substring(0, groups.length() - 1);
                }
                groups = groups + "]";
                InformationOfUser[count1] = groups;
                ++count1;
            }
            if (Status) {
                InformationOfUser[count1] = user.isActive();
                ++count1;
            }
            if (Directory2) {
                InformationOfUser[count1] = this.directoryManager.findDirectoryById(user.getDirectoryId()).getName();
                ++count1;
            }
            if (LastLoginDate) {
                Date lastLoginDate = CommonUserUtils.getLastLoginDate(user.getName(), user.getDirectoryId());
                InformationOfUser[count1] = lastLoginDate != null ? lastLoginDate : "Never Logged In";
            }
            CSVPrinter cSVPrinter = printer;
            synchronized (cSVPrinter) {
                printer.printRecord(InformationOfUser);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error occurred while exporting user: " + e.getMessage());
        }
    }
}

