/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.servlet;

import com.atlassian.crowd.embedded.api.CrowdService;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.User;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.sal.api.user.UserManager;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class AjaxCallServlet
extends HttpServlet {
    private static final Logger LOGGER = LoggerFactory.getLogger(AjaxCallServlet.class);
    private CrowdService crowdService;
    private UserManager userManager;
    private DirectoryManager directoryManager;
    private UserManagementPluginSettings settings;
    private CommonUserUtils commonUserUtils;

    public AjaxCallServlet(CommonUserUtils commonUserUtils, UserManager userManager, DirectoryManager directoryManager, UserManagementPluginSettings settings, CrowdService crowdService) {
        this.userManager = userManager;
        this.directoryManager = directoryManager;
        this.settings = settings;
        this.commonUserUtils = commonUserUtils;
        this.crowdService = crowdService;
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Ajax call servlet doPost Called");
        if (this.userManager.getRemoteUserKey() != null && this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            String userName = req.getParameter("userName");
            String directoryId = req.getParameter("directoryId").replaceAll(",", "");
            String action = req.getParameter("action");
            Long dictId = Long.parseLong(directoryId.replaceAll(",", "").replaceAll(" ", ""));
            LOGGER.debug("directory Id :" + dictId);
            if (userName != null && action != null && this.settings.isLicenseValid()) {
                switch (action) {
                    case "activate": 
                    case "deactivate": {
                        this.activateOrDeactivateUser(userName, dictId, action, resp);
                        break;
                    }
                    case "delete": {
                        this.deleteUsers(userName, dictId, resp);
                        break;
                    }
                    default: {
                        LOGGER.error("Invalid action");
                        this.sendErrorResponse("Invalid Action", 400, resp);
                        break;
                    }
                }
            } else {
                LOGGER.error("Invalid License/Username");
                this.sendErrorResponse("Invalid License check logs for more details", 400, resp);
            }
        } else {
            LOGGER.error("Admin access required");
            this.sendErrorResponse("Admin Access Required", 400, resp);
        }
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws IOException {
        LOGGER.debug("Ajax call servlet doGet Called");
        if (this.userManager.getRemoteUserKey() != null && this.userManager.isAdmin(this.userManager.getRemoteUserKey())) {
            String search = StringUtils.trim((String)req.getParameter("search"));
            String action = req.getParameter("action");
            LOGGER.debug("Action:" + action + " userName:" + search);
            switch (action) {
                case "CheckEvalLicense": {
                    if (this.settings.isLicenseValid()) break;
                    LOGGER.error("Evaluation license found for app. Operations will be allowed for only 10 users");
                    try {
                        this.sendErrorResponse("Error_User_eval_License", 400, resp);
                    }
                    catch (IOException e) {
                        e.printStackTrace();
                    }
                    return;
                }
            }
        } else {
            LOGGER.debug("Not an admin user");
        }
    }

    private void activateOrDeactivateUser(String userName, Long directoryId, String action, HttpServletResponse resp) throws IOException {
        try {
            if (action.equals("deactivate") && this.settings.getUserDeactivatedCount() >= 10) {
                this.sendErrorResponse("Please upgrade to premium license to unlock the full feature.", 500, resp);
                return;
            }
            if (action.equals("deactivate")) {
                this.settings.setUserDeactivatedCount(this.settings.getUserDeactivatedCount() + 1);
            }
            if (action.equals("activate") && this.settings.getUserActivatedCount() >= 10) {
                this.sendErrorResponse("Please upgrade to premium license to unlock the full feature.", 500, resp);
                return;
            }
            if (action.equals("activate")) {
                this.settings.setUserActivatedCount(this.settings.getUserActivatedCount() + 1);
            }
            LOGGER.debug("Perform:" + action + " on:" + userName);
            User user = this.directoryManager.findRemoteUserByName(directoryId, userName);
            UserTemplate userTemplate = new UserTemplate(user);
            boolean isAdmin = this.directoryManager.isUserDirectGroupMember(directoryId.longValue(), userName, "crowd-administrators");
            if (isAdmin && action.equals("deactivate")) {
                this.sendErrorResponse("User " + userName + " is admin", 500, resp);
                return;
            }
            if (!isAdmin && action.equals("deactivate")) {
                userTemplate.setActive(false);
            } else if (!userTemplate.isActive()) {
                userTemplate.setActive(true);
            } else {
                this.sendSuccessFullResponse("User " + userName + " is Active", resp);
            }
            this.directoryManager.updateUser(directoryId.longValue(), userTemplate);
            this.sendSuccessFullResponse("User " + userName + " " + action + "d Successfully", resp);
        }
        catch (Exception e) {
            LOGGER.error("Cannot " + action + " user " + userName, (Throwable)e);
            this.sendErrorResponse("Failed to " + action + " user " + userName, 500, resp);
        }
    }

    private void deleteUsers(String userName, Long directoryId, HttpServletResponse resp) throws IOException {
        try {
            LOGGER.debug("Deleting user:" + userName);
            if (this.settings.getUserDeletedCount() >= 10) {
                this.sendErrorResponse("Please upgrade to premium license to unlock the full feature.", 500, resp);
                return;
            }
            this.settings.setUserDeletedCount(this.settings.getUserDeletedCount() + 1);
            boolean isAdmin = this.directoryManager.isUserDirectGroupMember(directoryId.longValue(), userName, "crowd-administrators");
            if (!isAdmin) {
                this.directoryManager.removeUser(directoryId.longValue(), userName);
                this.sendSuccessFullResponse("Successfully Deleted user " + userName, resp);
            } else {
                this.sendErrorResponse("User " + userName + " is admin", 500, resp);
            }
        }
        catch (Exception e) {
            LOGGER.error("Error deleting user:" + userName, (Throwable)e);
            e.printStackTrace();
            this.sendErrorResponse("Error deleting user " + userName, 500, resp);
        }
    }

    private void sendErrorResponseForUsers(String group, String errorMessages, int errorCode, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(errorCode);
        resp.getOutputStream().write(group.getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().write(" ".getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().write(errorMessages.getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().close();
    }

    private void sendErrorResponse(String errorMessages, int errorCode, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(errorCode);
        resp.getOutputStream().write(errorMessages.getBytes(StandardCharsets.UTF_8));
        resp.getOutputStream().close();
    }

    private void sendSuccessFullResponse(String result, HttpServletResponse resp) throws IOException {
        resp.setContentType("application/json");
        resp.setStatus(200);
        if (result != null) {
            resp.getOutputStream().write(result.getBytes(StandardCharsets.UTF_8));
            resp.getOutputStream().close();
        }
    }
}

