/*
 * Decompiled with CFR 0.152.
 */
package com.miniorange.usermanagement.actions;

import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.crowd.model.user.UserTemplate;
import com.atlassian.sal.api.auth.LoginUriProvider;
import com.atlassian.sal.api.user.UserManager;
import com.atlassian.sal.api.user.UserProfile;
import com.atlassian.sal.api.user.UserRole;
import com.atlassian.templaterenderer.TemplateRenderer;
import com.miniorange.usermanagement.settings.UserManagementPluginSettings;
import com.miniorange.usermanagement.utils.CommonUserUtils;
import java.io.IOException;
import java.io.Writer;
import java.util.HashMap;
import java.util.List;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServlet;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BulkUserManagementAction
extends HttpServlet {
    private static final String USER_MANAGEMENT_ACTION_PATH = "/templates/bulkUserManagement.vm";
    private static final Logger LOGGER = LoggerFactory.getLogger(BulkUserManagementAction.class);
    private List<UserTemplate> userTemplates;
    private int page;
    private int numberOfPages;
    private int numberOfUsers;
    private Boolean enableDebugLogs;
    private String showPopup;
    private int startIndex;
    public String message = "";
    private UserManager userManager;
    private DirectoryManager directoryManager;
    private CommonUserUtils commonUserUtils;
    private final UserManagementPluginSettings settings;
    private TemplateRenderer renderer;
    private LoginUriProvider loginUriProvider;

    public BulkUserManagementAction(UserManagementPluginSettings settings, UserManager userManager, DirectoryManager directoryManager, CommonUserUtils commonUserUtils, TemplateRenderer renderer, LoginUriProvider loginUriProvider) {
        this.userManager = userManager;
        this.directoryManager = directoryManager;
        this.commonUserUtils = commonUserUtils;
        this.settings = settings;
        this.renderer = renderer;
        this.loginUriProvider = loginUriProvider;
    }

    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, NumberFormatException, IOException {
        LOGGER.debug("Bulk user management doGet() method called");
        if (this.doValidate().booleanValue()) {
            LOGGER.debug("After user validation....");
            this.page = req.getParameter("page") != null ? Integer.parseInt(req.getParameter("page")) : 1;
            this.startIndex = (this.page - 1) * 20;
            this.numberOfUsers = this.commonUserUtils.getTotalSearchResults("");
            this.numberOfPages = (int)Math.ceil(this.numberOfUsers / 20);
            this.userTemplates = this.commonUserUtils.getAllUsers("", false, false, 0L, this.startIndex);
            this.showPopup = this.settings.getShowPopup();
            if (this.showPopup.equals("true")) {
                this.settings.setShowPopup("false");
            }
            this.message = "";
            resp.setContentType("text/html;charset=utf-8");
            this.renderer.render(USER_MANAGEMENT_ACTION_PATH, this.initializeBUMConfig(), (Writer)resp.getWriter());
        } else {
            resp.sendRedirect(this.loginUriProvider.getLoginUriForRole(this.commonUserUtils.getUri(req), UserRole.ADMIN).toASCIIString());
        }
    }

    public Boolean doValidate() {
        UserProfile user = this.userManager.getRemoteUser();
        if (user != null && this.userManager.isAdmin(user.getUserKey())) {
            return true;
        }
        return false;
    }

    HashMap<String, Object> initializeBUMConfig() {
        HashMap<String, Object> context = new HashMap<String, Object>();
        context.put("message", "");
        context.put("page", this.page);
        context.put("numberOfPages", this.numberOfPages);
        context.put("settings", this.settings);
        context.put("contextPath", this.settings.getBaseUrl());
        context.put("startIndex", this.startIndex);
        context.put("directoryManager", this.directoryManager);
        context.put("userTemplates", this.commonUserUtils.getAllUsers("", false, false, 0L, this.startIndex));
        context.put("numberOfUsers", this.commonUserUtils.getTotalSearchResults(""));
        context.put("showPopup", this.showPopup);
        return context;
    }
}

